let tableCarreras;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

    if(document.querySelector("#formCarreras")){
        let formCarreras = document.querySelector("#formCarreras");
        formCarreras.onsubmit = function(e) {
            e.preventDefault();
            let strCarrera= document.querySelector('#txtCarrera').value;
            let strCarreraFormat = strCarrera.toUpperCase();
            let strAbreviatura= document.querySelector('#txtAbreviatura').value;
            let strAbreviaturaFormat = strAbreviatura.toUpperCase();
            let strModelo= document.querySelector('#txtModelo').value;
            let strModeloFormat = strModelo.toUpperCase();
            let intReforma = document.querySelector('#listReforma').value;
            let strRevision = document.querySelector("#txtRevision").value;
            let intNivelId = document.querySelector("#listNivel").value;
            let strModalidad = document.querySelector("#listModalidad").value;
            let strNombrePersona = document.querySelector("#txtNombrePersona").value;
            let intStatus= document.querySelector('#listStatus').value;

            if(strCarrera == '' || strAbreviatura == '' || strModelo == '' || intReforma == '' || strRevision == '' || 
                intNivelId == 0 || intStatus == '')
            {
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            //tinyMCE.triggerSave();
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Carreras/setCarrera'; 
            let formData = new FormData(formCarreras);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        if(rowTable == ""){
                            tableCarreras.api().ajax.reload();
                        }else{
                            htmlStatus = intStatus == 1 ? 
                            '<span class="badge badge-success">Activo</span>' : 
                            '<span class="badge badge-danger">Inactivo</span>';
                            rowTable.cells[0].textContent = strCarreraFormat;
                            rowTable.cells[1].textContent = strAbreviaturaFormat;
                            rowTable.cells[2].textContent = strModeloFormat;
                            rowTable.cells[3].textContent = intReforma;
                            rowTable.cells[4].textContent = strRevision;
                            rowTable.cells[5].textContent = document.querySelector("#listNivel").selectedOptions[0].text;
                            rowTable.cells[6].textContent = document.querySelector("#listModalidad").selectedOptions[0].text;
                            rowTable.cells[7].textContent = strNombrePersona
                            rowTable.cells[9].innerHTML = htmlStatus;
                            rowTable = ""; 
                        }
                        $('#modalFormCarreras').modal("hide");
                        formCarreras.reset();
                        swal("Carreras", objData.msg ,"success");
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }

    if(document.querySelector("#formBusqueda")){
        let formBusqueda = document.querySelector("#formBusqueda");
        formBusqueda.onsubmit = function(e) {
            e.preventDefault();
            let idGrupo = document.querySelector("#listGrupo").value;

            if(idGrupo == '' || idGrupo == 0)
            {
                swal("Atención", "Favor de seleccionar un grupo." , "error");
                return false;
            }

            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Actualizar_semestre/getBusqueda'; 
            let formData = new FormData(formBusqueda);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let divTable = document.querySelector("#divTable");
                    let objData = JSON.parse(request.responseText);
                    if(objData!="")
                    {
                        swal("Grupo", "Búsqueda exitosa" ,"success");
                        let cbAll = document.querySelector("#cbAll");
                        cbAll.checked="true";
                        divTable.style.display = 'block';
                        tableActualizar = $('#tableActualizar').DataTable({
                            "bDestroy": true,
                            "language": {
                                "url": "https://cdn.datatables.net/plug-ins/1.10.20/i18n/Spanish.json"
                            },
                            "aaData": objData,
                            "columns": [
                                {"data":"idalumno" , visible:false},
                                {"data":"cb"},
                                {"data":"matricula"},
                                {"data":"nombre_alumno"},
                                {"data":"grupo_format"},
                                {"data":"options"} 
                            ],
                            'dom': 'lBfrtip',
                            'buttons': [
                                {
                                    "extend": "copyHtml5",
                                    "text": "<i class='far fa-copy'></i> Copiar",
                                    "titleAttr":"Copiar",
                                    "className": "btn btn-secondary"
                                },{
                                    "extend": "excelHtml5",
                                    "text": "<i class='fas fa-file-excel'></i> Excel",
                                    "titleAttr":"Esportar a Excel",
                                    "className": "btn btn-success"
                                },{
                                    "extend": "csvHtml5",
                                    "text": "<i class='fas fa-file-csv'></i> CSV",
                                    "titleAttr":"Esportar a CSV",
                                    "className": "btn btn-info"
                                }
                            ],
                            "resonsieve":"true",
                            "bDestroy": true,
                            "iDisplayLength": 50,
                            "order":[[1,"asc"]]
                        });

                    }else{
                        swal("Atención", "No se encontraron alumnos asignados a este grupo" ,"warning");
                        divTable.style.display = 'none';
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }

})

function openModal()
{
    rowTable = "";
    //document.querySelector('#idCarrera').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Actualizar Semestre";
    document.querySelector("#formCarreras").reset();
    if(document.querySelector("#listNivel"))
    {
        document.querySelector("#listNivel").value = 0;
        $('#listNivel').selectpicker('render');
    }
    if(document.querySelector("#listStatus"))
    {
        document.querySelector("#listStatus").value = 1;
        $('#listStatus').selectpicker('render');
    }
    $('#modalFormActualizarSemestre').modal('show');
}

$("#cbAll").change(function(){
    let status = this.checked;
    $(".chBtn").prop("checked", status);
     
})

function fntActualizarSemestre(element, idalumno){
    rowTable = element.parentNode.parentNode;
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Actualizar_semestre/updateSemestre/'+idalumno;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {    
                swal("Actualizar Semestre", objData.msg ,"success");
                setTimeout(function(){
                            window.location.reload(true);
                        }, 2000);
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntActualizarSeleccion(){
    var ids_array = [];
    $("input:checkbox[class=chBtn]:checked").each(function () {
        ids_array.push($(this).val());
    }); 
    console.log(ids_array);
    
    if(ids_array == '')
    {
        swal("Error", "Debe seleccionar al menos un alumno" , "error");
        return;
    }
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Actualizar_semestre/getGrupoConsecutivo/';
    let formData = new FormData();
    request.open("POST",ajaxUrl,true);
    formData.append("ids_array",ids_array);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {    
                let grupoConsecutivo = objData.data.grupo_consecutivo_format;
                swal({
                    title: "Actualizar Grupo",
                    text: "¿Realmente quiere asignar estos alumnos al grupo "+grupoConsecutivo+"?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Si, actualizar!",
                    cancelButtonText: "No, cancelar!",
                    closeOnConfirm: false,
                    closeOnCancel: true
                }, function(isConfirm) {
                    
                    if (isConfirm) 
                    {
                        divLoading.style.display = "flex";
                        let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                        let ajaxUrl = base_url+'/Actualizar_semestre/updateSeleccion/';
                        let formData = new FormData();
                        request.open("POST",ajaxUrl,true);
                        formData.append("ids_array",ids_array);
                        request.send(formData);
                        request.onreadystatechange = function(){
                            if(request.readyState == 4 && request.status == 200){
                                let objData = JSON.parse(request.responseText);
                                if(objData.status)
                                {    
                                    swal("Actualizar Semestre", objData.msg ,"success");
                                    setTimeout(function(){
                                                window.location.reload(true);
                                            }, 2000);
                                }else{
                                    swal("Error", objData.msg , "error");
                                }
                            }
                        }
                    }

                });
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }

}
