let tableAdeudos;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");

//Script para sobreponer el editor de texto tinymce sobre los modales de bootstrap
$(document).on('focusin', function(e) {
    if ($(e.target).closest(".tox-dialog").length) {
        e.stopImmediatePropagation();
    }
});

document.addEventListener('DOMContentLoaded', function(){

    tableAdeudos = $('#tableAdeudos').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Adeudos/getAdeudos",
            "dataSrc":""
        },
        "columns":[
            {"data":"idadeudo", visible:false},
            {"data":"nombre_alumno"},
            {"data":"adeudo"},
            {"data":"modificador"},
            {"data":"ultima_modificacion_format"},
            {"data":"status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[2,"desc"]]  
    });

    if(document.querySelector("#formAdeudos")){
        let formAdeudos = document.querySelector("#formAdeudos");
        formAdeudos.onsubmit = function(e) {
            e.preventDefault();
            tinyMCE.triggerSave();
            let intAlumnoId= document.querySelector('#listAlumnos').value;
            let strAdeudo = document.querySelector('#txtAdeudo').value;
            let intStatus = document.querySelector('#listStatus').value;
            
            if(intAlumnoId == 0 || strAdeudo == '' || intStatus == 0)
            {
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            tinyMCE.triggerSave();
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Adeudos/setAdeudo'; 
            let formData = new FormData(formAdeudos);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        if(rowTable == ""){
                            tableAdeudos.api().ajax.reload();
                        }else{
                            tableAdeudos.api().ajax.reload();
                            rowTable = ""; 
                        }
                        $('#modalFormAdeudos').modal("hide");
                        formAdeudos.reset();
                        swal("Adeudos", objData.msg ,"success");
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }
})

function fntViewAdeudo(idadeudo){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Adeudos/getAdeudo/'+idadeudo;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            if(objData.status)
            {
               let status = objData.data.estado == 1 ? 
                '<span class="badge badge-success">Activo</span>' : 
                '<span class="badge badge-danger">Inactivo</span>';
                document.querySelector("#celAlumno").innerHTML = objData.data.nombre_alumno;
                document.querySelector("#celAdeudo").innerHTML = objData.data.adeudo;
                document.querySelector("#celModificador").innerHTML = objData.data.modificador;
                document.querySelector("#celUltimaModificacion").innerHTML = objData.data.ultima_modificacion_format;
                document.querySelector("#celStatus").innerHTML = status;
                $('#modalViewAdeudo').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditAdeudo(element,idadeudo){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Respaldo";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Adeudos/getAdeudo/'+idadeudo;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idAdeudo").value = objData.data.idadeudo;
                tinymce.activeEditor.setContent(objData.data.adeudo); 
                if(document.querySelector("#listAlumnos"))
                {
                    document.querySelector("#listAlumnos").value = objData.data.alumnoid;
                    $('#listAlumnos').selectpicker('render');
                }
                if(document.querySelector("#listStatus"))
                {
                    document.querySelector("#listStatus").value = objData.data.status;
                    $('#listStatus').selectpicker('render');
                }
            }
        }
    
        $('#modalFormAdeudos').modal('show');
    }
}

tinymce.init({
    selector: '#txtAdeudo',
    width: "100%",
    height: 400,    
    statubar: true,
    plugins: [
        "advlist autolink link image lists charmap print preview hr anchor pagebreak",
        "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
        "save table contextmenu directionality emoticons template paste textcolor"
    ],
    toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | print preview media fullpage | forecolor backcolor emoticons",
});

function fntDelAdeudo(idadeudo){
    swal({
        title: "Eliminar registro del adeudo",
        text: "¿Realmente quiere eliminar el adeudo?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Adeudos/delAdeudo';
            let strData = "idadeudo="+idadeudo;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableAdeudos.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idAdeudo').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nuevo Adeudo";
    document.querySelector("#formAdeudos").reset();
    if(document.querySelector("#listAlumnos"))
    {
        document.querySelector("#listAlumnos").value = 0;
        $('#listAlumnos').selectpicker('render');
    }
    if(document.querySelector("#listStatus"))
    {
        document.querySelector("#listStatus").value = 1;
        $('#listStatus').selectpicker('render');
    }
    $('#modalFormAdeudos').modal('show');
}
