var fecha = new Date();
var anio = fecha.getFullYear();
var _dia = fecha.getDate();
var _mes = fecha.getMonth(); //viene con valores de 0 al 11
_mes = _mes + 1; //ahora lo tienes de 1 al 12
if (_mes < 10) //ahora le agregas un 0 para el formato date
{
  var mes = "0" + _mes;
} else {
  var mes = _mes;
}
if (_dia < 10) //ahora le agregas un 0 para el formato date
{
  var dia = "0" + _dia;
} else {
  var dia = _dia;
}
let fecha_actual = anio + '-' + mes + '-' + dia;

document.addEventListener('DOMContentLoaded', function() {
    let request_calendar = base_url+'/Agenda/getEventosCalendar/'; 
    var calendarEl = document.getElementById('calendar');
    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',

        events:function(info, successCallback, failureCallback){
            fetch(request_calendar)
                .then(function(response){
                    return response.json()
                })
                .then(function(data){
                    let events = data.events.map(function(event){
                        return {
                            title: event.evento,
                            subtitle: event.descripcion,
                            start: event.fecha_inicial,
                            end: new Date(event.fecha_final),
                            location: event.ubicacion,
                            timeStart: event.hora_inicial,
                            timeEnd: event.hora_final,
                            nota: event.estado,

                        }
                    })
                    successCallback(events)
                })
                .catch(function(error){
                    failureCallback(error)
                })
        },

        eventContent: function(info){
            return {
                //html Anterior que muestra más información
                /*html: `
                <div style="overflow: hidden; font-size: 12px; positon: relative;  cursor: pointer; font-family: 'Inter', sans-serif;">
                    <div><strong>${info.event.title}</strong></div>
                    <div>Descripción: ${info.event.extendedProps.subtitle}</div>
                    <div>Fecha: ${info.event.start.toLocaleDateString(
                        "es-MX",
                        {
                            month: "long",
                            day: "numeric",
                            year: "numeric",
                        }
                    )}</div>
                        <div>Ubicación: ${info.event.extendedProps.location}</div>
                        <div>Hora: ${info.event.extendedProps.timeStart} - ${info.event.extendedProps.timeEnd}</div>
                        <div>Estatus: ${info.event.extendedProps.nota}</div>
                </div>
                `*/
                html: `
                <div style="overflow: hidden; font-size: 12px; positon: relative;  cursor: pointer; font-family: 'Inter', sans-serif;">
                    <div><strong>${info.event.title}</strong></div>
                    <div>Ubicación: ${info.event.extendedProps.location}</div>
                    <div>Hora: ${info.event.extendedProps.timeStart} - ${info.event.extendedProps.timeEnd}</div>
                    <div>Estatus: ${info.event.extendedProps.nota}</div>
                </div>
                `
            }
        },

        eventMouseEnter: function(mouseEnterInfo){
            let el = mouseEnterInfo.el
            el.classList.add("relative")
            let newEl = document.createElement("div")
            let newElTitulo = mouseEnterInfo.event.title
            let newElDescripcion = mouseEnterInfo.event.extendedProps.subtitle
            let newElUbicacion = mouseEnterInfo.event.extendedProps.location
            let newElFecha = mouseEnterInfo.event.extendedProps.start
            let newElInicio = mouseEnterInfo.event.extendedProps.timeStart
            let newElFin = mouseEnterInfo.event.extendedProps.timeEnd

            newEl.innerHTML = `
                <div
                    class="fc-hoverable-event"
                    style="position: absolute; bottom: 100%; left: 0; width: auto; height: auto; background-color: white; z-index: 50; border: 1px solid #e2e8f0; border-radius: 0.375rem; padding: 0.75rem; font-size: 13px; font-family: 'Inter', sans-serif; cursor: pointer;"
                >
                    <strong>${newElTitulo}</strong>
                    <div><strong>Descripción: </strong>${newElDescripcion}</div>
                    <div><strong>Ubicación: </strong>${newElUbicacion}</div>
                    <div><strong>Hora: </strong>${newElInicio} - ${newElFin}</div>
                </div>
            `
            el.after(newEl)
        },

        eventMouseLeave: function(){
            document.querySelector(".fc-hoverable-event").remove()
        }
    });
    calendar.render();
   
    tableAgenda = $('#tableAgenda').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/1.10.20/i18n/Spanish.json"
        },
         "ajax":{
            "url": " "+base_url+"/Agenda/getEventos",
            "dataSrc":""
        },
        
       
        "columns":[
            {"data": "idagenda", visible:false},
            {"data": "evento"},
            {"data": "ubicacion"},
            {"data": "descripcion"},
            {"data": "fecha_inicial", visible:false},
            {"data": "fecha_inicial_format"},
            {"data": "fecha_final_format"},
            {"data": "horario_format"},
            {"data": "status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 25,
        "order":[[4,"desc"]]  
    }); 

    if(document.querySelector("#formAgenda")){
        let formAgenda = document.querySelector("#formAgenda");
        formAgenda.onsubmit = function(e) {
            e.preventDefault();
            let strEvento = document.querySelector('#txtEvento').value;
            let strUbicacion = document.querySelector('#txtUbicacion').value;
            let strDescripcion = document.querySelector('#txtDescripcion').value;
            let strHoraInicial = document.querySelector('#txtHoraInicial').value;
            let strHoraFinal = document.querySelector('#txtHoraFinal').value;
            let strFechaInicial = document.querySelector('#txtFechaInicial').value;
            let strFechaFinal = document.querySelector('#txtFechaFinal').value;
            let intStatus = document.querySelector('#listStatus').value;
            if(strEvento == '' || strUbicacion == '' || strHoraInicial == '' || strHoraInicial == '' || 
                strFechaInicial == '' || strFechaFinal == '' || strDescripcion == '' ||
                intStatus == '')
            {
                swal("Atención", "Todos los campos son obligatorios" , "error");
                return false;
            }
            
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Agenda/setEvento'; 
            let formData = new FormData(formAgenda);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                let objData = JSON.parse(request.responseText);
                if(objData.status)
                {
                    $('#modalFormAgenda').modal("hide");
                    formAgenda.reset();
                    swal("Agenda", objData.msg ,"success");
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 2000);
                }else{
                    swal("Error", objData.msg , "error");
                }
            }
            divLoading.style.display = "none";
            return false;
          }
        }
    }

});

function fntEditInfo(element, idagenda){
    //rowTable = element.parentNode.parentNode.parentNode;
    document.querySelector('#titleModal').innerHTML ="Actualizar Agenda";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Agenda/getEvento/'+idagenda;

    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idAgenda").value = objData.data.idagenda;
                document.querySelector("#txtEvento").value = objData.data.evento;
                document.querySelector("#txtUbicacion").value = objData.data.ubicacion;
                document.querySelector("#txtDescripcion").value = objData.data.descripcion;
                document.querySelector("#txtHoraInicial").value = objData.data.hora_inicial;
                document.querySelector("#txtHoraFinal").value = objData.data.hora_final;
                document.querySelector("#txtFechaInicial").value = objData.data.fecha_inicial;
                document.querySelector("#txtFechaFinal").value = objData.data.fecha_final;
                if(document.querySelector("#listStatus"))
                {
                    document.querySelector("#listStatus").value = objData.data.status;
                    $('#listStatus').selectpicker('render');
                }
            }
        }
        $('#modalFormAgendaEditar').modal('hide');
        $('#modalFormAgenda').modal('show');
    }
     return;
  }

function fntDelInfo(idagenda){
    swal({
        title: "Eliminar Evento",
        text: "¿Realmente quiere eliminar el evento?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Agenda/delEvento';
            let strData = "idagenda="+idagenda;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        setTimeout(function(){
                            window.location.reload(true);
                        }, 2000);
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });

}

function openModal()
{
    rowTable = "";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nuevo Evento";
    document.querySelector("#formAgenda").reset();
    if(document.querySelector("#listStatus"))
    {
        document.querySelector("#listStatus").value = 1;
        $('#listStatus').selectpicker('render');
    }
    $('#modalFormAgenda').modal('show');
}

function openModalEditar()
{
    rowTable = "";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Editar Evento";
    document.querySelector("#formAgendaEditar").reset();
    $('#modalFormAgendaEditar').modal('show');
}

      
