let tableAlumnos;
let rowTable = ""; 

//Script para sobreponer el editor de texto tinymce sobre los modales de bootstrap
$(document).on('focusin', function(e) {
    if ($(e.target).closest(".tox-dialog").length) {
        e.stopImmediatePropagation();
    }
});

$(document).ready(function() {
  $('#listCarrera').selectpicker('refresh');
});

let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

    tableAlumnos = $('#tableAlumnos').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Alumnos/getAlumnos",
            "dataSrc":""
        },
        "columns":[
            {"data":"idalumno", visible:false},
            {"data":"nombre_alumno"},
            {"data":"matricula"},
            {"data":"nivel"},
            {"data":"carrera"},
            {"data":"grupo_format"},
            {"data":"modalidad"},
            {"data":"status_beca"},
            {"data":"tipo_alumno_format"},
            {"data":"tipo"},
            {"data":"status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[0,"asc"]]  
    });

    if(document.querySelector("#formAlumnos")){
        let formAlumnos = document.querySelector("#formAlumnos");
        formAlumnos.onsubmit = function(e) {
            e.preventDefault();
            
            let strNumeroSolictud= document.querySelector('#txtNumeroSolicitud').value;
            let strNombres= document.querySelector('#txtNombres').value;
            let strNombresFormat = strNombres.toUpperCase();

            let strApellidos = document.querySelector('#txtApellidos').value;
            let strApellidosFormat = strApellidos.toUpperCase();

            let strSexo = document.querySelector('#listSexo').value;
            let strEdad= document.querySelector('#txtEdad').value;
            let strFechaNacimiento= document.querySelector('#txtFechaNacimiento').value;
            let strEstadoCivil= document.querySelector('#listEstadoCivil').value;
            let strTelefonoFijo= document.querySelector('#txtTelefonoFijo').value;
            let strTelefonoCelular= document.querySelector('#txtTelefonoCelular').value;
            let strEmail = document.querySelector('#txtEmail').value;
            let strCalle= document.querySelector('#txtCalle').value;
            let strNumero= document.querySelector('#txtNumero').value;
            let strNumerInterior= document.querySelector('#txtNumeroInterior').value;
            let strColonia= document.querySelector('#txtColonia').value;
            let strLocalidad = document.querySelector('#txtLocalidad').value;
            let strMunicipioNacimiento = document.querySelector('#txtMunicipioNacimiento').value;
            let strEstado= document.querySelector('#listEstado').value;
            let strPais= document.querySelector('#listPais').value;
            let strCurp= document.querySelector('#txtCurp').value;
            let strNivelEstudios= document.querySelector('#listNivelEstudios').value;
            let strNivelIngresar= document.querySelector('#listNivelIngresar').value;
            let strModalidad = document.querySelector('#listModalidad').value;
            let strEstadoProcedencia = document.querySelector('#listEstadoProcedencia').value;
            let strAnioEgresoProcedencia = document.querySelector('#listAnioEgresoProcedencia').value;
            let strCarrera= document.querySelector('#listCarrera').value;
            let listGrupos = document.querySelector('#listGrupos'); // primero obtenemos el elemento
            let intGrupo = listGrupos ? listGrupos.value : null;
            let strTurno= document.querySelector('#listTurno').value;
            let strEgresado= document.querySelector('#listEgresado').value;
            let strBaja= document.querySelector('#listBaja').value;
            let strIrregular= document.querySelector('#listIrregular').value;
            let strBeca= document.querySelector('#listBeca').value;
            let strTipoBeca = document.querySelector('#listTipoBeca').value;
            let strPorcentajeBeca= document.querySelector('#txtPorcentajeBeca').value;
            let strAnioInicial= document.querySelector('#listAnioInicial').value;
            let strAnioFinal= document.querySelector('#listAnioFinal').value;
            let strTipoSangre= document.querySelector('#txtTipoSangre').value;
            let strAlergias= document.querySelector('#txtAlergias').value;
            let strAlergiasMedicamento = document.querySelector('#txtAlergiasMedicamento').value;
            let strTratamientoMedico = document.querySelector('#txtAlergiasMedicamento').value;
            let strInstitucionMedica= document.querySelector('#txtInstitucionMedica').value;
            let strCronicoDegenerativas= document.querySelector('#cbCronicoDegenerativas').checked;
            let strTraumatologicas= document.querySelector('#cbTraumatologicas').checked;
            let strFisicas= document.querySelector('#cbFisicas').checked;
            let strPsicosociales = document.querySelector('#cbPsicosociales').checked;
            let strEnfermedadEspecificar = document.querySelector('#txtEnfermedadEspecificar').value;
            let strNombreEmergencia = document.querySelector('#txtNombreEmergencia').value;
            let strContactoEmergencia = document.querySelector('#txtContactoEmergencia').value;
            let strPromocion = document.querySelector('#listPromocion').value;
            let strMedioPromocion= document.querySelector('#listMedioPromocion').value;
            let strFechaRegistro= document.querySelector('#txtFechaRegistro').value;
            let strNombreTutor= document.querySelector('#txtNombreTutor').value;
            let strTelefonoTutor= document.querySelector('#txtTelefonoTutor').value;
            let strNombreEmpresa= document.querySelector('#txtNombreEmpresa').value;
            let strTelefonoEmpresa= document.querySelector('#txtTelefonoEmpresa').value;
            let strTipoRegistro = document.querySelector('#listTipoRegistro').value;
            let intStatus = document.querySelector('#listStatus').value;

            /*console.log("Numero de Solictud: "+strNumeroSolictud);
            console.log("Nombres: "+strNombresFormat);
            console.log("Apellido Paterno: "+strApellidoPaternoFormat);
            console.log("Apellido Materno: "+strApellidoMaternoFormat);
            console.log("Sexo: "+strSexo);
            console.log("Edad: "+strEdad);
            console.log("Fecha de Nacimiento: "+strFechaNacimiento);
            console.log("Estado Civil: "+strEstadoCivil);
            console.log("Teléfono Fijo: "+strTelefonoFijo);
            console.log("Teléfono Celular: "+strTelefonoCelular);
            console.log("Email: "+strEmail);
            console.log("Calle: "+strCalle);
            console.log("Número Exterior: "+strNumero);
            console.log("Número Interior: "+strNumerInterior);
            console.log("Colonia: "+strColonia);
            console.log("Localidad: "+strLocalidad);
            console.log("Municipio Nacimiento: "+strMunicipioNacimiento);
            console.log("Estado Nacimiento: "+strEstado);
            console.log("País Nacimiento: "+strPais);
            console.log("CURP: "+strCurp);
            console.log("Último Nivel Estudios: "+strNivelEstudios);
            console.log("Nivel a Ingresar: "+strNivelIngresar);
            console.log("Modalidad: "+strModalidad);
            console.log("Estado Procedencia: "+strEstadoProcedencia);
            console.log("Irregular: "+strIrregular);
            console.log("Beca: "+strBeca);
            console.log("Tipo de Beca: "+strBeca);
            console.log("Porcentaje Beca: "+strPorcentajeBeca);
            console.log("Anio Inicial: "+strAnioInicial);
            console.log("Anio Final: "+strAnioFinal);
            console.log("Tipo de Sangre: "+strTipoSangre);
            console.log("Alergias: "+strAlergias);
            console.log("Alergías a Medicamento: "+strAlergiasMedicamento);
            console.log("Grado: "+strGrado);
            console.log("Grupo: "+strGrupo);
            console.log("Tratpámiento Médico: "+strTratamientoMedico);
            console.log("Institución Servicio Médico: "+strInstitucionMedica);
            console.log("Crónico Degenerativas: "+strCronicoDegenerativas);
            console.log("Traumatológicas: "+strTraumatologicas);
            console.log("Físicas: "+strFisicas);
            console.log("Psicosociales: "+strPsicosociales);
            console.log("Enfermedades Específicas: "+strEnfermedadEspecificar);
            console.log("Nombre Emergencia: "+strNombreEmergencia);
            console.log("Recibió Promoción: "+strPromocion);
            console.log("Medio de Promoción: "+strMedioPromocion);
            console.log("Fecha Registro: "+strFechaRegistro);
            console.log("Nombre Tutor: "+strNombreTutor);
            console.log("Teléfono Tutor: "+strTelefonoTutor);
            console.log("Nombre Empresa: "+strNombreEmpresa);
            console.log("Teléfono Empresa: "+strTelefonoEmpresa);
            console.log("Tipo de Registro: "+strTipoRegistro);
            //return;*/

            if(strAnioFinal != 'No Aplica' && (strAnioFinal<=strAnioInicial)){
                swal("Atención", "El año final de egreso no puede ser menor al año inicial de ingreso." , "error");
                return false;
            }
            if (!listGrupos || intGrupo == 0) {
                swal("¡Atención!", "Debe seleccionar un grupo." , "error");
                return false;
            }
            if (strSexo == 0 || strSexo == '') {
                swal("¡Atención!", "Debe seleccionar el sexo." , "error");
                return false;
            }
            if (strEstadoCivil == 0 || strEstadoCivil == '') {
                swal("¡Atención!", "Debe seleccionar el estado cívil." , "error");
                return false;
            }
            if (strEstado == 0 || strEstado == '') {
                swal("¡Atención!", "Debe seleccionar el estado de nacimiento." , "error");
                return false;
            }
            if (strPais == 0 || strPais == '') {
                swal("¡Atención!", "Debe seleccionar el país de nacimiento." , "error");
                return false;
            }
            if (strNivelEstudios == 0 || strNivelEstudios == '') {
                swal("¡Atención!", "Debe seleccionar el país de nacimiento." , "error");
                return false;
            }
            if (strModalidad == 0 || strModalidad == '') {
                swal("¡Atención!", "Debe seleccionar la modalidad de procedencia." , "error");
                return false;
            }
            if (strEstadoProcedencia == 0 || strEstadoProcedencia == '') {
                swal("¡Atención!", "Debe seleccionar el estado de procedencia." , "error");
                return false;
            }
            if (strEstadoProcedencia == 0 || strEstadoProcedencia == '') {
                swal("¡Atención!", "Debe seleccionar el estado de la escuela de procedencia." , "error");
                return false;
            }
            if (strAnioEgresoProcedencia == 0 || strAnioEgresoProcedencia == '') {
                swal("¡Atención!", "Debe seleccionar el año de egreso del nivel anterior." , "error");
                return false;
            }
            if (strCarrera == 0 || strCarrera == '') {
                swal("¡Atención!", "Debe seleccionar la carrera a ingresar." , "error");
                return false;
            }
            if (strEgresado == 0 || strEgresado == '') {
                swal("¡Atención!", "El estatus de egreso es obligatorio." , "error");
                return false;
            }
            if (strBaja == 0 || strBaja == '') {
                swal("¡Atención!", "El estatus de baja es obligatorio." , "error");
                return false;
            }
            if (strIrregular == 0 || strIrregular == '') {
                swal("¡Atención!", "El estatus de irregular es obligatorio." , "error");
                return false;
            }
            if (strBeca == 0 || strBeca == '') {
                swal("¡Atención!", "El estatus de beca es obligatorio." , "error");
                return false;
            }
            if (strTipoBeca == 0 || strTipoBeca == '') {
                swal("¡Atención!", "El estatus del tipo de beca es obligatorio." , "error");
                return false;
            }
            if (strAnioInicial == 0 || strAnioInicial == '') {
                swal("¡Atención!", "Debe seleccionar el año inicial." , "error");
                return false;
            }
            if (strAnioFinal == 0 || strAnioFinal == '') {
                swal("¡Atención!", "Debe seleccionar el año final." , "error");
                return false;
            }
            if (strTurno == 0 || strTurno == '') {
                swal("¡Atención!", "Debe seleccionar el turno a ingresar." , "error");
                return false;
            }
            if (strPromocion == 0 || strPromocion == '') {
                swal("¡Atención!", "Debe seleccionar si recibió algún tipo de promoción." , "error");
                return false;
            }
            if (strMedioPromocion == 0 || strMedioPromocion == '') {
                swal("¡Atención!", "Debe seleccionar el medio de promoción de promoción." , "error");
                return false;
            }
            if (strTipoRegistro == 0 || strTipoRegistro == '') {
                swal("¡Atención!", "Debe seleccionar si es alumno o aspirante." , "error");
                return false;
            }
            if (strTipoRegistro == 0 || strTipoRegistro == '') {
                swal("¡Atención!", "Debe seleccionar si es alumno o aspirante." , "error");
                return false;
            }
            if (intStatus == 0 || intStatus == '') {
                swal("¡Atención!", "Debe seleccionar el estatus del alumno." , "error");
                return false;
            }

            if(strNombres == '' || strApellidos == '' || strEdad == ''  ||strFechaNacimiento == '' || 
                strTelefonoCelular == '' || strEmail == '' || strMunicipioNacimiento == ''  || strCurp == '' || 
                strTipoSangre == '' || strAlergias == '' || strAlergiasMedicamento == '' || strTratamientoMedico == '' || 
                strInstitucionMedica == '' || strNombreEmergencia == '' || strContactoEmergencia == '' || strFechaRegistro == '')
            {
                swal("Atención", "Favor de completar todos los campos obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 

            divLoading.style.display = "flex";
            tinyMCE.triggerSave();
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Alumnos/setAlumno'; 
            let formData = new FormData(formAlumnos);
            formData.append("cronicoDegenerativas",strCronicoDegenerativas);
            formData.append("traumatologicas",strTraumatologicas);
            formData.append("fisicas",strFisicas);
            formData.append("psicosociales",strPsicosociales);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        if(rowTable == ""){
                            tableAlumnos.api().ajax.reload();
                        }else{
                            tableAlumnos.api().ajax.reload();
                            /*htmlStatus = intStatus == 1 ? 
                            '<span class="badge badge-success">Activo</span>' : 
                            '<span class="badge badge-danger">Inactivo</span>';
                            rowTable.cells[1].textContent = strMatricula;
                            rowTable.cells[2].textContent = strNombresFormat+' '+strApellidosFormat;
                            rowTable.cells[3].textContent = document.querySelector("#listSexo").selectedOptions[0].text;
                            rowTable.cells[4].textContent = document.querySelector("#listNivel").selectedOptions[0].text;
                            rowTable.cells[5].textContent = strFechaAntiguedadFormat;
                            rowTable.cells[6].textContent = strFechaNacimientoFormat;
                            rowTable.cells[8].innerHTML = htmlStatus;*/
                            rowTable = ""; 
                        }
                        $('#modalFormAlumnos').modal("hide");
                        formAlumnos.reset();
                        swal("Alumnos", objData.msg ,"success");
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }

    if(document.querySelector("#foto")){
        let foto = document.querySelector("#foto");
        foto.onchange = function(e) {
            let uploadFoto = document.querySelector("#foto").value;
            let fileimg = document.querySelector("#foto").files;
            let nav = window.URL || window.webkitURL;
            let contactAlert = document.querySelector('#form_alert');
            if(uploadFoto !=''){
                let type = fileimg[0].type;
                let name = fileimg[0].name;
                if(type != 'image/jpeg' && type != 'image/jpg' && type != 'image/png'){
                    contactAlert.innerHTML = '<p class="errorArchivo">El archivo no es válido.</p>';
                    if(document.querySelector('#img')){
                        document.querySelector('#img').remove();
                    }
                    if(document.querySelector('.delPhoto'))
                    {
                        document.querySelector('.delPhoto').classList.add("notBlock");
                    }
                    foto.value="";
                    return false;
                }else{  
                        contactAlert.innerHTML='';
                        if(document.querySelector('#img')){
                            document.querySelector('#img').remove();
                        }
                        if(document.querySelector('.delPhoto'))
                        {
                            document.querySelector('.delPhoto').classList.remove("notBlock");
                        }
                        let objeto_url = nav.createObjectURL(this.files[0]);
                        document.querySelector('.prevPhoto div').innerHTML = "<img id='img' src="+objeto_url+" style='width:100px; height:120px;'>";
                        document.querySelector('#foto_remove').value=1;
                    }
            }else{
                alert("No selecciono foto");
                if(document.querySelector('#img')){
                    document.querySelector('#img').remove();
                }
            }
        }
    }

    if(document.querySelector(".delPhoto")){
        let delPhoto = document.querySelector(".delPhoto");
        delPhoto.onclick = function(e) {
            document.querySelector("#foto_remove").value= 1;
            removePhoto();
        }
    }

})

function formatearPalabra(val) {
  return val.toLowerCase()
            .trim()
            .split(' ')
            .map( v => v[0].toUpperCase() + v.substr(1) )
            .join(' ');  
}

function fntViewAlumno(idalumno){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Alumnos/getAlumno/'+idalumno;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
               let baja = objData.data.baja == 1 ? 
                '<span class="badge badge-danger">Baja</span>' : 
                '<span class="badge badge-success">Activo</span>';

                let irregular = objData.data.irregular == 1 ? 
                '<span class="badge badge-warning">Irregular</span>' : 
                '<span class="badge badge-success">Regular</span>';

                let tipo_registro = objData.data.tipo_registro == 'Alumno' ? 
                '<span class="badge badge-info">Alumno</span>' : 
                '<span class="badge badge-info">Aspirante</span>';

                let beca = objData.data.beca == 1 ? 
                '<span class="badge badge-info">Becado</span>' : 
                '';

                let egresado = objData.data.egresado == 1 ? 
                '<br /><span class="badge badge-success">SI</span>' : 
                '<br /><span class="badge badge-danger">NO</span>';

                let cronicas = objData.data.cronico_degenerativas == 'true' ? 
                '<br /><span class="badge badge-warning">Cronico Degerativas</span>' : 
                '';
                let traumatologicas = objData.data.traumatologicas == 'true' ? 
                '<br /><span class="badge badge-warning">Traumatológicas</span>' : 
                '';
                let fisicas = objData.data.fisicas == 'true' ? 
                '<br /><span class="badge badge-warning">Físicas</span>' : 
                '';
                let piscosociales = objData.data.psicosociales == 'true' ? 
                '<br /><span class="badge badge-warning">Psicosociales</span>' : 
                '';

                let enfermedades = cronicas+traumatologicas+fisicas+piscosociales

                document.querySelector("#celMatricula").innerHTML = objData.data.matricula;
                document.querySelector("#celNumeroSolicitud").innerHTML = objData.data.numero_solicitud;
                document.querySelector("#celFoto").innerHTML = '<img src="'+objData.data.url_foto+'" style="height: 128px; width: 128px;"></img>';
                document.querySelector("#celNombre").innerHTML = objData.data.nombre_alumno;
                document.querySelector("#celEdad").innerHTML = objData.data.edad
                document.querySelector("#celFechaNacimiento").innerHTML = objData.data.fecha_nacimiento_format;
                document.querySelector("#celEstadoCivil").innerHTML = objData.data.estado_civil;
                document.querySelector("#celTelefonoFijo").innerHTML = objData.data.telefono_fijo;
                document.querySelector("#celTelefonoCelular").innerHTML = objData.data.telefono_celular;
                document.querySelector("#celEmail").innerHTML = objData.data.email;
                document.querySelector("#celCalle").innerHTML = objData.data.calle;
                document.querySelector("#celNumeroExterior").innerHTML = objData.data.numero_exterior;
                document.querySelector("#celNumeroInterior").innerHTML = objData.data.numero_interior;
                document.querySelector("#celColonia").innerHTML = objData.data.colonia
                document.querySelector("#celLocalidad").innerHTML = objData.data.localidad;
                document.querySelector("#celMunicipioNacimiento").innerHTML = objData.data.municipio_nacimiento;
                document.querySelector("#celEstadoNacimiento").innerHTML = objData.data.estado_nacimiento;
                document.querySelector("#celPaisNacimiento").innerHTML = objData.data.pais_nacimiento;
                document.querySelector("#celCurp").innerHTML = objData.data.curp;
                document.querySelector("#celNivelEstudios").innerHTML = objData.data.nivel_estudios;
                document.querySelector("#celNivelIngresar").innerHTML = objData.data.nivel;
                document.querySelector("#celModalidad").innerHTML = objData.data.modalidad;
                document.querySelector("#celEstadoProcedencia").innerHTML = objData.data.estado_procedencia
                document.querySelector("#celAnioEgreso").innerHTML = objData.data.anio_egreso_procedencia;
                document.querySelector("#celCarrera").innerHTML = objData.data.carrera;
                document.querySelector("#celGrado").innerHTML = objData.data.grado;
                document.querySelector("#celGrupo").innerHTML = objData.data.grupo;
                document.querySelector("#celTurno").innerHTML = objData.data.turno;
                document.querySelector("#celEgresado").innerHTML = egresado;
                document.querySelector("#celBaja").innerHTML = baja;
                document.querySelector("#celIrregular").innerHTML = irregular;
                document.querySelector("#celBeca").innerHTML = beca;
                document.querySelector("#celTipoBeca").innerHTML = objData.data.tipo_beca;
                document.querySelector("#celPorcentajeBeca").innerHTML = objData.data.porcentaje_beca;
                document.querySelector("#celAnioInicial").innerHTML = objData.data.anio_inicial;
                document.querySelector("#celAnioFinal").innerHTML = objData.data.anio_final;
                document.querySelector("#celTipoSangre").innerHTML = objData.data.tipo_sangre;
                document.querySelector("#celAlergias").innerHTML = objData.data.alergias;
                document.querySelector("#celAlergiasMedicamento").innerHTML = objData.data.alergias_medicamento;
                document.querySelector("#celTratamientoMedico").innerHTML = objData.data.tratamiento_medico;
                document.querySelector("#celInstitucionMedica").innerHTML = objData.data.institucion_medica;
                document.querySelector("#celEnfermedades").innerHTML = enfermedades;
                document.querySelector("#celEnfermedadEspecificar").innerHTML = objData.data.enfermedad_especificar;
                document.querySelector("#celNombreEmergencia").innerHTML = objData.data.nombre_emergencia;
                document.querySelector("#celTelefonoEmergencia").innerHTML = objData.data.telefono_emergencia;
                document.querySelector("#celPromocion").innerHTML = objData.data.promocion;
                document.querySelector("#celMedioPromocion").innerHTML = objData.data.medio_promocion;
                document.querySelector("#celFechaRegistro").innerHTML = objData.data.fecha_registro_format;
                document.querySelector("#celNombreTutor").innerHTML = objData.data.nombre_tutor;
                document.querySelector("#celTelefonoTutor").innerHTML = objData.data.telefono_tutor;
                document.querySelector("#celNombreEmpresa").innerHTML = objData.data.nombre_empresa;
                document.querySelector("#celTelefonoEmpresa").innerHTML = objData.data.telefono_empresa;
                document.querySelector("#celComentarios").innerHTML= objData.data.comentarios;
                document.querySelector("#celTipoRegistro").innerHTML = tipo_registro;
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }

    $('#modalViewAlumno').modal('show');

}

function fntEditAlumno(element,idalumno){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Alumno";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Alumnos/getAlumno/'+idalumno;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                
                if(document.querySelector("#cbCronicoDegenerativas"))
                {
                    document.querySelector("#cbCronicoDegenerativas").removeAttribute("checked");
                }
                if(document.querySelector("#cbTraumatologicas"))
                {
                    document.querySelector("#cbTraumatologicas").removeAttribute("checked");
                }
                if(document.querySelector("#cbFisicas"))
                {
                    document.querySelector("#cbFisicas").removeAttribute("checked");
                }
                if(document.querySelector("#cbPsicosociales"))
                {
                    document.querySelector("#cbPsicosociales").removeAttribute("checked");
                }
                document.querySelector("#idAlumno").value = objData.data.idalumno;
                document.querySelector("#idPersona").value = objData.data.personaid;
                document.querySelector("#txtNumeroSolicitud").value = objData.data.numero_solicitud;
                document.querySelector("#txtMatricula").value = objData.data.matricula;
                document.querySelector("#txtNombres").value = objData.data.nombres;
                document.querySelector("#txtApellidos").value = objData.data.apellidos;
                document.querySelector("#txtEdad").value = objData.data.edad;
                document.querySelector("#txtFechaNacimiento").value = objData.data.fecha_nacimiento;
                document.querySelector("#txtTelefonoFijo").value = objData.data.telefono_fijo;
                document.querySelector("#txtTelefonoCelular").value = objData.data.telefono_celular;
                document.querySelector("#txtEmail").value = objData.data.email;
                document.querySelector("#txtCalle").value = objData.data.calle;
                document.querySelector("#txtNumero").value = objData.data.numero_exterior;
                document.querySelector("#txtNumeroInterior").value = objData.data.numero_interior;
                document.querySelector("#txtColonia").value = objData.data.colonia;
                document.querySelector("#txtLocalidad").value = objData.data.localidad;
                document.querySelector("#txtMunicipioNacimiento").value = objData.data.municipio_nacimiento;
                document.querySelector("#txtCurp").value = objData.data.curp;
                document.querySelector("#txtPorcentajeBeca").value = objData.data.porcentaje_beca;
                document.querySelector("#txtTipoSangre").value = objData.data.tipo_sangre;
                document.querySelector("#txtAlergias").value = objData.data.alergias;
                document.querySelector("#txtAlergiasMedicamento").value = objData.data.alergias_medicamento;
                document.querySelector("#txtTratamientoMedico").value = objData.data.tratamiento_medico;
                document.querySelector("#txtInstitucionMedica").value = objData.data.institucion_medica;
                document.querySelector("#txtEnfermedadEspecificar").value = objData.data.enfermedad_especificar;
                document.querySelector("#txtNombreEmergencia").value = objData.data.nombre_emergencia;
                document.querySelector("#txtContactoEmergencia").value = objData.data.telefono_emergencia;
                document.querySelector("#txtFechaRegistro").value = objData.data.fecha_registro;
                document.querySelector("#txtNombreTutor").value = objData.data.nombre_tutor;
                document.querySelector("#txtTelefonoTutor").value = objData.data.telefono_tutor;
                document.querySelector("#txtNombreEmpresa").value = objData.data.telefono_empresa;
                document.querySelector('#foto_actual').value = objData.data.foto;
                document.querySelector("#foto_remove").value= 0;
                tinymce.activeEditor.setContent(objData.data.comentarios); 
                
                if(objData.data.cronico_degenerativas == 'true')
                {
                    document.querySelector("#cbCronicoDegenerativas").setAttribute("checked",'');
                }
                if(objData.data.traumatologicas == 'true')
                {
                    document.querySelector("#cbTraumatologicas").setAttribute("checked",'');
                }
                if(objData.data.fisicas == 'true')
                {
                    document.querySelector("#cbFisicas").setAttribute("checked",'');
                }
                if(objData.data.psicosociales == 'true')
                {
                    document.querySelector("#cbPsicosociales").setAttribute("checked",'');
                }

                if(document.querySelector("#listSexo"))
                {
                    document.querySelector("#listSexo").value = objData.data.sexo;
                    $('#listSexo').selectpicker('render');
                }
                if(document.querySelector("#listEstadoCivil"))
                {
                    document.querySelector("#listEstadoCivil").value = objData.data.estado_civil;
                    $('#listEstadoCivil').selectpicker('render');
                }
                if(document.querySelector("#listEstado"))
                {
                    document.querySelector("#listEstado").value = objData.data.estado_nacimiento;
                    $('#listEstado').selectpicker('render');
                }
                if(document.querySelector("#listPais"))
                {
                    document.querySelector("#listPais").value = objData.data.pais_nacimiento;
                    $('#listPais').selectpicker('render');
                }
                if(document.querySelector("#listNivelEstudios"))
                {
                    document.querySelector("#listNivelEstudios").value = objData.data.nivel_estudios;
                    $('#listNivelEstudios').selectpicker('render');
                }
                if(document.querySelector("#listNivelIngresar"))
                {
                    document.querySelector("#listNivelIngresar").value = objData.data.nivelid;
                    $('#listNivelIngresar').selectpicker('render');  
                }
                if(document.querySelector("#listModalidad"))
                {
                    document.querySelector("#listModalidad").value = objData.data.modalidad;
                    $('#listModalidad').selectpicker('render');
                }
                if(document.querySelector("#listEstadoProcedencia"))
                {
                    document.querySelector("#listEstadoProcedencia").value = objData.data.estado_procedencia;
                    $('#listEstadoProcedencia').selectpicker('render');
                }
                if(document.querySelector("#listAnioEgresoProcedencia"))
                {
                    document.querySelector("#listAnioEgresoProcedencia").value = objData.data.anio_egreso_procedencia;
                    $('#listAnioEgresoProcedencia').selectpicker('render');
                }
                if(document.querySelector("#listCarrera"))
                {
                    document.querySelector("#listCarrera").value = objData.data.carreraid;
                    $('#listCarrera').selectpicker('render');
                }
                /*if(document.querySelector("#listGrado"))
                {
                    document.querySelector("#listGrado").value = objData.data.grado;
                    $('#listGrado').selectpicker('render');
                }
                if(document.querySelector("#listGrupos"))
                {
                    document.querySelector("#listGrupos").value = objData.data.grupo;
                    $('#listGrupos').selectpicker('render');
                }*/
                if(document.querySelector("#listTurno"))
                {
                    document.querySelector("#listTurno").value = objData.data.turno;
                    $('#listTurno').selectpicker('render');
                }
                if(document.querySelector("#listEgresado"))
                {
                    document.querySelector("#listEgresado").value = objData.data.egresado;
                    $('#listEgresado').selectpicker('render');
                }
                if(document.querySelector("#listBaja"))
                {
                    document.querySelector("#listBaja").value = objData.data.baja;
                    $('#listBaja').selectpicker('render');
                }
                 if(document.querySelector("#listIrregular"))
                {
                    document.querySelector("#listIrregular").value = objData.data.irregular;
                    $('#listIrregular').selectpicker('render');
                }
                if(document.querySelector("#listBeca"))
                {
                    document.querySelector("#listBeca").value = objData.data.beca;
                    $('#listBeca').selectpicker('render');
                }
                if(document.querySelector("#listTipoBeca"))
                {
                    document.querySelector("#listTipoBeca").value = objData.data.tipo_beca;
                    $('#listTipoBeca').selectpicker('render');
                }
                if(document.querySelector("#listAnioInicial"))
                {
                    document.querySelector("#listAnioInicial").value = objData.data.anio_inicial;
                    $('#listAnioInicial').selectpicker('render');
                }
                if(document.querySelector("#listAnioFinal"))
                {
                    document.querySelector("#listAnioFinal").value = objData.data.anio_final;
                    $('#listAnioFinal').selectpicker('render');
                }
                if(document.querySelector("#listPromocion"))
                {
                    document.querySelector("#listPromocion").value = objData.data.promocion;
                    $('#listPromocion').selectpicker('render');
                }
                if(document.querySelector("#listMedioPromocion"))
                {
                    document.querySelector("#listMedioPromocion").value = objData.data.medio_promocion;
                    $('#listMedioPromocion').selectpicker('render');
                }
                if(document.querySelector("#listTipoRegistro"))
                {
                    document.querySelector("#listTipoRegistro").value = objData.data.tipo_registro;
                    $('#listTipoRegistro').selectpicker('render');
                }
                if(document.querySelector("#listStatus"))
                {
                    document.querySelector("#listStatus").value = objData.data.status;
                    $('#listStatus').selectpicker('render');
                }

                //console.log(objData.data.url_foto);

                if(document.querySelector('#img'))
                {
                    document.querySelector('#img').src = objData.data.url_foto;
                }else{
                    document.querySelector('.prevPhoto div').innerHTML = "<img id='img' src="+objData.data.url_foto+">";
                }

                if(objData.data.foto == 'avatar.png')
                {
                    if(document.querySelector('.delPhoto'))
                    {
                        document.querySelector('.delPhoto').classList.add("notBlock");
                    }
                    
                }else{
                    if(document.querySelector('.delPhoto'))
                    {
                        document.querySelector('.delPhoto').classList.add("notBlock");
                    }
                }

                if(objData.statusGrupo){
                    let grupos = objData.grupos;
                    let divGrupos = $('#divGruposA');
                    divGrupos.html("");

                    let selectGrupos = $('<select>', {
                        class: 'form-control selectpicker',
                        'data-live-search': 'true',
                        id: 'listGrupos',
                        name: 'listGrupos'
                    });
                    selectGrupos.append('<option value="0">Seleccionar Grupo</option>');
                    grupos.forEach(grupos => {
                        selectGrupos.append(
                            `<option value="${grupos.idgrupo}">${grupos.grado}-${grupos.grupo} / ${grupos.carrera}</option>`
                        );
                    });
                    divGrupos.append(selectGrupos);
                    $('#listGrupos').selectpicker('refresh');

                    if(document.querySelector("#listGrupos")){
                        document.querySelector("#listGrupos").value = objData.data.grupoid;
                        $('#listGrupos').selectpicker('render');
                    }
                }else{
                    let divGrupos = $('#divGruposA');
                    divGrupos.html("");

                    let selectGrupos = $('<select>', {
                        class: 'form-control selectpicker',
                        'data-live-search': 'true',
                        id: 'listGrupos',
                        name: 'listGrupos'
                    });
                    selectGrupos.append('<option value="0">Seleccionar Grupo</option>');
                    selectGrupos.append(
                        `<option value="${objData.data.grupoid}">${objData.data.grado}-${objData.data.grupo} / ${objData.data.carrera}</option>`
                    );
                    divGrupos.append(selectGrupos);
                    $('#listGrupos').selectpicker('refresh');

                    if(document.querySelector("#listGrupos")){
                        document.querySelector("#listGrupos").value = objData.data.grupoid;
                        $('#listGrupos').selectpicker('render');
                    }

                }
               
            }else{
                swal("¡Atención!", "Error de proceso. Favor de intentar nuevamente" , "error");
            }
        }
    
        $('#modalFormAlumnos').modal('show');
    }
}

tinymce.init({
    selector: '#txtComentarios',
    width: "100%",
    height: 400,    
    statubar: true,
    plugins: [
        "advlist autolink link image lists charmap print preview hr anchor pagebreak",
        "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
        "save table contextmenu directionality emoticons template paste textcolor"
    ],
    toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | print preview media fullpage | forecolor backcolor emoticons",
});

function removePhoto(){
    document.querySelector('#foto').value ="";
    if(document.querySelector('.delPhoto'))
    {
        document.querySelector('.delPhoto').classList.add("notBlock");
    }
    if(document.querySelector('#img')){
        document.querySelector('#img').remove();
    }
}

function fntDelAlumno(idalumno){
    swal({
        title: "Eliminar Alumno",
        text: "¿Realmente quiere eliminar el registro del alumno?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Alumnos/delAlumno';
            let strData = "idalumno="+idalumno;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableAlumnos.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });

}


function openModal()
{
    rowTable = "";
    document.querySelector('#idAlumno').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nuevo Alumno";
    document.querySelector("#formAlumnos").reset();


    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Alumnos/getLastId';
    request.open("POST",ajaxUrl,true);
    request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                if(document.querySelector("#txtNumeroSolicitud"))
                {
                    document.querySelector("#txtNumeroSolicitud").value = objData.data.idalumno + 1;
                }
                //console.log(objData.data);
                //return;
            }else{
                swal("Atención!", objData.msg , "error");
            }
        }
    }


    if(document.querySelector("#cbCronicoDegenerativas"))
    {
        document.querySelector("#cbCronicoDegenerativas").removeAttribute("checked");
    }
    if(document.querySelector("#cbTraumatologicas"))
    {
        document.querySelector("#cbTraumatologicas").removeAttribute("checked");
    }
    if(document.querySelector("#cbFisicas"))
    {
        document.querySelector("#cbFisicas").removeAttribute("checked");
    }
    if(document.querySelector("#cbPsicosociales"))
    {
        document.querySelector("#cbPsicosociales").removeAttribute("checked");
    }

    if(document.querySelector("#listSexo"))
    {
        document.querySelector("#listSexo").value = 0;
        $('#listSexo').selectpicker('render');
    }
    if(document.querySelector("#listEstadoCivil"))
    {
        document.querySelector("#listEstadoCivil").value = 0;
        $('#listEstadoCivil').selectpicker('render');
    }
    if(document.querySelector("#listEstado"))
    {
        document.querySelector("#listEstado").value = 0;
        $('#listEstado').selectpicker('render');
    }
    if(document.querySelector("#listPais"))
    {
        document.querySelector("#listPais").value = 0;
        $('#listPais').selectpicker('render');
    }
    if(document.querySelector("#listNivelEstudios"))
    {
        document.querySelector("#listNivelEstudios").value = 0;
        $('#listNivelEstudios').selectpicker('render');
    }
    if(document.querySelector("#listNivelIngresar"))
    {
        document.querySelector("#listNivelIngresar").value = 0;
        $('#listNivelIngresar').selectpicker('render');  
    }
    if(document.querySelector("#listModalidad"))
    {
        document.querySelector("#listModalidad").value = 0;
        $('#listModalidad').selectpicker('render');
    }
    if(document.querySelector("#listEstadoProcedencia"))
    {
        document.querySelector("#listEstadoProcedencia").value = 0;
        $('#listEstadoProcedencia').selectpicker('render');
    }
    if(document.querySelector("#listAnioEgresoProcedencia"))
    {
        document.querySelector("#listAnioEgresoProcedencia").value = 0;
        $('#listAnioEgresoProcedencia').selectpicker('render');
    }
    if(document.querySelector("#listCarrera"))
    {
        document.querySelector("#listCarrera").value = 0;
        $('#listCarrera').selectpicker('render');
    }
    if(document.querySelector("#listGrado"))
    {
        document.querySelector("#listGrado").value = 0;
        $('#listGrado').selectpicker('render');
    }
    if(document.querySelector("#listGrupos"))
    {
        document.querySelector("#listGrupos").value = 0;
        $('#listGrupos').selectpicker('render');
    }
    if(document.querySelector("#listTurno"))
    {
        document.querySelector("#listTurno").value = 0;
        $('#listTurno').selectpicker('render');
    }
    if(document.querySelector("#listEgresado"))
    {
        document.querySelector("#listEgresado").value = 0;
        $('#listEgresado').selectpicker('render');
    }
    if(document.querySelector("#listBaja"))
    {
        document.querySelector("#listBaja").value = 0;
        $('#listBaja').selectpicker('render');
    }
     if(document.querySelector("#listIrregular"))
    {
        document.querySelector("#listIrregular").value = 0;
        $('#listIrregular').selectpicker('render');
    }
    if(document.querySelector("#listBeca"))
    {
        document.querySelector("#listBeca").value = 0;
        $('#listBeca').selectpicker('render');
    }
    if(document.querySelector("#listTipoBeca"))
    {
        document.querySelector("#listTipoBeca").value = 0;
        $('#listTipoBeca').selectpicker('render');
    }
    if(document.querySelector("#listAnioInicial"))
    {
        document.querySelector("#listAnioInicial").value = 0;
        $('#listAnioInicial').selectpicker('render');
    }
    if(document.querySelector("#listAnioFinal"))
    {
        document.querySelector("#listAnioFinal").value = 0;
        $('#listAnioFinal').selectpicker('render');
    }
    if(document.querySelector("#listPromocion"))
    {
        document.querySelector("#listPromocion").value = 0;
        $('#listPromocion').selectpicker('render');
    }
    if(document.querySelector("#listMedioPromocion"))
    {
        document.querySelector("#listMedioPromocion").value = 0;
        $('#listMedioPromocion').selectpicker('render');
    }
    if(document.querySelector("#listTipoRegistro"))
    {
        document.querySelector("#listTipoRegistro").value = 0;
        $('#listTipoRegistro').selectpicker('render');
    }
    $('#modalFormAlumnos').modal('show');
}

$("#listCarrera").change(function(){
    let carreraid = $(this).val();
    if (carreraid == "") {
        swal("Atención", "Tiene que seleccionar una carrera para asignar el alumno a un grupo." , "error");
                return false;
    }
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Alumnos/getGrupos/'+carreraid; 
    let formData = new FormData();
    formData.append('idcarrera', carreraid);
    request.open("POST",ajaxUrl,true);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let divGrupos = $('#divGruposA');
                divGrupos.html("");

                let selectGrupos = $('<select>', {
                    class: 'form-control selectpicker',
                    'data-live-search': 'true',
                    id: 'listGrupos',
                    name: 'listGrupos'
                });
                selectGrupos.append('<option value="0">Seleccionar Grupo</option>');
                objData.data.forEach(grupos => {
                    selectGrupos.append(
                        `<option value="${grupos.idgrupo}">${grupos.grado}-${grupos.grupo} / ${grupos.carrera}</option>`
                    );
                });
                divGrupos.append(selectGrupos);
                $('#listGrupos').selectpicker('refresh');
            }else{
                $('#divGruposA').html("");
                swal("¡Atención!", "No hay grupos asignados en la carrera seleccionada" , "error");
            }
        }
    }

    /*let request2 = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl2 = base_url+'/Grupos/getCarreras/'; 
    let formData2 = new FormData();
    formData2.append('idnivel', nivelid);
    request2.open("POST",ajaxUrl2,true);
    request2.send(formData2);
    request2.onreadystatechange = function(){
        if(request2.readyState == 4 && request2.status == 200){
            let objData2 = JSON.parse(request2.responseText);
            if(objData2.status) {
                let divCarreras = $('#divCarreras');
                divCarreras.html("");

                let selectCarreras = $('<select>', {
                    class: 'form-control selectpicker',
                    'data-live-search': 'true',
                    id: 'listCarreras',
                    name: 'listCarreras'
                });
                selectCarreras.append('<option value="0">Seleccionar Carrera</option>');
                objData2.data.forEach(carrera => {
                    selectCarreras.append(
                        `<option value="${carrera.idcarrera}">${carrera.abreviatura}/${carrera.carrera}/${carrera.reforma}</option>`
                    );
                });
                divCarreras.append(selectCarreras);
                $('#listCarreras').selectpicker('refresh');
            } else {
                $('#divCarreras').html("");
                swal("Atención", objData2.msg , "error");
            }
        }
    }*/
})