let tableAsistencias;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

    tableAsistencias = $('#tableAsistencias').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Asistencias/getGrupos",
            "dataSrc":""
        },
        "columns":[
            {"data":"idgrupo", visible:false},
            {"data":"nivel"},
            {"data":"grupo_format"},
            {"data":"materia"},
            {"data":"nombre_docente"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[2,"asc"]]  
    });

    if(document.querySelector("#formAsistencias")){
        let formAsistencias = document.querySelector("#formAsistencias");
        formAsistencias.onsubmit = function(e) {
            e.preventDefault();
            listarElementos();
            let idGrupo= document.querySelector('#idGrupo').value;
            let listaElementos= document.querySelector('#listaElementos').value;

            if(listaElementos == '')
            {
                swal("Atención", "Error de proceso." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            setTimeout(function(){
                let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                let ajaxUrl = base_url+'/Asistencias/setAsistencia'; 
                let formData = new FormData(formAsistencias);
                request.open("POST",ajaxUrl,true);
                request.send(formData);
                request.onreadystatechange = function(){
                    if(request.readyState == 4 && request.status == 200){
                        let objData = JSON.parse(request.responseText);
                        if(objData.status)
                        {
                            $('#modalFormAsistencias').modal("hide");
                            formAsistencias.reset();
                            swal("Asistencias", objData.msg ,"success");
                            $("#divAlumnos").html("");
                        }else{
                            swal("Error", objData.msg , "error");
                        }
                    }
                    divLoading.style.display = "none";
                    return false;
                }
            }, 0);
        }
    }

    if(document.querySelector("#formEditarAsistencias")){
        let formEditarAsistencias = document.querySelector("#formEditarAsistencias");
        formEditarAsistencias.onsubmit = function(e) {
            e.preventDefault();
            listarElementos();
            let idGrupoE= document.querySelector('#idGrupo').value;
            let listaElementosE= document.querySelector('#listaElementosE').value;

            if(listaElementosE == '')
            {
                swal("Atención", "Error de proceso." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            setTimeout(function(){
                let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                let ajaxUrl = base_url+'/Asistencias/updateAsistencia'; 
                let formData = new FormData(formEditarAsistencias);
                request.open("POST",ajaxUrl,true);
                request.send(formData);
                request.onreadystatechange = function(){
                    if(request.readyState == 4 && request.status == 200){
                        let objData = JSON.parse(request.responseText);
                        if(objData.status)
                        {
                            $('#modalFormEditarAsistencias').modal("hide");
                            formEditarAsistencias.reset();
                            swal("Asistencias", objData.msg ,"success");
                            $("#divAlumnosE").html("");
                        }else{
                            swal("Error", objData.msg , "error");
                        }
                    }
                    divLoading.style.display = "none";
                    return false;
                }
            }, 0);
        }
    }

    if(document.querySelector("#formVerAsistencias")){
        let formVerAsistencias = document.querySelector("#formVerAsistencias");
        formVerAsistencias.onsubmit = function(e) {
            e.preventDefault();
            listarElementos();
            let idgrupo= document.querySelector('#idGrupoVF').value;
            let idprofesor= document.querySelector('#idProfesorVF').value;
            let idmateria= document.querySelector('#idMateriaVF').value;
            let fecha_inicial = document.querySelector('#txtFechaInicialVF').value;
            let fecha_final = document.querySelector('#txtFechaFinalVF').value;
        
            if(idgrupo == '' || idprofesor == '' || idmateria == '')
            {
                swal("Atención", "Datos incorrectos, favor de intentar nuevamente." , "error");
                return false;
            }

            if(fecha_inicial == '' || fecha_final == '')
            {
                swal("Atención", "Las fechas son obligatorias." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            setTimeout(function(){
                let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                let ajaxUrl = base_url+'/Asistencias/getAsistenciasGrupo'; 
                let formData = new FormData(formVerAsistencias);
                formData.append('idgrupo', idgrupo);
                formData.append('idprofesor', idprofesor);
                formData.append('idmateria', idmateria);
                formData.append('fechai', fecha_inicial);
                formData.append('fechaf', fecha_final);
                request.open("POST",ajaxUrl,true);
                request.send(formData);
                request.onreadystatechange = function(){
                    if(request.readyState == 4 && request.status == 200){
                        let objData = JSON.parse(request.responseText);
                        if(objData.status)
                        {
                            fntViewAsistencia(idgrupo, idprofesor, idmateria, fecha_inicial, fecha_final)
                            $('#modalViewAsistenciaFechas').modal("hide");
                            formVerAsistencias.reset();
                            swal("Asistencias", objData.msg ,"success");
                            
                        }else{
                            swal("Error", objData.msg , "error");
                        }
                    }
                    divLoading.style.display = "none";
                    return false;
                }
            }, 0);
        }
    }
})

function formatearPalabra(val) {
  return val.toLowerCase()
            .trim()
            .split(' ')
            .map( v => v[0].toUpperCase() + v.substr(1) )
            .join(' ');  
}














/* =================================================
   Renderizador de tabla de Asistencias (UNA sola vez)
   Compatible: no usa optional chaining ni nullish coalescing
   ================================================= */
(function(){
  if (!document.getElementById('asistencias-table-styles')) {
    var css = ''
    + '.asistencias-wrapper{ background:#fff; padding:12px; border-radius:10px; box-shadow:0 8px 22px rgba(11,20,30,0.06); }'
    + '.asistencias-legend{ display:flex; gap:8px; align-items:center; margin-bottom:8px; font-size:13px; color:#555; flex-wrap:wrap;}'
    + '.asistencias-table{ width:100%; border-collapse:collapse; font-family: Inter, "Segoe UI", Roboto, Arial, sans-serif; font-size:13px; color:#333; }'
    + '.asistencias-table thead th{ position:sticky; top:0; background:linear-gradient(180deg,#ffffff,#f8f9fb); z-index:5; padding:10px 12px; border-bottom:1px solid #e9eef5; text-align:center; font-weight:600; }'
    + '.asistencias-table th:first-child, .asistencias-table td:first-child{ position:sticky; left:0; z-index:6; background:#fff; text-align:left; min-width:220px; box-shadow: 4px 0 12px rgba(0,0,0,0.03); }'
    + '.asistencias-table td, .asistencias-table th{ padding:8px 10px; vertical-align:middle; white-space:nowrap; }'
    + '.asistencias-table tbody tr:nth-child(even){ background:#fbfdff; }'
    + '.alumno-name{ display:block; max-width:200px; overflow:hidden; text-overflow:ellipsis; white-space:nowrap; }'
    + '.badge{ display:inline-flex; align-items:center; gap:6px; padding:5px 9px; border-radius:999px; font-weight:600; font-size:12px; }'
    + '.badge svg{ width:14px; height:14px; flex-shrink:0; }'
    + '.badge-asiste{ background:#e9fff0; color:#0b7e3a; border:1px solid rgba(11,126,58,0.12); }'
    + '.badge-retardo{ background:#fff8e6; color:#a66a00; border:1px solid rgba(166,106,0,0.12); }'
    + '.badge-falta{ background:#fff0f0; color:#b32424; border:1px solid rgba(179,36,36,0.12); }'
    + '.cell-empty{ color:#9aa3ad; font-weight:600; }'
    + '.totals-col{ position:sticky; right:0; background:#fff; z-index:6; min-width:140px; text-align:center; box-shadow: -4px 0 12px rgba(0,0,0,0.03); }'
    + '.totals-badges{ display:flex; gap:6px; justify-content:center; align-items:center; }'
    + '.legend-item{ display:inline-flex; gap:8px; align-items:center; color:#444; font-size:13px; }'
    + '.legend-square{ width:12px; height:12px; border-radius:3px; display:inline-block; }'
    + '.scroll-wrap{ overflow:auto; max-height:62vh; border-radius:8px; padding-bottom:6px; }'
    + '.summary-panel{ display:flex; gap:12px; align-items:center; margin-bottom:10px; font-size:13px; color:#333; flex-wrap:wrap;}'
    + '.summary-box{ background:#f7f8fb; padding:8px 10px; border-radius:8px; box-shadow: inset 0 -1px 0 rgba(0,0,0,0.02); }'
    + '.pct-good{ color:#0b7e3a; font-weight:700; }'
    + '.pct-warning{ color:#a66a00; font-weight:700; }'
    + '.pct-bad{ color:#b32424; font-weight:700; }';
    var style = document.createElement('style');
    style.id = 'asistencias-table-styles';
    style.appendChild(document.createTextNode(css));
    document.head.appendChild(style);
  }

  function escapeHtml(str) {
    if (str === undefined || str === null) return '';
    return String(str).replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
  }

  function iconSVG(type) {
    if (type === 'asiste') {
      return '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><path d="M20 6L9 17l-5-5"/></svg>';
    }
    if (type === 'retardo') {
      return '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><circle cx="12" cy="12" r="10"/><path d="M12 6v6l4 2"/></svg>';
    }
    return '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true"><path d="M18 6L6 18M6 6l12 12"/></svg>';
  }

  function formatDateLabel(yyyy_mm_dd) {
    if (!yyyy_mm_dd) return '';
    var parts = yyyy_mm_dd.split('-');
    if (parts.length < 3) return yyyy_mm_dd;
    var dd = parts[2];
    var mm = parts[1];
    return dd + '-' + mm;
  }

  function createBadge(tipo, rec) {
    var kind = (tipo || '').toString().toLowerCase();
    var cls = 'asiste';
    var label = 'Asiste';
    if (kind.indexOf('ret') !== -1 || kind.indexOf('tard') !== -1) {
      cls = 'retardo';
      label = 'Retardo';
    } else if (kind.indexOf('fal') !== -1) {
      cls = 'falta';
      label = 'Falta';
    } else if (kind.indexOf('aus') !== -1) { // por si "Ausente"
      cls = 'falta';
      label = 'Falta';
    }
    var title = label + '\nFecha: ' + (rec.fecha || '') + '\nProfesor: ' + (rec.nombre_profesor || rec.modificador || '') + '\nComentario: ' + (rec.comentarios || '');
    return '<span class="badge badge-' + cls + '" title="' + escapeHtml(title) + '">' + iconSVG(cls) + '<span>' + label + '</span></span>';
  }

  // Función pública
  window.renderAsistenciasTable = function(data) {
    if (!Array.isArray(data) || data.length === 0) {
      var emptyHtml = '<div class="asistencias-wrapper"><p style="padding:10px;color:#666">No hay registros de asistencia para este grupo.</p></div>';
      var cont = document.getElementById('divAsistenciasTable');
      if (cont) cont.innerHTML = emptyHtml;
      return;
    }

    // Agrupar alumnos y fechas
    var alumnosMap = {};
    var fechasSet = {};
    for (var i = 0; i < data.length; i++) {
      var r = data[i];
      var id = r.idalumno || r.alumnoid || r.idpersona || ('p_' + (r.idpersona || Math.random()));
      var nombre = r.nombre_alumno || r.nombre || r.alumno || 'Sin nombre';
      if (!alumnosMap[id]) {
        alumnosMap[id] = { id: id, nombre: nombre, registros: {} };
      }
      // última entrada para esa fecha reemplaza
      alumnosMap[id].registros[r.fecha] = r;
      if (r.fecha) fechasSet[r.fecha] = true;
    }

    // ordenar fechas asc
    var fechas = Object.keys(fechasSet).sort(function(a, b){ return a.localeCompare(b); });

    var minWidth = Math.max(720, 220 + fechas.length * 86);

    // header fechas
    var headerFechas = '';
    for (var i = 0; i < fechas.length; i++) {
      headerFechas += '<th title="' + escapeHtml(fechas[i]) + '">' + formatDateLabel(fechas[i]) + '</th>';
    }

    // ordenar alumnos por nombre
    var alumnosArr = [];
    for (var k in alumnosMap) {
      if (alumnosMap.hasOwnProperty(k)) alumnosArr.push(alumnosMap[k]);
    }
    alumnosArr.sort(function(a, b){ return a.nombre.localeCompare(b.nombre); });

    // construir filas y sumar globales
    var rowsHtml = '';
    var globalAsist = 0, globalRet = 0, globalFalt = 0;

    for (var ai = 0; ai < alumnosArr.length; ai++) {
      var a = alumnosArr[ai];
      var asis = 0, ret = 0, falt = 0;
      var cellsHtml = '';
      for (var fi = 0; fi < fechas.length; fi++) {
        var f = fechas[fi];
        var rec = a.registros[f];
        if (!rec) {
          cellsHtml += '<td><span class="cell-empty" title="Sin registro">-</span></td>';
        } else {
          var tipo = (rec.asistencia || rec.tipo_movimiento || '').toString().toLowerCase();
          if (tipo.indexOf('asist') !== -1 || tipo === 'asiste' || tipo.indexOf('pres') !== -1) {
            asis++;
            globalAsist++;
          } else if (tipo.indexOf('ret') !== -1 || tipo.indexOf('tard') !== -1) {
            ret++;
            globalRet++;
          } else if (tipo.indexOf('fal') !== -1 || tipo.indexOf('aus') !== -1) {
            falt++;
            globalFalt++;
          } else {
            // Si no encaja en nada, considerarlo falta por seguridad (evita sesgos)
            falt++;
            globalFalt++;
          }
          cellsHtml += '<td>' + createBadge(rec.asistencia || rec.tipo_movimiento || '', rec) + '</td>';
        }
      }

      var totalsHtml = '<td class="totals-col">'
                      + '<div class="totals-badges" aria-hidden="true">'
                      + '<span class="badge badge-asiste" title="Asistencias">' + iconSVG('asiste') + '<span>' + asis + '</span></span>'
                      + '<span class="badge badge-retardo" title="Retardos">' + iconSVG('retardo') + '<span>' + ret + '</span></span>'
                      + '<span class="badge badge-falta" title="Faltas">' + iconSVG('falta') + '<span>' + falt + '</span></span>'
                      + '</div></td>';

      rowsHtml += '<tr>'
               + '<td><span class="alumno-name" title="' + escapeHtml(a.nombre) + '">' + escapeHtml(a.nombre) + '</span></td>'
               + cellsHtml
               + totalsHtml
               + '</tr>';
    }

    // resumen global y porcentaje
    var totalRegistros = globalAsist + globalRet + globalFalt;
    var porcentajeAsistencia = 0;
    if (totalRegistros > 0) {
      porcentajeAsistencia = (globalAsist / totalRegistros) * 100;
    }
    // color para el porcentaje
    var pctClass = 'pct-good';
    if (porcentajeAsistencia < 60) pctClass = 'pct-bad';
    else if (porcentajeAsistencia < 80) pctClass = 'pct-warning';

    var summaryHtml = ''
      + '<div class="summary-panel" role="status" aria-live="polite">'
      + '<div class="summary-box"><strong>Total registros:</strong> ' + totalRegistros + '</div>'
      + '<div class="summary-box"><strong>Asistencias:</strong> ' + globalAsist + '</div>'
      + '<div class="summary-box"><strong>Retardos:</strong> ' + globalRet + '</div>'
      + '<div class="summary-box"><strong>Faltas:</strong> ' + globalFalt + '</div>'
      + '<div class="summary-box"><strong>Porcentaje asistencia:</strong> <span class="' + pctClass + '">' + porcentajeAsistencia.toFixed(2) + '%</span></div>'
      + '</div>';

    // leyenda
    var legend = ''
      + '<div class="asistencias-legend" role="note" aria-label="Leyenda de asistencias">'
      + '<div class="legend-item"><span class="legend-square" style="background:#e9fff0;border:1px solid rgba(11,126,58,0.12)"></span> Asiste</div>'
      + '<div class="legend-item"><span class="legend-square" style="background:#fff8e6;border:1px solid rgba(166,106,0,0.12)"></span> Retardo</div>'
      + '<div class="legend-item"><span class="legend-square" style="background:#fff0f0;border:1px solid rgba(179,36,36,0.12)"></span> Falta</div>'
      + '</div>';

    var html = ''
      + '<div class="asistencias-wrapper">'
      + summaryHtml
      + legend
      + '<div class="scroll-wrap">'
      + '<table class="asistencias-table" style="min-width:' + minWidth + 'px" role="table" aria-label="Tabla de asistencias">'
      + '<thead><tr><th>Alumno</th>' + headerFechas + '<th class="totals-col">Totales</th></tr></thead>'
      + '<tbody>' + rowsHtml + '</tbody>'
      + '</table>'
      + '</div></div>';

    var cont = document.getElementById('divAsistenciasTable');
    if (cont) cont.innerHTML = html;
  };
})(); // fin IIFE


/* =================================================
   fntViewAsistencia (REEMPLAZA la anterior)
   - No usa ?? ni ?. 
   - Pasa los datos reales a renderAsistenciasTable
   ================================================= */
function fntViewAsistencia(idgrupo, idprofesor, idmateria, fechai, fechaf){
  let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
  let ajaxUrl = base_url + '/Asistencias/getAsistenciasGrupo';
  let formDataA = new FormData();
  formDataA.append("idgrupo", idgrupo);
  formDataA.append("idprofesor", idprofesor);
  formDataA.append("idmateria", idmateria);
  formDataA.append("fechai", fechai);
  formDataA.append("fechaf", fechaf);

  request.open("POST", ajaxUrl, true);
  request.send(formDataA);

  request.onreadystatechange = function(){
    if(request.readyState !== 4) return;
    if(request.status === 200){
      let objData;
      try {
        objData = JSON.parse(request.responseText);
      } catch (e) {
        console.error("Respuesta no válida JSON:", request.responseText);
        swal("Error", "Respuesta no válida del servidor.", "error");
        return;
      }

      if(objData.status){
        const datos = objData.data;
        if(Array.isArray(datos) && datos.length > 0){
          const primer = datos[0];
          document.querySelector("#txtProfesorV").value = primer.nombre_profesor ?? '';
          document.querySelector("#txtMateriaV").value = primer.materia ?? '';
          document.querySelector("#txtNivelV").value = primer.nivel ?? '';
          document.querySelector("#txtGrupoV").value = primer.grupo_format ?? '';

          renderAsistenciasTable(datos);

        } else {
          $("#divAsistenciasTable").html('<div class="asistencias-wrapper"><p style="padding:10px;color:#666">No hay registros de asistencia para este grupo.</p></div>');
        }

        $('#modalViewAsistencia').modal('show');

      } else {
        swal("Advertencia", objData.msg ?? "No se pudieron obtener las asistencias.", "warning");
      }
    }
  };
}


// --- Renderizar tabla ---
function renderAsistenciasTable(datos){
  const alumnosMap = {};
  const fechasSet = new Set();

  datos.forEach(item => {
    const id = item.idalumno;
    if(!alumnosMap[id]){
      alumnosMap[id] = {
        nombre: item.nombre_alumno,
        registros: []
      };
    }
    alumnosMap[id].registros.push(item);
    fechasSet.add(item.fecha);
  });

  const fechasOrdenadas = Array.from(fechasSet).sort();

  let html = `
    <div class="table-responsive">
      <table class="table table-bordered table-striped table-sm text-center align-middle">
        <thead class="table-dark">
          <tr>
            <th>Alumno</th>`;

  fechasOrdenadas.forEach(f => html += `<th>${f}</th>`);

  html += `<th>Asistencias</th><th>Retardos</th><th>Faltas</th><th>% Asistencia</th></tr></thead><tbody>`;

  let totalAsistencias = 0;
  let totalRetardos = 0;
  let totalFaltas = 0;
  let totalRegistros = 0;

  Object.values(alumnosMap).forEach(alumno => {
    let asist = 0, ret = 0, falt = 0;
    html += `<tr><td class="text-start">${alumno.nombre}</td>`;

    fechasOrdenadas.forEach(f => {
      // Obtener todos los registros de ese alumno en esa fecha
      const registrosFecha = alumno.registros.filter(r => r.fecha === f);

      let badge = '-';
      registrosFecha.forEach(r => {
        if(r.asistencia === 'Falta'){ falt++; badge = '<span class="badge bg-danger">F</span>'; }
        else if(r.asistencia === 'Retardo'){ ret++; if(badge !== '<span class="badge bg-danger">F</span>') badge = '<span class="badge bg-warning text-dark">R</span>'; }
        else if(r.asistencia === 'Asiste'){ asist++; if(badge === '-') badge = '<span class="badge bg-success">A</span>'; }
      });

      html += `<td>${badge}</td>`;
    });

    const totalAlumno = asist + ret + falt;
    const porcentaje = totalAlumno > 0 ? ((asist / totalAlumno) * 100).toFixed(1) : "0.0";

    totalAsistencias += asist;
    totalRetardos += ret;
    totalFaltas += falt;
    totalRegistros += totalAlumno;

    html += `<td>${asist}</td><td>${ret}</td><td>${falt}</td><td>${porcentaje}%</td></tr>`;
  });

  const porcentajeGlobal = totalRegistros > 0 ? ((totalAsistencias / totalRegistros) * 100).toFixed(1) : "0.0";

  html += `</tbody>
    <tfoot class="table-secondary fw-bold">
      <tr>
        <td>Total</td>`;
  fechasOrdenadas.forEach(() => html += `<td>-</td>`);
  html += `<td>${totalAsistencias}</td><td>${totalRetardos}</td><td>${totalFaltas}</td><td>${porcentajeGlobal}%</td>
      </tr>
    </tfoot>
  </table>
  </div>`;

  $("#divAsistenciasTable").html(html);
}



function fntViewAsistenciaFechas(idgrupo, idprofesor, idmateria){
    document.querySelector("#idGrupoVF").value = idgrupo;
    document.querySelector("#idProfesorVF").value = idprofesor;
    document.querySelector("#idMateriaVF").value = idmateria;
    document.querySelector("#formVerAsistencias").reset();
    $('#modalViewAsistenciaFechas').modal('show');
    
}


















function fntRegistrarAsistencia(idgrupo, idmateria){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Asistencias/getAlumnos'; 
    let formData = new FormData();
    formData.append('idgrupo', idgrupo);
    formData.append('idmateria', idmateria);
    request.open("POST",ajaxUrl,true);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                formAsistencias.reset();
                $("#divAlumnos").html("");
                document.querySelector("#idGrupo").value = objData.data[0].grupoid;
                document.querySelector("#idProfesor").value = objData.data[0].profesorid;
                document.querySelector("#idMateria").value = objData.data[0].materiaid; 
                document.querySelector("#txtMateria").value = objData.data[0].materia;
                document.querySelector("#txtProfesor").value = objData.data[0].nombre_docente;  
                document.querySelector("#txtGrupo").value = objData.data[0].grado+'-'+objData.data[0].grupo; 
                for (var i = 0; i < objData.data.length; i++) {
                    $('#divAlumnos').append(
                        '<div class="form-row">'+
                            '<div class="form-group col-md-5" style="align-content-center">'+
                                '<input class="form-control" type="text" id="txtAlumno" name="txtAlumno" value="'+objData.data[i].nombre_alumno+'" idalumno="'+objData.data[i].idalumno+'" readonly placeholder="Nombre del alumno">'+
                            '</div>'+
                            '<div class="form-group col-md-2" style="align-content-center">'+
                                '<input type="button" id="btnEstado" class="btn btn-success  btn-block btnChange" onClick="fntChange(this,'+objData.data[i].idalumno+')" title="Cambiar estado" estado="Asiste" value="Asiste"/>'+
                            '</div>'+
                            '<div class="form-group col-md-5" style="align-content-center">'+
                                '<textarea class="form-control" type="text" id="txtComentarios" name="txtComentarios" value=""></textarea>'+
                            '</div>'+
                        '</div>'
                    )
                }
                $('#modalFormAsistencias').modal("show");
            }else{
                swal("Error", objData.msg , "error");
            }
        }
        divLoading.style.display = "none";
        return false;
    }
}

function fntChange(element,idalumno){
    let estado = $(element).attr("estado");
    if(estado === "Asiste"){
        element.setAttribute("estado", "Retardo");
        element.value = "Retardo";
        element.classList.remove("btn-success");
        element.classList.add("btn-warning");
    }else if(estado === "Retardo"){
        element.setAttribute("estado", "Falta");
        element.value = "Falta";
        element.classList.remove("btn-warning");
        element.classList.add("btn-danger");
    }else{
        element.setAttribute("estado", "Asiste");
        element.value = "Asiste";
        element.classList.remove("btn-danger");
        element.classList.add("btn-success");
    }
}

$("#formAsistencias").on("click", "input#btnEstado", function(){
    listarElementos(); 
    return;
})

$("#formAsistencias").on("change", "textarea#txtComentarios", function(){
    listarElementos(); 
    return;
})

function listarElementos(){
    let listaElementos = [];
    let alumno = document.querySelectorAll("#txtAlumno");
    let estado = document.querySelectorAll("#btnEstado");
    let comentarios = document.querySelectorAll("#txtComentarios");
    for(let i = 0; i < alumno.length; i++){
        listaElementos.push({ "idalumno" : alumno[i].getAttribute("idAlumno"),
                            "asistencia" : estado[i].getAttribute('estado'),
                            "comentarios" : $(comentarios[i]).val()})   
    }
    $("#listaElementos").val(JSON.stringify(listaElementos)); 
}

$(function () {
    $("#txtFecha").datepicker({
        beforeShowDay: function (date) {
            var day = date.getDay();
            // Desactivar sábados (6) y domingos (0)
            return [day != 0 && day != 6, ''];
        }
    });
});

function fntEditarAsistencia(idgrupo, idmateria){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Asistencias/getAlumnos'; 
    let formData = new FormData();
    formData.append('idgrupo', idgrupo);
    formData.append('idmateria', idmateria);
    request.open("POST",ajaxUrl,true);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                formEditarAsistencias.reset();
                $("#divAlumnosE").html("");
                document.querySelector("#idGrupoE").value = objData.data[0].grupoid;
                document.querySelector("#idProfesorE").value = objData.data[0].profesorid;
                document.querySelector("#idMateriaE").value = objData.data[0].materiaid; 
                document.querySelector("#txtMateriaE").value = objData.data[0].materia;
                document.querySelector("#txtProfesorE").value = objData.data[0].nombre_docente;  
                document.querySelector("#txtGrupoE").value = objData.data[0].grado+'-'+objData.data[0].grupo; 

                $("#fechas").html("");
                let requestE = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                let ajaxUrlE = base_url+'/Asistencias/getFechas'; 
                let formDataE = new FormData();
                formDataE.append('idgrupo', objData.data[0].grupoid);
                formDataE.append('idprofesor', objData.data[0].profesorid);
                formDataE.append('idmateria', objData.data[0].materiaid);
                requestE.open("POST",ajaxUrlE,true);
                requestE.send(formDataE);
                requestE.onreadystatechange = function(){
                    if(requestE.readyState == 4 && requestE.status == 200){
                        let objDataE = JSON.parse(requestE.responseText);
                        if(objDataE.status)
                        {
                            
                            let selectHtml = '<select class="form-control selectpicker" data-live-search="true" id="listFechas" name="listFechas" required>';

                            for (let i = 0; i < objDataE.data.length; i++) {
                                selectHtml += '<option value="' + objDataE.data[i].fecha + '">' + objDataE.data[i].fecha + '</option>';
                            }

                            selectHtml += '</select>';

                            $("#fechas").html(selectHtml); // o .append(selectHtml) si no quieres reemplazar contenido previo

                            // Si usas Bootstrap Select, necesitas inicializar o refrescar:
                            $('.selectpicker').selectpicker('render'); // o 'refresh' si ya existía

                        }else{
                            swal("Advertencia", objDataE.msg , "warning");
                        }
                    }
                    return false;
                }





                $('#modalFormEditarAsistencias').modal("show");
            }else{
                swal("Error", objData.msg , "error");
            }
        }
        divLoading.style.display = "none";
        return false;
    }
}

$("#formEditarAsistencias").on("click", "input#btnEstadoE", function(){
    listarElementosE(); 
    return;
})

$("#formEditarAsistencias").on("change", "textarea#txtComentariosE", function(){
    listarElementosE(); 
    return;
})

function listarElementosE(){
    let listaElementosE = [];
    let alumnoE = document.querySelectorAll("#txtAlumnoE");
    let estadoE = document.querySelectorAll("#btnEstadoE");
    let comentariosE = document.querySelectorAll("#txtComentariosE");
    //console.log(estadoE);
    for(let i = 0; i < alumnoE.length; i++){
        listaElementosE.push({ "idalumno" : alumnoE[i].getAttribute("idAlumno"),
                            "asistencia" : estadoE[i].getAttribute('estado'),
                            "comentarios" : $(comentariosE[i]).val()})   
    }
    $("#listaElementosE").val(JSON.stringify(listaElementosE)); 
}

$("#formEditarAsistencias").on("change", "select#listFechas", function(){
    let fecha = document.querySelector("#listFechas").value;
    let grupoid = document.querySelector("#idGrupoE").value;
    let profesorid = document.querySelector("#idProfesorE").value;
    let materiaid = document.querySelector("#idMateriaE").value;
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Asistencias/getAsistencia'; 
    let formData = new FormData();
    formData.append('fecha', fecha);
    formData.append('idgrupo', grupoid);
    formData.append('idprofesor', profesorid);
    formData.append('idmateria', materiaid);
    request.open("POST",ajaxUrl,true);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                $("#divAlumnosE").html("");
                for (var i = 0; i < objData.data.length; i++) {
                    $('#divAlumnosE').append(
                        '<div class="form-row">'+
                            '<div class="form-group col-md-5" style="align-content-center">'+
                                '<input class="form-control" type="text" id="txtAlumnoE" name="txtAlumnoE" value="'+objData.data[i].nombre_alumno+'" idalumno="'+objData.data[i].idalumno+'" readonly placeholder="Nombre del alumno">'+
                            '</div>'+
                            '<div class="form-group col-md-2" style="align-content-center">'+
                                objData.data[i].btnEstado+
                            '</div>'+
                            '<div class="form-group col-md-5" style="align-content-center">'+
                                '<textarea class="form-control" type="text" id="txtComentariosE" name="txtComentariosE" value="'+objData.data[i].comentarios+'">'+objData.data[i].comentarios+'</textarea>'+
                            '</div>'+
                        '</div>'
                    )
                }
                //$('#modalFormEditarAsistencias').modal("show");
            }else{
                $("#divAlumnosE").html("");
                swal("Error", objData.msg , "error");
            }
        }
        divLoading.style.display = "none";
        return false;
    }
})

function fntDelMateria(idmateria){
    swal({
        title: "Eliminar Materia",
        text: "¿Realmente quiere eliminar el registro de la materia?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Materias/delMateria';
            let strData = "idmateria="+idmateria;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableAsistencias.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idMateria').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nueva Materia";
    document.querySelector("#formAsistencias").reset();
    if(document.querySelector("#listNivel"))
    {
        document.querySelector("#listNivel").value = 0;
        $('#listNivel').selectpicker('render');
    }
    if(document.querySelector("#listStatus"))
    {
        document.querySelector("#listStatus").value = 1;
        $('#listStatus').selectpicker('render');
    }
    $('#modalFormMaterias').modal('show');
}