let tableGrupos;
let rowTable = ""; 
let url;
//let optionCarreras = "";
let divLoading = document.querySelector("#divLoading");
let promedioParcialesCalculado = 0;
//const url = `${base_url}/Calificaciones/generarActasMasivas/${semestre}/${nivelid}/${carreraid}/${grupoid}/${profesorid}/${materiaid}/${parcialID}`;
//Variable global para el conteo de cambios y la referencia al botón (necesarias para el scope)
let cambiosRealizados = 0;
let botonGuardar = null; // Se inicializa a null y se asigna dentro de actualizarBotonGuardar
document.addEventListener('DOMContentLoaded', function(){
})

if (document.querySelector("#formBusqueda")) {
    let formBusqueda = document.querySelector("#formBusqueda");
    formBusqueda.onsubmit = function(e) {
        e.preventDefault();
        
        // Recolección de IDs
        let intNivelId = document.querySelector("#listNiveles").value;
        let intCarreraId = document.querySelector("#listCarreras") ? document.querySelector("#listCarreras").value : null;
        let strGrupo = document.querySelector("#listGrupos") ? document.querySelector("#listGrupos").value : null;
        let intMateriaId = document.querySelector("#listMaterias") ? document.querySelector("#listMaterias").value : null;
        
        // Validación de campos obligatorios
        if (intNivelId == 0 || intCarreraId == 0 || strGrupo == 0 || intMateriaId == 0 ||
            intNivelId == '' || intCarreraId == '' || strGrupo == '' || intMateriaId == '') 
        {
            swal("Atención", "Todos los campos son obligatorios.", "error");
            return false;
        }

        // Validación de inputs en rojo
        let elementsValid = document.getElementsByClassName("valid");
        for (let i = 0; i < elementsValid.length; i++) {
            if (elementsValid[i].classList.contains('is-invalid')) {
                swal("Atención", "Por favor verifique los campos en rojo.", "error");
                return false;
            }
        }
        
        divLoading.style.display = "flex";
        let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
        let ajaxUrl = base_url + '/Calificaciones/getBusquedaAlumnos';
        let formData = new FormData(formBusqueda);
        request.open("POST", ajaxUrl, true);
        request.send(formData);
        
        request.onreadystatechange = function() {
            if (request.readyState == 4 && request.status == 200) {
                let objData = JSON.parse(request.responseText);
                if (objData.status) {
                    // Inicializar el botón de guardar antes de generar la tabla
                    if (!botonGuardar) {
                        botonGuardar = document.getElementById("btnGuardarCalificaciones");
                    }
                    console.log(objData);
                    generarTablaCalificaciones(objData);
                    actualizarBotonGuardar();
                } else {
                    swal("¡Error!", objData.msg, "error");
                    document.getElementById("formularioCalificaciones").style.display = "none";
                }
            }
            divLoading.style.display = "none";
            return false;
        }
    }
}

// ----------------------------------------------------------------------
// 2. GENERACIÓN Y PRECARGA DE LA TABLA (MÚLTIPLES PARCIALES)
// ----------------------------------------------------------------------

function generarTablaCalificaciones(objData) {
    //console.log(objData);
    // Reseteo del contador de cambios al cargar nuevos datos
    cambiosRealizados = 0;
    $('.divAlumnos').html("");

    $('#divReporteMasivo').html('');

    // 1. Inicializar la estructura de la tabla con los 3 parciales MÁS LAS NUEVAS COLUMNAS
    $('.divAlumnos').html(
        '<div class="table-responsive">' +
            '<table id="tablaCalificaciones" class="table table-striped table-bordered table-hover">' +
                '<thead>' +
                    // Fila 1: Títulos principales (colspan para agrupar)
                    '<tr>' +
                        '<th rowspan="2">#</th>' +
                        '<th rowspan="2">Matrícula</th>' +
                        '<th rowspan="2">Alumno</th>' +
                        // ID's únicos para botones
                        '<th colspan="3" class="text-center bg-danger text-white" id="header-parcial-1">1ER PARCIAL</th>' +
                        '<th colspan="3" class="text-center bg-danger text-white" id="header-parcial-2">2DO PARCIAL</th>' +
                        '<th colspan="3" class="text-center bg-danger text-white" id="header-parcial-3">3ER PARCIAL</th>' +
                        // NUEVAS COLUMNAS DE RESUMEN
                        '<th colspan="1" class="text-center bg-danger text-white">PROMEDIO PARCIALES</th>' + // Nuevo Encabezado
                        '<th colspan="1" class="text-center bg-danger text-white">ORDINARIO</th>' + // Nuevo Encabezado
                        '<th colspan="1" class="text-center bg-danger text-white">CALIFICACIÓN FINAL</th>' + // Nuevo Encabezado
                        '<th colspan="1" class="text-center bg-danger text-white">REPORTAR EN ACTA</th>' + // Nuevo Encabezado
                    '</tr>' +
                    // Títulos detallados (Faltas, Tareas, Calificación)
                    '<tr>' +
                        '<th>Faltas</th><th>Tareas no entregadas</th><th>Calificación</th>' +
                        '<th>Faltas</th><th>Tareas no entregadas</th><th>Calificación</th>' +
                        '<th>Faltas</th><th>Tareas no entregadas</th><th>Calificación</th>' +
                        // NUEVOS SUB-ENCABEZADOS
                        '<th>Calificación</th>' + // Promedio Parciales
                        '<th>Calificación</th>' + // Ordinario
                        '<th>Calificación</th>' + // Calificación Final
                        '<th>Calificación</th>' + // Reporte en Acta
                    '</tr>' +
                '</thead>' +
                '<tbody></tbody>' +
            '</table>' +
        '</div>'
    );
    
    document.getElementById("formularioCalificaciones").style.display = "";
    
    let cont = 1;
    let rolid = document.querySelector("#txtRID").value;
    console.log(rolid);
    let tablaBody = $('#tablaCalificaciones tbody');

    // 2. Indexar Registros de Calificaciones Existentes por alumnoid
    const dataCalificacionesBD = {};
    const sourceDataCalificaciones = objData.calificaciones || [];

    if (sourceDataCalificaciones.length > 0) {
        sourceDataCalificaciones.forEach(reg => {
            dataCalificacionesBD[reg.alumnoid] = reg;
        });
    }

    //Iterar sobre la lista de ALUMNOS (objData.data) y generar las filas
    for (var i = 0; i < objData.data.length; i++) {
        let alumno = objData.data[i];
        let registroBD = dataCalificacionesBD[alumno.idalumno] || {};

        let row = '<tr>' +
            '<td>' + cont + '</td>' +
            '<td>' + alumno.matricula + '</td>' +
            '<td>' + alumno.nombre_alumno + '</td>';

        const parciales = [
            { id: 1, prefijo: 'primero_' },
            { id: 2, prefijo: 'segundo_' },
            { id: 3, prefijo: 'tercero_' }
        ];
        
        // Variables para el cálculo del promedio de parciales
        let sumatoriaCalificaciones = 0;
        let contadorParcialesValidos = 0;

        parciales.forEach(parcial => {
            const p = parcial.id;
            const prefijo = parcial.prefijo;
            let restriccionFaltas = '';
            let restriccionTareas = '';
            let restriccionCalificacion = '';
            
            // Obtener valores precargados usando los sufijos de la BD
            const faltas_val = registroBD[prefijo + 'inasistencias'] || '';
            const tareas_val = registroBD[prefijo + 'ntareas'] || '';
            const calif_val  = registroBD[prefijo + 'calificacion']; // Importante: debe ser null/valor, no usar || ''

            // Lógica para el cálculo del promedio de parciales
            const calificacionNumerica = parseFloat(calif_val);
            if (!isNaN(calificacionNumerica) && calif_val !== null) {
                sumatoriaCalificaciones += calificacionNumerica;
                contadorParcialesValidos++;
            }

            if(rolid == 1 || rolid == 4 || rolid == 8)
            {
                // Rol con privilegios (puede modificar todo siempre)
                // --- INPUT DE FALTAS (data-tipo="faltas") ---
                row += '<td>' +
                    '<input type="number" min="0" step="1" class="form-control form-control-sm input-calificacion" ' +
                    'data-idalumno="' + alumno.idalumno + '" data-parcial="' + p + '" data-tipo="faltas" ' +
                    'value="' + faltas_val + '" placeholder="F" oninput="validarYContarCambios(this, \'entero\')" />' +
                    '</td>';

                // --- INPUT DE TAREAS NO ENTREGADAS (data-tipo="tareas") ---
                row += '<td>' +
                    '<input type="number" min="0" step="1" class="form-control form-control-sm input-calificacion" ' +
                    'data-idalumno="' + alumno.idalumno + '" data-parcial="' + p + '" data-tipo="tareas" ' +
                    'value="' + tareas_val + '" placeholder="T" oninput="validarYContarCambios(this, \'entero\')" />' +
                    '</td>';

                // --- INPUT DE CALIFICACIÓN (data-tipo="calificacion") ---
                // Cambiado max="10" a max="100" según el formato de datos de ejemplo (93, 95, 100)
                row += '<td>' +
                    '<input type="number" min="0" max="100" step="0.1" class="form-control form-control-sm input-calificacion calificacion-parcial" ' +
                    'data-idalumno="' + alumno.idalumno + '" data-parcial="' + p + '" data-tipo="calificacion" ' +
                    'value="' + (calif_val !== null ? calif_val : '') + '" placeholder="C" oninput="validarYContarCambios(this, \'calificacion\')" />' +
                    '</td>';
            }else{
                // Rol docente (solo puede modificar si no hay valor previo)
                if(faltas_val != ''){restriccionFaltas = 'readonly=""'}
                if(tareas_val != ''){restriccionTareas = 'readonly=""'}
                // Aplicar readonly si la calificación es diferente de null o cadena vacía (incluye 0)
                if(calif_val != null && calif_val != ''){restriccionCalificacion = 'readonly=""'}

                // --- INPUT DE FALTAS (data-tipo="faltas") ---
                row += '<td>' +
                    '<input type="number" min="0" step="1" class="form-control form-control-sm input-calificacion" ' +
                    'data-idalumno="' + alumno.idalumno + '" data-parcial="' + p + '" data-tipo="faltas" ' +
                    'value="' + faltas_val + '" placeholder="F" oninput="validarYContarCambios(this, \'entero\')" '+restriccionFaltas+' />' +
                    '</td>';

                // --- INPUT DE TAREAS NO ENTREGADAS (data-tipo="tareas") ---
                row += '<td>' +
                    '<input type="number" min="0" step="1" class="form-control form-control-sm input-calificacion" ' +
                    'data-idalumno="' + alumno.idalumno + '" data-parcial="' + p + '" data-tipo="tareas" ' +
                    'value="' + tareas_val + '" placeholder="T" oninput="validarYContarCambios(this, \'entero\')" '+restriccionTareas+' />' +
                    '</td>';

                // --- INPUT DE CALIFICACIÓN (data-tipo="calificacion") ---
                row += '<td>' +
                    '<input type="number" min="0" max="100" step="0.1" class="form-control form-control-sm input-calificacion calificacion-parcial" ' +
                    'data-idalumno="' + alumno.idalumno + '" data-parcial="' + p + '" data-tipo="calificacion" ' +
                    'value="' + (calif_val !== null ? calif_val : '') + '" placeholder="C" oninput="validarYContarCambios(this, \'calificacion\')" '+restriccionCalificacion+' />' +
                    '</td>';
            }
        });

        // CÁLCULO DE PROMEDIO DE PARCIALES
        const promedioParciales = (contadorParcialesValidos > 0) ? (sumatoriaCalificaciones / contadorParcialesValidos) : 0;
        const promedioParcialesRedondeado = promedioParciales.toFixed(2);
        
        // --- COLUMNA PROMEDIO PARCIALES (Solo Lectura) ---
        row += '<td>' +
            '<input type="text" class="form-control form-control-sm text-center bg-light promedio-parciales-input" ' +
            'value="' + (promedioParciales > 0 ? promedioParcialesRedondeado : '') + '" readonly="" />' +
            '</td>';

        // OBTENER CALIFICACIÓN ORDINARIO
        const ordinario_val = registroBD.ordinario_calificacion;
        const ordinario_display_val = (ordinario_val !== null && ordinario_val !== '') ? ordinario_val : '';
        const ordinario_placeholder = 'C';
        let restriccionOrdinario = '';
        
        // Aplicar restricción si es rol docente y el campo Ordinario ya tiene valor
        if(!(rolid == 1 || rolid == 4 || rolid == 8) && (ordinario_val != null && ordinario_val != '')) {
            restriccionOrdinario = 'readonly=""';
        }

        // --- COLUMNA ORDINARIO (Editable/Restringido, clase única para guardar) ---
        row += '<td>' +
            '<input type="number" min="0" max="100" step="0.1" class="form-control form-control-sm input-calificacion-ordinario input-calificacion" ' +
            'data-idalumno="' + alumno.idalumno + '" data-parcial="0" data-tipo="ordinario" ' + // data-parcial=0 para distinguir en el guardado
            'value="' + ordinario_display_val + '" placeholder="' + ordinario_placeholder + '" oninput="validarYContarCambios(this, \'calificacion\')" ' + restriccionOrdinario + ' />' +
            '</td>';

        // CÁLCULO DE CALIFICACIÓN FINAL
        let calificacionFinal = promedioParciales; // Valor base: Promedio Parciales

        const ordinarioNumerico = parseFloat(ordinario_display_val);
        // Verificar si existe una calificación de Ordinario válida y tomar promedio
        if (!isNaN(ordinarioNumerico) && ordinario_display_val !== '') {
            calificacionFinal = (promedioParciales + ordinarioNumerico) / 2;
        }
        
        const calificacionFinalRedondeada = calificacionFinal.toFixed(2);

        // --- COLUMNA CALIFICACIÓN FINAL (Solo Lectura) ---
        row += '<td>' +
            '<input type="text" class="form-control form-control-sm text-center bg-light calificacion-final" ' +
            'data-idalumno="' + alumno.idalumno + '" ' + 
            'value="' + (calificacionFinal > 0 ? calificacionFinalRedondeada : '') + '" readonly="" />' +
            '</td>';
        
        // CÁLCULO DE REPORTAR EN ACTA (Redondeo basado en la Calificación Final)
        const calificacionReporte = calcularCalificacionReporte(calificacionFinal);

        // --- COLUMNA REPORTAR EN ACTA (Solo Lectura con lógica de 50) ---
        let readonlyReporte = 'readonly'; // Siempre es readonly
        let valorReporte = calificacionReporte;
        
        if (calificacionFinal < 70 && calificacionFinal > 0) {
            valorReporte = '50';
        } else if (calificacionFinal === 0) {
            valorReporte = ''; // Si no hay calificaciones, dejar vacío
        }

        row += '<td>' +
            '<input type="text" class="form-control form-control-sm text-center bg-light" ' +
            'value="' + valorReporte + '" readonly="" />' +
            '</td>';

        // **********************************************
        // ************ FIN NUEVAS COLUMNAS ************
        // **********************************************

        row += '</tr>';
        tablaBody.append(row);
        cont++;
    }
    
    //Actualización de datos informativos y GENERACIÓN DE BOTONES (IMPLEMENTACIÓN CLAVE)
    //Captura de todos los IDs
    let select = document.getElementById('listPeriodo');
    document.querySelector("#txtNivel").value = objData.nivel.nivel;
    document.querySelector("#txtNivel").setAttribute('idnivel', objData.nivel.idnivel);
    const idNivel = document.querySelector("#txtNivel").getAttribute('idnivel');

    document.querySelector("#txtCarrera").value = objData.nivel.nivel;
    document.querySelector("#txtCarrera").setAttribute('idcarrera', objData.carrera.idcarrera);
    const idCarrera = document.querySelector("#txtCarrera").getAttribute('idcarrera');

    document.querySelector("#txtProfesor").value = objData.docente.nombre_docente;
    document.querySelector("#txtProfesor").setAttribute('idprofesor', objData.docente.idpersona);
    const idProfesor = document.querySelector("#txtProfesor").getAttribute('idprofesor');

    document.querySelector("#txtMateria").value = objData.materia.materia;
    document.querySelector("#txtMateria").setAttribute('idmateria', objData.materia.idmateria);
    const idMateria = document.querySelector("#txtMateria").getAttribute('idmateria');

    document.querySelector("#txtSemestre").value = objData.data[0].grado;
    const semestre = objData.data[0].grado;

    document.querySelector("#txtGrupo").value = objData.data[0].grupo_format;
    document.querySelector("#txtGrupo").setAttribute('idgrupo', objData.data[0].idgrupo);
    const idGrupo = document.querySelector("#txtGrupo").getAttribute('idgrupo');

    //Inyección de botones
    
    // Función helper para generar el HTML del botón con todos los parámetros
    const getBtnHTML = (parcialID) => `
        <button type="button" class="btn btn-sm btn-light ml-2 btn-reporte-parcial"
            onclick="generarReporteMasivo(
                ${semestre},
                ${idNivel},
                ${idCarrera},
                ${idGrupo},
                ${idProfesor},
                ${idMateria},
                ${parcialID}
            )" title="Reporte Masivo Parcial ${parcialID}">
            <i class="fas fa-file-pdf text-danger"></i>
        </button>`;

    // Inyección en cada encabezado de parcial
    $('#header-parcial-1').append(getBtnHTML(1));
    $('#header-parcial-2').append(getBtnHTML(2));
    $('#header-parcial-3').append(getBtnHTML(3));
}

// =========================================================================
// FUNCIÓN AUXILIAR PARA LA LÓGICA DE REPORTAR EN ACTA (SE DEBE DECLARAR)
// =========================================================================

/**
 * Aplica la lógica de redondeo para la calificación de Reporte en Acta.
 * @param {number} calificacionFinal - La calificación final calculada (Promedio Parciales o Promedio Parciales + Ordinario/2).
 * @returns {string|number} La calificación a reportar según las reglas.
 */
function calcularCalificacionReporte(calificacionFinal) {
    if (calificacionFinal <= 0) {
        return '';
    } else if (calificacionFinal < 70) {
        // El valor 50 se asigna en la función principal junto con 'readonly'
        return '50'; 
    } else if (calificacionFinal >= 70 && calificacionFinal < 75) {
        return 70;
    } else if (calificacionFinal >= 75 && calificacionFinal < 85) {
        return 80;
    } else if (calificacionFinal >= 85 && calificacionFinal < 95) {
        return 90;
    } else if (calificacionFinal >= 95) {
        return 100;
    }
    return '';
}

// NUEVA FUNCIÓN PARA LA LÓGICA DE REPORTAR EN ACTA
function calcularCalificacionReporte(calificacionFinal) {
    if (calificacionFinal < 70) {
        return 50; // Ya se maneja en el HTML como readonly 50
    } else if (calificacionFinal >= 70 && calificacionFinal < 75) {
        return 70;
    } else if (calificacionFinal >= 75 && calificacionFinal < 85) {
        return 80;
    } else if (calificacionFinal >= 85 && calificacionFinal < 95) {
        return 90;
    } else if (calificacionFinal >= 95) {
        return 100;
    }
    return '';
}

//FUNCIÓN PARA VALIDACIÓN EN TIEMPO REAL Y CONTEO DE CAMBIOS

function validarYContarCambios(input, tipoValidacion) {
    let valor = input.value;
    let esValido = true;
    let numero = parseFloat(valor);

    //Quitar la clase de error por defecto
    input.classList.remove('is-invalid');

    if (valor === "") {
        //Si el valor se borra, y antes se había marcado como cambiado, se revierte el conteo.
        if (input.getAttribute('data-cambiado') === 'true') {
            cambiosRealizados--;
            input.setAttribute('data-cambiado', 'false');
        }
        actualizarBotonGuardar();
        //Si el campo es vacío, no se valida el formato, pero se requiere para el envío
        return; 
    }

    //Validación de tipo de dato y rango
    if (isNaN(numero)) {
        esValido = false;
    } else if (tipoValidacion === 'calificacion') {
        // Calificación: [0, 100]
        if (numero < 0 || numero > 100) {
            esValido = false;
        }
        // Validación estricta de un solo decimal
        //const partes = valor.split('.');
        //if (partes.length > 1 && partes[1].length > 1) {
            //esValido = false;
        //}
    } else if (tipoValidacion === 'entero') {
        // Faltas/Tareas: Entero y no negativo
        if (numero < 0 || (numero % 1 !== 0)) {
            esValido = false;
        }
    }

    // 3. Aplicar estilo de error y ajustar el contador
    if (!esValido) {
        input.classList.add('is-invalid');
        input.setAttribute('data-cambiado', 'false');
    } else {
        if (input.getAttribute('data-cambiado') !== 'true') {
            cambiosRealizados++;
            input.setAttribute('data-cambiado', 'true');
        }
    }

    actualizarBotonGuardar();
}

//FUNCIÓN DE GUARDAR Y ENVÍO AJAX

function actualizarBotonGuardar() {
    // Si el botón no existe, lo busca (necesario al inicio de la carga)
    if (!botonGuardar) {
        botonGuardar = document.getElementById("btnGuardarCalificaciones");
        if (!botonGuardar) {
            console.error("El botón 'btnGuardarCalificaciones' no se encontró en el DOM.");
            return;
        }
    }

    botonGuardar.textContent = `Registrar Cambios (${cambiosRealizados})`;
    botonGuardar.disabled = cambiosRealizados === 0;
}

function guardarCalificaciones() {
    const inputsCalificacion = document.querySelectorAll('.input-calificacion');
    let hayErroresDeValidacion = false;

    // 1. Validar solo los campos que tienen errores antes de intentar agrupar
    inputsCalificacion.forEach(input => {
        if (input.classList.contains('is-invalid')) {
            hayErroresDeValidacion = true;
        }
    });

    if (hayErroresDeValidacion) {
        swal("Atención", "Por favor corrija los campos en rojo.", "error");
        return;
    }
    
    // 2. RECOLECCIÓN ÚNICAMENTE DE CAMBIOS REALIZADOS
    const alumnos = {};
    let cambiosContados = 0;

    inputsCalificacion.forEach(input => {
        // CLAVE: Solo procesamos si data-cambiado es true
        if (input.getAttribute('data-cambiado') === 'true') {
            cambiosContados++;
            let idalumno = input.getAttribute('data-idalumno');
            let parcial = input.getAttribute('data-parcial');
            let tipo = input.getAttribute('data-tipo'); 
            let valor = input.value;
            
            if (!alumnos[idalumno]) { alumnos[idalumno] = {}; }
            
            if (tipo === 'ordinario') {
                alumnos[idalumno]['calificacion_ordinario'] = valor;
            } else {
                if (!alumnos[idalumno]['parciales']) { alumnos[idalumno]['parciales'] = {}; }
                if (!alumnos[idalumno]['parciales'][parcial]) { alumnos[idalumno]['parciales'][parcial] = {}; }
                alumnos[idalumno]['parciales'][parcial][tipo] = valor;
            }
        }
    });

    if (cambiosContados === 0) {
        swal("Atención", "No se detectaron cambios para guardar.", "info");
        return;
    }

    // 3. Estructura del array final (Idéntica a la que espera tu Modelo)
    const array_final = [];
    for (const idalumno in alumnos) {
        const alumnoData = alumnos[idalumno];
        
        // Si hay parciales modificados
        if (alumnoData.parciales) {
            for (const p in alumnoData.parciales) {
                const parcialData = alumnoData.parciales[p];
                array_final.push({
                    idalumno: idalumno,
                    parcial: p,
                    faltas: parcialData.faltas ?? null,
                    tareas_nentregadas: parcialData.tareas ?? null,
                    calificacion: parcialData.calificacion ?? null,
                    calificacion_ordinario: alumnoData.calificacion_ordinario ?? null
                });
            }
        } 
        // Si solo se modificó el ordinario
        else if (alumnoData.calificacion_ordinario !== undefined) {
            array_final.push({
                idalumno: idalumno,
                parcial: '0',
                calificacion_ordinario: alumnoData.calificacion_ordinario,
                faltas: null,
                tareas_nentregadas: null,
                calificacion: null
            });
        }
    }
    
    const dataJSON = JSON.stringify(array_final);
    
    // Sincronización con los nombres de variables de tu Controlador
    let formData = new FormData(); // Usamos un FormData limpio para asegurar precisión
    formData.append("json_calificaciones", dataJSON);
    formData.append("nivelid", document.querySelector("#txtNivel").getAttribute('idnivel'));
    formData.append("carreraid", document.querySelector("#txtCarrera").getAttribute('idcarrera'));
    formData.append("profesorid", document.querySelector("#txtProfesor").getAttribute('idprofesor'));
    formData.append("materiaid", document.querySelector("#txtMateria").getAttribute('idmateria'));
    formData.append("grupoid", document.querySelector("#txtGrupo").getAttribute('idgrupo'));
    formData.append("txtSemestre", document.querySelector("#txtSemestre").value);
    // Nombres exactos que tu controlador busca en el if(empty)
    formData.append("txtCarrera", document.querySelector("#txtCarrera").value);
    formData.append("txtProfesor", document.querySelector("#txtProfesor").value);
    formData.append("txtMateria", document.querySelector("#txtMateria").value);

    divLoading.style.display = "flex";
    fetch(base_url + '/Calificaciones/setCalificacion', {
        method: 'POST',
        body: formData
    })
    .then(res => res.json())
    .then(objData => {
        divLoading.style.display = "none";
        if (objData.status) {
            swal("Éxito", objData.msg, "success");
            setTimeout(() => location.reload(), 2000);
        } else {
            swal("Error", objData.msg, "error");
        }
    })
    .catch(() => {
        divLoading.style.display = "none";
        swal("Error", "Error de conexión.", "error");
    });
}

function generarReporteMasivo(semestre, nivelid, carreraid, grupoid, profesorid, materiaid, parcialID) {
    const url = `${base_url}/Calificaciones/generarActasMasivas/${semestre}/${nivelid}/${carreraid}/${grupoid}/${profesorid}/${materiaid}/${parcialID}`;
    window.open(url, '_blank');
}

if(document.querySelector("#formCalificaciones")){
    let formCalificaciones = document.querySelector("#formCalificaciones");
    formCalificaciones.onsubmit = function(e) {
        e.preventDefault();
        let strNivel = "";
        let strCarrera = "";
        let strDocente = "";
        let strMateria = "";
        let intNivelId = "";
        let intCarreraId = "";
        let intDocenteId = "";
        let intMateriaId = "";
        let strFechaCaptura = "Fecha";
        let intGrupo = document.querySelector('#listGrupos').value;
        let alumnos = document.querySelector('#listaElementos').value;

        if(document.querySelector("#txtNivel"))
        {
            strNivel = document.querySelector("#txtNivel").value;
            intNivelId = document.querySelector("#txtNivel").getAttribute('idnivel');
        }

        if(document.querySelector("#txtCarrera"))
        {
            strCarrera = document.querySelector("#txtCarrera").value;
            intCarreraId = document.querySelector("#txtCarrera").getAttribute('idcarrera');
        }

        if(document.querySelector("#txtGrupo"))
        {
            strGrupo = document.querySelector("#txtGrupo").value;
            intGrupoId = document.querySelector("#txtGrupo").getAttribute('idgrupo');
        }

        if(document.querySelector("#txtDocente"))
        {
            strDocente = document.querySelector("#txtDocente").value;
            intDocenteId = document.querySelector("#txtDocente").getAttribute('iddocente');
        }

        if(document.querySelector("#txtMateria"))
        {
            strMateria = document.querySelector("#txtMateria").value;
            intMateriaId = document.querySelector("#txtMateria").getAttribute('idmateria');
        }

        if(document.querySelector("#txtFechaCaptura"))
        {
            strFechaCaptura = document.querySelector("#txtFechaCaptura").value;
        }

        console.log("Nivel: "+strNivel);
        console.log("Carrera: "+strCarrera);
        console.log("Docente: "+strDocente);
        console.log("Materia: "+strMateria);
        console.log("Fecha Captura: "+strNivel);
        console.log("Alumnos: "+alumnos);
        return;

        if(strNivel == '' || strNivel == null || strCarrera == '' || strCarrera == null 
            || strDocente == '' || strDocente == null || strMateria == '' || strMateria == null 
            || strNivel == 0 || strCarrera == 0 || strDocente == 0 || strMateria == 0 || strFechaCaptura == '' 
            || alumnos == '')
        {
            swal("Atención", "Todos los campos son obligatorios." , "error");
            return false;
        }

        let elementsValid = document.getElementsByClassName("valid");
        for (let i = 0; i < elementsValid.length; i++) { 
            if(elementsValid[i].classList.contains('is-invalid')) { 
                swal("Atención", "Por favor verifique los campos en rojo." , "error");
                return false;
            } 
        } 

        let arrayJson = JSON.parse(alumnos);
        let calReprobatoria = false;
        let alumnosReprobados = [];
        for(var i = 0; i < arrayJson.length; i++)
        {
            if(isNaN(arrayJson[i].calificacion_a))
            {
                if(arrayJson[i].calificacion_a == 'NA' || arrayJson[i].calificacion_a == 'na')
                {
                    calReprobatoria = true;
                    alumnosReprobados.push({"idalumno" : arrayJson[i].idalumno,
                                            "nombre_alumno" : arrayJson[i].nombre_alumno});  
                }
                if(arrayJson[i].calificacion_a != 'AC' && arrayJson[i].calificacion_a != 'NA' && arrayJson[i].calificacion != 'ac' && arrayJson[i].calificacion != 'na')
                {
                    swal("Error!", 'La calificación no puede ser diferente de AC o NA' , "error");
                    return;
                }
                
            }else{
                if(arrayJson[i].calificacion_a != '' && arrayJson[i].calificacion_a < 70)
                {
                    calReprobatoria = true;
                    alumnosReprobados.push({"idalumno" : arrayJson[i].idalumno,
                                            "nombre_alumno" : arrayJson[i].nombre_alumno});  
                }
                if(arrayJson[i].calificacion_a != '' && arrayJson[i].calificacion_a < 10)
                {
                    swal("Error!", 'La calificación no puede ser menor a 10' , "error");
                    return;
                }
                if(arrayJson[i].calificacion_a != '' && arrayJson[i].calificacion_a > 100)
                {
                    swal("Error!", 'La calificación no puede ser mayor a 100' , "error");
                    return;
                }
                
            }
        }

        if(alumnosReprobados.length === 0)
        {
            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Calificaciones/setCalificacion'; 
            let formData = new FormData(formCalificaciones);
            request.open("POST",ajaxUrl,true);
            formData.append("nivelid", intNivelId);
            formData.append("carreraid", intCarreraId);
            formData.append("docenteid", intDocenteId);
            formData.append("materiaid", intMateriaId);
            formData.append("grupoid", intGrupoId);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Calificaciones", objData.msg ,"success");
                        setTimeout(function(){
                            window.location.reload(true);
                        }, 2000);
                    }else{
                        swal("¡Error!", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }

        }else{
            swal({
                title: "¡ATENCIÓN! Calificación No Aprobatoria",
                text: "¿Realmente desea asignar calificación no aprobatoría?",
                type: "warning",
                showCancelButton: true,
                confirmButtonText: "Si, continuar!",
                cancelButtonText: "No, cancelar!",
                closeOnConfirm: false,
                closeOnCancel: true
            }, function(isConfirm) {
                if (isConfirm) 
                {
                    divLoading.style.display = "flex";
                    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                    let ajaxUrl = base_url+'/Calificaciones/setCalificacion'; 
                    let formData = new FormData(formCalificaciones);
                    request.open("POST",ajaxUrl,true);
                    formData.append("nivelid", intNivelId);
                    formData.append("carreraid", intCarreraId);
                    formData.append("docenteid", intDocenteId);
                    formData.append("materiaid", intMateriaId);
                    formData.append("grupo", strGrupo);
                    formData.append("grupoid", intGrupoId);
                    request.send(formData);
                    request.onreadystatechange = function(){
                        if(request.readyState == 4 && request.status == 200){
                            let objData = JSON.parse(request.responseText);
                            if(objData.status)
                            {
                                swal("Calificaciones", objData.msg ,"success");
                                setTimeout(function(){
                                    window.location.reload(true);
                                }, 2000);
                            }else{
                                swal("Error!", objData.msg , "error");
                            }

                        }
                        divLoading.style.display = "none";
                        return false;
                    }
                }
            });
        }     
    }
}

function fntViewGrupo(element,idgrupo){   
    let strGrupo = element.getAttribute('grupo');
    let intCarrera = element.getAttribute('carrera');
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Grupos/getGrupo/';
    request.open("POST",ajaxUrl,true);
    let formData = new FormData();
    formData.append("grupo",strGrupo);
    formData.append("carreraid",intCarrera);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                $("#modalTableGrupo").html("");
                let cont = 1;
                for (var i = 0; i < objData.data.length; i++) {
                    $("#modalTableGrupo").append(
                        '<tr>'+
                            '<td bgcolor="#D4EDDA">'+cont+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].matricula+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].nombre_alumno+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].sexo+'</td>'+
                        '</tr>'
                    );
                    document.querySelector("#txtNivel").value = objData.data[0].grado;
                    document.querySelector("#txtCarrera").value = objData.data[0].grupo;
                    document.querySelector("#txtDocente").value = objData.data[0].nivel;
                    document.querySelector("#txtMateria").value = objData.data[0].carrera;
                    cont++;
                }
                $('#modalViewGrupo').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

$("#listNiveles").change(function(){
    let nivelid = $(this).val();
    if (nivelid == "") {
        swal("Atención", "Tiene que seleccionar un nivel." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Calificaciones/getCarreras/'+nivelid;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionCarreras = "";
                optionCarreras += '<option value="0" selected>Seleccionar Carrera</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionCarreras += '<option value="'+objData.data[i].idcarrera+'">'+objData.data[i].carrera+'/'+objData.data[i].reforma+'</option>';
                }
                $('#divCarreras').html("");
                $('#divGrupos').html("");
                $('#divMaterias').html("");
                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divCarreras').append(
                    '<label>Carrera</label>'+
                    ' <select class="form-control selectpicker" data-live-search="true" id="listCarreras" name="listCarreras" required>'+
                        optionCarreras+
                    '</select>'
                );

                $('#listCarreras').selectpicker('render');
                swal("Carreras", objData.msg, "success");
            }else{
                $('#divCarreras').html("");
                $('#divGrupos').html("");
                $('#divMaterias').html("");
                document.getElementById("formularioCalificaciones").style.display = "none";
                swal("Error", objData.msg , "error");
            }
        }
    }    
})

$("#formBusqueda").on("change", "select#listCarreras", function(){
    let carreraid = $(this).val();
    if (carreraid == "") {
        swal("Atención", "Tiene que seleccionar una carrera." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Calificaciones/getGrupos/'+carreraid;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionGrupos = "";
                optionGrupos += '<option value="0" selected>Seleccionar Grupo</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionGrupos += '<option value="'+objData.data[i].idgrupo+'">'+objData.data[i].grado+'-'+objData.data[i].grupo+'</option>';
                }
                $('#divGrupos').html("");
                $('#divMaterias').html("");
                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divGrupos').append(
                    '<label>Grupo</label>'+
                    ' <select class="form-control selectpicker" data-live-search="true" id="listGrupos" name="listGrupos" required>'+
                        optionGrupos+
                    '</select>'
                );         
                $('#listGrupos').selectpicker('render');
                swal("Grupos", objData.msg, "success");
            }else{
                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divGrupos').html("");
                $('#divMaterias').html("");
                swal("Error", objData.msg , "error");
            }
        }
    }
    
})

$("#formBusqueda").on("change", "select#listGrupos", function(){
    let intCarrera = document.querySelector("#listCarreras").value;
    let intGrupo = $(this).val();

    if (intCarrera == "" || intCarrera == null || intGrupo == "" || intGrupo == 0) {
        swal("Atención", "Es necesario seleccionar carrera y grupo." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Calificaciones/getMaterias/';
    request.open("POST",ajaxUrl,true);
    let formData = new FormData();
    formData.append("carreraid", intCarrera);
    formData.append("grupoid", intGrupo);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionMaterias = "";
                optionMaterias += '<option value="0" selected>Seleccionar Materia</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionMaterias += '<option value="'+objData.data[i].idmateria+'">'+objData.data[i].materia+'</option>';
                }
                $('#divMaterias').html("");
                $('#divPeriodo').html("");

                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divMaterias').append(
                    '<label>Materia</label>'+
                    '<select class="form-control selectpicker" data-live-search="true" id="listMaterias" name="listMaterias" required>'+
                        optionMaterias+
                    '</select>'
                ); 

                $('#listMaterias').selectpicker('render');
                $('#listPeriodo').selectpicker('render');
                swal("Materias", objData.msg, "success");
            }else{
                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divMaterias').html("");
                swal("Error", objData.msg , "error");
            }
        }
    }
})

$("#formCalificaciones").on("change", "input#cbSeleccion", function(){
    listarElementos();
    actualizarStatus(); 
})

$("#formCalificaciones").on("change", "input#txtMatricula", function(){
    listarElementos(); 
})

$("#formCalificaciones").on("change", "input#txtAlumno", function(){
    listarElementos(); 
})

$("#formCalificaciones").on("change", "input#txtCalificacion", function(){
    listarElementos(); 
})

$("#formCalificaciones").on("change", "input#cbSeleccionarTodos", function(){
    let estado = this.checked;
    let cb = document.querySelectorAll("#cbSeleccion");
    if(estado == true)
    {
        for (var i = cb.length - 1; i >= 0; i--) {
            cb[i].checked = true;
        }
    }else{
        for (var i = cb.length - 1; i >= 0; i--) {
            cb[i].checked = false;
        }
    }
    listarElementos();
    actualizarStatus();
})

function listarElementos(){
    let listaElementos = [];
    let matricula = document.querySelectorAll("#txtMatricula");
    let alumno = document.querySelectorAll("#txtAlumno");
    let calificacion = document.querySelectorAll("#txtCalificacion");
    let cbEstado = document.querySelectorAll("#cbSeleccion");

    for(let i = 0; i < alumno.length; i++){
        if(cbEstado[i].checked == true)
        {
            listaElementos.push({ "idalumno" : alumno[i].getAttribute("idAlumno"),
                            "nombre_alumno" : $(alumno[i]).val(),
                            "calificacionid" : calificacion[i].getAttribute("idAlumno"),
                            "calificacion_a" : ($(calificacion[i]).val()).toLocaleUpperCase(),
                            "calificacion_b" : '',
                            "calificacion_c" : '',
                            "calificacion_d" : '',
                            "checked" : true,
                            "matricula" : $(matricula[i]).val()}) 
        }else{
            listaElementos.push({"idalumno" : alumno[i].getAttribute("idAlumno"),
                            "nombre_alumno" : $(alumno[i]).val(),
                            "calificacionid" : calificacion[i].getAttribute("idAlumno"),
                            "calificacion_a" : '',
                            "calificacion_b" : '',
                            "calificacion_c" : '',
                            "calificacion_d" : '',
                            "checked" : false,
                            "matricula" : $(matricula[i]).val()}) 
        }
    }
    $("#listaElementos").val(JSON.stringify(listaElementos)); 
}

function actualizarStatus(){
    let cbEstado = document.querySelectorAll("#cbSeleccion");
    let condicion = 0;
    for(let i = 0; i < cbEstado.length; i++){
        if(cbEstado[i].checked == true)
        {
            condicion = 1;
        }
    }
    $("#txtSeleccion").val(condicion); 
}