let tableDocentes;
let rowTable = ""; 
let optionGrupos = "";
let optionMaterias;
let objMaterias;
let divLoading = document.querySelector("#divLoading");

document.addEventListener('DOMContentLoaded', function(){

    tableDocentes = $('#tableDocentes').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Cargas/getDocentes",
            "dataSrc":""
        },
        "columns":[
            {"data":"idpersona", visible: false},
            {"data":"nombre_docente"},
            {"data":"direccion"},
            {"data":"telefono"},
            {"data":"email_user"},
            {"data":"cantidad_materias"},
            {"data":"ultima_modificacion_format"},
            {"data":"status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[1,"asc"]]  
    });

    if(document.querySelector("#formCargas")){
        let formCargas = document.querySelector("#formCargas");
        formCargas.onsubmit = function(e) {
            e.preventDefault();
            let strNombre= document.querySelector('#txtNombreDocente').value;
            let strNombreFormat = formatearPalabra(strNombre);
            let strDireccion= document.querySelector('#txtDireccion').value;
            let strDireccionFormat = formatearPalabra(strDireccion);
            let strTelefono= document.querySelector('#txtTelefono').value;
            let strEmail= document.querySelector('#txtEmail').value;
            let intCarreraId= document.querySelector('#listCarreras').value;
            let strGrupo= document.querySelector('#listGrupos').value;
            let listaElementos = document.querySelector('#listaElementos').value;
            
            if(strNombre == '' || strEmail == '' || intCarreraId == '' || strGrupo == '' || listaElementos == 0)
            {
                swal("Atención", "Favor de llenar todos los campos obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            //tinyMCE.triggerSave();
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Cargas/setCarga'; 
            let formData = new FormData(formCargas);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        if(rowTable == ""){
                            tableDocentes.api().ajax.reload();
                        }else{
                            tableDocentes.api().ajax.reload();
                            rowTable = ""; 
                        }
                        $('#modalFormCargas').modal("hide");
                        formCargas.reset();
                        swal("Carga Académica", objData.msg ,"success");
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }
})


$("#listCarreras").change(function(){
    let carreraid = $(this).val();
    document.querySelector("#idCarrera").value = carreraid;
    let requestG = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrlG = base_url+'/Cargas/getGruposCarrera/'+carreraid; 
    requestG.open("GET",ajaxUrlG,true);
    requestG.send();
    requestG.onreadystatechange = function(){
        if(requestG.readyState == 4 && requestG.status == 200){
            let objDataG = JSON.parse(requestG.responseText);
            if(objDataG.status) 
            {
                //console.log(objDataG);
                let optionGrupos = "";
                optionGrupos += '<option value="0" selected>Seleccionar Grupo</option>';
                for (let i = 0; i < objDataG.data.length; i++) 
                {
                    optionGrupos += '<option value="'+objDataG.data[i].grupo_format+'">'+objDataG.data[i].grupo_format+'</option>';
                }
                document.getElementById("divMaterias").style.display = "none";
                $('#divGrupos').append(
                    '<label>Grupo</label>'+
                    ' <select class="form-control selectpicker" data-live-search="true" id="listGrupos" name="listGrupos" required>'+
                        optionGrupos+
                    '</select>'
                );



                /*$("#listGrupos").html("");
                optionGrupos = "";

                for (var i = 0; i < objDataG.data.length; i++) {
                    optionGrupos += '<option value="'+objDataG.data[i].grupo_format+'">'+objDataG.data[i].grupo_format+'</option>';
                }*/
                document.querySelector("#listGrupos").innerHTML = optionGrupos;
                $('#listGrupos').selectpicker('render');
            }else{
                $("#divMaterias").html("");
                $("#divGrupos").html("");
                optionGrupos = "";
                document.getElementById("divMaterias").style.display = "none";
                document.querySelector("#divGrupos").innerHTML = optionGrupos;
                swal("Error", "No hay grupos asignados a está carrera" , "error");
            }
        }
    }     
              
})

function formatearPalabra(val) {
  return val.toLowerCase()
            .trim()
            .split(' ')
            .map( v => v[0].toUpperCase() + v.substr(1) )
            .join(' ');  
}

function fntViewCarga(idpersona){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Cargas/getCargasDocente/'+idpersona;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            if (objData.status) {
                console.log(objData);
                document.querySelector('#txtDocente').value = objData.data[0].nombre_profesor;
                document.querySelector('#txtModificacion').value = objData.data[0].ultima_modificacion_format;
                $('.horarioD').empty();

                // Organizar los datos por día y hora
                const schedule = {
                    lunes: {},
                    martes: {},
                    miercoles: {},
                    jueves: {},
                    viernes: {},
                    sabado: {}
                };

                const dias = ['lunes', 'martes', 'miercoles', 'jueves', 'viernes', 'sabado'];

                // Recorrer todas las materias y organizarlas por día/hora
                objData.data.forEach(item => {
                    const dia = item.dia.toLowerCase();
                    if (!schedule[dia]) return; // seguridad por si hay otro valor de día

                    if (!schedule[dia][item.hora_inicial]) {
                        schedule[dia][item.hora_inicial] = {
                            hora_final: item.hora_final,
                            grupo: item.grupo_format,
                            materia: item.materia,
                            profesor: item.nombre_profesor
                        };
                    }
                });

                // Obtener todas las horas únicas ordenadas
                const horas = [];
                dias.forEach(dia => {
                    Object.keys(schedule[dia]).forEach(hora => {
                        if (!horas.includes(hora)) {
                            horas.push(hora);
                        }
                    });
                });
                horas.sort();

                // Crear tabla HTML
                let html = `
                <table class="schedule-table">
                    <thead>
                        <tr>
                            <th>Hora</th>
                            <th>Lunes</th>
                            <th>Martes</th>
                            <th>Miércoles</th>
                            <th>Jueves</th>
                            <th>Viernes</th>
                            <th>Sábado</th>
                        </tr>
                    </thead>
                    <tbody>`;

                // Generar filas de la tabla
                horas.forEach(hora => {
                    html += `<tr>
                        <td class="time-slot">${hora} - ${
                        schedule.lunes[hora]?.hora_final ||
                        schedule.martes[hora]?.hora_final ||
                        schedule.miercoles[hora]?.hora_final ||
                        schedule.jueves[hora]?.hora_final ||
                        schedule.viernes[hora]?.hora_final ||
                        schedule.sabado[hora]?.hora_final || ''
                    }</td>`;

                    dias.forEach(dia => {
                        if (schedule[dia][hora]) {
                            html += `<td>${schedule[dia][hora].materia}<br>
                                     <small>${schedule[dia][hora].profesor}</small><br>
                                     <small>${schedule[dia][hora].grupo}</small></td>`;
                        } else {
                            html += '<td>-</td>';
                        }
                    });

                    html += '</tr>';
                });

                html += `</tbody>
                </table>`;

                // Agregar CSS mínimo
                const css = `
                <style>
                    .schedule-table {
                        width: 100%;
                        border-collapse: collapse;
                        margin-bottom: 30px;
                        font-family: Arial, sans-serif;
                        table-layout: fixed; /* Todas las columnas del mismo ancho */
                    }
                    .schedule-table th, 
                    .schedule-table td {
                        border: 1px solid #ddd;
                        padding: 8px;
                        text-align: center;
                        width: 14.28%; /* 100% / 7 columnas */
                        word-wrap: break-word;
                    }
                    .schedule-table th {
                        background-color: #C82333;
                        color: white;
                        padding: 10px;
                    }
                    .time-slot {
                        font-weight: bold;
                    }
                </style>`;

                // Insertar tabla en el contenedor
                $('.horarioD').append(css + html);

                $('#modalViewCarga').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntAgregarCarga(element,idpersona){
    rowTable = element.parentNode.parentNode.parentNode;
    $("#divMaterias").html("");
    $("#listGrupos").html();
    if(document.querySelector("#listCarreras"))
    {
        document.querySelector("#listCarreras").value = 0;
        $('#listCarreras').selectpicker('render');
    }
    if(document.querySelector("#listGrupos"))
    {
        $("#listGrupos").html();
    }
    document.querySelector("#formCargas").reset();
    document.querySelector('#titleModal').innerHTML ="Agregar Carga Académica";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Cargas/getDocente/'+idpersona;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idDocente").value = objData.data.idpersona;
                document.querySelector("#txtNombreDocente").value = objData.data.nombres;
                document.querySelector("#txtApellidosDocente").value = objData.data.apellidos   ;
                document.querySelector("#txtDireccion").value = objData.data.direccion;
                document.querySelector("#txtTelefono").value = objData.data.telefono;
                document.querySelector("#txtEmail").value = objData.data.email_user;     
            }
        }
        $('#modalFormCargas').modal('show');
    }
}

function fntEditCarga(element,idpersona){
   rowTable = element.parentNode.parentNode.parentNode;
   $("#divMaterias").html("");
    document.querySelector('#titleModal').innerHTML ="Actualizar Carga Académica";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    if(document.querySelector("#listCarreras"))
    {
        document.querySelector("#listCarreras").value = 0;
        $('#listCarreras').selectpicker('render');
    }
    if(document.querySelector("#listGrupos"))
    {
        document.querySelector("#listGrupos").value = '';
    }
    let intCarreraId;
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Cargas/getDocente/'+idpersona;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idDocente").value = objData.data.idpersona;
                document.querySelector("#txtNombreDocente").value = objData.data.nombres;
                document.querySelector("#txtApellidosDocente").value = objData.data.apellidos   ;
                document.querySelector("#txtDireccion").value = objData.data.direccion;
                document.querySelector("#txtTelefono").value = objData.data.telefono;
                document.querySelector("#txtEmail").value = objData.data.email_user;   

                $("#modalFormCargas").on("change", "select#listCarreras", function(){
                    //console.log("Está cambiando el List");
                    intCarreraId = document.querySelector("#listCarreras").value;
                    //console.log(intCarreraId);
                    document.querySelector("#idCarrera").value = intCarreraId;
                    let requestMat = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                    let ajaxUrlMat = base_url+'/Cargas/getMateriasCarrera/'+intCarreraId; 
                    requestMat.open("GET",ajaxUrlMat,true);
                    requestMat.send();
                    requestMat.onreadystatechange = function()
                    {
                        if(requestMat.readyState == 4 && requestMat.status == 200)
                        {
                            let objData2 = JSON.parse(requestMat.responseText);
                            if(objData2.status)
                            {
                                optionMaterias="";
                                for (var i = 0; i < objData2.data.length; i++) 
                                {
                                    optionMaterias += '<option value="'+objData2.data[i].idmateria+'">'+objData2.data[i].materia+'</option>';
                                }
                            }
                        }
                    }

                })

                $("#modalFormCargas").on("change", "select#listGrupos", function(){
                //$("#modalFormCargas").on("change", "select#listGrupos", function(){
                    let strGrupo = $(this).val();
                    let intDocenteId = document.querySelector("#idDocente").value;
                    let intIdCarrera = document.querySelector("#idCarrera").value;

                    if(strGrupo != null && strGrupo != "")
                    {
                        let requestEdit = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                        let ajaxUrlEdit = base_url+'/Cargas/getEditCarga/';
                        let formDataEdit = new FormData();
                        formDataEdit.append("grupo",strGrupo);
                        formDataEdit.append("docenteId",intDocenteId);
                        formDataEdit.append("carreraId",intIdCarrera);
                        requestEdit.open("POST",ajaxUrlEdit,true);
                        requestEdit.send(formDataEdit);
                        requestEdit.onreadystatechange = function(){
                            if(requestEdit.readyState == 4 && requestEdit.status == 200){
                                let objDataMaterias = JSON.parse(requestEdit.responseText);
                                if(objDataMaterias.status)
                                {
                                    document.getElementById("divMaterias").style.display = "block";
                                    document.querySelector("#idCarga").value = objDataMaterias.data[0].horariojid;
                                    //console.log(objDataMaterias.data);
                                    let lunes;
                                    let martes;
                                    let miercoles;
                                    let jueves;
                                    let viernes;
                                    $("#divMaterias").html("");
                                    
                                    for (let i = 0; i < objDataMaterias.data.length; i++) 
                                    {
                                        optionMaterias="";
                                        for (let j = 0; j < objDataMaterias.materias.length; j++) 
                                        {
                                            /*console.log(optionMaterias.idmateria);
                                            console.log(objDataMaterias.data[i].materiaid);*/
                                            if(objDataMaterias.materias[j].idmateria == objDataMaterias.data[i].materiaid)
                                            {
                                                optionMaterias += '<option value="'+objDataMaterias.materias[j].idmateria+'" selected>'+objDataMaterias.materias[j].materia+'</option>';
                                                /*console.log(optionMaterias[j]);
                                                console.log("SE cumple la condicion selected");*/
                                            }else{
                                                optionMaterias += '<option value="'+objDataMaterias.materias[j].idmateria+'">'+objDataMaterias.materias[j].materia+'</option>';
                                            }
                                        }

                                        lunes="";
                                        martes="";
                                        miercoles="";
                                        jueves="";
                                        viernes="";
                                        objDataMaterias.data[i].lunes == 1 ? lunes='checked' : lunes="";
                                        objDataMaterias.data[i].martes == 1 ? martes='checked' : martes="";
                                        objDataMaterias.data[i].miercoles == 1 ? miercoles='checked' : miercoles="";
                                        objDataMaterias.data[i].jueves == 1 ? jueves='checked' : jueves="";
                                        objDataMaterias.data[i].viernes == 1 ? viernes='checked' : viernes="";

                                        $("#divMaterias").append(
                                            '<div class="form-row">'+
                                                '<div class="form-group col-md-4">'+
                                                    '<label for="listMateriaVie">Materia</label>'+
                                                    '<div class="input-group">'+
                                                        '<span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs quitarElementos"><i class="fa fa-times"></i></button></span>'+
                                                        '<select class="form-control" id="listMaterias" name="listMaterias" required >'+
                                                         optionMaterias+
                                                        '</select>'+
                                                    '</div>'+
                                                '</div>'+
                                                '<div class="form-group col-md-2">'+
                                                    '<label for="txtFechaInicial">F. Inicial</label>'+
                                                    '<input type="date" class="form-control" id="txtFechaInicial" name="txtFechaInicial" value="'+objDataMaterias.data[i].fecha_inicial+'" required />'+
                                                '</div>'+
                                                '<div class="form-group col-md-2">'+
                                                    '<label for="txtFechaFinal">F. Final</label>'+
                                                    '<input type="date" class="form-control" id="txtFechaFinal" name="txtFechaFinal" value="'+objDataMaterias.data[i].fecha_final+'" required />'+
                                                '</div>'+
                                                '<div class="form-group col-md-2">'+
                                                    '<label for="txtHoraInicial">H. Inicial</label>'+
                                                    '<input type="time" class="form-control" id="txtHoraInicial" name="txtHoraInicial" value="'+objDataMaterias.data[i].hora_inicial+'" required />'+
                                                '</div>'+
                                                '<div class="form-group col-md-2">'+
                                                    '<label for="txtHoraFinal">H. Final</label>'+
                                                    '<input type="time" class="form-control" id="txtHoraFinal" name="txtHoraFinal" value="'+objDataMaterias.data[i].hora_final+'" required />'+
                                                '</div>'+
                                                '<div class="form-group col-md-2">'+
                                                    '<label for="txtAula">Aula</label>'+
                                                    '<input type="text" class="form-control" id="txtAula" name="txtAula" value="'+objDataMaterias.data[i].aula+'" required />'+
                                                '</div>'+
                                                '<div class="form-group col-md-5">'+
                                                    '<label for="txtComentarios">Comentarios</label>'+
                                                    '<textarea type="time" class="form-control" id="txtComentarios" name="txtComentarios" value="'+objDataMaterias.data[i].comentarios+'" rows="1">'+objDataMaterias.data[i].comentarios+'</textarea>'+
                                                '</div>'+
                                                '<div class="form-group col-md-5">'+
                                                    '<label for="txtHoraInicial">Seleccionar Días</label> <br />'+
                                                    '<label><input type="checkbox" id="cbLunes" name="cbLunes" value="" '+lunes+'/> Lunes</label>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp'+
                                                    '<label><input type="checkbox" id="cbMartes" name="cbMartes" value="" '+martes+'/> Martes</label>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp'+
                                                    '<label><input type="checkbox" id="cbMiercoles" name="cbMiercoles" value="" '+miercoles+'/> Miércoles</label>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp'+
                                                    '<label><input type="checkbox" id="cbJueves" name="cbJueves" value="" '+jueves+'/> Jueves</label>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp'+
                                                    '<label><input type="checkbox" id="cbViernes" name="cbViernes" value="" '+viernes+'/> Viernes</label>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp'+
                                                '</div>'+
                                                '<div class="form-group col-md-12" style="border-bottom:#d12018 2px solid; padding-left: 20px;"></div>'+
                                            '</div>'
                                        );

                                    }
                                }else{
                                    document.getElementById("divMaterias").style.display = "none";   
                                }
                            }
                        } 

                    }else{
                        document.getElementById("divMaterias").style.display = "none";
                        $("#divMaterias").html("");
                        swal("Error", objDataMaterias.msg , "error");
                    }
                    return;
                    
                    
                })

                
            }

        }

        $('#modalFormCargas').modal('show');

    }

}

$("#modalFormCargas").on("click", "button.btnAgregarMateria", function(){
    let intCarreraId= document.querySelector('#listCarreras').value;
    if(document.querySelector('#listGrupos'))
    {
        if(document.querySelector('#listGrupos').value == 0)
        {
            swal("Atención", "Primero debe seleccionar un grupo." , "error");
        return false;
        }
    }else{
        swal("Atención", "Primero debe seleccionar un grupo." , "error");
        return false;
    }

    let requestMat = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrlMat = base_url+'/Cargas/getMateriasCarrera/'+intCarreraId;
    requestMat.open("GET",ajaxUrlMat,true);
    requestMat.send();
    requestMat.onreadystatechange = function(){
        if(requestMat.readyState == 4 && requestMat.status == 200){
            let objDataMat = JSON.parse(requestMat.responseText);
            if(objDataMat.status)
            {
                optionMaterias="";
                for (var i = 0; i < objDataMat.data.length; i++) {
                    optionMaterias += '<option value="'+objDataMat.data[i].idmateria+'">'+objDataMat.data[i].materia+'</option>';
                }
                document.getElementById("divMaterias").style.display = "block";
                $("#divMaterias").append(
                    '<div class="form-row">'+
                        '<div class="form-group col-md-4">'+
                            '<label for="listMateriaVie">Materia</label>'+
                            '<div class="input-group">'+
                                '<span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs quitarElementos"><i class="fa fa-times"></i></button></span>'+
                                '<select class="form-control" id="listMaterias" name="listMaterias" required >'+
                                 optionMaterias+
                                '</select>'+
                            '</div>'+
                        '</div>'+
                        '<div class="form-group col-md-2">'+
                            '<label for="txtFechaInicial">F. Inicial</label>'+
                            '<input type="date" class="form-control" id="txtFechaInicial" name="txtFechaInicial" required />'+
                        '</div>'+
                        '<div class="form-group col-md-2">'+
                            '<label for="txtFechaFinal">F. Final</label>'+
                            '<input type="date" class="form-control" id="txtFechaFinal" name="txtFechaFinal" required />'+
                        '</div>'+
                        '<div class="form-group col-md-2">'+
                            '<label for="txtHoraInicial">H. Inicial</label>'+
                            '<input type="time" class="form-control" id="txtHoraInicial" name="txtHoraInicial" required />'+
                        '</div>'+
                        '<div class="form-group col-md-2">'+
                            '<label for="txtHoraFinal">H. Final</label>'+
                            '<input type="time" class="form-control" id="txtHoraFinal" name="txtHoraFinal" required />'+
                        '</div>'+
                        '<div class="form-group col-md-2">'+
                            '<label for="txtAula">Aula</label>'+
                            '<input type="text" class="form-control" id="txtAula" name="txtAula" required />'+
                        '</div>'+
                        '<div class="form-group col-md-5">'+
                            '<label for="txtComentarios">Comentarios</label>'+
                            '<textarea type="time" class="form-control" id="txtComentarios" name="txtComentarios" rows="1"/>'+
                        '</div>'+
                        '<div class="form-group col-md-5">'+
                            '<label for="txtHoraInicial">Seleccionar Días</label> <br />'+
                            '<label><input type="checkbox" id="cbLunes" name="cbLunes" value="" checked/> Lunes</label>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp'+
                            '<label><input type="checkbox" id="cbMartes" name="cbMartes" value="" checked/> Martes</label>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp'+
                            '<label><input type="checkbox" id="cbMiercoles" name="cbMiercoles" value="" checked/> Miércoles</label>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp'+
                            '<label><input type="checkbox" id="cbJueves" name="cbJueves" value="" checked/> Jueves</label>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp'+
                            '<label><input type="checkbox" id="cbViernes" name="cbViernes" value="" checked/> Viernes</label>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp'+
                        '</div>'+
                        '<div class="form-group col-md-12" style="border-bottom:#d12018 2px solid; padding-left: 20px;"></div>'+
                    '</div>'
                    
                ); 
                
            }
        }

    }



                   
});

//Código para listar todos los elementos del DIV Materias
$("#modalFormCargas").on("click", "button.quitarElementos", function(){
    $(this).parent().parent().parent().parent().remove();
    // AGRUPAR PRODUCTOS EN FORMATO JSON
    listarElementos(); 
})


$("#modalFormCargas").on("change", "select#listMaterias", function(){
    listarElementos(); 
})  
$("#modalFormCargas").on("change", "input#txtFechaInicial", function(){
    listarElementos(); 
})
$("#modalFormCargas").on("change", "input#txtFechaFinal", function(){
    listarElementos(); 
})
$("#modalFormCargas").on("change", "input#txtAula", function(){
    listarElementos(); 
})
$("#modalFormCargas").on("change", "input#txtHoraInicial", function(){
    listarElementos(); 
})
$("#modalFormCargas").on("change", "input#txtHoraFinal", function(){
    listarElementos(); 
})
$("#modalFormCargas").on("change", "textarea#txtComentarios", function(){
    listarElementos(); 
})
$("#modalFormCargas").on("change", "#cbLunes", function(){
    listarElementos(); 
})
$("#modalFormCargas").on("change", "#cbMartes", function(){
    listarElementos(); 
})
$("#modalFormCargas").on("change", "#cbMiercoles", function(){
    listarElementos(); 
})
$("#modalFormCargas").on("change", "#cbJueves", function(){
    listarElementos(); 
})
$("#modalFormCargas").on("change", "#cbViernes", function(){
    listarElementos(); 
})


function listarElementos(){
    let listaElementos = [];
    let docenteId = document.querySelector("#idDocente").value;
    let materia = document.querySelectorAll("#listMaterias");
    let fechaInicial = document.querySelectorAll("#txtFechaInicial");
    let fechaFinal = document.querySelectorAll("#txtFechaFinal");
    let horaInicial = document.querySelectorAll("#txtHoraInicial");
    let horaFinal = document.querySelectorAll("#txtHoraFinal");
    let aula = document.querySelectorAll("#txtAula");
    let comentarios = document.querySelectorAll("#txtComentarios");
    let lunes = document.querySelectorAll("#cbLunes");
    let martes = document.querySelectorAll("#cbMartes");
    let miercoles = document.querySelectorAll("#cbMiercoles");
    let jueves = document.querySelectorAll("#cbJueves");
    let viernes = document.querySelectorAll("#cbViernes");
    for(let i = 0; i < materia.length; i++){
        listaElementos.push({"docenteid" : docenteId,
                                "materia" : $(materia[i]).val(), 
                                "fecha_inicial" : $(fechaInicial[i]).val(),
                                "fecha_final" : $(fechaFinal[i]).val(),
                                "aula" : $(aula[i]).val(),
                                "hora_inicial" : $(horaInicial[i]).val(),
                                "hora_final" : $(horaFinal[i]).val(),
                                "lunes" : lunes[i].checked,
                                "martes" : martes[i].checked,
                                "miercoles" : miercoles[i].checked,
                                "jueves" : jueves[i].checked,
                                "viernes" : viernes[i].checked,
                                "comentarios" : $(comentarios[i]).val(),})
    }
    //console.log(listaElementos);
    $("#listaElementos").val(JSON.stringify(listaElementos)); 
}

function fntDelHorario(idhorario){
    swal({
        title: "Eliminar Horario",
        text: "¿Realmente quiere eliminar el registro del horario?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Horarios/delHorario';
            let strData = "idhorario="+idhorario;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableHorarios.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idCarga').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nueva Carga Académica";
    document.querySelector("#formCargas").reset();
    if(document.querySelector("#listGrupo"))
    {
        document.querySelector("#listGrupo").value = 0;
        $('#listGrupo').selectpicker('render');
    }

    $('#modalFormHorarios').modal('show');
}