let tableCarreras;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

    tableCarreras = $('#tableCarreras').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Carreras/getCarreras",
            "dataSrc":""
        },
        "columns":[
            {"data":"idcarrera", visible:false},
            {"data":"carrera"},
            {"data":"abreviatura"},
            {"data":"modelo"},
            {"data":"reforma"},
            {"data":"revision"},
            {"data":"nivel"},
            {"data":"modalidad"},
            {"data":"ultima_modificacion_format"},
            {"data":"status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[0,"asc"]]  
    });

    if(document.querySelector("#formCarreras")){
        let formCarreras = document.querySelector("#formCarreras");
        formCarreras.onsubmit = function(e) {
            e.preventDefault();
            let strCarrera= document.querySelector('#txtCarrera').value;
            let strCarreraFormat = strCarrera.toLocaleUpperCase();
            let strAbreviatura= document.querySelector('#txtAbreviatura').value;
            let strAbreviaturaFormat = strAbreviatura.toLocaleUpperCase();;
            let strModelo= document.querySelector('#txtModelo').value;
            let strModeloFormat = strModelo.toLocaleUpperCase();;
            let intReforma = document.querySelector('#listReforma').value;
            let strRevision = document.querySelector("#txtRevision").value;
            let intNivelId = document.querySelector("#listNivel").value;
            let strModalidad = document.querySelector("#listModalidad").value;
            let strNombrePersona = document.querySelector("#txtNombrePersona").value;
            let intStatus= document.querySelector('#listStatus').value;

            if(strCarrera == '' || strAbreviatura == '' || strModelo == '' || intReforma == '' || strRevision == '' || 
                intNivelId == 0 || intStatus == '')
            {
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            //tinyMCE.triggerSave();
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Carreras/setCarrera'; 
            let formData = new FormData(formCarreras);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        if(rowTable == ""){
                            tableCarreras.api().ajax.reload();
                        }else{
                            htmlStatus = intStatus == 1 ? 
                            '<span class="badge badge-success">Activo</span>' : 
                            '<span class="badge badge-danger">Inactivo</span>';
                            rowTable.cells[0].textContent = strCarreraFormat;
                            rowTable.cells[1].textContent = strAbreviaturaFormat;
                            rowTable.cells[2].textContent = strModeloFormat;
                            rowTable.cells[3].textContent = intReforma;
                            rowTable.cells[4].textContent = strRevision;
                            rowTable.cells[5].textContent = document.querySelector("#listNivel").selectedOptions[0].text;
                            rowTable.cells[6].textContent = document.querySelector("#listModalidad").selectedOptions[0].text;
                            rowTable.cells[7].textContent = objData.fecha;
                            rowTable.cells[8].innerHTML = htmlStatus;
                            rowTable = ""; 
                        }
                        $('#modalFormCarreras').modal("hide");
                        formCarreras.reset();
                        swal("Carreras", objData.msg ,"success");
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }
})

function formatearPalabra(val) {
  return val.toLowerCase()
            .trim()
            .split(' ')
            .map( v => v[0].toUpperCase() + v.substr(1) )
            .join(' ');  
}

function fntViewCarrera(idcarrera){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Carreras/getCarrera/'+idcarrera;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            if(objData.status)
            {
               let estado = objData.data.status == 1 ? 
                '<span class="badge badge-success">Activo</span>' : 
                '<span class="badge badge-danger">Inactivo</span>';
                document.querySelector("#celCarrera").innerHTML = objData.data.carrera;
                document.querySelector("#celAbreviatura").innerHTML = objData.data.abreviatura;
                document.querySelector("#celModelo").innerHTML = objData.data.modelo;
                document.querySelector("#celReforma").innerHTML = objData.data.reforma;
                document.querySelector("#celRevision").innerHTML = objData.data.revision;
                document.querySelector("#celNivel").innerHTML = objData.data.nivel;
                document.querySelector("#celModalidad").innerHTML = objData.data.modalidad;
                document.querySelector("#celModificador").innerHTML = objData.data.modificador;
                document.querySelector("#celUltimaModificacion").innerHTML = objData.data.ultima_modificacion_format;
                document.querySelector("#celStatus").innerHTML = estado;
                $('#modalViewCarrera').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditCarrera(element,idcarrera){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Carrera";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Carreras/getCarrera/'+idcarrera;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idCarrera").value = objData.data.idcarrera;
                document.querySelector("#txtCarrera").value = objData.data.carrera;
                document.querySelector("#txtAbreviatura").value = objData.data.abreviatura;
                document.querySelector("#txtModelo").value = objData.data.modelo;
                document.querySelector("#txtRevision").value = objData.data.revision;
                if(document.querySelector("#listReforma"))
                {
                    document.querySelector("#listReforma").value = objData.data.reforma;
                    $('#listReforma').selectpicker('render');
                }
                if(document.querySelector("#listNivel"))
                {
                    document.querySelector("#listNivel").value = objData.data.nivelid;
                    $('#listNivel').selectpicker('render');
                }
                if(document.querySelector("#listModalidad"))
                {
                    document.querySelector("#listModalidad").value = objData.data.modalidad;
                    $('#listModalidad').selectpicker('render');
                }
                if(document.querySelector("#listStatus"))
                {
                    document.querySelector("#listStatus").value = objData.data.status;
                    $('#listStatus').selectpicker('render');
                }
               
            }
        }
    
        $('#modalFormCarreras').modal('show');
    }
}

function fntDelCarrera(idcarrera){
    swal({
        title: "Eliminar Carrera",
        text: "¿Realmente quiere eliminar el registro de la carrera?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Carreras/delCarrera';
            let strData = "idcarrera="+idcarrera;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableCarreras.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idCarrera').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nueva Carrera";
    document.querySelector("#formCarreras").reset();
    if(document.querySelector("#listNivel"))
    {
        document.querySelector("#listNivel").value = 0;
        $('#listNivel').selectpicker('render');
    }
    if(document.querySelector("#listModalidad"))
    {
        document.querySelector("#listModalidad").value = 0;
        $('#listModalidad').selectpicker('render');
    }
    if(document.querySelector("#listStatus"))
    {
        document.querySelector("#listStatus").value = 1;
        $('#listStatus').selectpicker('render');
    }
    $('#modalFormCarreras').modal('show');
}
