var fecha = new Date();
var anio = fecha.getFullYear();
var _dia = fecha.getDate();
var _mes = fecha.getMonth(); //viene con valores de 0 al 11
_mes = _mes + 1; //ahora lo tienes de 1 al 12
if (_mes < 10) //ahora le agregas un 0 para el formato date
{
  var mes = "0" + _mes;
} else {
  var mes = _mes;
}
if (_dia < 10) //ahora le agregas un 0 para el formato date
{
  var dia = "0" + _dia;
} else {
  var dia = _dia;
}

let fecha_actual = anio + '-' + mes + '-' + dia;

document.addEventListener('DOMContentLoaded', function() {
    let request_calendar = base_url+'/Ccomputo/getSolicitudesCalendar/'; 
    var calendarEl = document.getElementById('calendar');
    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',

        events:function(info, successCallback, failureCallback){
            fetch(request_calendar)
                .then(function(response){
                    return response.json()
                })
                .then(function(data){
                    let events = data.events.map(function(event){
                        return {
                            title: event.centro_computo,
                            subtitle: event.nombre_solicitante,
                            start: event.fecha_inicial,
                            end: new Date(event.fecha_final),
                            location: event.descripcion,
                            nota: event.bdgEstado,
                            timeStart: event.hora_inicial,
                            timeEnd: event.hora_final,
                        }
                    })
                    successCallback(events)
                })
                .catch(function(error){
                    failureCallback(error)
                })
        },

        eventContent: function(info){
            return {

                html: `
                <div style="overflow: hidden; font-size: 12px; positon: relative; cursor: pointer; font-family: 'Inter', sans-serif;">
                    <div><strong>${info.event.title}</strong></div>
                    <div>Solicitante: ${info.event.extendedProps.subtitle}</div>
                    <div>Fecha: ${info.event.start.toLocaleDateString(
                        "es-MX",
                        {
                            month: "long",
                            day: "numeric",
                            year: "numeric",
                        }
                    )}</div>
                    <div>Hora: ${info.event.extendedProps.timeStart} - ${info.event.extendedProps.timeEnd}</div>
                    <div>Estado: ${info.event.extendedProps.nota}</div>
                </div>
                `
            }
        },

        eventMouseEnter: function(mouseEnterInfo){
            let el = mouseEnterInfo.el
            el.classList.add("relative")

            let newEl = document.createElement("div")
            let newElTitulo = mouseEnterInfo.event.title
            let newElSolicitante = mouseEnterInfo.event.extendedProps.subtitle
            let newElDescripcion = mouseEnterInfo.event.extendedProps.location
            let newElEstado = mouseEnterInfo.event.extendedProps.nota
            newEl.innerHTML = `
                <div
                    class="fc-hoverable-event"
                    style="position: absolute; bottom: 100%; left: 0; width: auto; height: auto; background-color: white; z-index: 50; border: 1px solid #e2e8f0; border-radius: 0.375rem; padding: 0.75rem; font-size: 13px; font-family: 'Inter', sans-serif; cursor: pointer;"
                >
                    <strong>${newElTitulo}</strong>
                    <div><strong>Solicitante: </strong>${newElSolicitante}</div>
                    <div><strong>Descripción: </strong>${newElDescripcion}</div>
                </div>
            `
            el.after(newEl)
        },

        eventMouseLeave: function(){
            document.querySelector(".fc-hoverable-event").remove()
        }
    });
    calendar.render();


   tableSolicitudes = $('#tableSolicitudes').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/1.10.20/i18n/Spanish.json"
        },
         "ajax":{
            "url": " "+base_url+"/Ccomputo/getSolicitudes",
            "dataSrc":""
        },
        
       
        "columns":[
            {"data": "idsolicitud", visible:false},
            {"data": "nombre_solicitante"},
            {"data": "centro_computo"},
            {"data": "descripcion"},
            {"data": "fecha_inicial", visible:false},
            {"data": "fecha_inicial_format"},
            {"data": "fecha_final_format"},
            {"data": "format_horario"},
            {"data": "edo"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 25,
        "order":[[4,"desc"]]  
    }); 

    if(document.querySelector("#formSolicitudes")){
    let formSolicitudes = document.querySelector("#formSolicitudes");
    formSolicitudes.onsubmit = function(e) {
        e.preventDefault();
        let strCentroComputo = document.querySelector('#listCentroComputo').value;
        let strDescripcion = document.querySelector('#txtDescripcion').value;
        let strHoraInicial = document.querySelector('#txtHoraInicial').value;
        let strHoraFinal = document.querySelector('#txtHoraFinal').value;
        let strFechaInicial = document.querySelector('#txtFechaInicial').value;
        let strFechaFinal = document.querySelector('#txtFechaFinal').value;
        let strRecurrente = document.querySelector('#cbRecurrente').checked;
        let listaElementos = document.querySelector('#listaElementos').value;
        let listaJson = JSON.parse(listaElementos);
        console.log(listaElementos);
        console.log(listaJson[0]);
        if(listaJson[0].recurrente == true){
            if(listaJson[0].lunes==false && listaJson[0].martes==false && listaJson[0].miercoles==false && 
                listaJson[0].jueves==false && listaJson[0].viernes==false){
                swal("Atención", "Usted seleccionó que es evento recurrente; necesita seleccionar al menos un día" , "error");
                return false;
            }
        }
        if(strCentroComputo == '' || strDescripcion == '' || strHoraInicial == '' || strHoraFinal == '' || 
            strFechaInicial == '' || strFechaFinal == ''){
            swal("Atención", "Todos los campos son obligatorios" , "error");
            return false;
        }
        
        /*if(strFecha < fecha_actual)
        {
            swal("Atención", "La fecha de la actividad no puede ser menor a la fecha actual" , "error");
            return false;
        }*/
        
        let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
        let ajaxUrl = base_url+'/Ccomputo/setSolicitud'; 
        let formData = new FormData(formSolicitudes);
        request.open("POST",ajaxUrl,true);
        request.send(formData);
        request.onreadystatechange = function(){
            if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                $('#modalFormSolicitud').modal("hide");
                formSolicitudes.reset();
                swal("Centro de Computo", objData.msg ,"success");
                setTimeout(function(){
                            window.location.reload(true);
                        }, 2000);
            }else{
                swal("Error", objData.msg , "error");
            }
        }
        divLoading.style.display = "none";
        return false;
      }
    }
  }

});

function fntEditInfo(element, idsolicitud){
    //rowTable = element.parentNode.parentNode.parentNode;
    document.querySelector('#titleModal').innerHTML ="Actualizar Solicitud";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/CComputo/getSolicitud/'+idsolicitud;

    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idpersona").value = objData.data.personaid;
                document.querySelector("#idSolicitud").value = objData.data.idsolicitud;
                document.querySelector("#txtDescripcion").value = objData.data.descripcion;
                document.querySelector("#txtHoraInicial").value = objData.data.hora_inicial;
                document.querySelector("#txtHoraFinal").value = objData.data.hora_final;
                document.querySelector("#txtFechaInicial").value = objData.data.fecha_inicial;
                document.querySelector("#txtFechaFinal").value = objData.data.fecha_final;
                if(document.querySelector("#txtEstado"))
                {
                    document.querySelector("#txtEstado").value = objData.data.estado;
                }
                if(document.querySelector("#txtComentarios"))
                {
                    document.querySelector("#txtComentarios").value = objData.data.comentarios_ti;
                }
                if(document.querySelector("#listCentroComputo"))
                {
                    document.querySelector("#listCentroComputo").value = objData.data.centro_computo;
                    $('#listCentroComputo').selectpicker('render');
                }
                if(document.querySelector("#listEstado"))
                {
                    document.querySelector("#listEstado").value = objData.data.estado;
                    $('#listEstado').selectpicker('render');
                }
            }
        }
        $('#modalFormSolicitudesEditar').modal('hide');
        $('#modalFormSolicitud').modal('show');
    }
     return;
  }

function fntDelInfo(idsolicitud){
    swal({
        title: "Eliminar Solicitud",
        text: "¿Realmente quiere eliminar esta solicitud?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Ccomputo/delSolicitud';
            let strData = "idsolicitud="+idsolicitud;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        setTimeout(function(){
                            window.location.reload(true);
                        }, 2000);
                        //window.location.reload(true);
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });

}

function openModal()
{
    rowTable = "";
    let json = '[{"recurrente":false,"lunes":false,"martes":false,"miercoles":false,"jueves":false,"viernes":false}]';
    document.querySelector('#idSolicitud').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nueva Solicitud";
    document.querySelector("#formSolicitudes").reset();
    document.querySelector('#listaElementos').value = json;
    if(document.querySelector("#listCentroComputo"))
    {
        document.querySelector("#listCentroComputo").value = 0;
        $('#listCentroComputo').selectpicker('render');
    }
    if(document.querySelector("#listStatus"))
    {
        document.querySelector("#listStatus").value = 1;
        $('#listStatus').selectpicker('render');
    }
    $('#modalFormSolicitud').modal('show');
}

function openModalEditar()
{
    rowTable = "";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Editar Solicitud";
    document.querySelector("#formSolicitudesEditar").reset();
    $('#modalFormSolicitudesEditar').modal('show');
}

function fntEditEstado(element, idsolicitud){
    rowTable = element.parentNode.parentNode;
    let estado = element.getAttribute("estado");
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Ccomputo/actualizarEstado/';
    request.open("POST",ajaxUrl,true);
    let formData = new FormData();
    formData.append("idsolicitud",idsolicitud);
    formData.append("estado",estado);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {    
                rowTable.cells[6].innerHTML = objData.btnEstado;
                rowTable = ""; 
                swal("Solicitud", objData.msg ,"success");
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}  

$('#modalFormSolicitud').on("change", "input#cbRecurrente", function(){
    let estado = this.checked;
    if(estado == true){
        document.getElementById("divRecurrente").style.display = "flex";
        listarElementos();
    }else{
        document.getElementById("divRecurrente").style.display = "none";
        document.getElementById("cbRecurrente").checked = false;
        document.getElementById("cbLunes").checked = false;
        document.getElementById("cbMartes").checked = false;
        document.getElementById("cbMiercoles").checked = false;
        document.getElementById("cbJueves").checked = false;
        document.getElementById("cbViernes").checked = false;
        listarElementos();
    }
})   

$('#formSolicitudes').on("change", "input#cbLunes", function(){
    listarElementos();
})

$('#formSolicitudes').on("change", "input#cbMartes", function(){
    listarElementos();
})

$("#formSolicitudes").on("change", "input#cbMiercoles", function(){
    listarElementos();
})

$("#formSoicitudes").on("change", "input#cbJueves", function(){
    listarElementos();
})

$("formSolicitudes").on("change", "input#cbViernes", function(){
    listarElementos();
})

function listarElementos(){
    console.log("Hola");
    let listaElementos = [];
    let recurrente = document.getElementById("cbRecurrente").checked;
    let lunes = document.getElementById("cbLunes").checked;
    let martes = document.getElementById("cbMartes").checked;
    let miercoles = document.getElementById("cbMiercoles").checked;
    let jueves = document.getElementById("cbJueves").checked;
    let viernes = document.getElementById("cbViernes").checked;
        
    if(recurrente == true){
        listaElementos.push({ "recurrente" : recurrente,
                    "lunes" : lunes,
                    "martes" : martes,
                    "miercoles" : miercoles,
                    "jueves" : jueves,
                    "viernes" : viernes})
    }else{
        listaElementos.push({ "recurrente" : false,
                    "lunes" : false,
                    "martes" : false,
                    "miercoles" : false,
                    "jueves" : false,
                    "viernes" : false})
    }
    $("#listaElementos").val(JSON.stringify(listaElementos)); 
} 