let tableGrupos;
let rowTable = ""; 
let url;
let divLoading = document.querySelector("#divLoading");
let cambiosRealizados = 0;
let botonGuardar = null;
document.addEventListener('DOMContentLoaded', function(){
})

/* ==========================================================
   1. BUSQUEDA Y GENERACIÓN DE TABLA
   ========================================================== */
if (document.querySelector("#formBusqueda")) {
    let formBusqueda = document.querySelector("#formBusqueda");
    formBusqueda.onsubmit = function(e) {
        e.preventDefault();
        let intNivelId = document.querySelector("#listNiveles").value;
        let intCarreraId = document.querySelector("#listCarreras") ? document.querySelector("#listCarreras").value : null;
        let strGrupo = document.querySelector("#listGrupos") ? document.querySelector("#listGrupos").value : null;
        let intMateriaId = document.querySelector("#listMaterias") ? document.querySelector("#listMaterias").value : null;
        
        if (intNivelId == 0 || intCarreraId == 0 || strGrupo == 0 || intMateriaId == 0 ||
            intNivelId == '' || intCarreraId == '' || strGrupo == '' || intMateriaId == '') 
        {
            swal("Atención", "Todos los campos son obligatorios.", "error");
            return false;
        }

        divLoading.style.display = "flex";
        let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
        let ajaxUrl = base_url + '/Calificaciones/getBusquedaAlumnos';
        let formData = new FormData(formBusqueda);
        request.open("POST", ajaxUrl, true);
        request.send(formData);
        
        request.onreadystatechange = function() {
            if (request.readyState == 4 && request.status == 200) {
                let objData = JSON.parse(request.responseText);
                if (objData.status) {
                    if (!botonGuardar) {
                        botonGuardar = document.getElementById("btnGuardarCalificaciones");
                    }
                    generarTablaCalificaciones(objData);
                    actualizarBotonGuardar();
                } else {
                    swal("¡Error!", objData.msg, "error");
                    document.getElementById("formularioCalificaciones").style.display = "none";
                }
            }
            divLoading.style.display = "none";
            return false;
        }
    }
}

function generarTablaCalificaciones(objData) {
    cambiosRealizados = 0;
    $('.divAlumnos').html("");
    $('#divReporteMasivo').html('');

    $('.divAlumnos').html(
        '<div class="table-responsive">' +
            '<table id="tablaCalificaciones" class="table table-striped table-bordered table-hover">' +
                '<thead>' +
                    '<tr>' +
                        '<th rowspan="2" class="text-center bg-danger text-white">#</th>' +
                        '<th rowspan="2" class="text-center bg-danger text-white">Matrícula</th>' +
                        '<th rowspan="2" class="text-center bg-danger text-white">Alumno</th>' +
                        '<th colspan="1" class="text-center bg-danger text-white" id="header-pdf">CALIF. FINAL</th>' +
                    '</tr>' +
                '</thead>' +
                '<tbody></tbody>' +
            '</table>' +
        '</div>'
    );
    
    document.getElementById("formularioCalificaciones").style.display = "";
    
    let cont = 1;
    let rolid = document.querySelector("#txtRID").value;
    let tablaBody = $('#tablaCalificaciones tbody');

    const dataCalificacionesBD = {};
    const sourceDataCalificaciones = objData.calificaciones || [];

    if (sourceDataCalificaciones.length > 0) {
        sourceDataCalificaciones.forEach(reg => {
            dataCalificacionesBD[reg.alumnoid] = reg;
        });
    }

    for (var i = 0; i < objData.data.length; i++) {
        let alumno = objData.data[i];
        let registroBD = dataCalificacionesBD[alumno.idalumno] || {};
        let calif_val = (registroBD['calificacion_final'] == null || registroBD['calificacion_final'] == undefined) ? "" : registroBD['calificacion_final'];

        let row = '<tr>' +
            '<td>' + cont + '</td>' +
            '<td>' + alumno.matricula + '</td>' +
            '<td>' + alumno.nombre_alumno + '</td>';

        // Lógica de solo lectura para ciertos roles
        let restriccionCalificacion = '';
        if(!(rolid == 1 || rolid == 4 || rolid == 8)) {
            if(calif_val != '') { restriccionCalificacion = 'readonly=""'; }
        }

        // CLAVE: data-original guarda el valor inicial para comparar cambios reales
        row += '<td>' +
            '<input type="text" class="form-control form-control-sm input-calificacion" ' +
            'data-idalumno="' + alumno.idalumno + '" data-tipo="calificacion" ' +
            'data-cambiado="false" data-original="' + calif_val + '" ' + 
            'value="' + calif_val + '" placeholder="" oninput="validarYContarCambios(this)" ' + restriccionCalificacion + ' />' +
            '</td></tr>';

        tablaBody.append(row);
        cont++;
    }
    
    // Inyección de IDs informativos
    document.querySelector("#txtNivel").value = objData.nivel.nivel;
    document.querySelector("#txtNivel").setAttribute('idnivel', objData.nivel.idnivel);
    document.querySelector("#txtCarrera").value = objData.nivel.nivel;
    document.querySelector("#txtCarrera").setAttribute('idcarrera', objData.carrera.idcarrera);
    document.querySelector("#txtProfesor").value = objData.docente.nombre_docente;
    document.querySelector("#txtProfesor").setAttribute('idprofesor', objData.docente.idpersona);
    document.querySelector("#txtMateria").value = objData.materia.materia;
    document.querySelector("#txtMateria").setAttribute('idmateria', objData.materia.idmateria);
    document.querySelector("#txtSemestre").value = objData.data[0].grado;
    document.querySelector("#txtGrupo").value = objData.data[0].grupo_format;
    document.querySelector("#txtGrupo").setAttribute('idgrupo', objData.data[0].idgrupo);

    // Función helper para generar el HTML del botón con todos los parámetros
    const getBtnHTML = () => `
        <button type="button" class="btn btn-sm btn-light ml-2 btn-reporte-parcial"
            onclick="generarReporteMasivo(
                ${objData.nivel.idnivel},
                ${objData.carrera.idcarrera},
                ${objData.data[0].idgrupo},
                ${objData.docente.idpersona},
                ${objData.materia.idmateria},
            )" title="Formato Acta Final">
            <i class="fas fa-file-pdf text-danger"></i>
        </button>`;

    // Inyección en cada encabezado de parcial
    $('#header-pdf').append(getBtnHTML());
}

/* ==========================================================
   2. VALIDACIÓN EN TIEMPO REAL Y DETECCIÓN DE CAMBIOS
   ========================================================== */
function validarYContarCambios(input) {
    let valorActual = input.value.trim();
    let valorOriginal = input.getAttribute('data-original').trim();
    let numero = parseFloat(valorActual);
    let esValido = true;
    
    input.classList.remove('is-invalid');

    // Validación de formato (Números 50-100 o texto AC/NA)
    if (valorActual !== "") {
        const valorUpper = valorActual.toUpperCase();
        const esTextoValido = (valorUpper === 'NA' || valorUpper === 'AC');
        const esNumeroValido = !isNaN(numero) && numero >= 50 && numero <= 100;
        if (!esTextoValido && !esNumeroValido) esValido = false;
    }

    // Lógica de detección de cambios reales
    let haCambiado = (valorActual !== valorOriginal);
    let yaEstabaMarcado = (input.getAttribute('data-cambiado') === 'true');

    if (esValido) {
        if (haCambiado && !yaEstabaMarcado) {
            cambiosRealizados++;
            input.setAttribute('data-cambiado', 'true');
        } else if (!haCambiado && yaEstabaMarcado) {
            cambiosRealizados--;
            input.setAttribute('data-cambiado', 'false');
        }
    } else {
        input.classList.add('is-invalid');
        if (yaEstabaMarcado) {
            cambiosRealizados--;
            input.setAttribute('data-cambiado', 'false');
        }
    }

    actualizarBotonGuardar();
}

function actualizarBotonGuardar() {
    if (!botonGuardar) {
        botonGuardar = document.getElementById("btnGuardarCalificaciones");
    }
    if (botonGuardar) {
        botonGuardar.textContent = `Registrar Cambios (${cambiosRealizados})`;
        botonGuardar.disabled = (cambiosRealizados === 0);
    }
}

/* ==========================================================
   3. GUARDAR CAMBIOS (ENVÍO SELECTIVO)
   ========================================================== */
function guardarCalificaciones() {
    const inputsCalificacion = document.querySelectorAll('.input-calificacion');
    let hayErroresDeValidacion = false;
    const array_final = [];

    // Recolectar ÚNICAMENTE lo que tenga data-cambiado="true"
    inputsCalificacion.forEach(input => {
        if (input.classList.contains('is-invalid')) {
            hayErroresDeValidacion = true;
        }
        if (input.getAttribute('data-cambiado') === 'true') {
            array_final.push({
                idalumno: input.getAttribute('data-idalumno'),
                calificacion_final: input.value.trim()
            });
        }
    });

    if (hayErroresDeValidacion) {
        swal("Atención", "Por favor corrija los campos en rojo.", "error");
        return;
    }

    if (array_final.length === 0) {
        swal("Información", "No se detectaron cambios nuevos para guardar.", "info");
        return;
    }

    const dataJSON = JSON.stringify(array_final);

    // Parámetros adicionales
    let intNivelId = document.querySelector("#txtNivel").getAttribute('idnivel');
    let intCarreraId = document.querySelector("#txtCarrera").getAttribute('idcarrera');
    let intProfesorId = document.querySelector("#txtProfesor").getAttribute('idprofesor');
    let intMateriaId = document.querySelector("#txtMateria").getAttribute('idmateria');
    let intGrupoId = document.querySelector("#txtGrupo").getAttribute('idgrupo');
    let intSemestre = document.querySelector("#txtSemestre").value;

    divLoading.style.display = "flex";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url + '/Cfinales/setCalificacion';
    let formData = new FormData(document.querySelector('#formCalificaciones'));
    
    formData.append("nivelid", intNivelId);
    formData.append("carreraid", intCarreraId);
    formData.append("profesorid", intProfesorId);
    formData.append("materiaid", intMateriaId);
    formData.append("grupoid", intGrupoId);
    formData.append("txtSemestre", intSemestre);
    formData.append("json_calificaciones", dataJSON); 
    
    request.open("POST", ajaxUrl, true);
    request.onreadystatechange = function() {
        if (request.readyState == 4 && request.status == 200) {
            let objData = JSON.parse(request.responseText);
            if (objData.status) {
                swal("Calificaciones", objData.msg, "success");
                setTimeout(() => { window.location.reload(true); }, 2000);
            } else {
                swal("¡Error!", objData.msg, "error");
            }
            divLoading.style.display = "none";
        }
    }
    request.send(formData);
}

function generarReporteMasivo(nivelid, carreraid, grupoid, profesorid, materiaid) {
    const url = `${base_url}/Cfinales/generarActasMasivas/${nivelid}/${carreraid}/${grupoid}/${profesorid}/${materiaid}`;
    window.open(url, '_blank');
}

if(document.querySelector("#formCalificaciones")){
    let formCalificaciones = document.querySelector("#formCalificaciones");
    formCalificaciones.onsubmit = function(e) {
        e.preventDefault();
        let strNivel = "";
        let strCarrera = "";
        let strDocente = "";
        let strMateria = "";
        let intNivelId = "";
        let intCarreraId = "";
        let intDocenteId = "";
        let intMateriaId = "";
        let strFechaCaptura = "Fecha";
        let intGrupo = document.querySelector('#listGrupos').value;
        let alumnos = document.querySelector('#listaElementos').value;

        if(document.querySelector("#txtNivel"))
        {
            strNivel = document.querySelector("#txtNivel").value;
            intNivelId = document.querySelector("#txtNivel").getAttribute('idnivel');
        }

        if(document.querySelector("#txtCarrera"))
        {
            strCarrera = document.querySelector("#txtCarrera").value;
            intCarreraId = document.querySelector("#txtCarrera").getAttribute('idcarrera');
        }

        if(document.querySelector("#txtGrupo"))
        {
            strGrupo = document.querySelector("#txtGrupo").value;
            intGrupoId = document.querySelector("#txtGrupo").getAttribute('idgrupo');
        }

        if(document.querySelector("#txtDocente"))
        {
            strDocente = document.querySelector("#txtDocente").value;
            intDocenteId = document.querySelector("#txtDocente").getAttribute('iddocente');
        }

        if(document.querySelector("#txtMateria"))
        {
            strMateria = document.querySelector("#txtMateria").value;
            intMateriaId = document.querySelector("#txtMateria").getAttribute('idmateria');
        }

        if(document.querySelector("#txtFechaCaptura"))
        {
            strFechaCaptura = document.querySelector("#txtFechaCaptura").value;
        }

        console.log("Nivel: "+strNivel);
        console.log("Carrera: "+strCarrera);
        console.log("Docente: "+strDocente);
        console.log("Materia: "+strMateria);
        console.log("Fecha Captura: "+strNivel);
        console.log("Alumnos: "+alumnos);
        return;

        if(strNivel == '' || strNivel == null || strCarrera == '' || strCarrera == null 
            || strDocente == '' || strDocente == null || strMateria == '' || strMateria == null 
            || strNivel == 0 || strCarrera == 0 || strDocente == 0 || strMateria == 0 || strFechaCaptura == '' 
            || alumnos == '')
        {
            swal("Atención", "Todos los campos son obligatorios." , "error");
            return false;
        }

        let elementsValid = document.getElementsByClassName("valid");
        for (let i = 0; i < elementsValid.length; i++) { 
            if(elementsValid[i].classList.contains('is-invalid')) { 
                swal("Atención", "Por favor verifique los campos en rojo." , "error");
                return false;
            } 
        } 

        let arrayJson = JSON.parse(alumnos);
        let calReprobatoria = false;
        let alumnosReprobados = [];
        for(var i = 0; i < arrayJson.length; i++)
        {
            if(isNaN(arrayJson[i].calificacion_a))
            {
                if(arrayJson[i].calificacion_a == 'NA' || arrayJson[i].calificacion_a == 'na')
                {
                    calReprobatoria = true;
                    alumnosReprobados.push({"idalumno" : arrayJson[i].idalumno,
                                            "nombre_alumno" : arrayJson[i].nombre_alumno});  
                }
                if(arrayJson[i].calificacion_a != 'AC' && arrayJson[i].calificacion_a != 'NA' && arrayJson[i].calificacion != 'ac' && arrayJson[i].calificacion != 'na')
                {
                    swal("Error!", 'La calificación no puede ser diferente de AC o NA' , "error");
                    return;
                }
                
            }else{
                if(arrayJson[i].calificacion_a != '' && arrayJson[i].calificacion_a < 70)
                {
                    calReprobatoria = true;
                    alumnosReprobados.push({"idalumno" : arrayJson[i].idalumno,
                                            "nombre_alumno" : arrayJson[i].nombre_alumno});  
                }
                if(arrayJson[i].calificacion_a != '' && arrayJson[i].calificacion_a < 10)
                {
                    swal("Error!", 'La calificación no puede ser menor a 10' , "error");
                    return;
                }
                if(arrayJson[i].calificacion_a != '' && arrayJson[i].calificacion_a > 100)
                {
                    swal("Error!", 'La calificación no puede ser mayor a 100' , "error");
                    return;
                }
                
            }
        }

        if(alumnosReprobados.length === 0)
        {
            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Calificaciones/setCalificacion'; 
            let formData = new FormData(formCalificaciones);
            request.open("POST",ajaxUrl,true);
            formData.append("nivelid", intNivelId);
            formData.append("carreraid", intCarreraId);
            formData.append("docenteid", intDocenteId);
            formData.append("materiaid", intMateriaId);
            formData.append("grupoid", intGrupoId);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Calificaciones", objData.msg ,"success");
                        setTimeout(function(){
                            window.location.reload(true);
                        }, 2000);
                    }else{
                        swal("¡Error!", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }

        }else{
            swal({
                title: "¡ATENCIÓN! Calificación No Aprobatoria",
                text: "¿Realmente desea asignar calificación no aprobatoría?",
                type: "warning",
                showCancelButton: true,
                confirmButtonText: "Si, continuar!",
                cancelButtonText: "No, cancelar!",
                closeOnConfirm: false,
                closeOnCancel: true
            }, function(isConfirm) {
                if (isConfirm) 
                {
                    divLoading.style.display = "flex";
                    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                    let ajaxUrl = base_url+'/Calificaciones/setCalificacion'; 
                    let formData = new FormData(formCalificaciones);
                    request.open("POST",ajaxUrl,true);
                    formData.append("nivelid", intNivelId);
                    formData.append("carreraid", intCarreraId);
                    formData.append("docenteid", intDocenteId);
                    formData.append("materiaid", intMateriaId);
                    formData.append("grupo", strGrupo);
                    formData.append("grupoid", intGrupoId);
                    request.send(formData);
                    request.onreadystatechange = function(){
                        if(request.readyState == 4 && request.status == 200){
                            let objData = JSON.parse(request.responseText);
                            if(objData.status)
                            {
                                swal("Calificaciones", objData.msg ,"success");
                                setTimeout(function(){
                                    window.location.reload(true);
                                }, 2000);
                            }else{
                                swal("Error!", objData.msg , "error");
                            }

                        }
                        divLoading.style.display = "none";
                        return false;
                    }
                }
            });
        }     
    }
}

function fntViewGrupo(element,idgrupo){   
    let strGrupo = element.getAttribute('grupo');
    let intCarrera = element.getAttribute('carrera');
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Grupos/getGrupo/';
    request.open("POST",ajaxUrl,true);
    let formData = new FormData();
    formData.append("grupo",strGrupo);
    formData.append("carreraid",intCarrera);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                $("#modalTableGrupo").html("");
                let cont = 1;
                for (var i = 0; i < objData.data.length; i++) {
                    $("#modalTableGrupo").append(
                        '<tr>'+
                            '<td bgcolor="#D4EDDA">'+cont+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].matricula+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].nombre_alumno+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].sexo+'</td>'+
                        '</tr>'
                    );
                    document.querySelector("#txtNivel").value = objData.data[0].grado;
                    document.querySelector("#txtCarrera").value = objData.data[0].grupo;
                    document.querySelector("#txtDocente").value = objData.data[0].nivel;
                    document.querySelector("#txtMateria").value = objData.data[0].carrera;
                    cont++;
                }
                $('#modalViewGrupo').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

$("#listNiveles").change(function(){
    let nivelid = $(this).val();
    if (nivelid == "") {
        swal("Atención", "Tiene que seleccionar un nivel." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Calificaciones/getCarreras/'+nivelid;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionCarreras = "";
                optionCarreras += '<option value="0" selected>Seleccionar Carrera</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionCarreras += '<option value="'+objData.data[i].idcarrera+'">'+objData.data[i].carrera+'/'+objData.data[i].reforma+'</option>';
                }
                $('#divCarreras').html("");
                $('#divGrupos').html("");
                $('#divMaterias').html("");
                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divCarreras').append(
                    '<label>Carrera</label>'+
                    ' <select class="form-control selectpicker" data-live-search="true" id="listCarreras" name="listCarreras" required>'+
                        optionCarreras+
                    '</select>'
                );

                $('#listCarreras').selectpicker('render');
                swal("Carreras", objData.msg, "success");
            }else{
                $('#divCarreras').html("");
                $('#divGrupos').html("");
                $('#divMaterias').html("");
                document.getElementById("formularioCalificaciones").style.display = "none";
                swal("Error", objData.msg , "error");
            }
        }
    }    
})

$("#formBusqueda").on("change", "select#listCarreras", function(){
    let carreraid = $(this).val();
    if (carreraid == "") {
        swal("Atención", "Tiene que seleccionar una carrera." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Calificaciones/getGrupos/'+carreraid;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionGrupos = "";
                optionGrupos += '<option value="0" selected>Seleccionar Grupo</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionGrupos += '<option value="'+objData.data[i].idgrupo+'">'+objData.data[i].grado+'-'+objData.data[i].grupo+'</option>';
                }
                $('#divGrupos').html("");
                $('#divMaterias').html("");
                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divGrupos').append(
                    '<label>Grupo</label>'+
                    ' <select class="form-control selectpicker" data-live-search="true" id="listGrupos" name="listGrupos" required>'+
                        optionGrupos+
                    '</select>'
                );         
                $('#listGrupos').selectpicker('render');
                swal("Grupos", objData.msg, "success");
            }else{
                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divGrupos').html("");
                $('#divMaterias').html("");
                swal("Error", objData.msg , "error");
            }
        }
    }
    
})

$("#formBusqueda").on("change", "select#listGrupos", function(){
    let intCarrera = document.querySelector("#listCarreras").value;
    let intGrupo = $(this).val();

    if (intCarrera == "" || intCarrera == null || intGrupo == "" || intGrupo == 0) {
        swal("Atención", "Es necesario seleccionar carrera y grupo." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Calificaciones/getMaterias/';
    request.open("POST",ajaxUrl,true);
    let formData = new FormData();
    formData.append("carreraid", intCarrera);
    formData.append("grupoid", intGrupo);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionMaterias = "";
                optionMaterias += '<option value="0" selected>Seleccionar Materia</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionMaterias += '<option value="'+objData.data[i].idmateria+'">'+objData.data[i].materia+'</option>';
                }
                $('#divMaterias').html("");
                $('#divPeriodo').html("");

                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divMaterias').append(
                    '<label>Materia</label>'+
                    '<select class="form-control selectpicker" data-live-search="true" id="listMaterias" name="listMaterias" required>'+
                        optionMaterias+
                    '</select>'
                ); 

                $('#listMaterias').selectpicker('render');
                $('#listPeriodo').selectpicker('render');
                swal("Materias", objData.msg, "success");
            }else{
                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divMaterias').html("");
                swal("Error", objData.msg , "error");
            }
        }
    }
})

$("#formCalificaciones").on("change", "input#cbSeleccion", function(){
    listarElementos();
    actualizarStatus(); 
})

$("#formCalificaciones").on("change", "input#txtMatricula", function(){
    listarElementos(); 
})

$("#formCalificaciones").on("change", "input#txtAlumno", function(){
    listarElementos(); 
})

$("#formCalificaciones").on("change", "input#txtCalificacion", function(){
    listarElementos(); 
})

$("#formCalificaciones").on("change", "input#cbSeleccionarTodos", function(){
    let estado = this.checked;
    let cb = document.querySelectorAll("#cbSeleccion");
    if(estado == true)
    {
        for (var i = cb.length - 1; i >= 0; i--) {
            cb[i].checked = true;
        }
    }else{
        for (var i = cb.length - 1; i >= 0; i--) {
            cb[i].checked = false;
        }
    }
    listarElementos();
    actualizarStatus();
})

function listarElementos(){
    let listaElementos = [];
    let matricula = document.querySelectorAll("#txtMatricula");
    let alumno = document.querySelectorAll("#txtAlumno");
    let calificacion = document.querySelectorAll("#txtCalificacion");
    let cbEstado = document.querySelectorAll("#cbSeleccion");

    for(let i = 0; i < alumno.length; i++){
        if(cbEstado[i].checked == true)
        {
            listaElementos.push({ "idalumno" : alumno[i].getAttribute("idAlumno"),
                            "nombre_alumno" : $(alumno[i]).val(),
                            "calificacionid" : calificacion[i].getAttribute("idAlumno"),
                            "calificacion_a" : ($(calificacion[i]).val()).toLocaleUpperCase(),
                            "calificacion_b" : '',
                            "calificacion_c" : '',
                            "calificacion_d" : '',
                            "checked" : true,
                            "matricula" : $(matricula[i]).val()}) 
        }else{
            listaElementos.push({"idalumno" : alumno[i].getAttribute("idAlumno"),
                            "nombre_alumno" : $(alumno[i]).val(),
                            "calificacionid" : calificacion[i].getAttribute("idAlumno"),
                            "calificacion_a" : '',
                            "calificacion_b" : '',
                            "calificacion_c" : '',
                            "calificacion_d" : '',
                            "checked" : false,
                            "matricula" : $(matricula[i]).val()}) 
        }
    }
    $("#listaElementos").val(JSON.stringify(listaElementos)); 
}

function actualizarStatus(){
    let cbEstado = document.querySelectorAll("#cbSeleccion");
    let condicion = 0;
    for(let i = 0; i < cbEstado.length; i++){
        if(cbEstado[i].checked == true)
        {
            condicion = 1;
        }
    }
    $("#txtSeleccion").val(condicion); 
}