let tableCiclos;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

    tableCiclos = $('#tableCiclos').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Ciclos/getCiclos",
            "dataSrc":""
        },
        "columns":[
            {"data":"idciclo", visible: false},
            {"data":"cont"},
            {"data":"ciclo_escolar"},
            {"data":"ultima_modificacion_format"},
            {"data":"tipo_movimiento"},
            {"data":"status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[0,"asc"]]  
    });

    if(document.querySelector("#formCiclos")){
        let formCiclos = document.querySelector("#formCiclos");
        formCiclos.onsubmit = function(e) {
            e.preventDefault();
            let strCicloEscolar= document.querySelector('#listCiclo').value;
            let intStatus= document.querySelector('#listStatus').value;
            
            if(strCicloEscolar == '' || strCicloEscolar == 0 || intStatus == '')
            {
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }
            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Ciclos/setCiclo'; 
            let formData = new FormData(formCiclos);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        if(rowTable == ""){
                            tableCiclos.api().ajax.reload();
                        }else{
                            htmlStatus = intStatus == 1 ? 
                            '<span class="badge badge-success">Activo</span>' : 
                            '<span class="badge badge-danger">Inactivo</span>';
                            rowTable.cells[1].textContent = strCicloEscolar;
                            rowTable.cells[2].textContent = objData.modificador;
                            rowTable.cells[3].textContent = objData.ultima_modificacion;
                            rowTable.cells[4].textContent = objData.tipo_movimiento;
                            rowTable.cells[5].innerHTML = htmlStatus;
                            rowTable = ""; 
                        }
                        $('#modalFormCiclos').modal("hide");
                        formCiclos.reset();
                        swal("Ciclos", objData.msg ,"success");
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }
})

function fntViewCiclo(idciclo){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Ciclos/getCiclo/'+idciclo;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            if(objData.status)
            {
               let estado = objData.data.status == 1 ? 
                '<span class="badge badge-success">Activo</span>' : 
                '<span class="badge badge-danger">Inactivo</span>';
                document.querySelector("#celCiclo").innerHTML = objData.data.ciclo_escolar;
                document.querySelector("#celModificador").innerHTML = objData.data.modificador;
                document.querySelector("#celUltimaModificacion").innerHTML = objData.data.ultima_modificacion_format;
                document.querySelector("#celTipoMovimiento").innerHTML = objData.data.tipo_movimiento;
                document.querySelector("#celStatus").innerHTML = estado;
                $('#modalViewCiclo').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditCiclo(element,idciclo){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Ciclo";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Ciclos/getCiclo/'+idciclo;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {

            }
        }
    
        $('#modalFormCiclos').modal('show');
    }
}

function fntDelCiclo(idciclo){
    swal({
        title: "Eliminar ciclo escolar",
        text: "¿Realmente quiere eliminar este registro?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Ciclos/delCiclo';
            let strData = "idmateria="+idmateria;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableCiclos.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });
}

function fntChangeStatus(element, idciclo){
    rowTable = element.parentNode.parentNode;
    let status = $(element).attr('estado');
    let nuevoStatus = status == "Activo" ? "Inactivo" : "Activo";
    let mensaje = status == "Activo" ? "Actualmente a este ciclo escolar es el activo ¿Realmente desea asignarlo como inactivo?" : 
        "¿Realmente quiere asignar este ciclo escolar como "+nuevoStatus+"?";
    swal({
        title: "Cambiar Estado",
        text: mensaje,
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, actualizar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Ciclos/updStatus';
            let formData = new FormData();
            formData.append("idciclo",idciclo);
            formData.append("status",nuevoStatus);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("¡Actualizar!", objData.msg , "success");
                        rowTable.cells[4].innerHTML = objData.btnStatus;
                        //tableCiclos.api().ajax.reload();
                    }else{
                        swal("¡Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idCiclo').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nuevo Ciclo";
    document.querySelector("#formCiclos").reset();
    if(document.querySelector("#listCiclo"))
    {
        document.querySelector("#listCiclo").value = 0;
        $('#listCiclo').selectpicker('refresh');
    }
    if(document.querySelector("#listStatus"))
    {
        document.querySelector("#listStatus").value = 1;
        $('#listStatus').selectpicker('refresh');
    }
    $('#modalFormCiclos').modal('show');
}