let tableDocentes;
let rowTable = ""; 
/*let visible = 'display: true;';
let notVisible = 'display: none;';*/
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

    tableDocentes = $('#tableDocentes').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Docentes/getDocentes",
            "dataSrc":""
        },
        "columns":[
            {"data":"iddocente", visible:false},
            {"data":"identificador"},
            {"data":"nombre_docente"},
            {"data":"email_user"},
            {"data":"sexo"},
            {"data":"curp"},
            {"data":"rfc"},
            {"data":"status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[1,"desc"]]  
    });

    if(document.querySelector("#formDocentes")){
        let formDocentes = document.querySelector("#formDocentes");
        formDocentes.onsubmit = function(e) {
            e.preventDefault();
            let strIdentificadorUnformat = document.querySelector('#txtIdentificador').value;
            let strIdentificador = strIdentificadorUnformat.toUpperCase();
            let strNombres = document.querySelector('#txtNombres').value;
            let strApellidos = document.querySelector('#txtApellidos').value;
            let strEmailUnformat = document.querySelector('#txtEmail').value;
            let strEmail = strEmailUnformat.toLowerCase();
            let strSexo = document.querySelector('#listSexo').value;
            let strEstadoCivil = document.querySelector('#listEstadoCivil').value;
            let strEstadoNacimiento = document.querySelector('#listEstado').value;
            let strPais = document.querySelector('#listPais').value;
            let intNivelId = document.querySelector('#listNiveles').value;
            let strCurpUnformat = document.querySelector('#txtCurp').value;
            let strCurp = strCurpUnformat.toUpperCase();
            let strRfcUnformat = document.querySelector('#txtRfc').value;
            let strRfc = strRfcUnformat.toUpperCase();
            let strRol = 'Docente';
            let intStatus = document.querySelector('#listStatus').value;

            let strNombresFormat = strNombres.toLocaleUpperCase();
            let strApellidosFormat = strApellidos.toLocaleUpperCase();

            if(strIdentificador == ''){
                swal("Atención", "El número de empleado es obligatorio." , "error");
                return false;
            }
            if(strNombres == ''){
                swal("Atención", "El nombre es obligatorio." , "error");
                return false;
            }
            if(strApellidos == ''){
                swal("Atención", "El apellido es obligatorio." , "error");
                return false;
            }
            if(strEmail == ''){
                swal("Atención", "El email es obligatorio." , "error");
                return false;
            }
            if(strSexo == '' || strSexo == 0){
                swal("Atención", "Favor de seleccionar el sexo." , "error");
                return false;
            }
            if(strEstadoCivil == '' || strEstadoCivil == 0){
                swal("Atención", "Favor de seleccionar el estado cívil." , "error");
                return false;
            }
            if(strEstadoNacimiento == '' || strEstadoNacimiento == 0){
                swal("Atención", "Favor de seleccionar el estado de nacimiento." , "error");
                return false;
            }
            if(strPais == '' || strPais == 0){
                swal("Atención", "Favor de seleccionar el país de nacimiento." , "error");
                return false;
            }
            if(intNivelId == '' || intNivelId == 0){
                swal("Atención", "Favor de seleccionar el nivel a ingresar." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Docentes/setDocente'; 
            let formData = new FormData(formDocentes);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        if(rowTable == ""){
                            tableDocentes.api().ajax.reload();
                        }else{
                            //console.log(rowTable);
                            htmlStatus = intStatus == 1 ? 
                            '<span class="badge badge-success">Activo</span>' : 
                            '<span class="badge badge-danger">Inactivo</span>';
                            rowTable.cells[0].textContent = strIdentificador;
                            rowTable.cells[1].textContent = strNombresFormat+' '+strApellidosFormat;
                            rowTable.cells[2].textContent = strEmail;
                            rowTable.cells[3].textContent = strSexo;
                            rowTable.cells[4].textContent = strCurp;
                            rowTable.cells[5].textContent = strRfc;
                            rowTable.cells[6].innerHTML = htmlStatus;
                            rowTable = ""; 
                        }
                        $('#modalFormDocente').modal("hide");
                        formDocentes.reset();
                        swal("Docentes", objData.msg ,"success");
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }
    //Actualizar Perfil
    if(document.querySelector("#formPerfil")){
        let formPerfil = document.querySelector("#formPerfil");
        formPerfil.onsubmit = function(e) {
            e.preventDefault();
            let strNombre = document.querySelector('#txtNombre').value;
            let strApellido = document.querySelector('#txtApellido').value;
            let strPassword = document.querySelector('#txtPassword').value;
            let strPasswordConfirm = document.querySelector('#txtPasswordConfirm').value;
            let strDireccion = document.querySelector('#txtDireccion').value;
            let strTelefono = document.querySelector('#txtTelefono').value;

            if(strApellido == '' || strNombre == '')
            {
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }

            if(strPassword != "" || strPasswordConfirm != "")
            {   
                if( strPassword != strPasswordConfirm ){
                    swal("Atención", "Las contraseñas no son iguales." , "info");
                    return false;
                }           
                if(strPassword.length < 5 ){
                    swal("Atención", "La contraseña debe tener un mínimo de 5 caracteres." , "info");
                    return false;
                }
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Docentes/putPerfil'; 
            let formData = new FormData(formPerfil);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState != 4 ) return; 
                if(request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        $('#modalFormPerfil').modal("hide");
                        swal({
                            title: "",
                            text: objData.msg,
                            type: "success",
                            confirmButtonText: "Aceptar",
                            closeOnConfirm: false,
                        }, function(isConfirm) {
                            if (isConfirm) {
                                location.reload();
                            }
                        });
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }

    if(document.querySelector("#foto")){
        let foto = document.querySelector("#foto");
        foto.onchange = function(e) {
            let uploadFoto = document.querySelector("#foto").value;
            let fileimg = document.querySelector("#foto").files;
            let nav = window.URL || window.webkitURL;
            let contactAlert = document.querySelector('#form_alert');
            if(uploadFoto !=''){
                let type = fileimg[0].type;
                let name = fileimg[0].name;
                if(type != 'image/jpeg' && type != 'image/jpg' && type != 'image/png'){
                    contactAlert.innerHTML = '<p class="errorArchivo">El archivo no es válido.</p>';
                    if(document.querySelector('#img')){
                        document.querySelector('#img').remove();
                    }
                    if(document.querySelector('.delPhoto'))
                    {
                        document.querySelector('.delPhoto').classList.add("notBlock");
                    }
                    foto.value="";
                    return false;
                }else{  
                        contactAlert.innerHTML='';
                        if(document.querySelector('#img')){
                            document.querySelector('#img').remove();
                        }
                        if(document.querySelector('.delPhoto'))
                        {
                            document.querySelector('.delPhoto').classList.remove("notBlock");
                        }
                        let objeto_url = nav.createObjectURL(this.files[0]);
                        document.querySelector('.prevPhoto div').innerHTML = "<img id='img' src="+objeto_url+" style='width:100px; height:120px;'>";
                        document.querySelector('#foto_remove').value=1;
                    }
            }else{
                alert("No selecciono foto");
                if(document.querySelector('#img')){
                    document.querySelector('#img').remove();
                }
            }
        }
    }

    if(document.querySelector(".delPhoto")){
        let delPhoto = document.querySelector(".delPhoto");
        delPhoto.onclick = function(e) {
            document.querySelector("#foto_remove").value= 1;
            removePhoto();
        }
    }

})

window.addEventListener('load', function() {
        fntRolesUsuario();
}, false);

function formatearPalabra(val) {
  return val.toLowerCase()
            .trim()
            .split(' ')
            .map( v => v[0].toUpperCase() + v.substr(1) )
            .join(' ');  
}

function fntRolesUsuario(){
    if(document.querySelector('#listRolid')){
        let ajaxUrl = base_url+'/Roles/getSelectRoles';
        let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
        request.open("GET",ajaxUrl,true);
        request.send();
        request.onreadystatechange = function(){
            if(request.readyState == 4 && request.status == 200){
                document.querySelector('#listRolid').innerHTML = request.responseText;
                $('#listRolid').selectpicker('render');
            }
        }
    }
}

function fntViewDocente(iddocente){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Docentes/getDocente/'+iddocente;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            if(objData.status)
            {
               let estadoUsuario = objData.data.status == 1 ? 
                '<span class="badge badge-success">Activo</span>' : 
                '<span class="badge badge-danger">Inactivo</span>';
                document.querySelector("#celFoto").innerHTML = '<img src="'+objData.data.url_foto+'" style="height: 128px; width: 128px;"></img>';
                document.querySelector("#celIdentificador").innerHTML = objData.data.identificador;
                document.querySelector("#celNombres").innerHTML = objData.data.nombres;                
                document.querySelector("#celApellidos").innerHTML = objData.data.apellidos;
                document.querySelector("#celEmailUser").innerHTML = objData.data.email_user;
                document.querySelector("#celSexo").innerHTML = objData.data.sexo;                
                document.querySelector("#celEstadoCivil").innerHTML = objData.data.estado_civil;
                document.querySelector("#celFechaNacimiento").innerHTML = objData.data.fecha_nacimiento;
                document.querySelector("#celRfc").innerHTML = objData.data.rfc;                
                document.querySelector("#celCurp").innerHTML = objData.data.curp;
                document.querySelector("#celDireccion").innerHTML = objData.data.direccion;
                document.querySelector("#celCodigoPostal").innerHTML = objData.data.codigo_postal;                
                document.querySelector("#celCiudad").innerHTML = objData.data.ciudad;
                document.querySelector("#celEstado").innerHTML = objData.data.estado;
                document.querySelector("#celPais").innerHTML = objData.data.pais;                
                document.querySelector("#celSalario").innerHTML = objData.data.salario;
                document.querySelector("#celTelefonoCelular").innerHTML = objData.data.telefono_celular;
                document.querySelector("#celTelefonoFijo").innerHTML = objData.data.telefono_fijo;                
                document.querySelector("#celTipoSangre").innerHTML = objData.data.tipo_sangre;
                document.querySelector("#celEmpresa").innerHTML = objData.data.empresa;
                document.querySelector("#celTelefonoEmpresa").innerHTML = objData.data.telefono_empresa;   
                document.querySelector("#celDepartamento").innerHTML = objData.data.departamento;             
                document.querySelector("#celPuesto").innerHTML = objData.data.puesto;
                document.querySelector("#celNivel").innerHTML = objData.data.nivel;
                document.querySelector("#celFechaContratacion").innerHTML = objData.data.fecha_contratacion_format;                
                document.querySelector("#celTipoDocente").innerHTML = objData.data.tipo_docente;
                document.querySelector("#celFormaPago").innerHTML = objData.data.forma_pago;
                document.querySelector("#celNivelEstudios").innerHTML = objData.data.nivel_estudios;                
                document.querySelector("#celFechaEgreso").innerHTML = objData.data.fecha_egreso;
                document.querySelector("#celInstitucion").innerHTML = objData.data.institucion;
                document.querySelector("#celNumeroCedula").innerHTML = objData.data.numero_cedula;                
                document.querySelector("#celCampoEstudios").innerHTML = objData.data.campo_estudios;
                document.querySelector("#celExperienciaDocente").innerHTML = objData.data.experiencia_docente;
                document.querySelector("#celExperienciaProfesional").innerHTML = objData.data.experiencia_profesional;                
                document.querySelector("#celExperienciaLaboral").innerHTML = objData.data.experiencia_laboral;
                document.querySelector("#celPrioridad").innerHTML = objData.data.prioridad;
                document.querySelector("#celNecesidadRh").innerHTML = objData.data.necesidad_rh_format;                
                document.querySelector("#celFechaEntrevistaInicial").innerHTML = objData.data.fecha_entrevista_inicial_format;
                document.querySelector("#celFechaMicroenseñanza").innerHTML = objData.data.fecha_microenseñanza_format;
                document.querySelector("#celFechaEntrevistaFinal").innerHTML = objData.data.fecha_entrevista_final_format;                
                document.querySelector("#celFechaInduccion").innerHTML = objData.data.fecha_induccion_format;
                document.querySelector("#celCursoEbd").innerHTML = objData.data.curso_ebd;
                document.querySelector("#celFechaCursoEbd").innerHTML = objData.data.fecha_curso_ebd_format;                
                document.querySelector("#celOtrosCursos").innerHTML = objData.data.otros_cursos;
                document.querySelector("#celSolicitudEmpleo").innerHTML = objData.data.ruta_solicitud_empleo;
                document.querySelector("#celCv").innerHTML = objData.data.ruta_cv;                
                document.querySelector("#celAntecedentesNoPenales").innerHTML = objData.data.ruta_antecedentes;
                document.querySelector("#celCertificadoMedico").innerHTML = objData.data.ruta_certificado_medico;
                document.querySelector("#celCartasRecomendacion").innerHTML = objData.data.ruta_cartas_recomendacion;                
                document.querySelector("#celFotos").innerHTML = objData.data.ruta_fotos;
                document.querySelector("#celIne").innerHTML = objData.data.ruta_ine;                
                document.querySelector("#celCartillaMilitar").innerHTML = objData.data.ruta_cartilla_militar;
                document.querySelector("#celEcurp").innerHTML = objData.data.ruta_ecurp;
                document.querySelector("#celErfc").innerHTML = objData.data.ruta_erfc;                
                document.querySelector("#celActaNacimiento").innerHTML = objData.data.ruta_acta_nacimiento;
                document.querySelector("#celComprobanteDomicilio").innerHTML = objData.data.ruta_comprobante_domicilio;
                document.querySelector("#celCertificaciones").innerHTML = objData.data.ruta_certificaciones;                
                document.querySelector("#celTitulo").innerHTML = objData.data.ruta_titulo;
                document.querySelector("#celCedulaProfesional").innerHTML = objData.data.ruta_cedula_profesional;
                document.querySelector("#celNombreEmergencia").innerHTML = objData.data.nombre_emergencia;                
                document.querySelector("#celRelacionEmergencia").innerHTML = objData.data.relacion_emergencia;
                document.querySelector("#celTelefonoEmergencia").innerHTML = objData.data.telefono_emergencia;                
                document.querySelector("#celComentarios").innerHTML = objData.data.comentarios;
                document.querySelector("#celStatus").innerHTML = estadoUsuario;
                
                $('#modalViewDocente').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditDocente(element,idpersona){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Docente";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Docentes/getDocente/'+idpersona;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            if(objData.status)
            {
                document.querySelector("#formDocentes").reset();
                document.querySelector("#idDocente").value = objData.data.iddocente;
                document.querySelector("#idPersona").value = objData.data.personaid;
                document.querySelector("#txtIdentificador").value = objData.data.identificador;
                document.querySelector("#txtRol").value = "Docente";
                document.querySelector("#txtNombres").value = objData.data.nombres;
                document.querySelector("#txtApellidos").value = objData.data.apellidos;
                document.querySelector("#txtEmail").value = objData.data.email_user;
                document.querySelector("#txtFechaNacimiento").value = objData.data.fecha_nacimiento;
                document.querySelector("#txtRfc").value =objData.data.rfc;
                document.querySelector("#txtCurp").value =objData.data.curp;
                document.querySelector("#txtDireccion").value =objData.data.direccion;
                document.querySelector("#txtCodigoPostal").value =objData.data.codigo_postal;
                document.querySelector("#txtCiudad").value =objData.data.ciudad;
                document.querySelector("#txtSalario").value =objData.data.salario;
                document.querySelector("#txtTelefonoCelular").value =objData.data.telefono_celular;
                document.querySelector("#txtTelefonoFijo").value =objData.data.telefono_fijo;
                document.querySelector("#txtTipoSangre").value =objData.data.tipo_sangre;
                document.querySelector("#txtEmpresa").value =objData.data.empresa;
                document.querySelector("#txtTelefonoEmpresa").value =objData.data.telefono_empresa;
                document.querySelector("#txtPuesto").value = 'Docente';
                document.querySelector("#txtDepartamento").value =objData.data.departamento;
                document.querySelector("#txtFechaContratacion").value =objData.data.fecha_contratacion;
                document.querySelector("#txtTipoDocente").value =objData.data.tipo_docente;
                document.querySelector("#txtFormaPago").value =objData.data.forma_pago;
                document.querySelector("#txtNivelEstudios").value =objData.data.nivel_estudios;
                document.querySelector("#txtFechaEgreso").value =objData.data.fecha_egreso;
                document.querySelector("#txtInstitucion").value =objData.data.institucion;
                document.querySelector("#txtNumeroCedula").value =objData.data.numero_cedula;
                document.querySelector("#txtCampoEstudios").value =objData.data.campo_estudios;
                document.querySelector("#txtExperienciaDocente").value =objData.data.experiencia_docente;
                document.querySelector("#txtExperienciaProfesional").value =objData.data.experiencia_profesional;
                document.querySelector("#txtExperienciaLaboral").value =objData.data.experiencia_laboral;
                document.querySelector("#txtPrioridad").value =objData.data.prioridad;
                document.querySelector("#txtNecesidad").value =objData.data.necesidad_rh;
                document.querySelector("#txtFechaEntrevistaInicial").value =objData.data.fecha_entrevista_inicial;
                document.querySelector("#txtFechaMicroenseñanza").value =objData.data.fecha_microenseñanza;
                document.querySelector("#txtFechaEntrevistaFinal").value =objData.data.fecha_entrevista_final;
                document.querySelector("#txtFechaInduccion").value =objData.data.fecha_induccion;
                document.querySelector("#txtCursoEbd").value =objData.data.curso_ebd;
                document.querySelector("#txtFechaCursoEbd").value =objData.data.fecha_curso_ebd;
                document.querySelector("#txtOtrosCursos").value =objData.data.otros_cursos;
                document.querySelector("#txtComentarios").value =objData.data.comentarios;
                document.querySelector("#txtNombreEmergencias").value = objData.data.nombre_emergencia;
                document.querySelector("#txtTelefonoEmergencia").value = objData.data.telefono_emergencia;
                document.querySelector("#txtRelacionEmergencia").value = objData.data.relacion_emergencia;
                document.querySelector('#foto_actual').value = objData.data.foto;
                document.querySelector("#foto_remove").value= 0;

                $('#divSolicitudEmpleo').html(objData.data.ruta_solicitud_empleo);
                $('#divCurriculum').html(objData.data.ruta_cv);
                $('#divAntecedentesNoPenales').html(objData.data.ruta_antecedentes);
                $('#divCertificadoMedico').html(objData.data.ruta_certificado_medico);
                $('#divCertificadoMedico').html(objData.data.ruta_certificado_medico);
                $('#divCartasRecomendacion').html(objData.data.ruta_cartas_recomendacion);
                $('#divFotos').html(objData.data.ruta_fotos);
                $('#divIne').html(objData.data.ruta_ine);
                $('#divCartillaMilitar').html(objData.data.ruta_cartilla_militar);
                $('#divCurp').html(objData.data.ruta_ecurp);
                $('#divCurp').html(objData.data.ruta_ecurp);
                $('#divRfc').html(objData.data.ruta_erfc);
                $('#divActaNacimiento').html(objData.data.ruta_acta_nacimiento);
                $('#divComprobanteDomicilio').html(objData.data.ruta_comprobante_domicilio);
                $('#divCertificaciones').html(objData.data.ruta_certificaciones);
                $('#divTitulo').html(objData.data.ruta_titulo);
                $('#divCedulaProfesional').html(objData.data.ruta_cedula_profesional);
                
                if(document.querySelector("#listSexo"))
                {
                    document.querySelector("#listSexo").value = objData.data.sexo;
                    $('#listSexo').selectpicker('render');
                }
                if(document.querySelector("#listEstadoCivil"))
                {
                    document.querySelector("#listEstadoCivil").value = objData.data.estado_civil;
                    $('#listEstadoCivil').selectpicker('render');
                }
                if(document.querySelector("#listEstado"))
                {
                    document.querySelector("#listEstado").value = objData.data.estado;
                    $('#listEstado').selectpicker('render');
                }
                if(document.querySelector("#listPais"))
                {
                    document.querySelector("#listPais").value = objData.data.pais;
                    $('#listPais').selectpicker('render');
                }
                if(document.querySelector("#listNiveles"))
                {
                    document.querySelector("#listNiveles").value = objData.data.nivelid;
                    $('#listNiveles').selectpicker('render');
                }

                if(document.querySelector('#img'))
                {
                    document.querySelector('#img').src = objData.data.url_foto;
                }else{
                    document.querySelector('.prevPhoto div').innerHTML = "<img id='img' src="+objData.data.url_foto+">";
                }

                if(objData.data.foto == 'avatar.png')
                {
                    if(document.querySelector('.delPhoto'))
                    {
                        document.querySelector('.delPhoto').classList.add("notBlock");
                    }
                    
                }else{
                    document.querySelector('.delPhoto').classList.remove("notBlock");
                }

                if(objData.data.status == 1)
                {
                    document.querySelector("#listStatus").value = 1;
                }else{
                    document.querySelector("#listStatus").value = 2;
                }
                $('#listStatus').selectpicker('render');
            }
        }   
        $('#modalFormDocente').modal('show');
    }
}

function fntDelDocente(idpersona){
    swal({
        title: "Eliminar Docente",
        text: "¿Realmente quiere eliminar el docente?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Docentes/delDocente';
            let strData = "idpersona="+idpersona;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableDocentes.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }
    });
}

function removePhoto(){
    document.querySelector('#foto').value ="";
    if(document.querySelector('.delPhoto'))
    {
        document.querySelector('.delPhoto').classList.add("notBlock");
    }
    if(document.querySelector('#img')){
        document.querySelector('#img').remove();
    }
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idDocente').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nuevo Docente";
    document.querySelector("#formDocentes").reset();
    $('#divSolicitudEmpleo').html("");
    $('#divCurriculum').html("");
    $('#divAntecedentesNoPenales').html("");
    $('#divCertificadoMedico').html("");
    $('#divCertificadoMedico').html("");
    $('#divCartasRecomendacion').html("");
    $('#divFotos').html("");
    $('#divIne').html("");
    $('#divCartillaMilitar').html("");
    $('#divCurp').html("");
    $('#divCurp').html("");
    $('#divRfc').html("");
    $('#divActaNacimiento').html("");
    $('#divComprobanteDomicilio').html("");
    $('#divCertificaciones').html("");
    $('#divTitulo').html("");
    $('#divCedulaProfesional').html("");
    $('#modalFormDocente').modal('show');
    if(document.querySelector("#listSexo"))
    {
        document.querySelector("#listSexo").value = "0";
        $('#listSexo').selectpicker('render');
    }
    if(document.querySelector("#listEstadoCivil"))
    {
        document.querySelector("#listEstadoCivil").value = "0";
        $('#listEstadoCivil').selectpicker('render');
    }
    if(document.querySelector("#listEstado"))
    {
        document.querySelector("#listEstado").value = "0";
        $('#listEstado').selectpicker('render');
    }
    if(document.querySelector("#listPais"))
    {
        document.querySelector("#listPais").value = "0";
        $('#listPais').selectpicker('render');
    }
    if(document.querySelector("#listNiveles"))
    {
        document.querySelector("#listNiveles").value = "0";
        $('#listNiveles').selectpicker('render');
    }
}

/*function openModalPerfil(){
    $('#modalFormPerfil').modal('show');
}*/

/*$("#listRolid").change(function(){
    let idRol = document.querySelector("#listRolid").value;
    console.log("ID Rol: ", idRol);
    if(idRol == 5){
        document.querySelector(".divAlumnos").setAttribute("style",visible)
    }else{
        document.querySelector(".divAlumnos").setAttribute("style",notVisible)
    }
})*/