let tableNiveles;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){
    if(document.querySelector("#formEditarCalificaciones")){
        let formEditarCalificaciones = document.querySelector("#formEditarCalificaciones");
        formEditarCalificaciones.onsubmit = function(e) {
            e.preventDefault();
            listarElementos();
            let strNivel = "";
            let strCarrera = "";
            let strDocente = "";
            let strMateria = "";
            let intNivelId = "";
            let intCarreraId = "";
            let intDocenteId = "";
            let intMateriaId = "";
            let strFechaCaptura = "Fecha";
            let strGrupo = document.querySelector('#listGrupos').value;
            let alumnos = document.querySelector('#listaElementos').value;
            
            if(document.querySelector("#txtEditarNivel")){
                strNivel = document.querySelector("#txtEditarNivel").value;
                intNivelId = document.querySelector("#txtEditarNivel").getAttribute('idnivel');
            }

            if(document.querySelector("#txtEditarCarrera")){
                strCarrera = document.querySelector("#txtEditarCarrera").value;
                intCarreraId = document.querySelector("#txtEditarCarrera").getAttribute('idcarrera');
            }

            if(document.querySelector("#txtEditarGrupo")){
                strGrupo = document.querySelector("#txtEditarGrupo").value;
                intGrupoId = document.querySelector("#txtEditarGrupo").getAttribute('idgrupo');
            }

            if(document.querySelector("#txtEditarDocente")){
                strDocente = document.querySelector("#txtEditarDocente").value;
                intDocenteId = document.querySelector("#txtEditarDocente").getAttribute('iddocente');
            }

            if(document.querySelector("#txtEditarMateria")){
                strMateria = document.querySelector("#txtEditarMateria").value;
                intMateriaId = document.querySelector("#txtEditarMateria").getAttribute('idmateria');
            }

            if(document.querySelector("#txtEditarFechaCaptura")){
                strFechaCaptura = document.querySelector("#txtEditarFechaCaptura").value;
            }

            if(strNivel == '' || strNivel == null || strCarrera == '' || strCarrera == null 
                || strDocente == '' || strDocente == null || strMateria == '' || strMateria == null 
                || strNivel == 0 || strCarrera == 0 || strDocente == 0 || strMateria == 0 || strFechaCaptura == ''){
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 

            let arrayJson = JSON.parse(alumnos);
            let calReprobatoria = false;
            let alumnosReprobados = [];
            for(var i = 0; i < arrayJson.length; i++)
            {
                if(isNaN(arrayJson[i].calificacion_a) || isNaN(arrayJson[i].calificacion_b) 
                    || isNaN(arrayJson[i].calificacion_c) || isNaN(arrayJson[i].calificacion_d))
                {
                    if(arrayJson[i].calificacion_a == 'NA' || arrayJson[i].calificacion_a == 'na' || 
                        arrayJson[i].calificacion_b == 'NA' || arrayJson[i].calificacion_b == 'na' ||
                        arrayJson[i].calificacion_c == 'NA' || arrayJson[i].calificacion_c == 'na' ||
                        arrayJson[i].calificacion_d == 'NA' || arrayJson[i].calificacion_d == 'na')
                    {
                        calReprobatoria = true;
                        alumnosReprobados.push({"idalumno" : arrayJson[i].idalumno,
                                                "nombre_alumno" : arrayJson[i].nombre_alumno});  
                    }
                    if((arrayJson[i].calificacion_a != '' && arrayJson[i].calificacion_a != 'AC' && arrayJson[i].calificacion_a != 'NA' && arrayJson[i].calificacion_a != 'ac' && arrayJson[i].calificacion_a != 'na')
                        || (arrayJson[i].calificacion_b != '' && arrayJson[i].calificacion_b != 'AC' && arrayJson[i].calificacion_b != 'NA' && arrayJson[i].calificacion_b != 'ac' && arrayJson[i].calificacion_b != 'na')
                        || (arrayJson[i].calificacion_c != '' && arrayJson[i].calificacion_c != 'AC' && arrayJson[i].calificacion_c != 'NA' && arrayJson[i].calificacion_c != 'ac' && arrayJson[i].calificacion_c != 'na')
                        || (arrayJson[i].calificacion_d != '' && arrayJson[i].calificacion_d != 'AC' && arrayJson[i].calificacion_d != 'NA' && arrayJson[i].calificacion_d != 'ac' && arrayJson[i].calificacion_d != 'na'))
                    {
                        swal("Error!", 'La calificación no puede ser diferente de AC o NA' , "error");
                        return;
                    }
                }else{
                    if((arrayJson[i].calificacion_a != '' && arrayJson[i].calificacion_a < 70) ||
                       (arrayJson[i].calificacion_b != '' && arrayJson[i].calificacion_b < 70) ||
                       (arrayJson[i].calificacion_c != '' && arrayJson[i].calificacion_c < 70) ||
                       (arrayJson[i].calificacion_d != '' && arrayJson[i].calificacion_d < 70)) 
                    {
                        calReprobatoria = true;
                        alumnosReprobados.push({"idalumno" : arrayJson[i].idalumno,
                                                "nombre_alumno" : arrayJson[i].nombre_alumno});  
                    }
                    if((arrayJson[i].calificacion_a != '' && arrayJson[i].calificacion_a < 10) ||
                       (arrayJson[i].calificacion_b != '' && arrayJson[i].calificacion_b < 10) ||
                       (arrayJson[i].calificacion_c != '' && arrayJson[i].calificacion_c < 10) ||
                       (arrayJson[i].calificacion_d != '' && arrayJson[i].calificacion_d < 10)) 
                    {
                        swal("Error!", 'La calificación no puede ser menor a 10' , "error");
                        return;
                    }
                    if((arrayJson[i].calificacion_a != '' && arrayJson[i].calificacion_a > 100) ||
                       (arrayJson[i].calificacion_b != '' && arrayJson[i].calificacion_b > 100) ||
                       (arrayJson[i].calificacion_c != '' && arrayJson[i].calificacion_c > 100) ||
                       (arrayJson[i].calificacion_d != '' && arrayJson[i].calificacion_d > 100)) 
                    {
                        swal("Error!", 'La calificación no puede ser mayor a 100' , "error");
                        return;
                    } 
                }
            }

            if(alumnosReprobados.length === 0)
            {
                divLoading.style.display = "flex";
                let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                let ajaxUrl = base_url+'/Editar_calificaciones/updateCalificacion'; 
                let formData = new FormData(formEditarCalificaciones);
                request.open("POST",ajaxUrl,true);
                formData.append("nivelid", intNivelId);
                formData.append("carreraid", intCarreraId);
                formData.append("docenteid", intDocenteId);
                formData.append("materiaid", intMateriaId);
                formData.append("grupoid", intGrupoId);
                formData.append("grupo", strGrupo);
                request.send(formData);
                request.onreadystatechange = function(){
                    if(request.readyState == 4 && request.status == 200){
                        let objData = JSON.parse(request.responseText);
                        if(objData.status)
                        {
                            //console.log(objData);
                            swal("Calificaciones", objData.msg ,"success");
                            setTimeout(function(){
                                window.location.reload(true);
                            }, 2000);
                        }else{
                            swal("Error!", objData.msg , "error");
                        }
                    }
                    divLoading.style.display = "none";
                    return false;
                }
            }else{
                swal({
                    title: "¡ATENCIÓN! Calificación No Aprobatoria",
                    text: "¿Realmente desea asignar calificación no aprobatoría?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Si, continuar!",
                    cancelButtonText: "No, cancelar!",
                    closeOnConfirm: false,
                    closeOnCancel: true
                }, function(isConfirm) {
                    if (isConfirm) 
                    {
                        divLoading.style.display = "flex";
                        let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                        let ajaxUrl = base_url+'/Editar_calificaciones/updateCalificacion'; 
                        let formData = new FormData(formEditarCalificaciones);
                        request.open("POST",ajaxUrl,true);
                        formData.append("nivelid", intNivelId);
                        formData.append("carreraid", intCarreraId);
                        formData.append("docenteid", intDocenteId);
                        formData.append("materiaid", intMateriaId);
                        formData.append("grupoid", intGrupoId);
                        formData.append("grupo", strGrupo);
                        request.send(formData);
                        request.onreadystatechange = function(){
                            if(request.readyState == 4 && request.status == 200){
                                let objData = JSON.parse(request.responseText);
                                if(objData.status)
                                {
                                    //console.log(objData);
                                    swal("Calificaciones", objData.msg ,"success");
                                    setTimeout(function(){
                                        window.location.reload(true);
                                    }, 2000);
                                }else{
                                    swal("Error!", objData.msg , "error");
                                    //document.getElementById("formularioCalificaciones").style.display = "none";
                                }
                            }
                            divLoading.style.display = "none";
                            return false;
                        }
                    }
                });
            }
        }
    }

    if(document.querySelector("#formEditarCalificacionesIndividual")){
        let formEditarCalificacionesIndividual = document.querySelector("#formEditarCalificacionesIndividual");
        formEditarCalificacionesIndividual.onsubmit = function(e) {
            e.preventDefault();
            let intIdKardex = document.querySelector("#idKardexIndividual").value;
            let IntIdKardexJson = document.querySelector("#idKardexJson").value;
            let strCalificacionA = document.querySelector("#txtCalificacionIndivA").value;
            let strCalificacionB = document.querySelector("#txtCalificacionIndivB").value;
            let strCalificacionC = document.querySelector("#txtCalificacionIndivC").value;
            let strCalificacionD = document.querySelector("#txtCalificacionIndivD").value;
            let strNombreAlumno = document.querySelector("#txtAlumnoIndividual").value;
            let calReprobatoria = false;

            if(intIdKardex == '' || intIdKardex == null || IntIdKardexJson == '' || IntIdKardexJson == null &&
                (strCalificacionA == "" && strCalificacionB == "" && strCalificacionC == "" && strCalificacionD == "")){
                swal("Atención", "Favor de completar los campos obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 

            if(isNaN(strCalificacionA) && isNaN(strCalificacionA) && isNaN(strCalificacionA) && isNaN(strCalificacionA))
            {
                if(strCalificacionA== 'NA' || strCalificacionA == 'na' || 
                    strCalificacionB == 'NA' || strCalificacionB == 'na' ||
                    strCalificacionC == 'NA' || strCalificacionC == 'na' ||
                    strCalificacionD == 'NA' || strCalificacionD == 'na')
                {
                    calReprobatoria = true;
                }
                if((strCalificacionA != '' && strCalificacionA != 'AC' && strCalificacionA != 'NA' && strCalificacionA != 'ac' && strCalificacionA != 'na')
                        || (strCalificacionB != '' && strCalificacionB != 'AC' && strCalificacionB != 'NA' && strCalificacionB != 'ac' && strCalificacionB != 'na')
                        || (strCalificacionC != '' && strCalificacionC != 'AC' && strCalificacionC != 'NA' && strCalificacionC != 'ac' && strCalificacionC != 'na')
                        || (strCalificacionD != '' &&strCalificacionD != 'AC' && strCalificacionD != 'NA' && strCalificacionD != 'ac' && strCalificacionD != 'na'))
                {
                    swal("Error!", 'La calificación no puede ser diferente de AC o NA' , "error");
                    return;
                }
            }else{
                if((strCalificacionA != '' && strCalificacionA < 70) ||
                       (strCalificacionB != '' && strCalificacionB < 70) ||
                       (strCalificacionC != '' && strCalificacionC < 70) ||
                       (strCalificacionD != '' && strCalificacionD < 70)) 
                {
                    calReprobatoria = true;
                }
                if((strCalificacionA != '' && strCalificacionA < 10) ||
                   (strCalificacionB != '' && strCalificacionB < 10) ||
                   (strCalificacionC != '' && strCalificacionC < 10) ||
                   (strCalificacionD != '' && strCalificacionD < 10)) 
                {
                    swal("Error!", 'La calificación no puede ser menor a 10' , "error");
                    return;
                }
                if((strCalificacionA != '' && strCalificacionA > 100) ||
                   (strCalificacionB != '' && strCalificacionB > 100) ||
                   (strCalificacionC != '' && strCalificacionC > 100) ||
                   (strCalificacionD != '' && strCalificacionD > 100)) 
                {
                    swal("Error!", 'La calificación no puede ser mayor a 100' , "error");
                    return;
                } 
            }
    
            if(calReprobatoria == false)
            {
                divLoading.style.display = "flex";
                let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                let ajaxUrl = base_url+'/Editar_calificaciones/updateCalificacionIndividual'; 
                let formData = new FormData(formEditarCalificacionesIndividual);
                request.open("POST",ajaxUrl,true);
                request.send(formData);
                request.onreadystatechange = function(){
                    if(request.readyState == 4 && request.status == 200){
                        let objData = JSON.parse(request.responseText);
                        if(objData.status)
                        {
                            swal("Calificaciones", objData.msg ,"success");
                            setTimeout(function(){
                                window.location.reload(true);
                            }, 2000);
                        }else{
                            swal("Error!", objData.msg , "error");
                        }
                    }
                    divLoading.style.display = "none";
                    return false;
                }
            }else{
                swal({
                    title: "¡ATENCIÓN! Calificación No Aprobatoria",
                    text: "¿Realmente desea asignar calificación no aprobatoría al alumno "+strNombreAlumno+"?",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Si, continuar!",
                    cancelButtonText: "No, cancelar!",
                    closeOnConfirm: false,
                    closeOnCancel: true
                }, function(isConfirm) {
                    if (isConfirm) 
                    {
                        divLoading.style.display = "flex";
                        let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                        let ajaxUrl = base_url+'/Editar_calificaciones/updateCalificacionIndividual'; 
                        let formData = new FormData(formEditarCalificacionesIndividual);
                        request.open("POST",ajaxUrl,true);
                        request.send(formData);
                        request.onreadystatechange = function(){
                            if(request.readyState == 4 && request.status == 200){
                                let objData = JSON.parse(request.responseText);
                                if(objData.status)
                                {
                                    swal("Calificaciones", objData.msg ,"success");
                                    setTimeout(function(){
                                        window.location.reload(true);
                                    }, 2000);
                                }else{
                                    swal("Error!", objData.msg , "error");
                                }
                            }
                            divLoading.style.display = "none";
                            return false;
                        }
                    }
                });
            }
        }
    }

    if(document.querySelector("#formBusqueda")){
        let formBusqueda = document.querySelector("#formBusqueda");
        formBusqueda.onsubmit = function(e) {
            e.preventDefault();
            let intNivelId = document.querySelector("#listNiveles").value;
            let intCarreraId = "";
            let intGrupoId = "";
            let intMateriaId = "";

            if(document.querySelector("#listCarreras"))
            {
                intCarreraId = document.querySelector("#listCarreras").value;
            }

            if(document.querySelector("#listGrupos"))
            {
                intGrupoId = document.querySelector("#listGrupos").value;
            }

            if(document.querySelector("#listMaterias"))
            {
                intMateriaId = document.querySelector("#listMaterias").value;
            }
            
            if(intNivelId == '' || intNivelId == null || intCarreraId == '' || intCarreraId == null 
                || intGrupoId == '' || intGrupoId == null || intMateriaId == '' || intMateriaId == null 
                || intNivelId == 0 || intCarreraId == 0 || intGrupoId == 0 || intMateriaId == 0)
            {
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Editar_calificaciones/getBusquedaEditarAlumnos'; 
            let formData = new FormData(formBusqueda);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        let elementosJson = "";
                        let idKardex = "";
                        let seleccion =  0;
                        $('.divAlumnos').html("");
                        $('.divBoton').html("");
                        document.getElementById("formularioCalificaciones").style.display = "";
                        let cont = 1;
                        for (var i = 0; i < objData.data.length; i++){
                            let calificacion_a = "";
                            let calificacion_b = "";
                            let calificacion_c = "";
                            let calificacion_d = "";
                            let checked = '';
                            if(objData.data[i].kardexidj != null){
                                idKardex = objData.data[i].kardexidj;
                            }
                            if(objData.data[i].calificacion_a != null && objData.data[i].calificacion_a != ''){
                                calificacion_a = objData.data[i].calificacion_a;
                                checked = 'checked=""';
                                seleccion = 1;
                            }
                            if(objData.data[i].calificacion_b != null && objData.data[i].calificacion_b != ''){
                                calificacion_b = objData.data[i].calificacion_b;
                            }
                            if(objData.data[i].calificacion_c != null && objData.data[i].calificacion_c != ''){
                                calificacion_c = objData.data[i].calificacion_c;
                            }
                            if(objData.data[i].calificacion_d != null && objData.data[i].calificacion_d != ''){
                                calificacion_d = objData.data[i].calificacion_d;
                            }
                            if(objData.data[i].json_data != null){
                                elementosJson = objData.data[i].json_data;
                            }
                            $('.divAlumnos').append(
                                '<div class="form-row">'+
                                    '<div class="form-group col-md-1" style="align-content-center">'+
                                        '<input class="form-control" type="checkbox" id="cbSeleccion" name="cbSeleccion" value="" idAlumno="'+objData.data[i].idalumno+'" '+checked+'/>'+
                                    '</div>'+
                                    '<div class="form-group col-md-1" style="align-content-center">'+
                                        '<input class="form-control" type="text" id="txtOrden" name="txtOrden" value="'+cont+'" readonly placeholder="#">'+
                                    '</div>'+
                                    '<div class="form-group col-md-2" style="align-content-center">'+
                                        '<input class="form-control" type="text" id="txtMatricula" name="txtMatricula" idAlumno="'+objData.data[i].idalumno+'" value="'+objData.data[i].matricula+'" readonly placeholder="Matricula del alumno" required>'+
                                    '</div>'+
                                    '<div class="form-group col-md-5" style="align-content-center">'+
                                        '<input class="form-control" type="text" id="txtAlumno" name="txtAlumno" idAlumno="'+objData.data[i].idalumno+'" value="'+objData.data[i].nombre_alumno+'" readonly placeholder="Nombre del alumno" required>'+
                                    '</div>'+
                                    '<div class="form-group col-md-3" style="align-content-center">'+
                                        '<input class="form-control" type="text" id="txtCalificacionA" name="txtCalificacionA" calOriginalA="'+calificacion_a+'" idAlumno="'+objData.data[i].idalumno+'" value="'+calificacion_a+'" placeholder="Calificación Parcial" />'+
                                        '<input class="form-control" type="text" id="txtCalificacionB" name="txtCalificacionB" calOriginalB="'+calificacion_b+'" idAlumno="'+objData.data[i].idalumno+'" value="'+calificacion_b+'" placeholder="Calificación Ordinario" />'+
                                        '<input class="form-control" type="text" id="txtCalificacionC" name="txtCalificacionC" calOriginalC="'+calificacion_c+'" idAlumno="'+objData.data[i].idalumno+'" value="'+calificacion_c+'" placeholder="Calificación Extraordinario" />'+
                                        '<input class="form-control" type="text" id="txtCalificacionD" name="txtCalificacionD" calOriginalD="'+calificacion_d+'" idAlumno="'+objData.data[i].idalumno+'" value="'+calificacion_d+'" placeholder="Calificación Recursamiento" />'+
                                    '</div>'+
                                '</div>'
                            )
                            cont++;
                        }
                        $('.divBoton').append(
                            '<a title="Generar reporte de calificaciones" href="'+objData.url+'/Editar_calificaciones/formatoCalificaciones/'+objData.data[0].kardexidj+'" target="_blanck" class="btn btn-danger btn-sm"> <i class="fas fa-file-pdf"></i> Generar Reporte</a>'
                        )
                        document.querySelector("#idkardex").value = idKardex; //objData.data[0].kardexidj
                        document.querySelector("#listaElementos").value = elementosJson; //document.querySelector("#listaElementos").value = objData.data[0].json_data;
                        document.querySelector("#txtSeleccion").value = seleccion;
                        document.querySelector("#txtEditarNivel").value = objData.nivel.nivel;
                        document.querySelector("#txtEditarNivel").setAttribute('idnivel', objData.nivel.idnivel);
                        document.querySelector("#txtEditarCarrera").value = objData.carrera.carrera;
                        document.querySelector("#txtEditarCarrera").setAttribute('idcarrera', objData.carrera.idcarrera);
                        document.querySelector("#txtEditarGrupo").value = objData.data[0].grupo_format;
                        document.querySelector("#txtEditarGrupo").setAttribute('idgrupo', objData.data[0].grupoid);
                        document.querySelector("#txtEditarDocente").value = objData.docente.nombre_docente;
                        document.querySelector("#txtEditarDocente").setAttribute('iddocente', objData.docente.idpersona);
                        document.querySelector("#txtEditarMateria").value = objData.materia.materia;
                        document.querySelector("#txtEditarMateria").setAttribute('idmateria', objData.materia.idmateria);
                    }else{
                        swal("Error!", objData.msg , "error");
                        document.getElementById("formularioCalificaciones").style.display = "none";
                    }


                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }

    if(document.querySelector("#formBusquedaIndividual")){
        let formBusqueda = document.querySelector("#formBusquedaIndividual");
        formBusquedaIndividual.onsubmit = function(e) {
            e.preventDefault();
            
            let intNivelId = document.querySelector("#listNivelesIndividual").value;
            let intCarreraId = "";
            let intAlumnoId = "";
            let intMateriaId = "";

            if(document.querySelector("#listCarrerasIndividual"))
            {
                intCarreraId = document.querySelector("#listCarrerasIndividual").value;
            }

            if(document.querySelector("#listAlumnosIndividual"))
            {
                intAlumnoId = document.querySelector("#listAlumnosIndividual").value;
            }

            if(document.querySelector("#listMateriasIndividual"))
            {
                intMateriaId = document.querySelector("#listMateriasIndividual").value;
            }        

            if(intNivelId == '' || intNivelId == null || intCarreraId == '' || intCarreraId == null 
                || intAlumnoId == '' || intAlumnoId == null || intMateriaId == '' || intMateriaId == null 
                || intNivelId == 0 || intCarreraId == 0 || intAlumnoId == 0 || intMateriaId == 0)
            {
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Editar_calificaciones/getBusquedaAlumnoIndividual'; 
            let formData = new FormData(formBusquedaIndividual);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        let calificacionA = (objData.data.calificacion_a != '' && objData.data.calificacion_a != null) ? objData.data.calificacion_a : '';
                        let calificacionB = (objData.data.calificacion_b != '' && objData.data.calificacion_b != null) ? objData.data.calificacion_b : '';
                        let calificacionC = (objData.data.calificacion_c != '' && objData.data.calificacion_c != null) ? objData.data.calificacion_c : '';
                        let calificacionD = (objData.data.calificacion_d != '' && objData.data.calificacion_d != null) ? objData.data.calificacion_d : '';
                        $('.divAlumnosIndividual').html("");
                        $('.divBoton').html("");
                        document.getElementById("formularioCalificacionesIndividual").style.display = "flex";
                        $('.divAlumnosIndividual').append(
                            '<div class="form-row">'+
                                '<div class="form-group col-md-3" style="align-content-center">'+
                                    '<h6 for="txtCalificacionIndivA">Calif. Parcial</h6>'+
                                    '<input class="form-control" type="text" id="txtCalificacionIndivA" name="txtCalificacionIndivA"  idAlumno="'+objData.data.idalumno+'" value="'+calificacionA+'" placeholder="Editar Calificación" />'+
                                '</div>'+
                                '<div class="form-group col-md-3" style="align-content-center">'+
                                    '<h6 for="txtCalificacionIndivB">Calif. Ordinario</h6>'+
                                    '<input class="form-control" type="text" id="txtCalificacionIndivB" name="txtCalificacionIndivB"  idAlumno="'+objData.data.idalumno+'" value="'+calificacionB+'" placeholder="Editar Calificación" />'+
                                '</div>'+
                                '<div class="form-group col-md-3" style="align-content-center">'+
                                    '<h6 for="txtCalificacionIndivC">Calif. Extraordinario</h6>'+
                                    '<input class="form-control" type="text" id="txtCalificacionIndivC" name="txtCalificacionIndivC"  idAlumno="'+objData.data.idalumno+'" value="'+calificacionC+'" placeholder="Editar Calificación" />'+
                                '</div>'+
                                '<div class="form-group col-md-3" style="align-content-center">'+
                                    '<h6 for="txtCalificacionIndivD">Calif. Recursamiento</h6>'+
                                    '<input class="form-control" type="text" id="txtCalificacionIndivD" name="txtCalificacionIndivD"  idAlumno="'+objData.data.idalumno+'" value="'+calificacionD+'" placeholder="Editar Calificación" />'+
                                '</div>'+
                            '</div>'
                        )

                        $('.divBoton').append(
                            '<a title="Generar reporte de calificaciones" href="'+objData.url+'/Editar_calificaciones/formatoCalificaciones/'+objData.data.kardexidj+'" target="_blanck" class="btn btn-danger btn-sm"> <i class="fas fa-file-pdf"></i> Generar Reporte</a>'
                        )
                        console.log(objData);
                        document.querySelector("#idKardexIndividual").value = objData.data.idkardex;
                        document.querySelector("#idKardexJson").value = objData.data.kardexidj;
                        document.querySelector("#listaElementosIndividual").value = objData.data.data; //document.querySelector("#listaElementos").value = objData.data[0].json_data;
                        document.querySelector("#txtNivelIndividual").value = objData.nivel.nivel;
                        document.querySelector("#txtNivelIndividual").setAttribute('idnivel', objData.nivel.idnivel);
                        document.querySelector("#txtCarreraIndividual").value = objData.carrera.carrera;
                        document.querySelector("#txtCarreraIndividual").setAttribute('idcarrera', objData.carrera.idcarrera);
                        document.querySelector("#txtGrupoIndividual").value = objData.data.grupo_format;
                        document.querySelector("#txtGrupoIndividual").setAttribute('idcarrera', objData.data.idgrupo);
                        document.querySelector("#txtDocenteIndividual").value = objData.docente.nombre_docente;
                        document.querySelector("#txtDocenteIndividual").setAttribute('iddocente', objData.docente.idpersona);
                        document.querySelector("#txtMateriaIndividual").value = objData.materia.materia;
                        document.querySelector("#txtMateriaIndividual").setAttribute('idmateria', objData.materia.idmateria);
                        document.querySelector("#txtMatriculaIndividual").value = objData.data.matricula;
                        document.querySelector("#txtMatriculaIndividual").setAttribute('matricula', objData.data.matricula);
                        document.querySelector("#txtAlumnoIndividual").value = objData.data.nombre_alumno;
                        document.querySelector("#txtAlumnoIndividual").setAttribute('nombre_alumno', objData.data.nombre_alumno);
                    }else{
                        swal("Error!", objData.msg , "error");
                        document.getElementById("formularioCalificaciones").style.display = "none";
                        document.getElementById("formularioCalificacionesIndividual").style.display = "none";
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }

})

function fntReporteCalificacion(element,idcarrera){
    let intCarreraId = element.getAttribute("carrera");
    let intNivelId = element.getAttribute("nivel");
    let intDocenteId = element.getAttribute("docente");
    let strGrupo = element.getAttribute("grupo");
    let intMateriaId = element.getAttribute("materia");

    divLoading.style.display = "flex";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Editar_calificaciones/formatoCalificaciones/';
    let formDataFormato = new FormData();
    formDataFormato.append("carreraid", intCarreraId);
    formDataFormato.append("nivelid", intNivelId);
    formDataFormato.append("docenteid", intDocenteId);
    formDataFormato.append("grupo", strGrupo);
    formDataFormato.append("materiaid", intMateriaId);
    request.open("POST",ajaxUrl,true);
    request.send(formDataFormato);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idNivel").value = objData.data.idnivel;
                document.querySelector("#txtNivel").value = objData.data.nivel;
                if(document.querySelector("#listCoordinador"))
                {
                    document.querySelector("#listCoordinador").value = objData.data.coordinadorid;
                    $('#listCoordinador').selectpicker('render');
                }
                if(document.querySelector("#listStatus"))
                {
                    document.querySelector("#listStatus").value = objData.data.status;
                    $('#listStatus').selectpicker('render');
                }  
            }
        }
        $('#modalFormNiveles').modal('show');
    }
}

function fntViewNivel(idnivel){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Niveles/getNivel/'+idnivel;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            if(objData.status)
            {
               let estado = objData.data.status == 1 ? 
                '<span class="badge badge-success">Activo</span>' : 
                '<span class="badge badge-danger">Inactivo</span>';
                document.querySelector("#celNivel").innerHTML = objData.data.nivel;
                document.querySelector("#celModificador").innerHTML = objData.data.modificador;
                document.querySelector("#celUltimaModificacion").innerHTML = objData.data.ultima_modificacion_format;
                document.querySelector("#celStatus").innerHTML = estado;
                $('#modalViewNivel').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditNivel(element,idnivel){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Nivel";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Niveles/getNivel/'+idnivel;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idNivel").value = objData.data.idnivel;
                document.querySelector("#txtNivel").value = objData.data.nivel;
                if(document.querySelector("#listCoordinador"))
                {
                    document.querySelector("#listCoordinador").value = objData.data.coordinadorid;
                    $('#listCoordinador').selectpicker('render');
                }
                if(document.querySelector("#listStatus"))
                {
                    document.querySelector("#listStatus").value = objData.data.status;
                    $('#listStatus').selectpicker('render');
                } 
            }
        }
        $('#modalFormNiveles').modal('show');
    }
}

$("#listNiveles").change(function(){
    let nivelid = $(this).val();
    if (nivelid == "") {
        swal("Atención", "Tiene que seleccionar un nivel." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Editar_calificaciones/getCarreras/'+nivelid;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionCarreras = "";
                optionCarreras += '<option value="0" selected>Seleccionar Carrera</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionCarreras += '<option value="'+objData.data[i].idcarrera+'">'+objData.data[i].carrera+'/'+objData.data[i].reforma+'</option>';
                }
                $('#divCarrerasEditar').html("");
                $('#divGruposEditar').html("");
                $('#divMateriasEditar').html("");
                //document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divCarrerasEditar').append(
                    '<label>Carrera</label>'+
                    ' <select class="form-control selectpicker" data-live-search="true" id="listCarreras" name="listCarreras" required>'+
                        optionCarreras+
                    '</select>'
                );
                $('#listCarreras').selectpicker('render');
                swal("Carreras", objData.msg, "success");
            }else{
                $('#divCarrerasEditar').html("");
                $('#divGruposEditar').html("");
                $('#divMateriasEditar').html("");
                //document.getElementById("formularioCalificaciones").style.display = "none";
                swal("Error", objData.msg , "error");
            }
        }
    }
})

$("#formBusqueda").on("change", "select#listCarreras", function(){
    let carreraid = $(this).val();
    if (carreraid == ""){
        swal("Atención", "Tiene que seleccionar una carrera." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Calificaciones/getGrupos/'+carreraid;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionGrupos = "";
                optionGrupos += '<option value="0" selected>Seleccionar Grupo</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionGrupos += '<option value="'+objData.data[i].idgrupo+'">'+objData.data[i].grado+'-'+objData.data[i].grupo+'</option>';
                }
                $('#divGruposEditar').html("");
                $('#divMateriasEditar').html("");
                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divGruposEditar').append(
                    '<label>Grupo</label>'+
                    ' <select class="form-control selectpicker" data-live-search="true" id="listGrupos" name="listGrupos" required>'+
                        optionGrupos+
                    '</select>'
                );
                $("#listGrupos").selectpicker("render");
                swal("Grupos", objData.msg, "success");
            }else{
                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divGruposEditar').html("");
                $('#divMateriasEditar').html("");
                swal("Error", objData.msg , "error");
            }
        }
    }
})

$("#formBusqueda").on("change", "select#listGrupos", function(){
    let intCarrera = document.querySelector("#listCarreras").value;
    let intGrupo = $(this).val();

    if (intCarrera == "" || intCarrera == null || intGrupo == "" || intGrupo == 0) {
        swal("Atención", "Es necesario seleccionar carrera y grupo." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Calificaciones/getMaterias/';
    request.open("POST",ajaxUrl,true);
    let formData = new FormData();
    formData.append("carreraid", intCarrera);
    formData.append("grupoid", intGrupo);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionMaterias = "";
                optionMaterias += '<option value="0" selected>Seleccionar Materia</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionMaterias += '<option value="'+objData.data[i].idmateria+'">'+objData.data[i].materia+'</option>';
                }
                $('#divMateriasEditar').html("");
                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divMateriasEditar').append(
                    '<label>Materia</label>'+
                    '<select class="form-control selectpicker" data-live-search="true" id="listMaterias" name="listMaterias" required>'+
                        optionMaterias+
                    '</select>'
                );
                $('#listMaterias').selectpicker('render');
                swal("Materias", objData.msg, "success");
            }else{
                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divMateriasEditar').html("");
                swal("Error", objData.msg , "error");
            }
        }
    }
})

$("#formEditarCalificaciones").on("change", "input#cbSeleccion", function(){
    listarElementos();
    actualizarStatus();
})

$("#formEditarCalificaciones").on("change", "input#txtMatricula", function(){
    listarElementos(); 
})

$("#formEditarCalificaciones").on("change", "input#txtAlumno", function(){
    listarElementos(); 
})

$("#formEditarCalificaciones").on("change", "input#txtCalificacionA", function(){
    listarElementos(); 
})

$("#formEditarCalificaciones").on("change", "input#txtCalificacionB", function(){
    listarElementos(); 
})

$("#formEditarCalificaciones").on("change", "input#txtCalificacionC", function(){
    listarElementos(); 
})

$("#formEditarCalificaciones").on("change", "input#txtCalificacionD", function(){
    listarElementos(); 
})

$("#formEditarCalificaciones").on("change", "input#cbSeleccionarTodos", function(){
    let estado = this.checked;
    let cb = document.querySelectorAll("#cbSeleccion");
    if(estado == true)
    {
        for (var i = cb.length - 1; i >= 0; i--) {
            cb[i].checked = true;
        }
    }else{
        for (var i = cb.length - 1; i >= 0; i--) {
            cb[i].checked = false;
        }
    }
    listarElementos();
    actualizarStatus();
})

function listarElementos(){
    let listaElementosEditar = [];
    let matriculaEditar = document.querySelectorAll("#txtMatricula");
    let alumnoEditar = document.querySelectorAll("#txtAlumno");
    let calificacionEditarA = document.querySelectorAll("#txtCalificacionA");
    let calificacionEditarB = document.querySelectorAll("#txtCalificacionB");
    let calificacionEditarC = document.querySelectorAll("#txtCalificacionC");
    let calificacionEditarD = document.querySelectorAll("#txtCalificacionD");
    let cbEstadoEditar = document.querySelectorAll("#cbSeleccion");
    for(let i = 0; i < alumnoEditar.length; i++){
        if(cbEstadoEditar[i].checked == true)
        {
            listaElementosEditar.push({ "idalumno" : alumnoEditar[i].getAttribute("idAlumno"),
                        "nombre_alumno" : $(alumnoEditar[i]).val(),
                        "calificacionid" : calificacionEditarA[i].getAttribute("idAlumno"),
                        "calificacion_a" : ($(calificacionEditarA[i]).val()).toLocaleUpperCase(),
                        "calificacion_b" : ($(calificacionEditarB[i]).val()).toLocaleUpperCase(),
                        "calificacion_c" : ($(calificacionEditarC[i]).val()).toLocaleUpperCase(),
                        "calificacion_d" : ($(calificacionEditarD[i]).val()).toLocaleUpperCase(),
                        "checked" : true,
                        "matricula" : $(matriculaEditar[i]).val()})   
        }else{
            listaElementosEditar.push({ "idalumno" : alumnoEditar[i].getAttribute("idAlumno"),
                        "nombre_alumno" : $(alumnoEditar[i]).val(),
                        "calificacionid" : calificacionEditarA[i].getAttribute("idAlumno"),
                        "calificacion_a" : calificacionEditarA[i].getAttribute("calOriginalA").toLocaleUpperCase(),
                        "calificacion_b" : calificacionEditarB[i].getAttribute("calOriginalB").toLocaleUpperCase(),
                        "calificacion_c" : calificacionEditarC[i].getAttribute("calOriginalC").toLocaleUpperCase(),
                        "calificacion_d" : calificacionEditarD[i].getAttribute("calOriginalD").toLocaleUpperCase(),
                        "checked" : false,
                        "matricula" : $(matriculaEditar[i]).val()})
        }
    }
    $("#listaElementos").val(JSON.stringify(listaElementosEditar)); 
}

function actualizarStatus(){
    let cbEstado = document.querySelectorAll("#cbSeleccion");
    let condicion = 0;
    for(let i = 0; i < cbEstado.length; i++){
        if(cbEstado[i].checked == true)
        {
            condicion = 1;
        }
    }
    $("#txtSeleccion").val(condicion); 
}

function fntGrupal(){
    document.getElementById("busquedaGrupal").style.display = "flex";
    document.getElementById("busquedaIndividual").style.display = "none";
    if(document.querySelector("#divCarrerasEditar")){
        $("#divCarrerasEditar").html("");
    }
    if(document.querySelector("#divGruposEditar")){
        $("#divGruposEditar").html("");
    }
    if(document.querySelector("#divMateriasEditar")){
        $("#divMateriasEditar").html("");
    }
    if(document.querySelector("#divCarrerasIndividual")){
        $("#divCarrerasIndividual").html("");
    }
    if(document.querySelector("#divAlumnosIndividual")){
        $("#divAlumnosIndividual").html("");
    }
    if(document.querySelector("#divMateriasIndividual")){
        $("#divMateriasIndividual").html("");
    }
    if(document.querySelector("#listNivelesIndividual")){
        document.querySelector("#listNivelesIndividual").value = 0;
        $('#listNivelesIndividual').selectpicker('render');
    }
    if(document.querySelector("#listNiveles")){
        document.querySelector("#listNiveles").value = 0;
        $('#listNiveles').selectpicker('render');
    }
    document.getElementById("formularioCalificacionesIndividual").style.display = "none";
    document.getElementById("formularioCalificaciones").style.display = "none";
    return;
}

function fntIndividual(){
    document.getElementById("busquedaIndividual").style.display = "flex";
    document.getElementById("busquedaGrupal").style.display = "none";
    if(document.querySelector("#divCarrerasEditar")){
        $("#divCarrerasEditar").html("");
    }
    if(document.querySelector("#divGruposEditar")){
        $("#divGruposEditar").html("");
    }
    if(document.querySelector("#divMateriasEditar")){
        $("#divMateriasEditar").html("");
    }
    if(document.querySelector("#divCarrerasIndividual")){
        $("#divCarrerasIndividual").html("");
    }
    if(document.querySelector("#divAlumnosIndividual")){
        $("#divAlumnosIndividual").html("");
    }
    if(document.querySelector("#divMateriasIndividual")){
        $("#divMateriasIndividual").html("");
    }
    if(document.querySelector("#listNivelesIndividual")){
        document.querySelector("#listNivelesIndividual").value = 0;
        $('#listNivelesIndividual').selectpicker('render');
    }
    if(document.querySelector("#listNiveles")){
        document.querySelector("#listNiveles").value = 0;
        $('#listNiveles').selectpicker('render');
    }
    document.getElementById("formularioCalificacionesIndividual").style.display = "none";
    document.getElementById("formularioCalificaciones").style.display = "none";
    return;
}

$("#listNivelesIndividual").change(function(){
    let nivelid = $(this).val();
    if (nivelid == "") {
        swal("Atención", "Tiene que seleccionar un nivel." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Editar_calificaciones/getCarreras/'+nivelid;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionCarrerasIndividual = "";
                optionCarrerasIndividual += '<option value="0" selected>Seleccionar Carrera</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionCarrerasIndividual += '<option value="'+objData.data[i].idcarrera+'">'+objData.data[i].carrera+' / '+objData.data[i].reforma+'</option>';
                }
                $('#divCarrerasIndividual').html("");
                $('#divGruposIndividual').html("");
                $('#divMateriasIndividual').html("");
                document.getElementById("formularioCalificacionesIndividual").style.display = "none";
                $('#divCarrerasIndividual').append(
                    '<label for="listCarrerasIndividual">Carrera</label>'+
                    ' <select class="form-control selectpicker" data-live-search="true" id="listCarrerasIndividual" name="listCarrerasIndividual" required>'+
                        optionCarrerasIndividual+
                    '</select>'
                );
                $('#listCarrerasIndividual').selectpicker('render');
                swal("Carreras", objData.msg, "success");
            }else{
                $('#divCarrerasIndividual').html("");
                $('#divAlumnosIndividual').html("");
                $('#divMateriasIndividual').html("");
                document.getElementById("formularioCalificacionesIndividual").style.display = "none";
                swal("Error", objData.msg , "error");
            }
        }
    } 
})

$("#formBusquedaIndividual").on("change", "select#listCarrerasIndividual", function(){
    let carreraIdIndividual = $(this).val();
    if (carreraIdIndividual == "") {
        swal("Atención", "Tiene que seleccionar una carrera." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Editar_calificaciones/getAlumnosIndividual/'+carreraIdIndividual;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionAlumnos = "";
                optionAlumnos += '<option value="0" selected>Seleccionar Alumno</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionAlumnos += '<option value="'+objData.data[i].idalumno+'">'+objData.data[i].nombre_alumno+'</option>';
                }
                $('#divAlumnosIndividual').html("");
                $('#divMateriasIndividual').html("");
                document.getElementById("formularioCalificacionesIndividual").style.display = "none";
                $('#divAlumnosIndividual').append(
                    '<label for="listAlumnosIndividual">Alumno</label>'+
                    ' <select class="form-control selectpicker" data-live-search="true" id="listAlumnosIndividual" name="listAlumnosIndividual" required>'+
                        optionAlumnos+
                    '</select>'
                );
                $("#listAlumnosIndividual").selectpicker("render");
                swal("Alumnos", objData.msg, "success");
            }else{
                document.getElementById("formularioCalificacionesIndividual").style.display = "none";
                $('#divAlumnosIndividual').html("");
                $('#divMateriasIndividual').html("");
                swal("Error", objData.msg , "error");
            }
        }
    }
})

$("#formBusquedaIndividual").on("change", "select#listAlumnosIndividual", function(){
    let intCarreraIndividual = document.querySelector("#listCarrerasIndividual").value;
    let intAlumnoId = $(this).val();
    if (intCarreraIndividual == "" || intCarreraIndividual == null || intAlumnoId == "" || intAlumnoId == null) {
        swal("Atención", "Es necesario seleccionar carrera y alumno." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Editar_calificaciones/getMateriasIndividual/';
    request.open("POST",ajaxUrl,true);
    let formData = new FormData();
    formData.append("carreraid", intCarreraIndividual);
    formData.append("alumnoid", intAlumnoId);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionMaterias = "";
                optionMaterias += '<option value="0" selected>Seleccionar Materia</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionMaterias += '<option value="'+objData.data[i].idmateria+'">'+objData.data[i].materia+'</option>';
                }
                $('#divMateriasIndividual').html("");
                document.getElementById("formularioCalificacionesIndividual").style.display = "none";
                $('#divMateriasIndividual').append(
                    '<label for="listMateriasIndividual">Materia</label>'+
                    '<select class="form-control selectpicker" data-live-search="true" id="listMateriasIndividual" name="listMateriasIndividual" required>'+
                        optionMaterias+
                    '</select>'
                );
                $('#listMateriasIndividual').selectpicker('render');
                swal("Materias", objData.msg, "success");
            }else{
                document.getElementById("formularioCalificacionesIndividual").style.display = "none";
                $('#divMateriasIndividual').html("");
                swal("Error", objData.msg , "error");
            }
        }
    }
})

$("#formEditarCalificacionesIndividual").on("change", "input#txtCalificacionIndivA", function(){
    listarElementosIndividual(); 
})

$("#formEditarCalificacionesIndividual").on("change", "input#txtCalificacionIndivB", function(){
    listarElementosIndividual(); 
})

$("#formEditarCalificacionesIndividual").on("change", "input#txtCalificacionIndivC", function(){
    listarElementosIndividual(); 
})

$("#formEditarCalificacionesIndividual").on("change", "input#txtCalificacionIndivD", function(){
    listarElementosIndividual(); 
})

function listarElementosIndividual(){
    let listaElementosEditar = [];
    let matriculaEditar = document.querySelector("#txtMatriculaIndividual").value;
    let alumnoEditar = document.querySelector("#txtAlumnoIndividual").value;
    let txtCalificacion = document.querySelectorAll("#txtCalificacionIndivA");
    let idAlumnoEditar = document.querySelector("#txtCalificacionIndivA").getAttribute("idAlumno");
    let calificacionEditarA = document.querySelector("#txtCalificacionIndivA").value;
    let calificacionEditarB = document.querySelector("#txtCalificacionIndivB").value;
    let calificacionEditarC = document.querySelector("#txtCalificacionIndivC").value;
    let calificacionEditarD = document.querySelector("#txtCalificacionIndivD").value;
    let objJson = JSON.parse(document.querySelector('#listaElementosIndividual').value);

    for (var i = objJson.length - 1; i >= 0; i--) {
        if(idAlumnoEditar == objJson[i].idalumno)
        {
            objJson[i] = {"idalumno" : idAlumnoEditar,
                        "nombre_alumno" : objJson[i].nombre_alumno,
                        "calificacionid" : idAlumnoEditar,
                        "calificacion_a" : calificacionEditarA,
                        "calificacion_b" : calificacionEditarB,
                        "calificacion_c" : calificacionEditarC,
                        "calificacion_d" : calificacionEditarD,
                        "checked" : true,
                        "matricula" : matriculaEditar}
        }
    }
    $("#listaElementosIndividual").val(JSON.stringify(objJson)); 
}