let tableEquipos;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

    tableEquipos = $('#tableEquipos').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Equipos/getEquipos",
            "dataSrc":""
        },
        "columns":[
            {"data":"idequipo", visible:false},
            {"data":"extension"},
            {"data":"usuario"},
            {"data":"ip"},
            {"data":"btnTipoIp"},
            /*{"data":"mac"},*/
            {"data":"anydesk"},
            /*{"data":"departamento"},*/
            {"data":"btnSynology"},
            {"data":"ip_telefono"},
            {"data":"btnTipoIpTelefono"},
            /*{"data":"tipo_dns"},*/
            /*{"data":"nombre_persona"},*/
            {"data":"ultima_modificacion_format"},
            /*{"data":"status"},*/
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[1,"asc"]]  
    });

    if(document.querySelector("#formEquipos")){
        let formEquipos = document.querySelector("#formEquipos");
        formEquipos.onsubmit = function(e) {
            e.preventDefault();
            let strUsuario= document.querySelector('#txtUsuario').value;
            let strUsuarioFormat = strUsuario.toUpperCase();
            let strIp= document.querySelector('#txtIp').value;
            let strTipoIp= document.querySelector('#listTipoIp').value;
            let strMac= document.querySelector('#txtMac').value;
            let strAnyDesk= document.querySelector('#txtAnyDesk').value;
            let strDepartamento= document.querySelector('#txtDepartamento').value;
            let strSynology= document.querySelector('#listSynology').value;
            //let strExtension = document.querySelector("txtExtension").value;
            let strIpTelefono= document.querySelector('#txtIpTelefono').value;
            let strTipoIpTelefono= document.querySelector('#listTipoIpTelefono').value;
            let strDns= document.querySelector('#txtDns').value;
            let intStatus= document.querySelector('#listStatus').value;


            if(strUsuario == '' || intStatus == '')
            {
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            //tinyMCE.triggerSave();
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Equipos/setEquipo'; 
            let formData = new FormData(formEquipos);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        if(rowTable == ""){
                            tableEquipos.api().ajax.reload();
                        }else{
                            /*htmlStatus = intStatus == 1 ? 
                            '<span class="badge badge-success">Activo</span>' : 
                            '<span class="badge badge-danger">Inactivo</span>';
                            rowTable.cells[1].textContent = strNivelFormat;
                            rowTable.cells[2].textContent = document.querySelector("#listCoordinador").selectedOptions[0].text;
                            rowTable.cells[4].innerHTML = htmlStatus;
                            rowTable = ""; */
                            tableEquipos.api().ajax.reload();
                            rowTable = "";
                        }
                        $('#modalFormEquipos').modal("hide");
                        formEquipos.reset();
                        swal("Equipos", objData.msg ,"success");
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }
})

function formatearPalabra(val) {
  return val.toLowerCase()
            .trim()
            .split(' ')
            .map( v => v[0].toUpperCase() + v.substr(1) )
            .join(' ');  
}

function fntViewEquipo(idequipo){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Equipos/getEquipo/'+idequipo;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            if(objData.status)
            {
               let estado = objData.data.status == 1 ? 
                '<span class="badge badge-success">Activo</span>' : 
                '<span class="badge badge-danger">Inactivo</span>';
                document.querySelector("#celUsuario").innerHTML = objData.data.usuario;
                document.querySelector("#celIp").innerHTML = objData.data.ip;
                document.querySelector("#celTipoIp").innerHTML = objData.data.tipo_ip;
                document.querySelector("#celMac").innerHTML = objData.data.mac;
                document.querySelector("#celAnyDesk").innerHTML = objData.data.anydesk;
                document.querySelector("#celDepartamento").innerHTML = objData.data.departamento;
                document.querySelector("#celSynology").innerHTML = objData.data.synology;
                document.querySelector("#celExtension").innerHTML = objData.data.extension;
                document.querySelector("#celIpTelefono").innerHTML = objData.data.ip_telefono;
                document.querySelector("#celTipoIpTelefono").innerHTML = objData.data.tipo_ip_telefono;
                document.querySelector("#celDns").innerHTML = objData.data.tipo_dns;
                document.querySelector("#celPersona").innerHTML = objData.data.nombre_persona;
                document.querySelector("#celUltimaModificacion").innerHTML = objData.data.ultima_modificacion_format;
                document.querySelector("#celTipoMovimiento").innerHTML = objData.data.tipo_movimiento;
                document.querySelector("#celComentarios").innerHTML = objData.data.comentarios;
                document.querySelector("#celEstatus").innerHTML = estado;
                $('#modalViewEquipo').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditEquipo(element,idequipo){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Información";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Equipos/getEquipo/'+idequipo;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idEquipo").value = objData.data.idequipo;
                document.querySelector("#txtUsuario").value = objData.data.usuario;
                document.querySelector("#txtIp").value = objData.data.ip;
                document.querySelector("#txtMac").value = objData.data.mac;
                document.querySelector("#txtAnyDesk").value = objData.data.anydesk;
                document.querySelector("#txtDepartamento").value = objData.data.departamento;
                document.querySelector("#txtExtension").value = objData.data.extension;
                document.querySelector("#txtIpTelefono").value = objData.data.ip_telefono;
                document.querySelector("#txtDns").value = objData.data.tipo_dns;
                document.querySelector("#txtComentarios").value = objData.data.comentarios;
                if(document.querySelector("#listTipoIp"))
                {
                    document.querySelector("#listTipoIp").value = objData.data.tipo_ip;
                    $('#listTipoIp').selectpicker('render');
                }
                if(document.querySelector("#listSynology"))
                {
                    document.querySelector("#listSynology").value = objData.data.synology;
                    $('#listSynology').selectpicker('render');
                }
                if(document.querySelector("#listTipoIpTelefono"))
                {
                    document.querySelector("#listTipoIpTelefono").value = objData.data.tipo_ip_telefono;
                    $('#listTipoIpTelefono').selectpicker('render');
                }
                if(document.querySelector("#listStatus"))
                {
                    document.querySelector("#listStatus").value = objData.data.status;
                    $('#listStatus').selectpicker('render');
                }
               
            }
        }
    
        $('#modalFormEquipos').modal('show');
    }
}

function fntDelEquipo(idequipo){
    swal({
        title: "Eliminar Equipo",
        text: "¿Realmente quiere eliminar el registro del equipo?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Equipos/delEquipo';
            let strData = "idequipo="+idequipo;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableEquipos.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idEquipo').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nuevo Equipo";
    document.querySelector("#formEquipos").reset();
    if(document.querySelector("#listTipoIp"))
    {
        document.querySelector("#listTipoIp").value = 'No verificado';
        $('#listTipoIp').selectpicker('render');
    }
    if(document.querySelector("#listSynology"))
    {
        document.querySelector("#listSynology").value = 'No verificado';
        $('#listSynology').selectpicker('render');
    }
    if(document.querySelector("#listTipoIpTelefono"))
    {
        document.querySelector("#listTipoIpTelefono").value = 'No verificado';
        $('#listTipoIpTelefono').selectpicker('render');
    }
    if(document.querySelector("#listStatus"))
    {
        document.querySelector("#listStatus").value = 1;
        $('#listStatus').selectpicker('render');
    }
    $('#modalFormEquipos').modal('show');
}

function fntEditSynology(element, idequipo){
    rowTable = element.parentNode.parentNode;
    let estado = element.getAttribute("estado");
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Equipos/actualizarSynology/';
    request.open("POST",ajaxUrl,true);
    let formData = new FormData();
    formData.append("idequipo",idequipo);
    formData.append("estado",estado);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {    
                rowTable.cells[5].innerHTML = objData.btnSynology;
                rowTable.cells[8].innerHTML = objData.fecha;
                rowTable = ""; 
                swal("Equipos", objData.msg ,"success");
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditTipoIp(element, idequipo){
    rowTable = element.parentNode.parentNode;
    let estado = element.getAttribute("estado");
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Equipos/actualizarTipoIp/';
    request.open("POST",ajaxUrl,true);
    let formData = new FormData();
    formData.append("idequipo",idequipo);
    formData.append("estado",estado);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {    
                rowTable.cells[3].innerHTML = objData.btnTipoIp;
                rowTable.cells[8].innerHTML = objData.fecha;
                rowTable = ""; 
                swal("Equipos", objData.msg ,"success");
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditTipoIpTelefono(element, idequipo){
    rowTable = element.parentNode.parentNode;
    let estado = element.getAttribute("estado");
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Equipos/actualizarTipoIpTelefono/';
    request.open("POST",ajaxUrl,true);
    let formData = new FormData();
    formData.append("idequipo",idequipo);
    formData.append("estado",estado);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {    
                rowTable.cells[7].innerHTML = objData.btnTipoIpTelefono;
                rowTable.cells[8].innerHTML = objData.fecha;
                rowTable = ""; 
                swal("Equipos", objData.msg ,"success");
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}