let tableEscuelas;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

    tableEscuelas = $('#tableEscuelas').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Escuelas/getEscuelas",
            "dataSrc":""
        },
        "columns":[
            {"data":"idescuela", visible:false},
            {"data":"nombre"},
            {"data":"localidad"},
            {"data":"ultima_modificacion_format"},
            {"data":"status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[1,"asc"]]  
    });

    if(document.querySelector("#formEscuelas")){
        let formEscuelas = document.querySelector("#formEscuelas");
        formEscuelas.onsubmit = function(e) {
            e.preventDefault();
            let strNombre= document.querySelector('#txtNombre').value;
            let strLocalidad= document.querySelector('#txtLocalidad').value;
            let intStatus= document.querySelector('#listStatus').value;
            let strNombreFormat = strNombre.toLocaleUpperCase();
            let strLocalidadFormat = strLocalidad.toLocaleUpperCase();

            if(strNombre == ''){
                swal("Atención", "El nombre de la escuela es obligatorio." , "error");
                return false;
            }
            if(strLocalidad == ''){
                swal("Atención", "La localidad de la escuela es obligatorio." , "error");
                return false;
            }
            if(intStatus == '' || intStatus == 0){
                swal("Atención", "El estatus es obligatorio." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            //tinyMCE.triggerSave();
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Escuelas/setEscuela'; 
            let formData = new FormData(formEscuelas);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        if(rowTable == ""){
                            tableEscuelas.api().ajax.reload();
                        }else{
                            htmlStatus = intStatus == 1 ? 
                            '<span class="badge badge-success">Activo</span>' : 
                            '<span class="badge badge-danger">Inactivo</span>';
                            rowTable.cells[0].textContent = strNombreFormat;
                            rowTable.cells[1].textContent = strLocalidadFormat;
                            rowTable.cells[2].textContent = objData.fecha;
                            rowTable.cells[3].innerHTML = htmlStatus;
                            rowTable = ""; 
                        }
                        $('#modalFormEscuelas').modal("hide");
                        formEscuelas.reset();
                        swal("Escuelas", objData.msg ,"success");
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }
})

function formatearPalabra(val) {
  return val.toLowerCase()
            .trim()
            .split(' ')
            .map( v => v[0].toUpperCase() + v.substr(1) )
            .join(' ');  
}

function fntViewEscuela(idescuela){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Escuelas/getEscuela/'+idescuela;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            if(objData.status)
            {
               let estado = objData.data.status == 1 ? 
                '<span class="badge badge-success">Activo</span>' : 
                '<span class="badge badge-danger">Inactivo</span>';
                document.querySelector("#celNombre").innerHTML = objData.data.nombre;
                document.querySelector("#celLocalidad").innerHTML = objData.data.localidad;
                document.querySelector("#celModificador").innerHTML = objData.data.modificador;
                document.querySelector("#celUltimaModificacion").innerHTML = objData.data.ultima_modificacion_format;
                document.querySelector("#celStatus").innerHTML = estado;
                $('#modalViewEscuela').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditEscuela(element,idescuela){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Escuela";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Escuelas/getEscuela/'+idescuela;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idEscuela").value = objData.data.idescuela;
                document.querySelector("#txtNombre").value = objData.data.nombre;
                document.querySelector("#txtLocalidad").value = objData.data.localidad;
                if(document.querySelector("#listStatus")){
                    document.querySelector("#listStatus").value = objData.data.status;
                    $('#listStatus').selectpicker('render');
                }
               
            }
        }
    
        $('#modalFormEscuelas').modal('show');
    }
}

function fntDelEscuela(idnivel){
    swal({
        title: "Eliminar Escuela",
        text: "¿Realmente quiere eliminar el registro de la escuela?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Escuelas/delEscuela';
            let strData = "idnivel="+idnivel;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableEscuelas.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idEscuela').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nueva Escuela";
    document.querySelector("#formEscuelas").reset();
    if(document.querySelector("#listStatus"))
    {
        document.querySelector("#listStatus").value = 1;
        $('#listStatus').selectpicker('render');
    }
    $('#modalFormEscuelas').modal('show');
}
