let tableMaterias;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

    if(document.querySelector("#formBusqueda")){
        let formBusqueda = document.querySelector("#formBusqueda");
        formBusqueda.onsubmit = function(e) {
            e.preventDefault();
            let intIdAlumnos= document.querySelector('#listAlumnos').value;

            if(intIdAlumnos == '' || intIdAlumnos == 0)
            {
                swal("Atención", "Debe seleccionar un alumno." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            //tinyMCE.triggerSave();

            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url + '/Estadisticas/getAlumno';
            let formData = new FormData(formBusqueda);

            request.open("POST", ajaxUrl, true);
            request.send(formData);

            request.onreadystatechange = function () {
                if (request.readyState == 4 && request.status == 200) {
                    let objData = JSON.parse(request.responseText);
                    if (objData.status) {

                        console.log(objData);

                        let calificaciones = objData.calificaciones || [];
                        let asistencias = objData.asistencias || [];
                        let incidencias = objData.incidencias || [];

                        console.log(calificaciones);
                        console.log(asistencias);
                        console.log(incidencias);

                        let divWidguets = $(".divWidgets");
                        let divCalificaciones = $(".divCalificaciones");
                        let divIncidencias = $(".divIncidencias");
                        let divScore = $(".divScore");

                        $('#modalFormMaterias').modal("hide");
                        formBusqueda.reset();
                        swal("Estadística", objData.msg, "success");

                        // ============= WIDGET DE ASISTENCIAS 3D ===============
                        (function renderAsistenciasWidget(asistencias, $container) {
                            if (!$container || $container.length === 0) return;
                            const container = $container[0];
                            const total = Array.isArray(asistencias) ? asistencias.length : 0;
                            const isPresent = (valor) => valor && String(valor).toLowerCase().includes('asist');
                            let presentes = asistencias.filter(a => isPresent(a.asistencia)).length;
                            const porcentaje = total === 0 ? 0 : (presentes / total) * 100;
                            const porcentajeRound = Math.round(porcentaje * 10) / 10;

                            const widgetId = 'hc-asistencias-widget';
                            container.innerHTML = "";
                            const wrapper = document.createElement('div');
                            wrapper.id = widgetId;
                            wrapper.style.cssText = `
                                width:100%;max-width:450px;margin:12px auto;background:#fff;
                                border-radius:12px;box-shadow:0 4px 10px rgba(0,0,0,0.12);
                                padding:16px;text-align:center;
                            `;
                            wrapper.innerHTML = `
                                <div id="${widgetId}-chart" style="width:100%; height:220px;"></div>
                                <div style="margin-top:10px;">
                                    <div style="font-size:16px; font-weight:600; color:#333;">Cumplimiento de asistencias</div>
                                    <div style="font-size:28px; font-weight:700; margin:5px 0;">${porcentajeRound}%</div>
                                    <div style="font-size:13px; color:#666;">Asistencias: ${presentes} / ${total}</div>
                                    <div style="margin-top:5px; font-size:12px; color:#888;">Última actualización: ${new Date().toLocaleString()}</div>
                                </div>
                            `;
                            container.appendChild(wrapper);

                            Highcharts.chart(`${widgetId}-chart`, {
                                chart: {
                                    type: 'pie',
                                    backgroundColor: null,
                                    options3d: { enabled: true, alpha: 55, beta: 0, depth: 50, viewDistance: 30 }
                                },
                                title: null,
                                credits: { enabled: false },
                                tooltip: { pointFormat: '<b>{point.y}</b> ({point.percentage:.1f}%)' },
                                plotOptions: {
                                    pie: {
                                        innerSize: '55%',
                                        depth: 45,
                                        dataLabels: {
                                            enabled: true,
                                            distance: -30,
                                            style: { fontWeight: 'bold', color: '#fff', textOutline: 'none' },
                                            format: '{point.percentage:.1f}%'
                                        },
                                        showInLegend: true
                                    }
                                },
                                legend: {
                                    align: 'center',
                                    verticalAlign: 'bottom',
                                    layout: 'horizontal',
                                    itemStyle: { fontSize: '12px', color: '#333' }
                                },
                                series: [{
                                    name: 'Asistencias',
                                    data: [
                                        { name: 'Asiste', y: presentes },
                                        { name: 'No asiste', y: Math.max(0, total - presentes) }
                                    ],
                                    colors: ['#28a745', '#dc3545']
                                }]
                            });

                            // Guardamos el porcentaje para usarlo en el Score
                            wrapper.dataset.porcentajeAsistencia = porcentajeRound;
                        })(asistencias, divWidguets);

                        // === SECCIÓN DE INCIDENCIAS (TABLA) ===============
                        (function renderIncidencias(incidencias, $container) {
                            if (!$container || $container.length === 0) return;
                            const container = $container[0];
                            container.innerHTML = "";

                            const box = document.createElement('div');
                            box.style.cssText = `
                                background:#fff;padding:16px;border-radius:12px;
                                box-shadow:0 3px 8px rgba(0,0,0,0.1);max-width:450px;margin:auto;
                            `;

                            if (incidencias.length === 0) {
                                box.innerHTML = `<div style="text-align:center;color:#28a745;font-weight:600;">Sin incidencias registradas 🎉</div>`;
                            } else {
                                let tabla = `
                                    <h5 style="margin-bottom:10px;color:#c00;">Incidencias registradas</h5>
                                    <table style="width:100%;border-collapse:collapse;font-size:13px;">
                                        <thead>
                                            <tr style="background:#007bff;color:#fff;text-align:left;">
                                                <th style="padding:8px;">Fecha</th>
                                                <th style="padding:8px;">Incidencia</th>
                                                <th style="padding:8px;">Estatus</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                `;
                                incidencias.forEach((i) => {
                                    tabla += `
                                        <tr style="border-bottom:1px solid #eee;">
                                            <td style="padding:8px;">${i.fecha_incidencia_format || i.fecha_incidencia}</td>
                                            <td style="padding:8px;">${i.incidencia}</td>
                                            <td style="padding:8px;">${i.estado}</td>
                                        </tr>
                                    `;
                                });
                                tabla += `</tbody></table>`;
                                box.innerHTML = tabla;
                            }

                            container.appendChild(box);
                        })(incidencias, divIncidencias);

                        // === PROMEDIO DE CALIFICACIONES ===================
                        (function renderCalificaciones(calificaciones, $container) {
                            if (!$container || $container.length === 0) return;
                            const container = $container[0];
                            container.innerHTML = "";

                            let valores = [];

                            console.log(calificaciones);

                            calificaciones.forEach(c => {
                                let ultima = null;
                                if (c.recursamiento_calificacion) ultima = c.recursamiento_calificacion;
                                else if (c.tercero_calificacion) ultima = c.tercero_calificacion;
                                else if (c.segundo_calificacion) ultima = c.segundo_calificacion;
                                else if (c.primero_calificacion) ultima = c.primero_calificacion;

                                if (ultima) {
                                    // Conversión AC/NA
                                    if (String(ultima).toUpperCase() === 'AC') ultima = 100;
                                    else if (String(ultima).toUpperCase() === 'NA') ultima = 0;
                                    else ultima = parseFloat(ultima);
                                    valores.push(ultima);
                                }
                            });

                            const promedio = valores.length === 0 ? 0 :
                                valores.reduce((a, b) => a + b, 0) / valores.length;
                            const promedioRound = Math.round(promedio * 10) / 10;

                            const widgetId = 'hc-calificaciones-widget';
                            const wrapper = document.createElement('div');
                            wrapper.id = widgetId;
                            wrapper.style.cssText = `
                                background:#fff;padding:16px;border-radius:12px;
                                box-shadow:0 3px 8px rgba(0,0,0,0.1);max-width:450px;margin:12px auto;
                            `;
                            wrapper.innerHTML = `
                                <div id="${widgetId}-chart" style="width:100%; height:325px;"></div>
                                <div style="text-align:center;font-size:16px;font-weight:600;">Promedio General: ${promedioRound}</div>
                            `;
                            container.appendChild(wrapper);

                            Highcharts.chart(`${widgetId}-chart`, {
                                chart: { type: 'column', backgroundColor: null },
                                title: { text: 'Promedio de Calificaciones', align: 'center' },
                                xAxis: { categories: ['Promedio'], lineWidth: 0, labels: { enabled: false } },
                                yAxis: { min: 0, max: 100, title: { text: 'Calificación' } },
                                credits: { enabled: false },
                                series: [{
                                    name: 'Promedio',
                                    data: [promedioRound],
                                    color: promedioRound >= 75 ? '#28a745' : (promedioRound >= 50 ? '#ffc107' : '#dc3545')
                                }]
                            });

                            wrapper.dataset.promedio = promedioRound;
                        })(calificaciones, divCalificaciones);

                        // =====================================================
                        // === 4️⃣ SCORE GLOBAL (TACÓMETRO) =====================
                        // =====================================================
                        (function renderScore(divWidguets, divCalificaciones, incidencias, $container) {
                            if (!$container || $container.length === 0) return;
                            const container = $container[0];
                            container.innerHTML = "";

                            // Obtener datos previos (con manejo de vacíos)
                            const asistenciaWidget = divWidguets.find('#hc-asistencias-widget')[0];
                            const asistenciaPct = asistenciaWidget ? parseFloat(asistenciaWidget.dataset.porcentajeAsistencia) || 0 : 0;

                            const califWidget = divCalificaciones.find('#hc-calificaciones-widget')[0];
                            const promedio = califWidget ? parseFloat(califWidget.dataset.promedio) || 0 : 0;

                            // Si los arreglos vienen vacíos, se asigna automáticamente el 33.3% correspondiente
                            const asistenciaScore = asistencias.length === 0 ? 40 : (asistenciaPct * 0.40);
                            const califScore = calificaciones.length === 0 ? 40 : (promedio * 0.40);
                            const incidenciaScore = incidencias.length === 0 ? 20 : 0;

                            const scoreFinal = Math.round((asistenciaScore + califScore + incidenciaScore) * 100) / 100;

                            let color = '#28a745';
                            let mensaje = 'Alumno regular, sin indicios de deserción.';

                            if (scoreFinal < 50) {
                                color = '#dc3545';
                                mensaje = '⚠️ Riesgo alto de deserción. Atención inmediata.';
                            } else if (scoreFinal >= 50 && scoreFinal < 75) {
                                color = '#ffc107';
                                mensaje = '🟡 Atención recomendada, tendencia inestable.';
                            }

                            const widgetId = 'hc-score-widget';
                            const wrapper = document.createElement('div');
                            wrapper.id = widgetId;
                            wrapper.style.cssText = `
                                background:#fff;padding:16px;border-radius:12px;
                                box-shadow:0 3px 8px rgba(0,0,0,0.1);max-width:600px;margin:12px auto;text-align:center;
                            `;
                            wrapper.innerHTML = `
                                <div id="${widgetId}-chart" style="width:100%; height:300px;"></div>
                                <div style="margin-top:10px;font-weight:600;font-size:16px;">${mensaje}</div>
                            `;
                            container.appendChild(wrapper);

                            Highcharts.chart(`${widgetId}-chart`, {
                                chart: {
                                    type: 'gauge',
                                    backgroundColor: null,
                                    plotBackgroundColor: null,
                                    plotBorderWidth: 0,
                                    plotShadow: false
                                },
                                title: { text: 'Score Global del Alumno' },
                                credits: { enabled: false },
                                pane: {
                                    startAngle: -150,
                                    endAngle: 150,
                                    background: [{
                                        backgroundColor: {
                                            linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                                            stops: [[0, '#FFF'], [1, '#333']]
                                        },
                                        borderWidth: 0,
                                        outerRadius: '100%'
                                    }]
                                },
                                yAxis: {
                                    min: 0,
                                    max: 100,
                                    tickInterval: 10,
                                    labels: { step: 2 },
                                    title: { text: 'Porcentaje' },
                                    plotBands: [
                                        { from: 0, to: 50, color: '#dc3545' },
                                        { from: 50, to: 75, color: '#ffc107' },
                                        { from: 75, to: 100, color: '#28a745' }
                                    ]
                                },
                                series: [{
                                    name: 'Score',
                                    data: [scoreFinal],
                                    tooltip: { valueSuffix: ' %' },
                                    dial: { backgroundColor: color },
                                    pivot: { backgroundColor: color }
                                }]
                            });

                        })(divWidguets, divCalificaciones, incidencias, divScore);

                    } else {
                        swal("Error", objData.msg, "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            };

        }
    }
})

function formatearPalabra(val) {
  return val.toLowerCase()
            .trim()
            .split(' ')
            .map( v => v[0].toUpperCase() + v.substr(1) )
            .join(' ');  
}

function fntViewMateria(idmateria){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Materias/getMateria/'+idmateria;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            if(objData.status)
            {
               let estado = objData.data.status == 1 ? 
                '<span class="badge badge-success">Activo</span>' : 
                '<span class="badge badge-danger">Inactivo</span>';
                let campoFormativo = objData.data.campo != '' && objData.data.campo != null ?
                '<span class="badge badge-success">'+objData.data.campo+'</span>' :
                '';
                document.querySelector("#celClave").innerHTML = objData.data.clave;
                document.querySelector("#celMateria").innerHTML = objData.data.materia;
                document.querySelector("#celNivel").innerHTML = objData.data.nivel;
                document.querySelector("#celCampoFormativo").innerHTML = campoFormativo;
                document.querySelector("#celComentarios").innerHTML = objData.data.comentarios;
                document.querySelector("#celModificador").innerHTML = objData.data.modificador;
                document.querySelector("#celUltimaModificacion").innerHTML = objData.data.ultima_modificacion_format;
                document.querySelector("#celTipoMovimiento").innerHTML = objData.data.tipo_movimiento;
                document.querySelector("#celStatus").innerHTML = estado;
                $('#modalViewMateria').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditMateria(element,idmateria){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Materia";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Materias/getMateria/'+idmateria;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idMateria").value = objData.data.idmateria;
                document.querySelector("#txtClave").value = objData.data.clave;
                document.querySelector("#txtMateria").value = objData.data.materia;
                document.querySelector("#txtComentarios").value = objData.data.comentarios;
                if(document.querySelector("#listNivel"))
                {
                    document.querySelector("#listNivel").value = objData.data.nivelid;
                    $('#listNivel').selectpicker('render');
                }
                if(document.querySelector("#listStatus"))
                {
                    document.querySelector("#listStatus").value = objData.data.status;
                    $('#listStatus').selectpicker('render');
                }
               
            }
        }
    
        $('#modalFormMaterias').modal('show');
    }
}

function fntDelMateria(idmateria){
    swal({
        title: "Eliminar materia",
        text: "¿Realmente quiere eliminar el registro de la materia?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Materias/delMateria';
            let strData = "idmateria="+idmateria;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableMaterias.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idMateria').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nueva Materia";
    document.querySelector("#formMaterias").reset();
    if(document.querySelector("#listNivel"))
    {
        document.querySelector("#listNivel").value = 0;
        $('#listNivel').selectpicker('render');
    }
    if(document.querySelector("#listStatus"))
    {
        document.querySelector("#listStatus").value = 1;
        $('#listStatus').selectpicker('render');
    }
    $('#modalFormMaterias').modal('show');
}