var fecha = new Date();
var anio = fecha.getFullYear();
var _dia = fecha.getDate();
var _mes = fecha.getMonth(); //viene con valores de 0 al 11
_mes = _mes + 1; //ahora lo tienes de 1 al 12
if (_mes < 10) //ahora le agregas un 0 para el formato date
{
  var mes = "0" + _mes;
} else {
  var mes = _mes;
}
if (_dia < 10) //ahora le agregas un 0 para el formato date
{
  var dia = "0" + _dia;
} else {
  var dia = _dia;
}

let fecha_actual = anio + '-' + mes + '-' + dia;
//console.log(fecha_actual);

document.addEventListener('DOMContentLoaded', function() {




    let request_calendar = base_url+'/Eventos/getEventosCalendar/'; 
    //console.log(request_calendar);
    

    var calendarEl = document.getElementById('calendar');
    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',

        events:function(info, successCallback, failureCallback){
            fetch(request_calendar)
                .then(function(response){
                    return response.json()
                })
                .then(function(data){
                    let events = data.events.map(function(event){
                        return {
                            title: event.evento,
                            subtitle: event.nivel,
                            start: event.fecha_inicial,
                            end: new Date(event.fecha_final),
                            location: event.ubicacion,
                            timeStart: event.hora_inicial,
                            timeEnd: event.hora_final,
                            //color: '#7b2424',

                        }
                    })
                    successCallback(events)
                })
                .catch(function(error){
                    failureCallback(error)
                })
        },

        eventContent: function(info){
            return {

                html: `
                <div style="overflow: hidden; font-size: 12px; positon: relative;  cursor: pointer; font-family: 'Inter', sans-serif;">
                    <div><strong>${info.event.title}</strong></div>
                    <div>Nivel: ${info.event.extendedProps.subtitle}</div>
                    <div>Fecha: ${info.event.start.toLocaleDateString(
                        "es-MX",
                        {
                            month: "long",
                            day: "numeric",
                            year: "numeric",
                        }
                    )}</div>
                        <div>Ubicación: ${info.event.extendedProps.location}</div>
                    <div>Hora: ${info.event.extendedProps.timeStart} - ${info.event.extendedProps.timeEnd}</div>
                </div>
                `
            }
        },

        eventMouseEnter: function(mouseEnterInfo){
            let el = mouseEnterInfo.el
            el.classList.add("relative")

            let newEl = document.createElement("div")
            let newElTitulo = mouseEnterInfo.event.title
            let newElNivel = mouseEnterInfo.event.extendedProps.subtitle
            let newElUbicacion = mouseEnterInfo.event.extendedProps.location
            newEl.innerHTML = `
                <div
                    class="fc-hoverable-event"
                    style="position: absolute; bottom: 100%; left: 0; width: auto; height: auto; background-color: white; z-index: 50; border: 1px solid #e2e8f0; border-radius: 0.375rem; padding: 0.75rem; font-size: 13px; font-family: 'Inter', sans-serif; cursor: pointer;"
                >
                    <strong>${newElTitulo}</strong>
                    <div><strong>Nivel: </strong>${newElNivel}</div>
                    <div><strong>Ubicación: </strong>${newElUbicacion}</div>

                </div>
            `
            el.after(newEl)
        },

        eventMouseLeave: function(){
            document.querySelector(".fc-hoverable-event").remove()
        }
    });
    calendar.render();




  
  let intIdPersona = document.querySelector('#idpersona').value;
  let totalEventos = [];  
   
   tableEventos = $('#tableEventos').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/1.10.20/i18n/Spanish.json"
        },
         "ajax":{
            "url": " "+base_url+"/Eventos/getEventos",
            "dataSrc":""
        },
        
       
        "columns":[
            {"data": "idevento", visible:false},
            {"data": "evento"},
            {"data": "nivel"},
            {"data": "fecha_inicial", visible:false},
            {"data": "format_fecha_inicial"},
            {"data": "format_fecha_final"},
            {"data": "format_horario"},
            {"data": "descripcion"},
            {"data": "nombre_persona", visible:false},
            {"data": "status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 25,
        "order":[[3,"desc"]]  
    }); 


    
  

  /*let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
  let ajaxUrl = base_url+'/Eventos/getEventos/'; 
  let formData = new FormData(formEventos);
  request.open("POST",ajaxUrl,true);
  request.send(formData);
  request.onreadystatechange = function(){
    if(request.readyState == 4 && request.status == 200){
      let objData = JSON.parse(request.responseText);
      if(objData)
      {
        for(var i = 0; i < objData.length; i++){
            if(objData[i]["activo"] == true)
            {
                totalEventos.push(
                {
                    "start": objData[i]["fecha"],
                    "end": objData[i]["fecha"],
                    "title": objData[i]["evento"]+'-'+objData[i]["nivel"]+'-'+objData[i]["descripcion"],
                    "eventLabelFontSize": '120px',
                    "rendering": 'background',
                    "height": '180px',
                    "editable": true,
                    "color": '#009688'
                })
            }else{
                totalEventos.push(
                {
                    "start": objData[i]["fecha"],
                    "end": objData[i]["fecha"],
                    "title": objData[i]["evento"]+'-'+objData[i]["nivel"],
                    "eventLabelFontSize": '180px',
                    "rendering": 'background',
                    "editable": true,
                    "placeholder": objData[i]["descripcion"],
                    "color": '#fc0335'
                })

            }

        }
        var calendarEl = document.getElementById('calendar');
        var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                eventLabelFontSize: '200px',
                selectable: true,
                placeholder: true,
                editable: true,
                overflow: true,
                //contentHeight: 600,
                events:totalEventos,

                Click: function(info) {
                    alert('Clicked on: ' + info.dateStr);
                    alert('Coordinates: ' + info.jsEvent.pageX + ',' + info.jsEvent.pageY);
                    alert('Current view: ' + info.view.type);
                    // change the day's background color just for fun
                    info.dayEl.style.backgroundColor = 'red';
  }
        });
        calendar.render();
      }
    }
  }*/

  if(document.querySelector("#formEventos")){
    let formEventos = document.querySelector("#formEventos");
    formEventos.onsubmit = function(e) {
        e.preventDefault();
        let totalEventos = [];
        let strEvento = document.querySelector('#txtEvento').value;
        let strUbicacion = document.querySelector('#txtUbicacion').value;
        let strHoraInicial = document.querySelector('#txtHoraInicial').value;
        let strHoraFinal = document.querySelector('#txtHoraFinal').value;
        let strFechaInicial = document.querySelector('#txtFechaInicial').value;
        let strFechaFinal = document.querySelector('#txtFechaFinal').value;
        let strDescripcion = document.querySelector('#txtDescripcion').value;
        let intPersonaId = document.querySelector('#idpersona').value;
        let strNivel = document.querySelector('#listNivel').value;
        let intStatus = document.querySelector('#listStatus').value;
        if(strEvento == '' || strUbicacion == '' || strHoraInicial == '' || strHoraInicial == '' || 
            strFechaInicial == '' || strFechaFinal == '' || strDescripcion == '' || strNivel == '' ||
            intStatus == '')
        {
            swal("Atención", "Todos los campos son obligatorios" , "error");
            return false;
        }
        
        /*if(strFecha < fecha_actual)
        {
            swal("Atención", "La fecha de la actividad no puede ser menor a la fecha actual" , "error");
            return false;
        }*/
        
        let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
        let ajaxUrl = base_url+'/Eventos/setEvento'; 
        let formData = new FormData(formEventos);
        request.open("POST",ajaxUrl,true);
        request.send(formData);
        request.onreadystatechange = function(){
            if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                $('#modalFormEventos').modal("hide");
                formEventos.reset();
                swal("Eventos", objData.msg ,"success");
                setTimeout(function(){
                            window.location.reload(true);
                        }, 2000);
                /*let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                let ajaxUrl = base_url+'/Eventos/getEventos/'+intPersonaId; 
                let formData = new FormData(formEventos);
                request.open("POST",ajaxUrl,true);
                request.send(formData);
                request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData)
                    {
                        for(var i = 0; i < objData.length; i++)
                        {
                            if(objData[i]["cumplimiento"] != null && objData[i]["cumplimiento"] != '')
                            {
                                totalEventos.push(
                                {
                                    "start": objData[i]["fecha"],
                                    "end": objData[i]["fecha"],
                                    "title": objData[i]["evento"]+'-'+objData[i]["nivel"],
                                    "rendering": 'background',
                                    "color": '#009688'
                                })
                            }else{
                                totalEventos.push(
                                {
                                    "start": objData[i]["fecha"],
                                    "end": objData[i]["fecha"],
                                    "title": objData[i]["evento"]+'-'+objData[i]["nivel"],
                                    "rendering": 'background',
                                    "color": '#fc0335'
                                })

                            }
                        
                        }
                        var calendarEl = document.getElementById('calendar');
                        var calendar = new FullCalendar.Calendar(calendarEl, {
                                //plugins: [ interactionPlugin ],
                                initialView: 'dayGridMonth',
                                eventLabelFontSize: '200px',
                                selectable: true,
                                events:totalEventos
                        });
                        calendar.render();
                        
                        setTimeout(function(){
                            window.location.reload(true);
                        }, 2000);

                        
                    }else{
                    swal("Error", objData.msg , "error");
                    }
                    }
                }*/
            }else{
                swal("Error", objData.msg , "error");
            }
        }
        divLoading.style.display = "none";
        return false;
      }
    }
  }

});

/*$(document).ready(function () {

        $('#calendar').fullCalendar({
            header: {
                left: 'prev,next today',
                center: 'title',
                right: 'month,agendaWeek,agendaDay'
            },
            // defaultDate: '2017-09-12',
            navLinks: true, // can click day/week names to navigate views
            editable: true,
            eventLimit: true, // allow "more" link when too many events
            selectable: true,
            events: {
                url: 'data',
                error: function () {
                    console.log("error")
                }
            },


                eventClick: function (event, jsEvent, view) {
                //alert("nombre del evento" + event.start.format("YYYY-MM-DD HH:MM:SS") );
                //$('#myModalLabel').html(event.title);
                $('#ModalTitle').html(event.title);    
                $('#start').html(event.start.format("YYYY-DD-MM h\ hh:mm:ss") );
                $('#Modalevent').modal('show');
            },
        });

    });*/



function fntEditInfo(element, idevento){
    //rowTable = element.parentNode.parentNode.parentNode;
    document.querySelector('#titleModal').innerHTML ="Actualizar Evento";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Eventos/getEvento/'+idevento;

    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                console.log(objData.data);
                document.querySelector("#idpersona").value = objData.data.personaid;
                document.querySelector("#idEvento").value = objData.data.idevento;
                document.querySelector("#txtEvento").value = objData.data.evento;
                document.querySelector("#txtUbicacion").value = objData.data.ubicacion;
                document.querySelector("#txtHoraInicial").value = objData.data.hora_inicial;
                document.querySelector("#txtHoraFinal").value = objData.data.hora_final;
                document.querySelector("#txtFechaInicial").value = objData.data.fecha_inicial;
                document.querySelector("#txtFechaFinal").value = objData.data.fecha_final;
                document.querySelector("#txtDescripcion").value = objData.data.descripcion;
                if(document.querySelector("#listNivel"))
                {
                    document.querySelector("#listNivel").value = objData.data.nivel;
                    $('#listNivel').selectpicker('render');
                }
                if(document.querySelector("#listStatus"))
                {
                    document.querySelector("#listStatus").value = 1;
                    $('#listStatus').selectpicker('render');
                }
            }
        }
        $('#modalFormEventosEditar').modal('hide');
        $('#modalFormEventos').modal('show');
    }
     return;
  }

function fntDelInfo(idevento){
    swal({
        title: "Eliminar Evento",
        text: "¿Realmente quiere eliminar el evento?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Eventos/delEvento';
            let strData = "idevento="+idevento;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        setTimeout(function(){
                            window.location.reload(true);
                        }, 2000);
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });

}

function openModal()
{
    rowTable = "";
    document.querySelector('#idEvento').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nuevo Evento";
    document.querySelector("#formEventos").reset();
    if(document.querySelector("#listNivel"))
    {
        document.querySelector("#listNivel").value = "UNIVERSIDAD";
        $('#listNivel').selectpicker('render');
    }
    if(document.querySelector("#listStatus"))
    {
        document.querySelector("#listStatus").value = 1;
        $('#listStatus').selectpicker('render');
    }
    $('#modalFormEventos').modal('show');
}

function openModalEditar()
{
    rowTable = "";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Editar Evento";
    document.querySelector("#formEventosEditar").reset();
    $('#modalFormEventosEditar').modal('show');
}

      
