let tableAlumnos; 
let tableGrupos;
let idArray = [];
let rowTable = "";
let divLoading = document.querySelector("#divLoading");

document.addEventListener('DOMContentLoaded', function(){

    tableGrupos = $('#tableGrupos').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Grupos/getGrupos",
            "dataSrc":""
        },
        "columns":[
            {"data":"idgrupo", visible:false},
            {"data":"grupo_actual_format"},
            {"data":"modificador"},
            {"data":"grupo_siguiente_format"},
            {"data":"ultima_modificacion_format"},
            {"data":"status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[0,"asc"]]  
    });

    if(document.querySelector("#formGrupos")){
        let formGrupos = document.querySelector("#formGrupos");
        formGrupos.onsubmit = function(e) {
            e.preventDefault();
            let strGrado = document.querySelector('#listGrado').value;
            let strGrupo = document.querySelector('#txtGrupo').value;
            let intGrupoConsecutivo = document.querySelector('#listGrupoConsecutivo').value;

            if(strGrado == ''){
                swal("¡Atención!", "Favor de ingresar el grado." , "error");
                return false;
            }
            if(strGrupo == ''){
                swal("¡Atención!", "Favor de ingresar un grupo." , "error");
                return false;
            }
            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("¡Atención!", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            }

            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Grupos/setGrupo'; 
            let formData = new FormData(formGrupos);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        tableGrupos.api().ajax.reload();
                        formGrupos.reset();
                        swal("Grupos", objData.msg ,"success");
                        setTimeout(function(){
                            window.location.reload(true);
                        }, 2000);
                    }else{
                        tableGrupos.api().ajax.reload();
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }

}, false);

function fntViewInfo(idgrupo)
{
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Grupos/getGrupoAlumnos/'+idgrupo
    ;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200)
        {
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                $("#modalTableGrupo").html("");
                let cont = 1;
                for (var i = 0; i < objData.data.length; i++) {
                    $("#modalTableGrupo").append(
                        '<tr>'+
                            '<td bgcolor="#D4EDDA">'+cont+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].matricula+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].nombre_alumno+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].sexo+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].nivel+'</td>'+
                        '</tr>'
                    );
                    document.querySelector("#txtViewGrado").value = objData.data[0].grado;
                    document.querySelector("#txtViewGrupo").value = objData.data[0].grupo;
                    cont++;
                }
                //return;
            }else{

            }
            $('#modalViewGrupo').modal('show');
        }
    }
}

function fntViewAlumno(idalumno)
{
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Grupos/getAlumno/'+idalumno
    ;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200)
        {
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                console.log(objData.data);
                $("#modalTableAlumno").html("");
                
                    $("#modalTableAlumno").append(
                        '<tr>'+
                            '<td bgcolor="#D4EDDA">'+1+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data.matricula+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data.nombre+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data.sexo+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data.nivel+'</td>'+
                        '</tr>'
                    );

            }else{

            }
            $('#modalViewAlumno').modal('show');
        }
    }
}


function fntEditGrupo(element, idgrupo){
    rowTable = element.parentNode.parentNode.parentNode;
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Grupos/getGrupo/'+idgrupo;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            console.log(objData);
            if(objData.status)
            {
                document.querySelector("#idGrupo").value = objData.data.idgrupo;
                document.querySelector("#txtGrupo").value = objData.data.grupo;
                if(document.querySelector("#listGrado"))
                {
                    document.querySelector("#listGrado").value = objData.data.grado;
                    $('#listGrado').selectpicker('render');
                }
                if(document.querySelector("#listGrupoConsecutivo"))
                {
                    document.querySelector("#listGrupoConsecutivo").value = objData.data.grupoid_consecutivo;
                    $('#listGrupoConsecutivo').selectpicker('render');
                }
                swal("¡Exito!", "Datos obtenidos correctamente. Favor de dirigirse a la parte superior para editar el registro." , "success");
            }else{
                swal("¡Error!", "Error de proceso. Favor de intentar nuevamente." , "success");
            }

        }
    }
}

function fntDelGrupo(idgrupo){
    swal({
        title: "Eliminar Grupo",
        text: "¿Realmente quiere eliminar este grupo?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, ¡Eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Grupos/delGrupo';
            let strData = "idgrupo="+idgrupo;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("¡Eliminar!", objData.msg , "success");
                        tableGrupos.api().ajax.reload();
                    }else{
                        swal("¡¡Atención!!", objData.msg , "error");
                    }
                }
            }
        }

    });
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idGrupo').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nuevo Grupo";
    $('#modalFormGrupos').modal('show');
}