let tableAlumnos; 
let tableGrupos;
let idArray = [];
let rowTable = "";
let divLoading = document.querySelector("#divLoading");

document.addEventListener('DOMContentLoaded', function(){

    tableGrupos = $('#tableGrupos').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Grupos/getGrupos",
            "dataSrc":""
        },
        "columns":[
            {"data":"idgrupo", visible:false},
            {"data":"nivel"},
            {"data":"carrera_format"},
            {"data":"grado"},
            {"data":"grupo"},
            {"data":"modificador"},
            {"data":"ultima_modificacion_format"},
            {"data":"status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[0,"desc"]]  
    });

    if(document.querySelector("#formGrupos")){
        let formGrupos = document.querySelector("#formGrupos");
        formGrupos.onsubmit = function(e) {
            e.preventDefault();
            let intNivelId = document.querySelector('#listNivel').value;
            let listCarreras = document.querySelector('#listCarreras'); // primero obtenemos el elemento
            let intCarrera = listCarreras ? listCarreras.value : null;
            let strGrado = document.querySelector('#listGrado').value;
            let strGrupo = document.querySelector('#txtGrupo').value;
            let intPersonaid = document.querySelector('#txtPersonaId').value;
    
            if(intNivelId == 0){
                swal("¡Atención!", "Debe seleccionar un nivel." , "error");
                return false;
            } 

            if (!listCarreras || intCarrera == 0) {
                swal("¡Atención!", "Debe seleccionar una carrera." , "error");
                return false;
            }

            if(strGrado == ''){
                swal("¡Atención!", "Favor de ingresar el grado." , "error");
                return false;
            }


            if(strGrupo == ''){
                swal("¡Atención!", "Favor de ingresar un grupo." , "error");
                return false;
            }


            if(intPersonaid == ''){
                swal("¡Atención!", "Todos los campos son obligatorios." , "error");
                return false;
            }
   

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("¡Atención!", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            }

            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Grupos/setGrupo'; 
            let formData = new FormData(formGrupos);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        tableGrupos.api().ajax.reload();
                        formGrupos.reset();
                        swal("Grupos", objData.msg ,"success");
                        setTimeout(function(){
                            window.location.reload(true);
                        }, 2000);
                    }else{
                        tableGrupos.api().ajax.reload();
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }

}, false);

function fntViewInfo(idgrupo)
{
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Grupos/getGrupoAlumnos/'+idgrupo
    ;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200)
        {
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                $("#modalTableGrupo").html("");
                let cont = 1;
                for (var i = 0; i < objData.data.length; i++) {
                    $("#modalTableGrupo").append(
                        '<tr>'+
                            '<td bgcolor="#D4EDDA">'+cont+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].matricula+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].nombre_alumno+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].sexo+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data[i].nivel+'</td>'+
                        '</tr>'
                    );
                    document.querySelector("#txtViewGrado").value = objData.data[0].grado;
                    document.querySelector("#txtViewGrupo").value = objData.data[0].grupo;
                    document.querySelector("#txtViewCoordinador").value = objData.data[0].nombre_coordinador;
                    cont++;
                }
                //return;
            }else{

            }
            $('#modalViewGrupo').modal('show');
        }
    }
}

function fntViewAlumno(idalumno)
{
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Grupos/getAlumno/'+idalumno
    ;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200)
        {
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                console.log(objData.data);
                $("#modalTableAlumno").html("");
                
                    $("#modalTableAlumno").append(
                        '<tr>'+
                            '<td bgcolor="#D4EDDA">'+1+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data.matricula+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data.nombre+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data.sexo+'</td>'+
                            '<td bgcolor="#D4EDDA">'+objData.data.nivel+'</td>'+
                        '</tr>'
                    );

            }else{

            }
            $('#modalViewAlumno').modal('show');
        }
    }
}


function fntEditGrupo(element, idgrupo){
    rowTable = element.parentNode.parentNode.parentNode;
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Grupos/getGrupo/'+idgrupo;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            console.log(objData);
            if(objData.status)
            {
                document.querySelector("#idGrupo").value = objData.data.idgrupo;
                document.querySelector("#txtGrupo").value = objData.data.grupo;
                document.querySelector("#txtCoordinador").value = objData.data.nombre_coordinador;
                document.querySelector("#txtPersonaId").value = objData.data.personaid;
                if(document.querySelector("#listNivel"))
                {
                    document.querySelector("#listNivel").value = objData.data.nivelid;
                    $('#listNivel').selectpicker('render');
                }
                if(document.querySelector("#listGrado"))
                {
                    document.querySelector("#listGrado").value = objData.data.grado;
                    $('#listGrado').selectpicker('render');
                }

                let divCarreras = $('#divCarreras');
                divCarreras.html("");

                let selectCarreras = $('<select>', {
                    class: 'form-control selectpicker',
                    'data-live-search': 'true',
                    id: 'listCarreras',
                    name: 'listCarreras'
                });
                selectCarreras.append('<option value="0">Seleccionar Carrera</option>');
                objData.carreras.forEach(carrera => {
                    if(carrera.idcarrera == objData.data.idcarrera){
                        selectCarreras.append(
                            `<option value="${carrera.idcarrera}" selected>${carrera.abreviatura}/${carrera.carrera}/${carrera.reforma}</option>`
                        );
                    }else{
                        selectCarreras.append(
                            `<option value="${carrera.idcarrera}">${carrera.carrera}</option>`
                        );
                    }
                   
                });
                divCarreras.append(selectCarreras);
                $('#listCarreras').selectpicker('refresh');



                swal("¡Exito!", "Datos obtenidos correctamente. Favor de dirigirse a la parte superior para editar el registro." , "success");


            }else{
                swal("¡Error!", "Error de proceso. Favor de intentar nuevamente." , "success");
            }

        }
    }
}

function fntDelGrupo(idgrupo){
    swal({
        title: "Eliminar Grupo",
        text: "¿Realmente quiere eliminar este grupo?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, ¡Eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Grupos/delGrupo';
            let strData = "idgrupo="+idgrupo;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("¡Eliminar!", objData.msg , "success");
                        tableGrupos.api().ajax.reload();
                    }else{
                        swal("¡¡Atención!!", objData.msg , "error");
                    }
                }
            }
        }

    });

}

$("#listNivel").change(function(){
    let nivelid = $(this).val();
    if (nivelid == "") {
        swal("¡Atención!", "Tiene que seleccionar un nivel educativo." , "error");
                return false;
    }
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Grupos/getNivel/'+nivelid; 
    let formData = new FormData();
    formData.append('idnivel', nivelid);
    request.open("POST",ajaxUrl,true);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                //console.log(objData.data);
                document.querySelector("#txtCoordinador").value = objData.data.nombre;
                document.querySelector("#txtPersonaId").value = objData.data.idpersona;
                document.querySelector("#txtNivelSeleccionado").value = objData.data.idnivel;
            }
        }
    }

    let request2 = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl2 = base_url+'/Grupos/getCarreras/'; 
    let formData2 = new FormData();
    formData2.append('idnivel', nivelid);
    request2.open("POST",ajaxUrl2,true);
    request2.send(formData2);
    request2.onreadystatechange = function(){
        if(request2.readyState == 4 && request2.status == 200){
            let objData2 = JSON.parse(request2.responseText);
            if(objData2.status) {
                let divCarreras = $('#divCarreras');
                divCarreras.html("");

                let selectCarreras = $('<select>', {
                    class: 'form-control selectpicker',
                    'data-live-search': 'true',
                    id: 'listCarreras',
                    name: 'listCarreras'
                });
                selectCarreras.append('<option value="0">Seleccionar Carrera</option>');
                objData2.data.forEach(carrera => {
                    selectCarreras.append(
                        `<option value="${carrera.idcarrera}">${carrera.abreviatura}/${carrera.carrera}/${carrera.reforma}</option>`
                    );
                });
                divCarreras.append(selectCarreras);
                $('#listCarreras').selectpicker('refresh');
            } else {
                $('#divCarreras').html("");
                swal("¡Atención!", objData2.msg , "error");
            }
        }
    }
})

if(document.querySelector("#formNiveles"))
{
    let formNiveles = document.querySelector("#formNiveles");
    formNiveles.onsubmit = function(e) {
        e.preventDefault();
        let niveles = [];
        let nivelesEmpleados = [];
        niveles =document.querySelectorAll("#nivelEmpleado");
        for (var i = 0; i < niveles.length; i++) {
            //empleados.splice(nombres[i].val());
            //console.log(nombres[i].value);
            nivelesEmpleados.push({"idEmpleado":niveles[i].getAttribute('idEmpleado'), "Nivel": niveles[i].value})
            //nivelesEmpleados.push({"nivelEmpleado":niveles[i].value})
            //console.log(idEmpleados);
        }
        console.log(nivelesEmpleados);
    }
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idDepartamento').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nuevo Departamento";
    document.querySelector("#formDepartamentos").reset();
    $('#modalFormDepartamentos').modal('show');
}