let tableHorarios;
let rowTable = ""; 
let optionMaterias;
let optionProfesores;
let optionMLunes;
let optionMMartes;
let optionMMiercoles;
let optionMJueves;
let optionMViernes;
let optionMSabado;
let optionPLunes;
let optionPMartes;
let optionPMiercoles;
let optionPJueves;
let optionPViernes;
let optionPSabado;
let objMaterias;
let objProfesores;

$("#listCarreras").change(function(){
    //Limpiar los div que contienen las materias
    $('.divLunes').html("");
    $('.divMartes').html("");
    $('.divMiercoles').html("");
    $('.divJueves').html("");
    $('.divViernes').html("");
    $('.divSabado').html("");
    optionMaterias="";

    //Limpiar los controles que contienen las JSON formados del horario diario
    document.querySelector("#listaElementosLunes").value = "";
    document.querySelector("#listaElementosMartes").value = "";
    document.querySelector("#listaElementosMiercoles").value = "";
    document.querySelector("#listaElementosJueves").value = "";
    document.querySelector("#listaElementosViernes").value = "";
    document.querySelector("#listaElementosSabado").value = "";

    let carreraid = $(this).val();
    let requestM = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrlM = base_url+'/Horarios/getMateriasCarrera/'+carreraid; 
    requestM.open("GET",ajaxUrlM,true);
    requestM.send();
    requestM.onreadystatechange = function(){
        if(requestM.readyState == 4 && requestM.status == 200){
            let objDataM = JSON.parse(requestM.responseText);
            if(objDataM.status)
            {
                optionMaterias="";
                objMaterias=objDataM.data;
                for (var i = 0; i < objDataM.data.length; i++) {
                    optionMaterias += '<option value="'+objDataM.data[i].idmateria+'">'+objDataM.data[i].materia+' ('+objDataM.data[i].semestre+')</option>';
                }
            }
        }
    }         
})

let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

    let requestP = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrlP = base_url+'/Horarios/getProfesores'; 
    requestP.open("GET",ajaxUrlP,true);
    requestP.send();
    requestP.onreadystatechange = function(){
        if(requestP.readyState == 4 && requestP.status == 200){
            let objDataP = JSON.parse(requestP.responseText);
            if(objDataP.status)
            {
                objProfesores=objDataP.data;
                for (var i = 0; i < objDataP.data.length; i++) {
                    optionProfesores += '<option value="'+objDataP.data[i].idpersona+'">'+objDataP.data[i].nombre+'</option>';
                }
            }
        }
    }

    tableHorarios = $('#tableHorarios').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Horarios/getHorarios",
            "dataSrc":""
        },
        "columns":[
            {"data":"idhorarioj"},
            {"data":"grupo_format"},
            {"data":"nivel"},
            {"data":"carrera_format"},
            {"data":"ultima_modificacion_format"},
            {"data":"tipo_movimiento"},
            {"data":"status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[2,"asc"]]  
    });

    if(document.querySelector("#formHorarios")){
        let formHorarios = document.querySelector("#formHorarios");
        formHorarios.onsubmit = function(e) {
            e.preventDefault();
            let intGrupo = document.querySelector('#listGrupo').value;
            let intStatus = document.querySelector('#listStatus').value;
            let intCiclo = document.querySelector('#listCiclo').value;
            let strFechaInicial = document.querySelector('#txtFechaInicial').value;
            let strFechaFinal = document.querySelector('#txtFechaFinal').value;
            let listaLunes = document.querySelector('#listaElementosLunes').value;
            let listaMartes = document.querySelector('#listaElementosMartes').value;
            let listaMiercoles = document.querySelector('#listaElementosMiercoles').value;
            let listaJueves = document.querySelector('#listaElementosJueves').value;
            let listaViernes = document.querySelector('#listaElementosViernes').value;
            let listaSabado = document.querySelector('#listaElementosSabado').value;

            if(intGrupo == 0 || intStatus == '')
            {
                swal("Atención", "Es obligatorio seleccionar un grupo para guardar el horario." , "error");
                return false;
            }

            if(intCiclo == 0 || intCiclo == '')
            {
                swal("Atención", "Es obligatorio asignar un ciclo escolar." , "error");
                return false;
            }

            if(strFechaInicial == '' || strFechaFinal == '')
            {
                swal("Atención", "Debe seleccionar el periódo de impartición de la materia para la captura de calificaciones." , "error");
                return false;
            }

            if(listaLunes == '' && listaMartes == '' && listaMiercoles == '' && listaJueves == '' && listaViernes == '' &&
                listaSabado == '')
            {
                swal("Atención", "El horario no se puede almacenar vacio. Favor de completar la información." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Horarios/setHorario'; 
            let formData = new FormData(formHorarios);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        tableHorarios.api().ajax.reload();
                        $('#modalFormHorarios').modal("hide");
                        formHorarios.reset();
                        swal("Horarios", objData.msg ,"success");
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }
})

function formatearPalabra(val) {
  return val.toLowerCase()
            .trim()
            .split(' ')
            .map( v => v[0].toUpperCase() + v.substr(1) )
            .join(' ');  
}

function fntViewHorario(idhorario){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Horarios/getTableHorario/'+idhorario;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            if(objData.status)
            {
                
                document.querySelector('#txtGrupo').value = objData.data[0].grado+'-'+objData.data[0].grupo;
                document.querySelector('#txtNivel').value = objData.data[0].nivel;
                document.querySelector('#txtModificacion').value = objData.data[0].ultima_modificacion_format
                document.querySelector('#txtCarrera').value = objData.data[0].carrera
                $('.horario').empty();
                //console.log(objData);
                
                // Organizar los datos por día y hora
                const schedule = {
                    lunes: {},
                    martes: {},
                    miercoles: {},
                    jueves: {},
                    viernes: {}
                };
                
                // Procesar datos para cada día
                const dias = ['lunes', 'martes', 'miercoles', 'jueves', 'viernes'];
                
                dias.forEach(dia => {
                    const diaKey = `data_${dia}`;
                    if (objData.data[0][diaKey]) {
                        try {
                            const clases = JSON.parse(objData.data[0][diaKey]);
                            clases.forEach(clase => {
                                if (!schedule[dia][clase.hora_inicial]) {
                                    // Buscar el nombre del profesor y materia en los datos
                                    const materiaData = objData.data.find(item => 
                                        item.materiaid == clase.materia);
                                    
                                    const profesorData = objData.data.find(item => 
                                        item.profesorid == clase.profesor);

                                    
                                    schedule[dia][clase.hora_inicial] = {
                                        hora_final: clase.hora_final,
                                        materia: materiaData ? materiaData.materia : `Materia ID: ${clase.materia}`,
                                        profesor: profesorData ? profesorData.nombre_profesor : `Profesor ID: ${clase.profesor}`,
                                        aula: clase.aula ? clase.aula : `Aula: -`
                                    };
                                }
                            });
                        } catch (e) {
                            console.error(`Error al parsear ${diaKey}:`, e);
                        }
                    }
                });
                
                // Obtener todas las horas únicas ordenadas
                const horas = [];
                dias.forEach(dia => {
                    Object.keys(schedule[dia]).forEach(hora => {
                        if (!horas.includes(hora)) {
                            horas.push(hora);
                        }
                    });
                });
                horas.sort();
                
                // Crear tabla HTML
                let html = `
                <table class="schedule-table">
                    <thead>
                        <tr>
                            <th>Hora</th>
                            <th>Lunes</th>
                            <th>Martes</th>
                            <th>Miércoles</th>
                            <th>Jueves</th>
                            <th>Viernes</th>
                        </tr>
                    </thead>
                    <tbody>`;
                
                // Generar filas de la tabla
                horas.forEach(hora => {
                    html += `<tr>
                        <td class="time-slot">${hora} - ${schedule.lunes[hora]?.hora_final || 
                                                        schedule.martes[hora]?.hora_final || 
                                                        schedule.miercoles[hora]?.hora_final || 
                                                        schedule.jueves[hora]?.hora_final ||
                                                        schedule.viernes[hora]?.hora_final || 
                                                        schedule.sabado[hora]?.hora_final || ''}</td>`;
                    
                    dias.forEach(dia => {
                        if (schedule[dia][hora]) {
                            html += `<td>${schedule[dia][hora].materia}<br>
                                     <small>${schedule[dia][hora].profesor}</small><br>
                                     <small>${schedule[dia][hora].aula}</small></td>`;
                        } else {
                            html += '<td>-</td>';
                        }
                    });
                    
                    html += '</tr>';
                });
                
                html += `</tbody>
                </table>`;
                
                // Agregar CSS mínimo
                const css = `
                <style>
                    .schedule-table {
                        width: 100%;
                        border-collapse: collapse;
                        margin-bottom: 30px;
                        font-family: Arial, sans-serif;
                        table-layout: fixed; /* Fuerza que todas las columnas tengan el mismo ancho */
                    }
                    .schedule-table th, 
                    .schedule-table td {
                        border: 1px solid #ddd;
                        padding: 8px;
                        text-align: center;
                        width: 14.28%; /* 100% dividido entre 7 columnas (ajusta según el número de columnas) */
                        word-wrap: break-word; /* Permite ajustar el texto dentro de la celda */
                    }
                    .schedule-table th {
                        background-color: #C82333;
                        color: white;
                        padding: 10px;
                    }
                    .time-slot {
                        font-weight: bold;
                    }
                </style>`;
                
                // Insertar tabla en el contenedor
                $('.horario').append(css + html);
            




                $('#modalViewHorario').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditHorario(element, idhorariog) {
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Horario";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";

    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Horarios/getHorario/'+idhorariog;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status){

                //console.log(objData.data);

                document.querySelector("#listaElementosLunes").value = "";
                document.querySelector("#listaElementosMartes").value = "";
                document.querySelector("#listaElementosMiercoles").value = "";
                document.querySelector("#listaElementosJueves").value = "";
                document.querySelector("#listaElementosViernes").value = "";
                document.querySelector("#listaElementosSabado").value = "";
                
                // Variables para cada día (se convierten a array o vacío si no hay datos)
                let jsonDataLunes     = objData.data.data_lunes     ? JSON.parse(objData.data.data_lunes)     : [];
                let jsonDataMartes    = objData.data.data_martes    ? JSON.parse(objData.data.data_martes)    : [];
                let jsonDataMiercoles = objData.data.data_miercoles ? JSON.parse(objData.data.data_miercoles) : [];
                let jsonDataJueves    = objData.data.data_jueves    ? JSON.parse(objData.data.data_jueves)    : [];
                let jsonDataViernes   = objData.data.data_viernes   ? JSON.parse(objData.data.data_viernes)   : [];
                let jsonDataSabado    = objData.data.data_sabado    ? JSON.parse(objData.data.data_sabado)    : [];

                //console.log(jsonDataLunes);

                let diasSemana = [
                    { key: "data_lunes",     jsonVar: "jsonDataLunes",     inputId: "listaElementosLunes" },
                    { key: "data_martes",    jsonVar: "jsonDataMartes",    inputId: "listaElementosMartes" },
                    { key: "data_miercoles", jsonVar: "jsonDataMiercoles", inputId: "listaElementosMiercoles" },
                    { key: "data_jueves",    jsonVar: "jsonDataJueves",    inputId: "listaElementosJueves" },
                    { key: "data_viernes",   jsonVar: "jsonDataViernes",   inputId: "listaElementosViernes" },
                    { key: "data_sabado",    jsonVar: "jsonDataSabado",    inputId: "listaElementosSabado" }
                ];

                diasSemana.forEach(dia => {
                    let valor = objData.data[dia.key];
                    if (valor && valor !== '') {
                        window[dia.jsonVar] = JSON.parse(valor);
                        document.querySelector(`#${dia.inputId}`).value = valor;
                    }
                });

                //console.log(diasSemana);

                // Id Horario
                document.querySelector("#idHorario").value = objData.data.idhorarioj;
                document.querySelector("#txtFechaInicial").value = objData.data.fecha_inicial;
                document.querySelector("#txtFechaFinal").value = objData.data.fecha_final;

                if(document.querySelector("#listGrupo")){
                    document.querySelector("#listGrupo").value = objData.data.grupoid;
                    $('#listGrupo').selectpicker('render');
                }
                if(document.querySelector("#listCarreras")){
                    document.querySelector("#listCarreras").value = objData.data.carreraid;
                    $('#listCarreras').selectpicker('render');
                }
                if(document.querySelector("#listStatus")){
                    document.querySelector("#listStatus").value = objData.data.status;
                    $('#listStatus').selectpicker('render');
                }

                //Limpiar todos los contenedores de días
                $('.divLunes, .divMartes, .divMiercoles, .divJueves, .divViernes, .divSabado').html("");

                //Petición de materias según nivel
                let requestMaterias = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                let ajaxUrl2 = base_url+'/Horarios/getMateriasCarrera/'+objData.data.carreraid; 
                requestMaterias.open("GET",ajaxUrl2,true);
                requestMaterias.send();
                requestMaterias.onreadystatechange = function(){
                    if(requestMaterias.readyState == 4 && requestMaterias.status == 200){
                        let objData2 = JSON.parse(requestMaterias.responseText);
                        if(objData2.status){
                            //console.log(objData2.data)
                            //Función para generar opciones de materias
                            function getMateriasOptions(materiaId){
                                let options = "";
                                optionMaterias = "";
                                for (let m = 0; m < objData2.data.length; m++){
                                    let selected = (objData2.data[m].idmateria == materiaId) ? "selected" : "";
                                    options += `<option value="${objData2.data[m].idmateria}" ${selected}>${objData2.data[m].materia}</option>`;
                                    optionMaterias += `<option value="${objData2.data[m].idmateria}" ${selected}>${objData2.data[m].materia}</option>`;
                                }
                                return options;
                            }

                            //Función para generar opciones de profesores
                            function getProfesoresOptions(profesorId){
                                let options = "";
                                for (let p = 0; p < objProfesores.length; p++){
                                    let selected = (objProfesores[p].idpersona == profesorId) ? "selected" : "";
                                    options += `<option value="${objProfesores[p].idpersona}" ${selected}>${objProfesores[p].nombre}</option>`;
                                }
                                return options;
                            }

                            //Función para pintar cada bloque por día
                            function renderDia(divDia, jsonData, prefix){
                                for (let j = 0; j < jsonData.length; j++){
                                    let materiasOpt  = getMateriasOptions(jsonData[j].materia);
                                    let profesorOpt  = getProfesoresOptions(jsonData[j].profesor);

                                    $(divDia).append(
                                        `<div class="form-row">
                                            <div class="form-group col-md-4">
                                                <label>Materia</label>
                                                <div class="input-group">
                                                    <span class="input-group-addon">
                                                        <button type="button" class="btn btn-danger btn-xs quitarElemento${prefix}">
                                                            <i class="fa fa-times"></i>
                                                        </button>
                                                    </span>
                                                    <select class="form-control selectpicker listMateria${prefix}" id="listMateria${prefix}" name="listMateria${prefix}" data-live-search="true" required>
                                                        ${materiasOpt}
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>Profesor</label>
                                                <select class="form-control selectpicker listProfesor${prefix}" id="listProfesor${prefix}" name="listProfesor${prefix}" data-live-search="true" required>
                                                    ${profesorOpt}
                                                </select>
                                            </div>
                                            <div class="form-group col-md-2">
                                                <label>H. Inicial</label>
                                                <input type="time" class="form-control" id="txtHoraInicial${prefix}" name="txtHoraInicial${prefix}" value="${jsonData[j].hora_inicial}" required />
                                            </div>
                                            <div class="form-group col-md-2">
                                                <label>H. Final</label>
                                                <input type="time" class="form-control" id="txtHoraFinal${prefix}" name="txtHoraFinal${prefix}" value="${jsonData[j].hora_final}" required />
                                            </div>
                                            <div class="form-group col-md-1">
                                                <label>Aula</label>
                                                <input type="text" class="form-control" id="txtAula${prefix}" name="txtAula${prefix}" value="${jsonData[j].aula}" required />
                                            </div>
                                        </div>`
                                    );
                                }
                                $(`.listMateria${prefix}`).selectpicker('refresh');
                                $(`.listProfesor${prefix}`).selectpicker('refresh');
                            }

                            // Renderizar cada día con la función
                            renderDia(".divLunes", jsonDataLunes, "Lun");
                            renderDia(".divMartes", jsonDataMartes, "Mar");
                            renderDia(".divMiercoles", jsonDataMiercoles, "Mie");
                            renderDia(".divJueves", jsonDataJueves, "Jue");
                            renderDia(".divViernes", jsonDataViernes, "Vie");
                            renderDia(".divSabado", jsonDataSabado, "Sab");

                        }
                    }
                }
            }
        }
        $('#modalFormHorarios').modal('show');
    }
}

function fntDelHorario(idhorario){
    swal({
        title: "Eliminar Horario",
        text: "¿Realmente quiere eliminar el registro del horario?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Horarios/delHorario';
            let strData = "idhorario="+idhorario;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableHorarios.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idHorario').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nuevo Horario";
    document.querySelector("#formHorarios").reset();
    if(document.querySelector("#listGrupo"))
    {
        document.querySelector("#listGrupo").value = 0;
        $('#listGrupo').selectpicker('render');
    }
    if(document.querySelector("#listCarreras"))
    {
        document.querySelector("#listCarreras").value = 0;
        $('#listCarreras').selectpicker('render');
    }
    if(document.querySelector("#listMateria"))
    {
        document.querySelector("#listMateria").value = 0;
        $('#listMateria').selectpicker('render');
    }
    if(document.querySelector("#listProfesor"))
    {
        document.querySelector("#listProfesor").value = 0;
        $('#listProfesor').selectpicker('render');
    }
    if(document.querySelector("#listStatus"))
    {
        document.querySelector("#listStatus").value = 1;
        $('#listStatus').selectpicker('render');
    }
    if(document.querySelector(".divLunes"))
    {
        $(".divLunes").html("");
    }
    if(document.querySelector(".divMartes"))
    {
        $(".divMartes").html("");
    }
    if(document.querySelector(".divMiercoles"))
    {
        $(".divMiercoles").html("");
    }
    if(document.querySelector(".divJueves"))
    {
        $(".divJueves").html("");
    }
    if(document.querySelector(".divViernes"))
    {
        $(".divViernes").html("");
    }
    if(document.querySelector(".divSabado"))
    {
        $(".divSabado").html("");
    }

    $('#modalFormHorarios').modal('show');
}

$("#modalFormHorarios").on("click", "button.btnAgregarLunes", function(){
    if(document.querySelector('#listGrupo').value == 0)
    {
        swal("Atención", "Primero debe seleccionar un grupo." , "error");
        return false;
    }
    let grupoid = document.querySelector("#listGrupo").value;
    //console.log(grupoid);

    $(".divLunes").append(
        '<div class="form-row">'+
            '<div class="form-group col-md-4">'+
                '<label for="listMateriaLun">Materia</label>'+
                '<div class="input-group">'+
                    '<span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs quitarElementoLun"><i class="fa fa-times"></i></button></span>'+
                    '<select class="form-control selectpicker listMateriaLun" data-live-search="true" id="listMateriaLun" name="listMateriaLun" required >'+
                     optionMaterias+
                    '</select>'+
                '</div>'+
            '</div>'+
            '<div class="form-group col-md-3">'+
                '<label for="listProfesorLun">Profesor</label>'+
                '<select class="form-control selectpicker listProfesorLun" data-live-search="true" id="listProfesorLun" name="listProfesorLun" required >'+
                    optionProfesores+
                '</select>'+
            '</div>'+
            '<div class="form-group col-md-2">'+
                '<label for="txtHoraInicialLun">H. Inicial</label>'+
                '<input type="time" class="form-control" id="txtHoraInicialLun" name="txtHoraInicialLun" required />'+
            '</div>'+
            '<div class="form-group col-md-2">'+
                '<label for="txtHoraFinalLun">H. Final</label>'+
                '<input type="time" class="form-control" id="txtHoraFinalLun" name="txtHoraFinalLun" required />'+
            '</div>'+
            '<div class="form-group col-md-1">'+
                '<label for="txtAulaLun">Aula</label>'+
                '<input type="text" class="form-control" id="txtAulaLun" name="txtAulaLun" required />'+
            '</div>'+
        '</div>'
    );    
    $(".listMateriaLun").selectpicker('refresh');
    $(".listProfesorLun").selectpicker('refresh');
});

$("#modalFormHorarios").on("click", "button.btnAgregarMartes", function(){
    if(document.querySelector('#listGrupo').value == 0)
    {
        swal("Atención", "Primero debe seleccionar un grupo." , "error");
        return false;
    }
    $(".divMartes").append(
        '<div class="form-row">'+
            '<div class="form-group col-md-4">'+
                '<label for="listMateriaMar">Materia</label>'+
                '<div class="input-group">'+
                    '<span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs quitarElementoMar"><i class="fa fa-times"></i></button></span>'+
                    '<select class="form-control selectpicker listMateriaMar" data-live-search="true" id="listMateriaMar" name="listMateriaMar" required >'+
                     optionMaterias+
                    '</select>'+
                '</div>'+
            '</div>'+
            '<div class="form-group col-md-3">'+
                '<label for="listProfesorMar">Profesor</label>'+
                '<select class="form-control selectpicker listProfesorMar" data-live-search="true" id="listProfesorMar" name="listProfesorMar" required >'+
                    optionProfesores+
                '</select>'+
            '</div>'+
            '<div class="form-group col-md-2">'+
                '<label for="txtHoraInicialMar">H. Inicial</label>'+
                '<input type="time" class="form-control" id="txtHoraInicialMar" name="txtHoraInicialMar"  required/>'+
            '</div>'+
            '<div class="form-group col-md-2">'+
                '<label for="txtHoraFinalMar">H. Final</label>'+
                '<input type="time" class="form-control" id="txtHoraFinalMar" name="txtHoraFinalMar"  required/>'+
            '</div>'+
            '<div class="form-group col-md-1">'+
                '<label for="txtAulaMar">Aula</label>'+
                '<input type="text" class="form-control" id="txtAulaMar" name="txtAulaMar" required />'+
            '</div>'+
        '</div>'
    );    
    $(".listMateriaMar").selectpicker('refresh');
    $(".listProfesorMar").selectpicker('refresh');            
});

$("#modalFormHorarios").on("click", "button.btnAgregarMiercoles", function(){
    if(document.querySelector('#listGrupo').value == 0)
    {
        swal("Atención", "Primero debe seleccionar un grupo." , "error");
        return false;
    }
    $(".divMiercoles").append(
        '<div class="form-row">'+
            '<div class="form-group col-md-4">'+
                '<label for="listMateriaMier">Materia</label>'+
               '<div class="input-group">'+
                    '<span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs quitarElementoMie"><i class="fa fa-times"></i></button></span>'+
                    '<select class="form-control selectpicker listMateriaMie" data-live-search="true" id="listMateriaMie" name="listMateriaMie" required >'+
                     optionMaterias+
                    '</select>'+
                '</div>'+
            '</div>'+
            '<div class="form-group col-md-3">'+
                '<label for="listProfesorMie">Profesor</label>'+
                '<select class="form-control selectpicker listProfesorMie" data-live-search="true" id="listProfesorMie" name="listProfesorMie" required >'+
                    optionProfesores+
                '</select>'+
            '</div>'+
            '<div class="form-group col-md-2">'+
                '<label for="txtHoraInicialMie">H. Inicial</label>'+
                '<input type="time" class="form-control" id="txtHoraInicialMie" name="txtHoraInicialMie" required />'+
            '</div>'+
            '<div class="form-group col-md-2">'+
                '<label for="txtHoraFinalMie">H. Final</label>'+
                '<input type="time" class="form-control" id="txtHoraFinalMie" name="txtHoraFinalMie" required />'+
            '</div>'+
            '<div class="form-group col-md-1">'+
                '<label for="txtAulaMie">Aula</label>'+
                '<input type="text" class="form-control" id="txtAulaMie" name="txtAulaMie" required />'+
            '</div>'+
        '</div>'
    );
    $(".listMateriaMie").selectpicker('refresh');
    $(".listProfesorMie").selectpicker('refresh');                
});
$("#modalFormHorarios").on("click", "button.btnAgregarJueves", function(){
    if(document.querySelector('#listGrupo').value == 0)
    {
        swal("Atención", "Primero debe seleccionar un grupo." , "error");
        return false;
    }
    $(".divJueves").append(
        '<div class="form-row">'+
            '<div class="form-group col-md-4">'+
                '<label for="listMateriaJue">Materia</label>'+
                '<div class="input-group">'+
                    '<span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs quitarElementoJue"><i class="fa fa-times"></i></button></span>'+
                    '<select class="form-control selectpicker listMateriaJue" data-live-search="true" id="listMateriaJue" name="listMateriaJue" required >'+
                     optionMaterias+
                    '</select>'+
                '</div>'+
            '</div>'+
            '<div class="form-group col-md-3">'+
                '<label for="listProfesorJue">Profesor</label>'+
                '<select class="form-control selectpicker listProfesorJue" data-live-search="true" id="listProfesorJue" name="listProfesorJue" required >'+
                    optionProfesores+
                '</select>'+
            '</div>'+
            '<div class="form-group col-md-2">'+
                '<label for="txtHoraInicialJue">H. Inicial</label>'+
                '<input type="time" class="form-control" id="txtHoraInicialJue" name="txtHoraInicialJue" required />'+
            '</div>'+
            '<div class="form-group col-md-2">'+
                '<label for="txtHoraFinalJue">H. Final</label>'+
                '<input type="time" class="form-control" id="txtHoraFinalJue" name="txtHoraFinalJue" required />'+
            '</div>'+
            '<div class="form-group col-md-1">'+
                '<label for="txtAulaJue">Aula</label>'+
                '<input type="text" class="form-control" id="txtAulaJue" name="txtAulaJue" required />'+
            '</div>'+
        '</div>'
    ); 
    $(".listMateriaJue").selectpicker('refresh');
    $(".listProfesorJue").selectpicker('refresh');                  
});
$("#modalFormHorarios").on("click", "button.btnAgregarViernes", function(){
    if(document.querySelector('#listGrupo').value == 0)
    {
        swal("Atención", "Primero debe seleccionar un grupo." , "error");
        return false;
    }
    $(".divViernes").append(
        '<div class="form-row">'+
            '<div class="form-group col-md-4">'+
                '<label for="listMateriaVie">Materia</label>'+
                '<div class="input-group">'+
                    '<span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs quitarElementoVie"><i class="fa fa-times"></i></button></span>'+
                    '<select class="form-control selectpicker listMateriaVie" data-live-search="true" id="listMateriaVie" name="listMateriaVie" required >'+
                     optionMaterias+
                    '</select>'+
                '</div>'+
            '</div>'+
            '<div class="form-group col-md-3">'+
                '<label for="listProfesorVie">Profesor</label>'+
                '<select class="form-control selectpicker listProfesorVie" data-live-search="true" id="listProfesorVie" name="listProfesorVie" required >'+
                    optionProfesores+
                '</select>'+
            '</div>'+
            '<div class="form-group col-md-2">'+
                '<label for="txtHoraInicialVie">H. Inicial</label>'+
                '<input type="time" class="form-control" id="txtHoraInicialVie" name="txtHoraInicialVie" required />'+
            '</div>'+
            '<div class="form-group col-md-2">'+
                '<label for="txtHoraFinalVie">H. Final</label>'+
                '<input type="time" class="form-control" id="txtHoraFinalVie" name="txtHoraFinalVie" required />'+
            '</div>'+
            '<div class="form-group col-md-1">'+
                '<label for="txtAulaVie">Aula</label>'+
                '<input type="text" class="form-control" id="txtAulaVie" name="txtAulaVie" required />'+
            '</div>'+
        '</div>'
    );
    $(".listMateriaVie").selectpicker('refresh');
    $(".listProfesorVie").selectpicker('refresh');                   
});

$("#modalFormHorarios").on("click", "button.btnAgregarSabado", function(){
    if(document.querySelector('#listGrupo').value == 0)
    {
        swal("Atención", "Primero debe seleccionar un grupo." , "error");
        return false;
    }
    $(".divSabado").append(
        '<div class="form-row">'+
            '<div class="form-group col-md-4">'+
                '<label for="listMateriaSab">Materia</label>'+
                '<div class="input-group">'+
                    '<span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs quitarElementoSab"><i class="fa fa-times"></i></button></span>'+
                    '<select class="form-control selectpicker listMateriaSab" data-live-search="true" id="listMateriaSab" name="listMateriaSab" required >'+
                     optionMaterias+
                    '</select>'+
                '</div>'+
            '</div>'+
            '<div class="form-group col-md-3">'+
                '<label for="listProfesorSab">Profesor</label>'+
                '<select class="form-control selectpicker listProfesorSab" data-live-search="true" id="listProfesorSab" name="listProfesorSab" required >'+
                    optionProfesores+
                '</select>'+
            '</div>'+
            '<div class="form-group col-md-2">'+
                '<label for="txtHoraInicialSab">H. Inicial</label>'+
                '<input type="time" class="form-control" id="txtHoraInicialSab" name="txtHoraInicialSab" required />'+
            '</div>'+
            '<div class="form-group col-md-2">'+
                '<label for="txtHoraFinalSab">H. Final</label>'+
                '<input type="time" class="form-control" id="txtHoraFinalSab" name="txtHoraFinalSab" required />'+
            '</div>'+
            '<div class="form-group col-md-1">'+
                '<label for="txtAulaSab">Aula</label>'+
                '<input type="text" class="form-control" id="txtAulaSab" name="txtAulaSab" required />'+
            '</div>'+
        '</div>'
    );
    $(".listMateriaSab").selectpicker('refresh');
    $(".listProfesorSab").selectpicker('refresh');                   
});

//Código para listar todos los elementos del DIV Lunes
$("#modalFormHorarios").on("click", "button.quitarElementoLun", function(){
    $(this).parent().parent().parent().parent().remove();
    // AGRUPAR PRODUCTOS EN FORMATO JSON
    listarElementosLunes(); 
})

$("#modalFormHorarios").on("change", "select#listMateriaLun", function(){
    listarElementosLunes(); 
})  
$("#modalFormHorarios").on("change", "select#listProfesorLun", function(){
    listarElementosLunes(); 
})
$("#modalFormHorarios").on("change", "input#txtHoraInicialLun", function(){
    listarElementosLunes(); 
})
$("#modalFormHorarios").on("change", "input#txtHoraFinalLun", function(){
    listarElementosLunes(); 
})
$("#modalFormHorarios").on("change", "input#txtAulaLun", function(){
    listarElementosLunes(); 
})

function listarElementosLunes(){
    let listaElementosLunes = [];
    let materiaLun = document.querySelectorAll("#listMateriaLun");
    let profesorLun = document.querySelectorAll("#listProfesorLun");
    let horaInicialLun = document.querySelectorAll("#txtHoraInicialLun");
    let horaFinalLun = document.querySelectorAll("#txtHoraFinalLun");
    let aulaLun = document.querySelectorAll("#txtAulaLun");
    let grupoid = document.querySelector("#listGrupo");
    for(let i = 0; i < materiaLun.length; i++){
        listaElementosLunes.push({"grupoid" : $(grupoid).val(),
                                "materia" : $(materiaLun[i]).val(), 
                                "profesor" : $(profesorLun[i]).val(),
                                "hora_inicial" : $(horaInicialLun[i]).val(),
                                "hora_final" : $(horaFinalLun[i]).val(),
                                "aula" : $(aulaLun[i]).val()})
    }
    $("#listaElementosLunes").val(JSON.stringify(listaElementosLunes)); 
}


//Código para listar todos los elementos del DIV Martes
$("#modalFormHorarios").on("click", "button.quitarElementoMar", function(){
    $(this).parent().parent().parent().parent().remove();
    // AGRUPAR PRODUCTOS EN FORMATO JSON
    listarElementosMartes(); 
})

$("#modalFormHorarios").on("change", "select#listMateriaMar", function(){
    listarElementosMartes(); 
})  
$("#modalFormHorarios").on("change", "select#listProfesorMar", function(){
    listarElementosMartes(); 
})
$("#modalFormHorarios").on("change", "input#txtHoraInicialMar", function(){
    listarElementosMartes(); 
})
$("#modalFormHorarios").on("change", "input#txtHoraFinalMar", function(){
    listarElementosMartes(); 
})
$("#modalFormHorarios").on("change", "input#txtAulaMar", function(){
    listarElementosMartes(); 
})

function listarElementosMartes(){
    let listaElementosMartes = [];
    let materiaMar = document.querySelectorAll("#listMateriaMar");
    let profesorMar = document.querySelectorAll("#listProfesorMar");
    let horaInicialMar = document.querySelectorAll("#txtHoraInicialMar");
    let horaFinalMar = document.querySelectorAll("#txtHoraFinalMar");
    let aulaMar = document.querySelectorAll("#txtAulaMar");
    let grupoid = document.querySelector("#listGrupo");
    for(let i = 0; i < materiaMar.length; i++){
        listaElementosMartes.push({"grupoid" : $(grupoid).val(),
                                "materia" : $(materiaMar[i]).val(), 
                                "profesor" : $(profesorMar[i]).val(),
                                "hora_inicial" : $(horaInicialMar[i]).val(),
                                "hora_final" : $(horaFinalMar[i]).val(),
                                "aula" : $(aulaMar[i]).val()})
    }
    $("#listaElementosMartes").val(JSON.stringify(listaElementosMartes)); 
}  

//Código para listar todos los elementos del DIV Miércoles
$("#modalFormHorarios").on("click", "button.quitarElementoMie", function(){
    $(this).parent().parent().parent().parent().remove();
    // AGRUPAR PRODUCTOS EN FORMATO JSON
    listarElementosMiercoles(); 
})

$("#modalFormHorarios").on("change", "select#listMateriaMie", function(){
    listarElementosMiercoles(); 
})  
$("#modalFormHorarios").on("change", "select#listProfesorMie", function(){
    listarElementosMiercoles(); 
})
$("#modalFormHorarios").on("change", "input#txtHoraInicialMie", function(){
    listarElementosMiercoles(); 
})
$("#modalFormHorarios").on("change", "input#txtHoraFinalMie", function(){
    listarElementosMiercoles(); 
})
$("#modalFormHorarios").on("change", "input#txtAulaMie", function(){
    listarElementosMiercoles(); 
})

function listarElementosMiercoles(){
    let listaElementosMiercoles = [];
    let materiaMie = document.querySelectorAll("#listMateriaMie");
    let profesorMie = document.querySelectorAll("#listProfesorMie");
    let horaInicialMie = document.querySelectorAll("#txtHoraInicialMie");
    let horaFinalMie = document.querySelectorAll("#txtHoraFinalMie");
    let aulaMie = document.querySelectorAll("#txtAulaMie");
    let grupoid = document.querySelector("#listGrupo");
    for(let i = 0; i < materiaMie.length; i++){
        listaElementosMiercoles.push({"grupoid" : $(grupoid).val(),
                                "materia" : $(materiaMie[i]).val(), 
                                "profesor" : $(profesorMie[i]).val(),
                                "hora_inicial" : $(horaInicialMie[i]).val(),
                                "hora_final" : $(horaFinalMie[i]).val(),
                                "aula" : $(aulaMie[i]).val()})
    }
    $("#listaElementosMiercoles").val(JSON.stringify(listaElementosMiercoles)); 
}   


//Código para listar todos los elementos del DIV Jueves
$("#modalFormHorarios").on("click", "button.quitarElementoJue", function(){
    $(this).parent().parent().parent().parent().remove();
    // AGRUPAR PRODUCTOS EN FORMATO JSON
    listarElementosJueves(); 
})

$("#modalFormHorarios").on("change", "select#listMateriaJue", function(){
    listarElementosJueves(); 
})  
$("#modalFormHorarios").on("change", "select#listProfesorJue", function(){
    listarElementosJueves(); 
})
$("#modalFormHorarios").on("change", "input#txtHoraInicialJue", function(){
    listarElementosJueves(); 
})
$("#modalFormHorarios").on("change", "input#txtHoraFinalJue", function(){
    listarElementosJueves(); 
})
$("#modalFormHorarios").on("change", "input#txtAulaJue", function(){
    listarElementosJueves(); 
})

function listarElementosJueves(){
    let listaElementosJueves = [];
    let materiaJue = document.querySelectorAll("#listMateriaJue");
    let profesorJue = document.querySelectorAll("#listProfesorJue");
    let horaInicialJue = document.querySelectorAll("#txtHoraInicialJue");
    let horaFinalJue = document.querySelectorAll("#txtHoraFinalJue");
    let aulaJue = document.querySelectorAll("#txtAulaJue");
    let grupoid = document.querySelector("#listGrupo");
    for(let i = 0; i < materiaJue.length; i++){
        listaElementosJueves.push({"grupoid" : $(grupoid).val(),
                                "materia" : $(materiaJue[i]).val(), 
                                "profesor" : $(profesorJue[i]).val(),
                                "hora_inicial" : $(horaInicialJue[i]).val(),
                                "hora_final" : $(horaFinalJue[i]).val(),
                                "aula" : $(aulaJue[i]).val()})
    }
    $("#listaElementosJueves").val(JSON.stringify(listaElementosJueves)); 
}


//Código para listar todos los elementos del DIV Viernes
$("#modalFormHorarios").on("click", "button.quitarElementoVie", function(){
    $(this).parent().parent().parent().parent().remove();
    // AGRUPAR PRODUCTOS EN FORMATO JSON
    listarElementosViernes(); 
})

$("#modalFormHorarios").on("change", "select#listMateriaVie", function(){
    listarElementosViernes(); 
})  
$("#modalFormHorarios").on("change", "select#listProfesorVie", function(){
    listarElementosViernes(); 
})
$("#modalFormHorarios").on("change", "input#txtHoraInicialVie", function(){
    listarElementosViernes(); 
})
$("#modalFormHorarios").on("change", "input#txtHoraFinalVie", function(){
    listarElementosViernes(); 
})
$("#modalFormHorarios").on("change", "input#txtAulaVie", function(){
    listarElementosViernes(); 
})

function listarElementosViernes(){
    let listaElementosViernes = [];
    let materiaVie = document.querySelectorAll("#listMateriaVie");
    let profesorVie = document.querySelectorAll("#listProfesorVie");
    let horaInicialVie = document.querySelectorAll("#txtHoraInicialVie");
    let horaFinalVie = document.querySelectorAll("#txtHoraFinalVie");
    let aulaVie = document.querySelectorAll("#txtAulaVie");
    let grupoid = document.querySelector("#listGrupo");
    for(let i = 0; i < materiaVie.length; i++){
        listaElementosViernes.push({"grupoid" : $(grupoid).val(),
                                "materia" : $(materiaVie[i]).val(), 
                                "profesor" : $(profesorVie[i]).val(),
                                "hora_inicial" : $(horaInicialVie[i]).val(),
                                "hora_final" : $(horaFinalVie[i]).val(),
                                "aula" : $(aulaVie[i]).val()})
    }
    $("#listaElementosViernes").val(JSON.stringify(listaElementosViernes)); 
}

//Código para listar todos los elementos del DIV Sabado
$("#modalFormHorarios").on("click", "button.quitarElementoSab", function(){
    $(this).parent().parent().parent().parent().remove();
    // AGRUPAR PRODUCTOS EN FORMATO JSON
    listarElementosSabado(); 
})

$("#modalFormHorarios").on("change", "select#listMateriaSab", function(){
    listarElementosSabado(); 
})  
$("#modalFormHorarios").on("change", "select#listProfesorSab", function(){
    listarElementosSabado(); 
})
$("#modalFormHorarios").on("change", "input#txtHoraInicialSab", function(){
    listarElementosSabado(); 
})
$("#modalFormHorarios").on("change", "input#txtHoraFinalSab", function(){
    listarElementosSabado(); 
})
$("#modalFormHorarios").on("change", "input#txtAulaSab", function(){
    listarElementosSabado(); 
})

function listarElementosSabado(){
    let listaElementosSabado = [];
    let materiaSab = document.querySelectorAll("#listMateriaSab");
    let profesorSab = document.querySelectorAll("#listProfesorSab");
    let horaInicialSab = document.querySelectorAll("#txtHoraInicialSab");
    let horaFinalSab = document.querySelectorAll("#txtHoraFinalSab");
    let aulaSab = document.querySelectorAll("#txtAulaSab");
    let grupoid = document.querySelector("#listGrupo");
    for(let i = 0; i < materiaSab.length; i++){
        listaElementosSabado.push({"grupoid" : $(grupoid).val(),
                                "materia" : $(materiaSab[i]).val(), 
                                "profesor" : $(profesorSab[i]).val(),
                                "hora_inicial" : $(horaInicialSab[i]).val(),
                                "hora_final" : $(horaFinalSab[i]).val(),
                                "aula" : $(aulaSab[i]).val()})
    }
    $("#listaElementosSabado").val(JSON.stringify(listaElementosSabado)); 
}