//Examples autoNumeric Library: https://autonumeric.org/examples
let tableIncidencias;
let rowTable = "";

//Script para sobreponer el editor de texto tinymce sobre los modales de bootstrap
$(document).on('focusin', function(e) {
    if ($(e.target).closest(".tox-dialog").length) {
        e.stopImmediatePropagation();
    }
});

let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

    tableIncidencias = $('#tableIncidencias').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Incidencias/getIncidencias",
            "dataSrc":""
        },
        "columns":[
            {"data":"idincidencia", visible: false},
            {"data":"nombre_alumno"},
            {"data":"nivel"},
            {"data":"incidencia"},
            {"data":"nombre_persona"},
            {"data":"fecha_incidencia_format"},
            {"data":"btnEstado"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[5,"des"]]  
    });

    if(document.querySelector("#formIncidencias")){
        let formIncidencias = document.querySelector("#formIncidencias");
        formIncidencias.onsubmit = function(e) {
            e.preventDefault();
           
            let intAlumnoId= document.querySelector('#listAlumno').value;
            let strIncidencia = document.querySelector('#txtIncidencia').value;
            let strFecha = document.querySelector('#txtFecha').value;
            let strPersona = document.querySelector('#personaid').value;
            let fecha = strFecha.split("-");
            let strFechaFormat = fecha[2]+'-'+fecha[1] +'-'+fecha[0];

            if(strFecha == '' || strIncidencia == '' || intAlumnoId == 0 || intAlumnoId == '')
            {
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++){ 
                if(elementsValid[i].classList.contains('is-invalid')){ 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            }

            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Incidencias/setIncidencia'; 
            let formData = new FormData(formIncidencias);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {

                        if(rowTable == ""){
                            tableIncidencias.api().ajax.reload();
                        }else{
                            tableIncidencias.api().ajax.reload();
                           
                            rowTable.cells[1].textContent = document.querySelector("#listAlumno").selectedOptions[0].text;
                            rowTable.cells[2].textContent = objData.nivel.nivel;
                            rowTable.cells[3].textContent = strIncidencia;
                            rowTable.cells[4].textContent = strFechaFormat;
                            //rowTable.cells[5].innerHTML = objData.data.btnEstado;
                            rowTable = ""; 
                        }
                        $('#modalFormIncidencias').modal("hide");
                        formIncidencias.reset();
                        swal("Incidencias", objData.msg ,"success");
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }

    if(document.querySelector("#formIncidenciasContencion")){
        let formIncidenciasContencion = document.querySelector("#formIncidenciasContencion");
        formIncidenciasContencion.onsubmit = function(e) {
            e.preventDefault();
           
            /*let strAlumno= document.querySelector('#txtAlumnoIncidencia').value;
            let strFechaIncidencia = document.querySelector('#txtFechaIncidencia').value;
            let strNivel = document.querySelector('#txtNivel').value;
            let strPersonaS = document.querySelector('#personaid').value;
            let strIncidenciaS = document.querySelector('#txtIncidenciaSeguimiento').value;*/
            let strEstado = document.querySelector('#listEstado').value;

            if(strEstado == '' || strEstado == 0)
            {
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }

            divLoading.style.display = "flex";
            tinyMCE.triggerSave();
            let requestS = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrlS = base_url+'/Incidencias/updateSeguimiento'; 
            let formDataS = new FormData(formIncidenciasContencion);
            requestS.open("POST",ajaxUrlS,true);
            requestS.send(formDataS);
            requestS.onreadystatechange = function(){
                if(requestS.readyState == 4 && requestS.status == 200){
                    let objDataS = JSON.parse(requestS.responseText);
                    if(objDataS.status)
                    {
                        
                        rowTable.cells[5].innerHTML = objDataS.data;
                        rowTable = "";

                        $('#modalFormIncidenciasContencion').modal("hide");
                        formIncidenciasContencion.reset();
                        swal("Incidencias", objDataS.msg ,"success");
                    }else{
                        swal("Error", objDataS.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }

})

    


function formatearPalabra(val) {
  return val.toLowerCase()
            .trim()
            .split(' ')
            .map( v => v[0].toUpperCase() + v.substr(1) )
            .join(' ');  
}

tinymce.init({
    selector: '#txtSeguimiento',
    width: "100%",
    height: 400,    
    statubar: true,
    plugins: [
        "advlist autolink link image lists charmap print preview hr anchor pagebreak",
        "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
        "save table contextmenu directionality emoticons template paste textcolor"
    ],
    toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | print preview media fullpage | forecolor backcolor emoticons",
});

function fntViewIncidencia(idincidencia){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Incidencias/getIncidencia/'+idincidencia;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            if(objData.status)
            {
               let estado = objData.data.estado == 'Finalizado' ? 
                '<span class="badge badge-success">Finalizado</span>' : 
                '<span class="badge badge-warning">Pendiente</span>';
                document.querySelector("#celId").innerHTML = objData.data.idincidencia;
                document.querySelector("#celAlumno").innerHTML = objData.data.nombre_alumno;
                document.querySelector("#celPersonaId").innerHTML = objData.data.nombre_persona;
                document.querySelector("#celFecha").innerHTML = objData.data.fecha_incidencia_format;
                document.querySelector("#celIncidencia").innerHTML = objData.data.incidencia;
                document.querySelector("#celStatus").innerHTML = estado;
                $('#modalViewIncidencia').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditIncidencia(element,idincidencia){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Incidencia";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Incidencias/getIncidencia/'+idincidencia;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idIncidencia").value = objData.data.idincidencia;
                document.querySelector("#txtIncidencia").value = objData.data.incidencia;
                //document.querySelector("#txtIncidencia").value = tinymce.activeEditor.setContent(objData.data.incidencia); 
                document.querySelector("#txtFecha").value = objData.data.fecha_incidencia;
                if(document.querySelector("#listAlumno"))
                {
                    document.querySelector("#listAlumno").value = objData.data.alumnoid;
                    $('#listAlumno').selectpicker('render');
                }
                if(document.querySelector("#listStatus"))
                {
                    document.querySelector("#listStatus").value = objData.data.status;
                    $('#listStatus').selectpicker('render');
                }
               
            }
        }
    
        $('#modalFormIncidencias').modal('show');
    }
}

function fntSeguimiento(element,idincidencia){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Incidencia";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";

    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Incidencias/getIncidencia/'+idincidencia;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                if(objData.data.seguimiento != null)
                {
                    document.querySelector("#txtSeguimiento").value = tinymce.activeEditor.setContent(objData.data.seguimiento); 
                }

                document.querySelector("#idIncidenciaS").value = objData.data.idincidencia;
                document.querySelector("#txtAlumnoIncidencia").value = objData.data.nombre_alumno; 
                document.querySelector("#txtFechaIncidencia").value = objData.data.fecha_incidencia;
                document.querySelector("#txtNivel").value = objData.data.nivel;
                document.querySelector("#txtPersona").value = objData.data.nombre_persona;
                document.querySelector("#txtIncidenciaSeguimiento").value = objData.data.incidencia;
                
                
                if(document.querySelector("#listEstado"))
                {
                    document.querySelector("#listEstado").value = objData.data.estado;
                    $('#listEstado').selectpicker('render');
                }
                if(document.querySelector("#listStatus"))
                {
                    document.querySelector("#listStatus").value = objData.data.status;
                    $('#listStatus').selectpicker('render');
                }
               
            }
        }
    
        $('#modalFormIncidenciasContencion').modal('show');
    }
}

function fntDelIncidencia(idincidencia){
    swal({
        title: "Eliminar Incidencia",
        text: "¿Realmente quiere eliminar el registro de la incidencia?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Incidencias/delIncidencia';
            let strData = "idincidencia="+idincidencia;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableIncidencias.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });
}

function fntEditEstado(element, idincidencia){
    rowTable = element.parentNode.parentNode;
    let estado = element.getAttribute("estado");
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Incidencias/actualizarEstado/';
    request.open("POST",ajaxUrl,true);
    let formData = new FormData();
    formData.append("idincidencia",idincidencia);
    formData.append("estado",estado);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {    
                rowTable.cells[5].innerHTML = objData.btnEstado;
                //rowTable.cells[8].innerHTML = objData.fecha;
                rowTable = ""; 
                swal("Incidencias", objData.msg ,"success");
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idIncidencia').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nueva Incidencia";
    document.querySelector("#formIncidencias").reset();
    if(document.querySelector("#listAlumno"))
    {
        document.querySelector("#listAlumno").value = 0;
        $('#listAlumno').selectpicker('render');
    }
    if(document.querySelector("#listEstado"))
    {
        document.querySelector("#listEstado").value = 1;
        $('#listEstado').selectpicker('render');
    }
    $('#modalFormIncidencias').modal('show');
}
