let tableMaterias;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

    tableMaterias = $('#tableMaterias').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Materias/getMaterias",
            "dataSrc":""
        },
        "columns":[
            {"data":"idmateria", visible: false},
            {"data":"clave_materia"},
            {"data":"materia"},
            {"data":"duracion"},
            {"data":"semestre"},
            {"data":"antecesora"},
            {"data":"carrera"},
            {"data":"carrera_format"},
            {"data":"status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[2,"asc"]]  
    });

    if(document.querySelector("#formMaterias")){
        let formMaterias = document.querySelector("#formMaterias");
        formMaterias.onsubmit = function(e) {
            e.preventDefault();
            //let strNombreUsuario= document.querySelector('#txtUsuario').value;
            let strClave= document.querySelector('#txtClave').value;
            let strClaveFormat = strClave.toLocaleUpperCase();
            let strMateria= document.querySelector('#txtMateria').value;
            let strMateriaFormat = strMateria.toLocaleUpperCase();
            let intDuracion= document.querySelector('#txtDuracion').value;
            let intSemestre= document.querySelector('#txtSemestre').value;
            let antecesoraId= document.querySelector('#listAntecesora').value;
            let intCarreraId= document.querySelector('#listCarrera').value;
            let intNivelId= document.querySelector('#listNivel').value;
            let intStatus= document.querySelector('#listStatus').value;
            
            if(strMateria == '' || intDuracion == '' || intSemestre == '' ||intCarreraId == 0 ||  intNivelId == 0 || intStatus == '')
            {
                swal("Atención", "Favor de llenar todos los campos obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            //tinyMCE.triggerSave();
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Materias/setMateria'; 
            let formData = new FormData(formMaterias);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        if(rowTable == ""){
                            tableMaterias.api().ajax.reload();
                        }else{
                            htmlStatus = intStatus == 1 ? 
                            '<span class="badge badge-success">Activo</span>' : 
                            '<span class="badge badge-danger">Inactivo</span>';
                            let carreraFormat = objData.carrera_format;
                            rowTable.cells[0].textContent = strClaveFormat;
                            rowTable.cells[1].textContent = strMateriaFormat;
                            rowTable.cells[2].textContent = intDuracion;
                            rowTable.cells[3].textContent = intSemestre;
                            if(antecesoraId != 0){
                                rowTable.cells[4].textContent = document.querySelector("#listAntecesora").selectedOptions[0].text;
                            }
                            rowTable.cells[5].textContent = document.querySelector("#listCarrera").selectedOptions[0].text;
                            rowTable.cells[6].textContent = objData.data.carrera_format;
                            /*rowTable.cells[8].textContent = strNombreUsuario;
                            rowTable.cells[9].textContent = objData.fecha;
                            rowTable.cells[10].textContent = objData.movimiento;*/
                            rowTable.cells[7].innerHTML = htmlStatus;
                            rowTable = ""; 
                        }
                        $('#modalFormMaterias').modal("hide");
                        formMaterias.reset();
                        swal("Materias", objData.msg ,"success");
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }
})

function formatearPalabra(val) {
  return val.toLowerCase()
            .trim()
            .split(' ')
            .map( v => v[0].toUpperCase() + v.substr(1) )
            .join(' ');  
}

function palabrasMayus(val) {
  return val.toUpperCase()
}

function fntViewMateria(idmateria){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Materias/getMateria/'+idmateria;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            if(objData.status)
            {
               let estado = objData.data.status == 1 ? 
                '<span class="badge badge-success">Activo</span>' : 
                '<span class="badge badge-danger">Inactivo</span>';
                document.querySelector("#celClave").innerHTML = objData.data.clave_materia;
                document.querySelector("#celMateria").innerHTML = objData.data.materia;
                document.querySelector("#celDuracion").innerHTML = objData.data.duracion;
                document.querySelector("#celSemestre").innerHTML = objData.data.semestre;
                document.querySelector("#celAntecesora").innerHTML = objData.data.antecesora;
                document.querySelector("#celNivel").innerHTML = objData.data.carrera;
                document.querySelector("#celCarrera").innerHTML = objData.data.carrera_format;
                document.querySelector("#celUltimaModificacion").innerHTML = objData.data.ultima_modificacion_format;
                document.querySelector("#celStatus").innerHTML = estado;
                $('#modalViewMateria').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditMateria(element,idmateria){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Materia";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Materias/getMateria/'+idmateria;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idMateria").value = objData.data.idmateria;
                document.querySelector("#txtClave").value = objData.data.clave_materia;
                document.querySelector("#txtMateria").value = objData.data.materia;
                document.querySelector("#txtDuracion").value = objData.data.duracion;
                document.querySelector("#txtSemestre").value = objData.data.semestre;
                if(document.querySelector("#listNivel"))
                {
                    document.querySelector("#listNivel").value = objData.data.nivelid;
                    $('#listNivel').selectpicker('render');
                }
                if(document.querySelector("#listCarrera"))
                {
                    document.querySelector("#listCarrera").value = objData.data.carreraid;
                    $('#listCarrera').selectpicker('render');
                }
                if(document.querySelector("#listAntecesora"))
                {
                    if(objData.data.antecesora == 0)
                    {
                        document.querySelector("#listAntecesora").value = 0;
                        $('#listAntecesora').selectpicker('render');
                    }else{
                        document.querySelector("#listAntecesora").value = objData.data.antecesoraid;
                        $('#listAntecesora').selectpicker('render');
                    }
                }
                if(document.querySelector("#listStatus"))
                {
                    document.querySelector("#listStatus").value = objData.data.status;
                    $('#listStatus').selectpicker('render');
                }
               
            }
        }
    
        $('#modalFormMaterias').modal('show');
    }
}

function fntDelMateria(idmateria){
    swal({
        title: "Eliminar Materia",
        text: "¿Realmente quiere eliminar el registro de la materia?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Materias/delMateria';
            let strData = "idmateria="+idmateria;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableMaterias.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idMateria').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nueva Materia";
    document.querySelector("#formMaterias").reset();

    /*let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Materias/getAntecesoras';
    request.open("POST",ajaxUrl,true);
    request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                const listAntecesora = document.querySelector("#listAntecesora");

                if (listAntecesora) {
                    // 1. Vaciar el select de forma segura
                    listAntecesora.innerHTML = "";

                    // 2. Crear y agregar la opción por defecto
                    let defaultOption = document.createElement("option");
                    defaultOption.value = "0";
                    defaultOption.textContent = "Seleccione una materia";
                    defaultOption.selected = true; // Establecer 'selected' programáticamente
                    listAntecesora.appendChild(defaultOption);

                    // 3. Recorrer objData.data y generar las demás options
                    objData.data.forEach(item => {
                        let option = document.createElement("option");
                        option.value = item.idmateria;
                        option.textContent = `${item.carrera_format} / ${item.materia}`;

                        // Agregar al select
                        listAntecesora.appendChild(option);
                    });

                    // 4. Refrescar selectpicker
                    // **ESTA LÍNEA ES CRÍTICA PARA QUE EL PLUGIN RECONOZCA LOS CAMBIOS**
                    $('#listAntecesora').selectpicker('refresh'); 
                }
            }
        }
    }*/

    if(document.querySelector("#listNivel"))
    {
        document.querySelector("#listNivel").value = 0;
        $('#listNivel').selectpicker('render');
    }
    if(document.querySelector("#listCarrera"))
    {
        document.querySelector("#listCarrera").value = 0;
        $('#listCarrera').selectpicker('render');
    }
    if(document.querySelector("#listAntecesora"))
    {
        document.querySelector("#listAntecesora").value = 0;
        $('#listAntecesora').selectpicker('refresh');
    }
    if(document.querySelector("#listStatus"))
    {
        document.querySelector("#listStatus").value = 1;
        $('#listStatus').selectpicker('render');
    }
    $('#modalFormMaterias').modal('show');
}
