let tableGrupos;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

})

//Vista anterior, mostrando solo la última calificación
if(document.querySelector("#formBusqueda")){
    let formBusqueda = document.querySelector("#formBusqueda");
    formBusqueda.onsubmit = function(e) {
        e.preventDefault();
        
        let intCarreraId = document.querySelector("#listCarreras").value;
        let strGrupo = '';
        let intMateriaId = '';
        let strPrimero = document.querySelector("#cbPrimero").checked;
        let strSegundo = document.querySelector("#cbSegundo").checked;
        let strTercero = document.querySelector("#cbTercero").checked;
        let strCuarto = document.querySelector("#cbCuarto").checked;
        let strQuinto = document.querySelector("#cbQuinto").checked;
        let strSexto = document.querySelector("#cbSexto").checked;
        let strSeptimo = document.querySelector("#cbSeptimo").checked;
        let strOctavo = document.querySelector("#cbOctavo").checked;
        let strNoveno = document.querySelector("#cbNoveno").checked;
        let strAll = document.querySelector("#rbAll").checked;
        //let srtCustom = document.querySelector("#rbCustom").checked;
        let strOption = (strAll == 1) ? 'Todos' : 'Custom';

        let primero = (strPrimero == true) ? 1 : 0;
        let segundo = (strSegundo == true) ? 1 : 0;
        let tercero = (strTercero == true) ? 1 : 0;
        let cuarto = (strCuarto == true) ? 1 : 0;
        let quinto = (strQuinto == true) ? 1 : 0;
        let sexto = (strSexto == true) ? 1 : 0;
        let septimo = (strSeptimo == true) ? 1 : 0;
        let octavo = (strOctavo == true) ? 1 : 0;
        let noveno = (strNoveno == true) ? 1 : 0;

        if(document.querySelector("#listGrupos")){
            strGrupo = document.querySelector("#listGrupos").value;
        }
        if(document.querySelector("#listMaterias")){
            intMateriaId = document.querySelector("#listMaterias").value;
        }

        if(intCarreraId == '' || intCarreraId == 0 || strGrupo == '' || strGrupo == 0 || intMateriaId == '' || intMateriaId == 0)
        {
            swal("Atención", "Todos los campos son obligatorios." , "error");
            return false;
        }

        let elementsValid = document.getElementsByClassName("valid");
        for (let i = 0; i < elementsValid.length; i++) { 
            if(elementsValid[i].classList.contains('is-invalid')) { 
                swal("Atención", "Por favor verifique los campos en rojo." , "error");
                return false;
            } 
        } 
        divLoading.style.display = "flex";
        let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
        let ajaxUrl = base_url+'/Pgrupal/getBusquedaAlumno'; 
        let formData = new FormData(formBusqueda);
        request.open("POST",ajaxUrl,true);
        formData.append('primero', primero);
        formData.append('segundo', segundo);
        formData.append('tercero', tercero);
        formData.append('cuarto', cuarto);
        formData.append('quinto', quinto);
        formData.append('sexto', sexto);
        formData.append('septimo', septimo);
        formData.append('octavo', octavo);
        formData.append('noveno', noveno);
        request.send(formData);
        request.onreadystatechange = function(){
            if(request.readyState == 4 && request.status == 200){
                let objData = JSON.parse(request.responseText);
                if(objData.status)
                {
                    console.log(objData.data);
                    $('.divAlumnos').html("");
                    $('#divBoton').html("");
                    $('#divPromedio').html("");
                    document.getElementById("formularioCalificaciones").style.display = "";

                    // Encabezado reducido
                    $('.divAlumnos').append(
                        '<div class="form-row">'+
                            '<div class="form-group col-md-2"><label>Matricula</label></div>'+
                            '<div class="form-group col-md-5"><label>Alumno</label></div>'+
                            '<div class="form-group col-md-3"><label>Fecha Calificación</label></div>'+
                            '<div class="form-group col-md-2"><label>Calificación</label></div>'+
                        '</div>'
                    );
                    // Recorrer las materias
                    for (var i = 0; i < objData.data.length; i++) {
                        const item = objData.data[i];

                        // Determinar la última calificación válida (d → c → b → a)
                        let ultimaCalificacion = "";
                        let fechaUltima = item.fecha_a_format || "";

                        if (item.calificacion_d && item.calificacion_d.trim() !== "") {
                            ultimaCalificacion = item.calificacion_d;
                            fechaUltima = item.fecha_d_format || fechaUltima;
                        } else if (item.calificacion_c && item.calificacion_c.trim() !== "") {
                            ultimaCalificacion = item.calificacion_c;
                            fechaUltima = item.fecha_c_format || fechaUltima;
                        } else if (item.calificacion_b && item.calificacion_b.trim() !== "") {
                            ultimaCalificacion = item.calificacion_b;
                            fechaUltima = item.fecha_b_format || fechaUltima;
                        } else if (item.calificacion_a && item.calificacion_a.trim() !== "") {
                            ultimaCalificacion = item.calificacion_a;
                            fechaUltima = item.fecha_a_format || fechaUltima;
                        }

                        // Crear la fila con solo 1 input de calificación
                        const filaHTML =
                            '<div class="form-row materia-row" data-index="' + i + '" data-materiaid="'+ (item.materiaid || '') +'">' +
                                '<div class="form-group col-md-2">' +
                                    '<input class="form-control" type="text" value="' + (item.matricula || '') + '" readonly>' +
                                '</div>' +
                                '<div class="form-group col-md-5">' +
                                    '<input class="form-control" type="text" value="' + (item.nombre_alumno || '') + '" readonly>' +
                                '</div>' +
                                '<div class="form-group col-md-3">' +
                                    '<input class="form-control" type="text" value="' + fechaUltima + '" readonly>' +
                                '</div>' +
                                '<div class="form-group col-md-2">' +
                                    '<input class="form-control calificacion-input" type="text" value="' + (ultimaCalificacion || '') + '" readonly>' +
                                '</div>' +
                            '</div>';

                        $('.divAlumnos').append(filaHTML);

                        // Validar el input para colorear según valor
                        const input = $('.divAlumnos .materia-row:last-child .calificacion-input')[0];
                        if (input) validarCalificacion(input);
                    }

                    // Botón PDF
                    $('#divBoton').append(
                        '<a title="Generar PDF" href="'+objData.url+'/Pgrupal/formatoPromedioGrupal/'+objData.data[0].carreraid+'/'+objData.data[0].grupoid+'/'+objData.data[0].materiaid+'/'+strOption+'/'+primero+'/'+segundo+'/'+tercero+'/'+cuarto+'/'+quinto+'/'+sexto+'/'+septimo+'/'+octavo+'/'+noveno+'" target="_blanck" class="btn btn-danger btn-sm"> <i class="fas fa-file-pdf"></i> Generar Reporte</a>'
                    )

                    // Campo Promedio
                    $('#divPromedio').append(
                        '<label>Promedio</label>' +
                        '<input class="form-control" type="text" id="txtPromedio" name="txtPromedio" value="0.00" placeholder="Promedio Alumno" readonly>'
                    );

                    // Calcular promedio inicial
                    recalculatePromedio();
                    document.querySelector("#txtNivel").value = objData.data[0].nivel;
                    document.querySelector("#txtCarrera").value = objData.data[0].carrera;
                    document.querySelector("#txtMateria").value = objData.data[0].materia;
                    document.querySelector("#txtDocente").value = objData.data[0].nombre_docente;
                    document.querySelector("#txtSemestre").value = objData.data[0].semestre;
                }else{
                    swal("¡Advertencia!", objData.msg , "warning");
                    document.getElementById("formularioCalificaciones").style.display = "none";
                }


            }
            divLoading.style.display = "none";
            return false;
        }
    }
}

//Vista nueva mostrando todas la calificaciones (parcial, ordinario, extraordinario y recursamiento)
/*if(document.querySelector("#formBusqueda")){
    let formBusqueda = document.querySelector("#formBusqueda");
    formBusqueda.onsubmit = function(e) {
        e.preventDefault();
        
        let intCarreraId = document.querySelector("#listCarreras").value;
        let strGrupo = '';
        let intMateriaId = '';
        let strPrimero = document.querySelector("#cbPrimero").checked;
        let strSegundo = document.querySelector("#cbSegundo").checked;
        let strTercero = document.querySelector("#cbTercero").checked;
        let strCuarto = document.querySelector("#cbCuarto").checked;
        let strQuinto = document.querySelector("#cbQuinto").checked;
        let strSexto = document.querySelector("#cbSexto").checked;
        let strSeptimo = document.querySelector("#cbSeptimo").checked;
        let strOctavo = document.querySelector("#cbOctavo").checked;
        let strNoveno = document.querySelector("#cbNoveno").checked;
        let strAll = document.querySelector("#rbAll").checked;
        //let srtCustom = document.querySelector("#rbCustom").checked;
        let strOption = (strAll == 1) ? 'Todos' : 'Custom';

        let primero = (strPrimero == true) ? 1 : 0;
        let segundo = (strSegundo == true) ? 1 : 0;
        let tercero = (strTercero == true) ? 1 : 0;
        let cuarto = (strCuarto == true) ? 1 : 0;
        let quinto = (strQuinto == true) ? 1 : 0;
        let sexto = (strSexto == true) ? 1 : 0;
        let septimo = (strSeptimo == true) ? 1 : 0;
        let octavo = (strOctavo == true) ? 1 : 0;
        let noveno = (strNoveno == true) ? 1 : 0;

        if(document.querySelector("#listGrupos")){
            strGrupo = document.querySelector("#listGrupos").value;
        }
        if(document.querySelector("#listMaterias")){
            intMateriaId = document.querySelector("#listMaterias").value;
        }

        if(intCarreraId == '' || intCarreraId == 0 || strGrupo == '' || strGrupo == 0 || intMateriaId == '' || intMateriaId == 0)
        {
            swal("Atención", "Todos los campos son obligatorios." , "error");
            return false;
        }

        let elementsValid = document.getElementsByClassName("valid");
        for (let i = 0; i < elementsValid.length; i++) { 
            if(elementsValid[i].classList.contains('is-invalid')) { 
                swal("Atención", "Por favor verifique los campos en rojo." , "error");
                return false;
            } 
        } 
        divLoading.style.display = "flex";
        let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
        let ajaxUrl = base_url+'/Pgrupal/getBusquedaAlumno'; 
        let formData = new FormData(formBusqueda);
        request.open("POST",ajaxUrl,true);
        formData.append('primero', primero);
        formData.append('segundo', segundo);
        formData.append('tercero', tercero);
        formData.append('cuarto', cuarto);
        formData.append('quinto', quinto);
        formData.append('sexto', sexto);
        formData.append('septimo', septimo);
        formData.append('octavo', octavo);
        formData.append('noveno', noveno);
        request.send(formData);
        request.onreadystatechange = function(){
            if(request.readyState == 4 && request.status == 200){
                let objData = JSON.parse(request.responseText);
                if(objData.status)
                {
                    
                    $('.divAlumnos').html("");
                    $('#divBoton').html("");
                    $('#divPromedio').html("");
                    document.getElementById("formularioCalificaciones").style.display = "";

                    // header
                    $('.divAlumnos').append(
                        '<div class="form-row">'+
                            '<div class="form-group col-md-2"><label>Matricula</label></div>'+
                            '<div class="form-group col-md-4"><label>Alumno</label></div>'+
                            '<div class="form-group col-md-2"><label>Fecha Calificación</label></div>'+
                            '<div class="form-group col-md-2"><label>Tipo</label></div>'+
                            '<div class="form-group col-md-2"><label>Calificación</label></div>'+
                        '</div>'
                    );

                    // Por cada materia del array
                    for (var i = 0; i < objData.data.length; i++) {
                        const item = objData.data[i];

                        // nombres/ids únicos por índice
                        const idA = 'txtCalificacion_a_' + i;
                        const idB = 'txtCalificacion_b_' + i;
                        const idC = 'txtCalificacion_c_' + i;
                        const idD = 'txtCalificacion_d_' + i;

                        // fila por materia (nota: usamos estructura anidada para mostrar 4 inputs en 2x2)
                        const filaHTML =
                            '<div class="form-row materia-row" data-index="' + i + '" data-materiaid="'+ (item.materiaid || '') +'">' +
                                '<div class="form-group col-md-2">' +
                                    '<input class="form-control" type="text" id="txtMatricula' + i + '" name="txtMatricula" value="' + (item.matricula || '') + '" readonly>' +
                                '</div>' +
                                '<div class="form-group col-md-4">' +
                                    '<input class="form-control" type="text" id="txtAlumno' + i + '" name="txtAlumno" data-alumnoid="' + (item.alumnoid || '') + '" value="' + (item.nombre_alumno || '') + '" readonly>' +
                                '</div>' +
                                '<div class="form-group col-md-2">' +
                                    '<input class="form-control" type="text" id="txtFechaCalificacion_' + i + '" name="txtFechaCalificacion[]" value="' + (item.fecha_a_format || '') + '" readonly>' +
                                '</div>' +
                                '<div class="form-group col-md-2">' +
                                    '<input class="form-control" value="Parcial" readonly="" />' +
                                    '<input class="form-control" value="Ordinario" readonly="" />' +
                                    '<input class="form-control" value="Extraordinario" readonly="" />' +
                                    '<input class="form-control" value="Recursamiento" readonly="" />' +
                                '</div>' +
                                '<div class="form-group col-md-2">' +
                                    '<div class="form-row">' +
                                        // Calif. Parcial (a)
                                        '<input class="form-control calificacion-input cal-a" type="text" id="' + idA + '" name="txtCalificacion_a[]" value="' + (item.calificacion_a || '') + '" oninput="validarCalificacion(this);recalculatePromedio();" readonly="">' +
                                        
                                        // Calif. Ordinario (b)
                                        '<input class="form-control calificacion-input cal-b" type="text" id="' + idB + '" name="txtCalificacion_b[]" value="' + (item.calificacion_b || '') + '" oninput="validarCalificacion(this);recalculatePromedio();" readonly="">' +
                                        
                                        // Calif. Extraordinario (c)
                                        '<input class="form-control calificacion-input cal-c" type="text" id="' + idC + '" name="txtCalificacion_c[]" value="' + (item.calificacion_c || '') + '" oninput="validarCalificacion(this);recalculatePromedio();" readonly="">' +
                                        
                                        // Calif. Recursamiento (d)
                                        '<input class="form-control calificacion-input cal-d" type="text" id="' + idD + '" name="txtCalificacion_d[]" value="' + (item.calificacion_d || '') + '" oninput="validarCalificacion(this);recalculatePromedio();" readonly="">' +
                                        
                                    '</div>' +
                                '</div>' +
                            '</div>';

                        $('.divAlumnos').append(filaHTML);

                        // Inicializar validación para estos 4 inputs (para que dataset.valorNumerico quede poblado)
                        const inputsIds = [idA, idB, idC, idD];
                        inputsIds.forEach(function(elId){
                            const inp = document.getElementById(elId);
                            if (inp) {
                                validarCalificacion(inp);
                            }
                        });
                    } // fin for

                    // Botón PDF (igual que antes)
                    $('#divBoton').append(
                        '<a title="Generar PDF" href="'+objData.url+'/Pindividual/formatoPromedioIndividual/'+objData.data[0].alumnoid+'/'+strOption+'/'+primero+'/'+segundo+'/'+tercero+'/'+cuarto+'/'+quinto+'/'+sexto+'/'+septimo+'/'+octavo+'/'+noveno+'" target="_blank" class="btn btn-danger btn-sm"> <i class="fas fa-file-pdf"></i> Generar Reporte</a>'
                    );

                    // Mostrar campo Promedio (se actualizará por recalculatePromedio)
                    $('#divPromedio').append(
                        '<label>Promedio</label>' +
                        '<input class="form-control" type="text" id="txtPromedio" name="txtPromedio" value="0.00" placeholder="Promedio Alumno" readonly>'
                    );

                    // Calcular promedio inicial (toma la última calificación válida por materia)
                    recalculatePromedio();
                    document.querySelector("#txtNivel").value = objData.data[0].nivel;
                    document.querySelector("#txtCarrera").value = objData.data[0].carrera;
                    document.querySelector("#txtMateria").value = objData.data[0].materia;
                    document.querySelector("#txtDocente").value = objData.data[0].nombre_docente;
                }else{
                    swal("¡Advertencia!", objData.msg , "warning");
                    document.getElementById("formularioCalificaciones").style.display = "none";
                }


            }
            divLoading.style.display = "none";
            return false;
        }
    }
}*/

$("#formBusqueda").on("change", "select#listCicloEscolar", function(){
    let cicloid = $(this).val();
    if (cicloid == "" || cicloid == 0) {
        swal("Atención", "Tiene que seleccionar un ciclo escolar." , "error");
        document.querySelector('.divCarreras').style.display = 'none';
        document.querySelector('#listCarreras').value = 0;
        $('#listCarreras').selectpicker('render');
        return false;
    }else{
        document.querySelector('.divCarreras').style.display = 'block';
    }
})

$("#formBusqueda").on("change", "select#listCarreras", function(){
    let carreraid = $(this).val();
    let cicloid = $("#listCicloEscolar").val();
    if (carreraid == "") {
        swal("Atención", "Tiene que seleccionar una carrera." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Pgrupal/getGrupos/';
    request.open("POST",ajaxUrl,true);
    let formData = new FormData();
    formData.append("carreraid", carreraid);
    formData.append("cicloid", cicloid);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionGrupos = "";
                optionGrupos += '<option value="0" selected>Seleccionar Grupo</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionGrupos += '<option value="'+objData.data[i].idgrupo+'">'+objData.data[i].grado+'-'+objData.data[i].grupo+'</option>';
                }

                $('#divGrupos').html("");
                $('#divMaterias').html("");
                $('#divGrupos').append(
                    '<label for="listGrupos">Grupos</label>'+
                    ' <select class="form-control selectpicker" data-live-search="true" id="listGrupos" name="listGrupos" required>'+
                        optionGrupos+
                    '</select>'
                );

                $('#listGrupos').selectpicker('render');
                
                swal("Grupos", objData.msg, "success");
            }else{
                document.getElementById("formularioCalificaciones").style.display = "none";
                $('#divGrupos').html("");
                $('#divMaterias').html("");
                document.getElementById("divOptions").style.display = "none";
                document.getElementById("divSemestres").style.display = "none";
                document.getElementById("rbAll").setAttribute("checked","");
                document.getElementById("rbCustom").removeAttribute("checked");
                swal("Error", objData.msg , "error");
            }
        }
    }
    
})

$("#formBusqueda").on("change", "select#listGrupos", function(){
    let intGrupoId = $(this).val();
    let intCarreraId = document.querySelector("#listCarreras").value;
    if (intGrupoId == "" || intGrupoId == 0) {
        swal("Atención", "Tiene que seleccionar un Grupo." , "error");
                return false;
    }    
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Pgrupal/getMaterias';
    request.open("POST",ajaxUrl,true);
    let formData = new FormData();
    formData.append("carreraid", intCarreraId);
    formData.append("grupoid", intGrupoId);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let optionMaterias = "";
                optionMaterias += '<option value="0" selected>Seleccionar Materia</option>';
                for (let i = 0; i < objData.data.length; i++) 
                {
                    optionMaterias += '<option value="'+objData.data[i].idmateria+'">'+objData.data[i].materia+'</option>';
                }

                $('#divMaterias').html("");
                document.getElementById("divOptions").style.display = "block";

                $('#divMaterias').append(
                    '<label for="listMaterias">Materia</label>'+
                    ' <select class="form-control selectpicker" data-live-search="true" id="listMaterias" name="listMaterias" required>'+
                        optionMaterias+
                    '</select>'
                );

                $('#listMaterias').selectpicker('render');
                $('#listOption').selectpicker('render');
                
                swal("Materias", objData.msg, "success");
            }else{
                document.getElementById("formularioCalificaciones").style.display = "none";
                document.getElementById("divOptions").style.display = "none";
                document.getElementById("divSemestres").style.display = "none";
                document.getElementById("rbAll").setAttrib("checked");
                document.getElementById("rbCustom").removeAttribute("checked");
                $('#divMaterias').html("");
                swal("Error", objData.msg , "error");
            }
        }
    }
    
})

function validarCalificacion(input) {
    const valor = input.value.trim();
    let esValido = false;
    let valorNumerico = "";

    // Validar número 0–100
    if (/^(100|[1-9]?[0-9])$/.test(valor)) {
        esValido = true;
        valorNumerico = parseFloat(valor);
    }
    // Validar texto AC/ac
    else if (/^(AC|ac)$/.test(valor)) {
        esValido = true;
        valorNumerico = 100;
    }
    // Validar texto NA/na
    else if (/^(NA|na)$/.test(valor)) {
        esValido = true;
        valorNumerico = 50;
    }

    // Guardar el valor numérico como atributo para cálculos
    input.dataset.valorNumerico = esValido ? valorNumerico : "";

    // Limpiar clases previas
    input.classList.remove("input-valido", "input-invalido");

    // Aplicar clase según resultado
    if (valor === "") {
        // sin color si está vacío
    } else if (esValido) {
        input.classList.add("input-valido");
    } else {
        input.classList.add("input-invalido");
    }
}

// Recalcula el promedio tomando la última calificación válida por materia
function recalculatePromedio() {
    let sumatoria = 0;
    let contador = 0;

    // Iterar sobre cada materia
    document.querySelectorAll('.materia-row').forEach(row => {
        const inputs = row.querySelectorAll('.calificacion-input');

        // Buscar en orden inverso: D → C → B → A
        let calificacionValida = null;
        for (let i = inputs.length - 1; i >= 0; i--) {
            const val = inputs[i].value.trim();
            if (val !== "") {
                // Convertir el valor textual a numérico
                if (/^(100|[1-9]?[0-9])$/.test(val)) {
                    calificacionValida = parseFloat(val);
                } else if (/^(AC|ac)$/.test(val)) {
                    calificacionValida = 100;
                } else if (/^(NA|na)$/.test(val)) {
                    calificacionValida = 50;
                }
                // Si encontramos una válida, no seguimos revisando
                if (calificacionValida !== null) break;
            }
        }

        // Si encontramos calificación válida, sumamos
        if (calificacionValida !== null) {
            sumatoria += calificacionValida;
            contador++;
        }
    });

    // Calcular promedio
    let promedio = contador > 0 ? (sumatoria / contador) : 0;

    // Mostrarlo con 2 decimales
    const promedioInput = document.getElementById("txtPromedio");
    if (promedioInput) {
        promedioInput.value = promedio.toFixed(2);
    }
}

$("#formBusqueda").on("change", "input#rbCustom", function(){
    document.getElementById("divSemestres").style.display = "block";
})  

$("#formBusqueda").on("change", "input#rbAll", function(){
    document.getElementById("divSemestres").style.display = "none";
})  
