let tableMaterias;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){

    tableMaterias = $('#tableMaterias').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Materias/getMaterias",
            "dataSrc":""
        },
        "columns":[
            {"data":"idmateria", visible: false},
            {"data":"clave_materia"},
            {"data":"materia"},
            {"data":"duracion"},
            {"data":"semestre"},
            {"data":"antecesora"},
            {"data":"nivel"},
            {"data":"carrera"},
            {"data":"status"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[2,"asc"]]  
    });

    if(document.querySelector("#formDatos")){
        let formDatos = document.querySelector("#formDatos");
        formDatos.onsubmit = function(e) {
            e.preventDefault();
            //let strNombreUsuario= document.querySelector('#txtUsuario').value;
            let strNombres = document.querySelector('#txtNombres').value;
            let strApellidos = document.querySelector('#txtApellidos').value;
            let strFechaNacimiento = document.querySelector('#txtFechaNacimiento').value;
            let strCurp = document.querySelector('#txtCurp').value;
            let strTelefonoCelular = document.querySelector('#txtTelefonoCelular').value;
            let strTelefonoFijo = document.querySelector('#txtTelefonoFijo').value;
            let strEmail = document.querySelector('#txtEmail').value;
            let strCalle = document.querySelector('#txtCalle').value;
            let strNumeroExterior = document.querySelector('#txtNumeroExterior').value;
            let strNumeroInterior = document.querySelector('#txtNumeroInterior').value;
            let strColonia = document.querySelector('#txtColonia').value;
            let strLocalidad = document.querySelector('#txtLocalidad').value;
            let strSemestreActual = document.querySelector('#txtSemestreActual').value;
            let strSemestreNuevo = document.querySelector('#txtSemestreNuevo').value;
            //Campos opcionales dependiendiendo el nivel educativo
            let strNombreTutor = document.querySelector('#txtNombreTutor').value;
            let strTelefonoTutor = document.querySelector('#txtTelefonoTutor').value;
            let strNombreEmpresa = document.querySelector('#txtNombreEmpresa').value;
            let strTelefonoEmpresa = document.querySelector('#txtTelefonoEmpresa').value;

            if(strNombres == '' || strApellidos == '' || strFechaNacimiento == '' || strCurp == '' || 
                strTelefonoCelular == '' ||  strTelefonoFijo == '' || strEmail == '' || strCalle == '' || 
                strNumeroExterior == '' || strColonia == '' || strLocalidad == '' ||
                strSemestreActual == '' || strSemestreNuevo == '')
            {
                swal("Atención", "Favor de llenar todos los campos obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Reinscripciones/setReinscripcion'; 
            let formData = new FormData(formDatos);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Reinscripciones", objData.msg ,"success");

                        setTimeout(function(){
                        window.location.reload(true);
                    }, 2000);
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }
})

function formatearPalabra(val) {
  return val.toLowerCase()
            .trim()
            .split(' ')
            .map( v => v[0].toUpperCase() + v.substr(1) )
            .join(' ');  
}

function palabrasMayus(val) {
  return val.toUpperCase()
}
