let tableSolicitudes;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){
    tableSolicitudes = $('#tableSolicitudes').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "url": "https://cdn.datatables.net/plug-ins/2.0.5/i18n/es-ES.json"
        },
        "ajax":{
            "url": " "+base_url+"/Solicitudes/getSolicitudes",
            "dataSrc":""
        },
        "columns":[
            {"data":"idsolicitud", visible:false},
            {"data":"solicitante"},
            {"data":"descripcion"},
            {"data":"fecha", visible:false},
            {"data":"format_fecha"},
            {"data":"comentarios"},
            {"data":"btnEstado"},
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 50,
        "order":[[3,"desc"]]  
    });

    if(document.querySelector("#formSolicitudes")){
        let formSolicitudes = document.querySelector("#formSolicitudes");
        formSolicitudes.onsubmit = function(e) {
            e.preventDefault();
            let strSolicitante= document.querySelector('#txtSolicitante').value;
            let strSolicitanteFormat = strSolicitante.toLocaleUpperCase();
            let strDescripcion= document.querySelector('#txtDescripcion').value;
            let strFecha = document.querySelector('#txtFecha').value;
            let strComentarios = document.querySelector('#txtComentarios').value;
            let strEstado = document.querySelector('#listEstado').value;
            if(strSolicitante == '' || strDescripcion == '' || strFecha == '' || strEstado == '')
            {
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Solicitudes/setSolicitud'; 
            let formData = new FormData(formSolicitudes);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        if(rowTable == ""){
                            tableSolicitudes.api().ajax.reload();
                        }else{
                            tableSolicitudes.api().ajax.reload();
                            rowTable = ""; 
                        }
                        $('#modalFormSolicitudes').modal("hide");
                        formSolicitudes.reset();
                        swal("Solicitudes", objData.msg ,"success");
                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }
})

function formatearPalabra(val){
  return val.toLowerCase()
            .trim()
            .split(' ')
            .map( v => v[0].toUpperCase() + v.substr(1) )
            .join(' ');  
}

function fntViewSolicitud(idsolicitud){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Solicitudes/getSolicitud/'+idsolicitud;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
               let estado = objData.data.estado == "Terminado" ? 
                '<span class="badge badge-success">Terminado</span>' : 
                '<span class="badge badge-warning">Pendiente</span>';
                document.querySelector("#celSolicitante").innerHTML = objData.data.solicitante;
                document.querySelector("#celDescripcion").innerHTML = objData.data.descripcion;
                document.querySelector("#celFecha").innerHTML = objData.data.fecha;
                document.querySelector("#celComentarios").innerHTML = objData.data.comentarios;
                document.querySelector("#celEstado").innerHTML = estado;
                $('#modalViewSolicitud').modal('show');
            }else{
                swal("Error", objData.msg , "error");
            }
        }
    }
}

function fntEditSolicitud(element,idsolicitud){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Solicitud";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Solicitudes/getSolicitud/'+idsolicitud;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                document.querySelector("#idSolicitud").value = objData.data.idsolicitud;
                document.querySelector("#txtSolicitante").value = objData.data.solicitante;
                document.querySelector("#txtDescripcion").value = objData.data.descripcion;
                document.querySelector("#txtFecha").value = objData.data.fecha;
                document.querySelector("#txtComentarios").value = objData.data.comentarios;
                if(document.querySelector("#listEstado"))
                {
                    document.querySelector("#listEstado").value = objData.data.estado;
                    $('#listEstado').selectpicker('render');
                }
            }
        }
        $('#modalFormSolicitudes').modal('show');
    }
}

function fntDelSolicitud(idsolicitud){
    swal({
        title: "Eliminar Solicitud",
        text: "¿Realmente quiere eliminar el registro?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Solicitudes/delSolicitud';
            let strData = "idsolicitud="+idsolicitud;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableSolicitudes.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }
    });
}

function openModal()
{
    rowTable = "";
    document.querySelector('#idSolicitud').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nueva Solicitud";
    document.querySelector("#formSolicitudes").reset();
    if(document.querySelector("#listEstado"))
    {
        document.querySelector("#listEstado").value = "Pendiente";
        $('#listEstado').selectpicker('render');
    }
    $('#modalFormSolicitudes').modal('show');
}
