<?php 
	require 'Libraries/html2pdf/vendor/autoload.php';
	use Spipu\Html2Pdf\Html2Pdf;

	class Actas extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MACTAS);
		}

		public function Actas()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Generacion Acta";
			$data['page_title'] = "ACTAS <small>UAF</small>";
			$data['page_name'] = "generacion acta";
			$data['page_functions_js'] = "functions_actas.js";
			$data['carreras'] = $this->model->selectCarreras();
			$data['docentes'] = $this->model->selectDocentes();
			$this->views->getView($this,"actas",$data);
		}

		public function getGrupos($carreraid){
			if($_SESSION['permisosMod']['r']){
				$intCarreraId = intval($carreraid);
				if(intval($intCarreraId) > 0)
				{
					$arrData = $this->model->selectGrupos($intCarreraId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron grupos asignados a la carrera y nivel seleccionados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan los grupos correspondientes a la carrera y nivel seleccionados.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getMaterias(){
			if($_SESSION['permisosMod']['r']){
				$intCarreraId = intval($_POST['carreraid']);
				$strGrupo = intval($_POST['grupo']);
				if(intval($intCarreraId) > 0)
				{
					$arrData = $this->model->selectMaterias($intCarreraId, $strGrupo);
					$arrDataGeneracion = $this->model->selectGeneracion($intCarreraId, $strGrupo);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron materias asignadas a los datos seleccionados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'generacion' => $arrDataGeneracion, 'msg' => 'A continuación se listan las materias correspondientes a los datos seleccionados.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getBusquedaAlumno()
		{
			if($_POST)
			{
				if($_SESSION['permisosMod']['u'])
				{
					//$intCarreraId = intval($_POST['listCarreras']);
					$intCarreraId = intval($_POST['listCarreras']);
					$intGrupoId = intval($_POST['listGrupos']);
					$intMateriaId = intval($_POST['listMaterias']);
					$strGeneracion = strClean($_POST['listGeneracion']);
					$strTurno = strClean($_POST['listTurno']);
					$strHoraInicial = strClean($_POST['txtHoraInicial']);
					$strHoraFinal = strClean($_POST['txtHoraFinal']);
					$strExamen = strClean($_POST['listExamen']);
					$strFechaExamen = strClean($_POST['txtFechaExamen']);
					$array=[];
					$array['generacion'] = $strGeneracion;
					$array['turno'] = $strTurno;
					$array['hora_inicial'] = $strHoraInicial;
					$array['hora_final'] = $strHoraFinal;
					$array['tipo_examen'] = $strExamen;
					$array['fecha_examen'] = $strFechaExamen;
					
					$arrData = $this->model->selectKardex($intCarreraId, $intGrupoId, $intMateriaId);	
	
					
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron registros de calificaciones con los datos de la búsqueda seleccionados');
					}else{

						$calificacion="";
						for ($i=0; $i < count($arrData); $i++) { 
							$calificacion = $arrData[$i]['calificacion_a'];
							$calificacion_letra="";
							for ($j=0; $j < strlen($calificacion); $j++) {
								switch ($calificacion[$j]) {
								    case 1:
								        $calificacion_letra .= "UNO ";
								        break;
								    case 2:
								        $calificacion_letra .= "DOS ";
								        break;
							        case 3:
								        $calificacion_letra .= "TRES ";
								        break;
								    case 4:
								        $calificacion_letra .= "CUATRO ";
								        break;
							        case 5:
								        $calificacion_letra .= "CINCO ";
								        break;
								    case 6:
								        $calificacion_letra .= "SEIS ";
								        break;
							        case 7:
								        $calificacion_letra .= "SIETE ";
								        break;
								    case 8:
								        $calificacion_letra .= "OCHO ";
								        break;
							        case 9:
								        $calificacion_letra .= "NUEVE ";
								        break;

								    default:
								        $calificacion_letra .= "CERO ";
								}
							}
							$arrData[$i]['calificacion_letra'] = $calificacion_letra;
						}

						$arrResponse = array('status' => true, 'data' => $arrData, 'url' => base_url(), 'datos' => $array, 'msg' => 'A continuación se muestra el resultado de la búsqueda.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
					die();
				}

			}
			
		}

		public function formatoActa($params)
		{
			if($_SESSION['permisosMod']['r']){
				$array = explode(",", $params);
				$intCarreraId = $array[0];
				$strGrupo = $array[1];
				$intMateriaId = $array[2];
				$strGeneracion = $array[3];
				$strTurno = $array[4];
				$strHoraInicial = $array[5];
				$strHoraFinal = $array[6];
				$strTipoExamen = $array[7];
				$strFechaExamen = $array[8];

				if(intval($intCarreraId)>0){
					
					$array=[];
					$array['generacion'] = $strGeneracion;
					$array['turno'] = $strTurno;
					$array['hora_inicial'] = $strHoraInicial;
					$array['hora_final'] = $strHoraFinal;
					$array['examen'] = $strTipoExamen;
					$array['fecha_examen'] = $strFechaExamen;
					
					$arrData = $this->model->selectKardex($intCarreraId, $strGrupo, $intMateriaId);	
					

					if(empty($arrData)){
						echo "Error: Datos no encontrados, intente más tarde.";
					}else{
						$calificacion="";
						for ($i=0; $i < count($arrData); $i++) { 
							$calificacion = $arrData[$i]['calificacion_a'];
							$calificacion_letra="";
							for ($j=0; $j < strlen($calificacion); $j++) {
								switch ($calificacion[$j]) {
								    case 1:
								        $calificacion_letra .= "UNO ";
								        break;
								    case 2:
								        $calificacion_letra .= "DOS ";
								        break;
							        case 3:
								        $calificacion_letra .= "TRES ";
								        break;
								    case 4:
								        $calificacion_letra .= "CUATRO ";
								        break;
							        case 5:
								        $calificacion_letra .= "CINCO ";
								        break;
								    case 6:
								        $calificacion_letra .= "SEIS ";
								        break;
							        case 7:
								        $calificacion_letra .= "SIETE ";
								        break;
								    case 8:
								        $calificacion_letra .= "OCHO ";
								        break;
							        case 9:
								        $calificacion_letra .= "NUEVE ";
								        break;

								    default:
								        $calificacion_letra .= "CERO ";
								}
							}
							$arrData[$i]['calificacion_letra'] = $calificacion_letra;
						}
						$data=array('data' => $arrData, 'datos' => $array);
						ob_end_clean();
						$html = getFile("Template/Modals/actasPDF",$data);
						$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
						//$html2pdf->Image(media().'/images/logoVertical.png' , 10 ,100, 190 , 150,'PNG');
						$html2pdf->writeHTML($html);
						$html2pdf->output('Acta: '.$arrData[0]['grupo'].'_'.$array['fecha_examen'].'.pdf');
					}
				}else{
					echo "Dato no válido";
				}
			}else{
				header('Location: '.base_url().'/login');
				die();
			}
		}
	}

 ?>