<?php 

	class Actualizar_semestre extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MASEMESTRE);
		}

		public function Actualizar_semestre()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Actualizar Semestre";
			$data['page_title'] = "ACTUALIZAR SEMESTRE <small>UAF</small>";
			$data['page_name'] = "actualizar_semestre";
			$data['page_functions_js'] = "functions_actualizar_semestre.js";
			$data['grupos'] = $this->model->selectGrupos();
			$this->views->getView($this,"actualizar_semestre",$data);
		}

		public function getGrupos($carreraid){
			if($_SESSION['permisosMod']['r']){
				$intCarreraId = intval($carreraid);
				if(intval($intCarreraId) > 0)
				{
					$arrData = $this->model->selectGrupos($intCarreraId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron grupos relacionados con la carrera seleccionada.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan los grupos correspondientes a la carrera seleccionada.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getBusqueda()
		{
			$intGrupoId = intval($_POST['listGrupo']);

			$arrData = $this->model->selectBusqueda($intGrupoId);
			
			if(empty($arrData))
			{
				$arrData = array();
			}else{
				for ($i=0; $i < count($arrData); $i++) {
					$btnActualizar = '';

					$arrData[$i]['cb'] = '<input type="checkbox" id="chBtn" name="chBtn"  value="'.$arrData[$i]['idalumno'].'" class="chBtn" checked="">';
					
					if($_SESSION['permisosMod']['u']){
						$btnActualizar = '<button class="btn btn-info  btn-sm btnActualizarSemestre" onClick="fntActualizarSemestre(this,'.$arrData[$i]['idalumno'].')" title="Actualizar semestre"><img src="'.media().'/images/iconoActualizar.png"></img></button>';
					}
					
					$arrData[$i]['options'] = '<div class="text-center">'.$btnActualizar.'</div>';
				}
				

			}
			echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			die();
		}

		public function updateSemestre($idalumno)
		{
			
			if($_SESSION['permisosMod']['u']){
				$intIdAlumno = intval($idalumno);
				$requestGrupo = $this->model->selectGrado($intIdAlumno);
				$gradoActual = intval($requestGrupo['grado']);
				$gradoNuevo = $gradoActual + 1;

				if($gradoActual == 9)
				{
					$arrResponse = array("status" => false, "msg" => 'No es posible actualizar a un semestre superior.');
				}else{
					if(intval($gradoActual) > 0)
					{
						$requestActualizar = $this->model->aumentarSemestre($intIdAlumno,
																			$gradoNuevo);
						if(intval($requestActualizar) > 0)
						{
							$arrResponse = array('status' => true, 'msg' => 'Se actulizó correctamente el semestre');
						}else{
							$arrResponse = array('status' => false, 'msg' => 'Error al intentar actualizar el semestre');
						}
					}else{
							$arrResponse = array('status' => false, 'msg' => 'Datos erroneos, favor de intentarlo nuevamente');
					}
				}

				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getGrupoConsecutivo()
		{
			if($_POST)
			{
				if($_SESSION['permisosMod']['u'])
				{
					$registros = array();
					$registros = explode(",", $_POST['ids_array']);
					if(count($registros)>0)
					{
						$requestData = $this->model->selectGrado($registros[0]);
						if(intval($requestData) > 0)
						{
							$intGrupoId = intVal($requestData['idgrupo']);
							$idGrupoConsecutivo = intval($requestData['grupoid_consecutivo']);
						
							if($idGrupoConsecutivo > 0)
							{
								$arrResponse = array('status' => true, 'data' => $requestData);
							}else{
								$arrResponse = array("status" => false, "msg" => 'No es posible actualizar a un grupo superior.');
							}
						}else{
							$arrResponse = array('status' => false, 'msg' => 'No existe un grupo consecutivo realacionado a este grupo, favor de revisar la información en el modulo de Grupos');
						}
							
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Debe al menos seleccionar a un alumno para actualizar el grupo');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
				die();
			}
		}

		public function updateSeleccion($idalumno)
		{
			if($_POST)
			{
				if($_SESSION['permisosMod']['u'])
				{
					$registros = array();
					$registros = explode(",", $_POST['ids_array']);
					$requestData = $this->model->selectGrado($registros[0]);
					$intGrupoId = intVal($requestData['idgrupo']);
					$idGrupoConsecutivo = intval($requestData['grupoid_consecutivo']);
					if(count($registros)>0)
					{
						if($idGrupoConsecutivo == 0)
						{
							$arrResponse = array("status" => false, "msg" => 'No es posible actualizar a un grupo superior.');
						}else{
							$requestActualizar = $this->model->selectActualizar($registros, $intGrupoId, $idGrupoConsecutivo);
							if(intval($requestData) > 0)
							{
								$arrResponse = array('status' => true, 'msg' => 'Se actualizó correctamente el grupo de los alumnos seleccionados');
							}else{
								$arrResponse = array('status' => false, 'msg' => 'Error al intentar actualizar el grupo');
							}
						}
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Debe al menos seleccionar a un alumno para actualizar el grupo');
					}

					
					
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
				die();
			}
		}

	}

 ?>