<?php 

	class Adeudos extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MRESPALDOS);
		}

		public function Adeudos()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Adeudos";
			$data['page_title'] = "ADEUDOS <small>UAF</small>";
			$data['page_name'] = "Adeudos";
			$data['page_functions_js'] = "functions_adeudos.js";
			$data['alumnos'] = $this->model->selectAlumnos();
			$this->views->getView($this,"adeudos",$data);
		}

		public function setAdeudo(){
			if($_POST){	
				
				if(empty($_POST['listAlumnos']) || empty($_POST['txtAdeudo']) || empty($_POST['listStatus']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incompletos.');
				}else{ 
					$idAdeudo = intval($_POST['idAdeudo']);
					$intAlumnoId = strClean($_POST['listAlumnos']);
					$strAdeudo = strClean($_POST['txtAdeudo']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$intStatus = strClean($_POST['listStatus']);
					$strTipoMovimiento = '';
					$requestAdeudo = "";

					if($idAdeudo == 0)
					{
						$option = 1;
						$strTipoMovimiento = 'Alta';
						if($_SESSION['permisosMod']['w']){
							$requestAdeudo = $this->model->insertAdeudo($intAlumnoId,
																		$strAdeudo,
																		$strModificador,
																		$strTipoMovimiento,
																		$intStatus);
						}
					}else{
						$option = 2;
						$strTipoMovimiento = 'Actualización';
						if($_SESSION['permisosMod']['u']){
							$requestAdeudo = $this->model->updateAdeudo($idAdeudo,
																		$intAlumnoId,
																		$strAdeudo,
																		$strModificador,
																		$strTipoMovimiento,
																		$intStatus);
						}

					}

					if(intval($requestAdeudo) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
					}else if($requestAdeudo == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Este alumno ya tiene registrado un adeudo en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getAdeudos()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectAdeudos();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Activo</span>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewAdeudo" onClick="fntViewAdeudo('.$arrData[$i]['idadeudo'].')" title="Ver adeudo"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary btn-sm btnEditAdeudo" onClick="fntEditAdeudo(this,'.$arrData[$i]['idadeudo'].')" title="Editar adeudo"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelAdeudo" onClick="fntDelAdeudo('.$arrData[$i]['idadeudo'].')" title="Eliminar adeudo"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getAdeudo($idadeudo){
			if($_SESSION['permisosMod']['r']){
				$intIdAdeudo = intval($idadeudo);
				if(intval($intIdAdeudo) > 0)
				{
					$arrData = $this->model->selectAdeudo($intIdAdeudo);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delAdeudo()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdAdeudo = intval($_POST['idadeudo']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$requestDelete = $this->model->deleteAdeudo($intIdAdeudo, $strModificador);
					if(intval($requestDelete) > 0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el adeudo');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el adeudo.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>