	<?php 

class Agenda extends Controllers{

	public function __construct()
	{
		parent::__construct();
		session_start();
		//session_regenerate_id(true);
		if(empty($_SESSION['login']))
		{
			header('Location: '.base_url().'/login');
			die();
		}
		getPermisos(MAGENDA);
	}

	public function agenda()
	{
		if(empty($_SESSION['permisosMod']['r'])){
			header("Location:".base_url().'/dashboard');
		}

		$data['page_tag'] = "Agenda";
		$data['page_title'] = "AGENDA RECTORÍA <small>UAF </small>";
		$data['page_name'] = "agenda rectoría";
		$data['page_functions_js'] = "functions_agenda.js";
		$this->views->getView($this,"agenda",$data);
	}

	public function setEvento(){
		//error_reporting(0);
		if(empty($_POST['txtEvento']) || empty($_POST['txtUbicacion']) || empty($_POST['txtDescripcion']) || empty($_POST['txtHoraInicial']) || empty($_POST['txtHoraFinal']) || empty($_POST['txtFechaInicial']) || empty($_POST['txtFechaFinal']) || empty($_POST['listStatus']))
		{
			$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
		}else{ 
			$idAgenda = intval($_POST['idAgenda']);
			$strEvento = strClean($_POST['txtEvento']);
			$strUbicacion = strClean($_POST['txtUbicacion']);
			$strDescripcion = strClean($_POST['txtDescripcion']);
			$strHoraInicial = strClean($_POST['txtHoraInicial']);
			$strHoraFinal = strClean($_POST['txtHoraFinal']);
			$strFechaInicial = strClean($_POST['txtFechaInicial']);
			$strFechaFinal = strClean($_POST['txtFechaFinal']);
			$intStatus = intval($_POST['listStatus']);
			$requestAgenda = "";

			if($idAgenda == 0)
			{
				$option = 1;
				if($_SESSION['permisosMod']['w']){
					$requestAgenda = $this->model->insertEvento($strEvento,
																	$strUbicacion,
																	$strDescripcion,
																	$strHoraInicial,
																	$strHoraFinal,
																	$strFechaInicial,
																	$strFechaFinal,
																	$intStatus);
				}
			}else{
				$option = 2;
				if($_SESSION['permisosMod']['u']){
					$requestAgenda = $this->model->updateEvento($idAgenda,
																	$strEvento,
																	$strUbicacion,
																	$strDescripcion,
																	$strHoraInicial,
																	$strHoraFinal,
																	$strFechaInicial,
																	$strFechaFinal,
																	$intStatus);
				}
			}

			if(intval($requestAgenda) > 0 )
			{
				if($option == 1){
					$arrResponse = array('status' => true, 'msg' => 'Evento guardado exitosamente.');
				}else{
					$arrResponse = array('status' => true, 'msg' => 'Evento actualizado exitosamente.');
				}
			}else if($requestAgenda == 'exist'){
				$arrResponse = array('status' => false, 'msg' => '¡Atención! Este evento ya se encuentra registrado en el sistema.');		
			}else{
				$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
			}
		}
		echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
	
		die();
	}

	public function getEventosCalendar()
	{
		if($_SESSION['permisosMod']['r']){
			date_default_timezone_set('America/Mexico_City');
			$fechaActual = date('Y-m-d');
			$arrData = $this->model->selectEventos();
			for ($i=0; $i < count($arrData); $i++) {
				if($arrData[$i]['status'] == 1)
				{
					$arrData[$i]['estado'] = '<span class="badge badge-success">Confirmado</span>';
				}else{
					$arrData[$i]['estado'] = '<span class="badge badge-warning">Sin Confirmar</span>';
				}
			}
			$arrData['events'] = $arrData;	
			echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
		}
		die();
	}

	public function getEventos()
	{
		if($_SESSION['permisosMod']['r']){
			date_default_timezone_set('America/Mexico_City');
			$fechaActual = date('Y-m-d');
			$arrData = $this->model->selectEventos();
			for ($i=0; $i < count($arrData); $i++) {
				$btnView = '';
				$btnEdit = '';
				$btnDelete = '';
				if($arrData[$i]['status'] == 1)
				{
					$arrData[$i]['estado'] = '<span class="badge badge-success">Confirmado</span>';
				}else{
					$arrData[$i]['estado'] = '<span class="badge badge-warning">Sin Confirmar</span>';
				}

				if($arrData[$i]['fecha_inicial'] >= $fechaActual)
				{
					$arrData[$i]['activo'] = true;
				}else{
					$arrData[$i]['activo'] = false;
				}

				$arrData[$i]['horario_format'] = '<h5><span class="badge badge-info">'.$arrData[$i]['hora_inicial'].' - '.$arrData[$i]['hora_final'].'</span></h5>';

				if($_SESSION['permisosMod']['u']){
					$btnEdit = '<button class="btn btn-primary  btn-sm" onClick="fntEditInfo(this,'.$arrData[$i]['idagenda'].'); return false;" title="Editar evento"><i class="fas fa-pencil-alt"></i></button>';
				}
				if($_SESSION['permisosMod']['d']){	
					$btnDelete = '<button class="btn btn-danger btn-sm" onClick="fntDelInfo('.$arrData[$i]['idagenda'].'); return false;" title="Eliminar evento"><i class="far fa-trash-alt"></i></button>';
				}
				$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
			}
			
			echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
		}
		die();
	}

	public function getEvento($idagenda){
		if($_SESSION['permisosMod']['r']){
			$intIdAgenda = intval($idagenda);
			if($intIdAgenda > 0)
			{
				$arrData = $this->model->selectEvento($intIdAgenda);
				if(empty($arrData))
				{
					$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
				}else{
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
		}
		die();
	}


	public function delEvento()
	{
		if($_POST){
			if($_SESSION['permisosMod']['d']){
				$intIdAgenda = intval($_POST['idagenda']);
				$requestDelete = $this->model->deleteEvento($intIdAgenda);
				if(intval($requestDelete)>0)
				{
					$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el evento del sistema');
				}else{
					$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el evento.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
		}
		die();
	}

}

?>