<?php 

	class Alumnos extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MALUMNOS);
		}

		public function Alumnos()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Alumnos";
			$data['page_title'] = "ALUMNOS <small> UAF</small>";
			$data['page_name'] = "alumnos";
			$data['page_functions_js'] = "functions_alumnos.js";
			$data['niveles'] = $this->model->selectNiveles();
			$data['carreras'] = $this->model->selectCarreras();
			$data['grupos'] = $this->model->selectGrupos();
			$data['last_id'] = $this->model->selectLastId();
			$data['last_solicitud']['numero_solicitud'] = '';
			if(!empty($data['last_id']['idalumno']) || intval($data['last_id']['idalumno']))
			{
				$data['last_solicitud'] = $this->model->selectLastSolcitud($data['last_id']['idalumno']);
			}else{
				//dep("No se cumple la condición");
			}
			$this->views->getView($this,"alumnos",$data);
		}

		public function setAlumno(){
			if($_POST){	
				
				if(empty($_POST['txtNombres']) || empty($_POST['txtApellidos']) || empty($_POST['listSexo']) || empty($_POST['txtEdad']) || empty($_POST['txtFechaNacimiento']) || empty($_POST['listEstadoCivil']) || empty($_POST['txtTelefonoCelular']) || empty($_POST['txtEmail']) || empty($_POST['txtMunicipioNacimiento']) || empty($_POST['listPais']) || empty($_POST['txtCurp']) || empty($_POST['listNivelEstudios']) || empty($_POST['listNivelIngresar']) || empty($_POST['listModalidad']) || empty($_POST['listEstadoProcedencia']) || empty($_POST['listCarrera']) || empty($_POST['listGrupos']) || empty($_POST['listTurno']) || empty($_POST['listEgresado']) || empty($_POST['listBaja']) || empty($_POST['listIrregular']) || empty($_POST['listBeca']) || empty($_POST['listTipoBeca']) || empty($_POST['listAnioInicial']) || empty($_POST['listAnioFinal']) || empty($_POST['txtTipoSangre']) || empty($_POST['txtAlergias']) || empty($_POST['txtAlergiasMedicamento']) || empty($_POST['txtTratamientoMedico']) || empty($_POST['txtInstitucionMedica']) || empty($_POST['txtNombreEmergencia']) || empty($_POST['txtContactoEmergencia']) || empty($_POST['listPromocion']) || empty($_POST['listMedioPromocion']) || empty($_POST['txtFechaRegistro']) || empty($_POST['listStatus']))
				{
					$arrResponse = array("status" => false, "msg" => 'Favor de completar todos los campos obligatorios.');
				}else{
					$idAlumno = $_POST['idAlumno'];
					$intPersonaId = intval($_POST['idPersona']);
					$intRolId = intval(RALUMNO);
					$strNumeroSolicitud = $_POST['txtNumeroSolicitud'];
					$strMatricula = '';
					$strConsecutivo = $strNumeroSolicitud;
					if($_POST['txtMatricula'] == '')
					{
						$strMatricula = $strConsecutivo;
					}else{
						$strMatricula = $_POST['txtMatricula'];
					}
					$strNombres = mb_strtoupper(strClean($_POST['txtNombres'], 'UTF-8'));
					$strApellidos = mb_strtoupper(strClean($_POST['txtApellidos'], 'UTF-8'));

					$strSexo = strClean($_POST['listSexo']);
					$strEdad = intval($_POST['txtEdad']);
					$strFechaNacimiento = strClean($_POST['txtFechaNacimiento']);
					$strEstadoCivil = strClean($_POST['listEstadoCivil']);
					$strTelefonoFijo = strClean($_POST['txtTelefonoFijo']);
					$strTelefonoCelular = strClean($_POST['txtTelefonoCelular']);
					$strEmail = strClean($_POST['txtEmail']);
					$strCalle = ucwords(strClean($_POST['txtCalle']));
					$strNumeroExterior = strClean($_POST['txtNumero']);
					$strNumeroInterior = strClean($_POST['txtNumeroInterior']);
					$strColonia = ucwords(strClean($_POST['txtColonia']));
					$strLocalidad = ucwords(strClean($_POST['txtLocalidad']));
					$strMunicipioNacimiento = ucwords(strClean($_POST['txtMunicipioNacimiento']));
					$strEstadoNacimiento = ucwords(strClean($_POST['listEstado']));
					$strPaisNacimiento = strClean($_POST['listPais']);
					$strCurp = mb_strtoupper(strClean($_POST['txtCurp'], 'UTF-8'));
					$strNivelEstudios = strClean($_POST['listNivelEstudios']);
					$intNivelId = intval($_POST['listNivelIngresar']);
					$strModalidad = strClean($_POST['listModalidad']);
					$strEstadoProcedencia = strClean($_POST['listEstadoProcedencia']);
					$intAnioEgresoProcedencia = strClean($_POST['listAnioEgresoProcedencia']);
					$intCarreraId = intval($_POST['listCarrera']);
					$intGrupoId = intval($_POST['listGrupos']);
					//$strGrado = strClean($_POST['listGrado']);
					//$strGrupo = strClean($_POST['listGrupo']);
					$strTurno = strClean($_POST['listTurno']);
					$intEgresado = intval($_POST['listEgresado']);
					$intBaja = intval($_POST['listBaja']);
					$intIrregular = intval($_POST['listIrregular']);
					$intBeca = intval($_POST['listBeca']);
					$strTipoBeca = strClean($_POST['listTipoBeca']);
					$intPorcentajeBeca = intVal($_POST['txtPorcentajeBeca']);
					$intAnioInicial = intval($_POST['listAnioInicial']);
					$strAnioFinal = strClean($_POST['listAnioFinal']);
					$strTipoSangre = strClean($_POST['txtTipoSangre']);
					$strAlergias = strClean($_POST['txtAlergias']);
					$strAlergiasMedicamento = strClean($_POST['txtAlergiasMedicamento']);
					$strTratamientoMedico = strClean($_POST['txtTratamientoMedico']);
					$strInstutucionMedica = strClean($_POST['txtInstitucionMedica']);
					$strCronicoDegenerativas = strClean($_POST['cronicoDegenerativas']);
					$strTraumatologicas = strClean($_POST['traumatologicas']);
					$strFisicas = strClean($_POST['fisicas']);
					$strPsicosociales = strClean($_POST['psicosociales']);
					$strEnfermedadEspecificar = strClean($_POST['txtEnfermedadEspecificar']);
					$strNombreEmergencia = strClean($_POST['txtNombreEmergencia']);
					$strTelefonoEmergencia = strClean($_POST['txtContactoEmergencia']);
					$strPromocion = strClean($_POST['listPromocion']);
					$strMedioPromocion = strClean($_POST['listMedioPromocion']);
					$strFechaRegistro = strClean($_POST['txtFechaRegistro']);
					$strNombreTutor = mb_strtoupper(strClean($_POST['txtNombreTutor'], 'UTF-8'));
					$strTelefonoTutor = strClean($_POST['txtTelefonoTutor']);
					$strNombreEmpresa = strClean($_POST['txtNombreEmpresa']);
					$strTelefonoEmpresa = strClean($_POST['txtTelefonoEmpresa']);
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$strTipoMovimiento = "";
					$strComentarios = strClean($_POST['txtComentarios']);
					$strTipoRegistro = strClean($_POST['listTipoRegistro']);
					$intStatus = intval($_POST['listStatus']);

					$foto   	 	= $_FILES['foto'];
					$nombre_foto 	= $foto['name'];
					$type 		 	= $foto['type'];
					$url_temp    	= $foto['tmp_name'];
					$nombreImagen 	= 'avatar.png';
					if($nombre_foto != ''){
						$nombreImagen = 'foto_'.$strNombres.' '.$strApellidos.'_'.rand(1,10000).'_'.$nombre_foto;
					}
					$requestAlumno = "";

					/*dep("ID Alumno: ".$idAlumno);	
					dep("Número Solicitud: ".$strNumeroSolicitud);	
					dep("Matricula: ".$strMatricula);	
					dep("Nombres: ".$strNombres);	
					dep("Apellido Patero: ".$strApellidoPaterno);	
					dep("Apellido Materno: ".$strApellidoMaterno);		
					dep("Sexo: ".$strSexo);
					dep("Edad: ".$strEdad);	
					dep("Fecha Nacimiento: ".$strFechaNacimiento);
					dep("Estado Civil: ".$strEstadoCivil);	
					dep("Teléfono Fijo: ".$strTelefonoFijo);	
					dep("Teléfono Celular: ".$strTelefonoCelular);		
					dep("Email: ".$strEmail);	
					dep("Calle: ".$strCalle);	
					dep("Número: ".$strNumeroExterior);	
					dep("Número Interior: ".$strNumeroInterior);		
					dep("Colonia: ".$strColonia);	
					dep("Localidad: ".$strLocalidad);	
					dep("Municipio Nacimiento: ".$strMunicipioNacimiento);	
					dep("Estado Nacimiento: ".$strEstadoNacimiento);	
					dep("País Nacimiento: ".$strPaisNacimiento);	
					dep("Curp: ".$strCurp);		
					dep("Nivel Estudios: ".$strNivelEstudios);	
					dep("Nivel a Ingresar: ".$intNivelId);	
					dep("Modalidad: ".$strModalidad);	
					dep("Estado Procedencia: ".$strEstadoProcedencia);	
					dep("Año Egreso Procedencia: ".$intAnioEgresoProcedencia);		
					dep("Carrera ID: ".$intCarreraId);	
					dep("Grado: ".$strGrado);	
					dep("Grupo: ".$strGrupo);	
					dep("Turno: ".$strTurno);		
					dep("Egresado: ".$intEgresado);	
					dep("Baja: ".$intBaja);	
					dep("Irregular: ".$intIrregular);	
					dep("Beca: ".$intBeca);	
					dep("Tipo de Beca: ".$strTipoBeca);	
					dep("Porcentaje Beca: ".$intPorcentajeBeca);	
					dep("Anio Inicial: ".$intAnioInicial);		
					dep("Anio Final: ".$intAnioFinal);	
					dep("Tipo de Sangre: ".$strTipoSangre);	
					dep("Alergias: ".$strAlergias);	
					dep("Alergias Medicamento: ".$strAlergiasMedicamento);		
					dep("Tratamiento Médico: ".$strTratamientoMedico);	
					dep("Institución Médica: ".$strInstutucionMedica);	
					dep("Crónico Degenerativa: ".$strCronicoDegenerativas);		
					dep("Traumatológicas: ".$strTraumatologicas);	
					dep("Físicas: ".$strFisicas);	
					dep("Psicosociales: ".$strPsicosociales);	
					dep("Enfermedades Específicas: ".$strEnfermedadEspecificar);	
					dep("Nombre Emergencia: ".$strNombreEmergencia);	
					dep("Teléfono Emergencia: ".$strTelefonoEmergencia);		
					dep("Promoción: ".$strPromocion);	
					dep("Medio Promoción: ".$strMedioPromocion);	
					dep("Fecha Registro: ".$strFechaRegistro);	
					dep("Nombre Tutor: ".$strNombreTutor);		
					dep("Teléfono Tutor: ".$strTelefonoTutor);	
					dep("Nombre Empresa: ".$strNombreEmpresa);	
					dep("Teléfono Empresa: ".$strTelefonoEmpresa);	
					dep("Comentarios: ".$strComentarios);		
					dep("Tipo de Registro: ".$strTipoRegistro);		
					exit;*/


					if($idAlumno == 0 || $idAlumno == '')
					{
						$option = 1;
						$strPassword = empty($_POST['txtPassword']) ? hash("SHA256",passGenerator()) : hash("SHA256",$_POST['txtPassword']);
						$strTipoMovimiento = "Alta";
						if($_SESSION['permisosMod']['w']){
							$requestAlumno = $this->model->insertAlumno($strNumeroSolicitud,
																		$strMatricula, 
																		$strConsecutivo,
																		$nombreImagen, 
																		$strNombres,
																		$strApellidos,
																		$strSexo,
																		$strEdad, 
																		$strFechaNacimiento, 
																		$strCurp,
																		$strEstadoCivil,
																		$strNombreTutor,
																		$strTelefonoTutor,
																		$strTelefonoCelular, 
																		$strTelefonoFijo,
																		$strEmail,
																		$strCalle,
																		$strNumeroExterior,
																		$strNumeroInterior, 
																		$strColonia, 
																		$strLocalidad,
																		$strMunicipioNacimiento,
																		$strEstadoNacimiento,
																		$strPaisNacimiento,
																		$strNivelEstudios, 
																		$intNivelId, 
																		$strModalidad,
																		$strEstadoProcedencia,
																		$intAnioEgresoProcedencia,
																		$strNombreEmpresa,
																		$strTelefonoEmpresa, 
																		$strPromocion, 
																		$strMedioPromocion,
																		$strFechaRegistro,
																		$intCarreraId,
																		$intGrupoId, 
																		$strTurno, 
																		$intEgresado,
																		$intBeca,
																		$intPorcentajeBeca,
																		$intBaja,
																		$intIrregular, 
																		$intAnioInicial, 
																		$strAnioFinal,
																		$strTipoBeca,
																		$strTipoSangre,
																		$strAlergias,
																		$strAlergiasMedicamento,
																		$strTratamientoMedico,
																		$strInstutucionMedica,
																		$strCronicoDegenerativas,
																		$strTraumatologicas,
																		$strFisicas,
																		$strPsicosociales,
																		$strEnfermedadEspecificar,
																		$strNombreEmergencia,
																		$strTelefonoEmergencia,
																		$strModificador,
																		$strTipoMovimiento,
																		$strComentarios,
																		$strTipoRegistro,
																		$strPassword,
																		$intRolId,
																		$intStatus);
						}
					}else{
						$option = 2;
						$strPassword = empty($_POST['txtPassword']) ? "" : hash("SHA256",$_POST['txtPassword']);
						$strTipoMovimiento = "Actualización";
						if($nombre_foto == ''){
							if($_POST['foto_actual'] != 'avatar.png' AND $_POST['foto_remove'] == 0 ){
								$nombreImagen = $_POST['foto_actual'];
							}
							if($nombre_foto == '' AND $_POST['foto_remove'] == 1 AND $_POST['foto_actual'] != '')
							{
								$nombreImagen = $_POST['foto_actual'];
							}
						}
						if($_SESSION['permisosMod']['u']){
							$requestAlumno = $this->model->updateAlumno($idAlumno,
																		$strNumeroSolicitud,
																		$strMatricula, 
																		$strConsecutivo,
																		$nombreImagen,  
																		$strNombres,
																		$strApellidos,
																		$strSexo,
																		$strEdad, 
																		$strFechaNacimiento, 
																		$strCurp,
																		$strEstadoCivil,
																		$strNombreTutor,
																		$strTelefonoTutor,
																		$strTelefonoCelular, 
																		$strTelefonoFijo,
																		$strEmail,
																		$strCalle,
																		$strNumeroExterior,
																		$strNumeroInterior, 
																		$strColonia, 
																		$strLocalidad,
																		$strMunicipioNacimiento,
																		$strEstadoNacimiento,
																		$strPaisNacimiento,
																		$strNivelEstudios, 
																		$intNivelId, 
																		$strModalidad,
																		$strEstadoProcedencia,
																		$intAnioEgresoProcedencia,
																		$strNombreEmpresa,
																		$strTelefonoEmpresa, 
																		$strPromocion, 
																		$strMedioPromocion,
																		$strFechaRegistro,
																		$intCarreraId,
																		$intGrupoId,
																		$strTurno, 
																		$intEgresado,
																		$intBeca,
																		$intPorcentajeBeca,
																		$intBaja,
																		$intIrregular, 
																		$intAnioInicial, 
																		$strAnioFinal,
																		$strTipoBeca,
																		$strTipoSangre,
																		$strAlergias,
																		$strAlergiasMedicamento,
																		$strTratamientoMedico,
																		$strInstutucionMedica,
																		$strCronicoDegenerativas,
																		$strTraumatologicas,
																		$strFisicas,
																		$strPsicosociales,
																		$strEnfermedadEspecificar,
																		$strNombreEmergencia,
																		$strTelefonoEmergencia,
																		$strModificador,
																		$strTipoMovimiento,
																		$strComentarios,
																		$strTipoRegistro,
																		$intPersonaId,
																		$strPassword,
																		$intRolId,
																		$intStatus);
						}

					}

					if(intval($requestAlumno) > 0 )
					{
						date(date_default_timezone_set('America/Mexico_City'));
						$fecha = date('Y-m-d h:i:s');
						if($option == 1){
							$arrResponse = array('status' => true, 'fecha' => $fecha, 'msg' => 'Datos guardados correctamente.');
							if($nombre_foto != "")
							{
								if(is_dir('Assets/fotos_usuarios'))
								{
									uploadFoto($foto,$nombreImagen);
								}else{
									mkdir("Assets/fotos_usuarios/", 0777);
									uploadFoto($foto,$nombreImagen);
								}
							}
						}else{
							if($nombre_foto != "" && $nombreImagen!='avatar.png')
							{
								if(is_dir('Assets/fotos_usuarios'))
								{
									uploadFoto($foto,$nombreImagen);
									if($_POST['foto_actual'] != 'avatar.png'){
										deleteFoto($_POST['foto_actual']);
									}
								}else{
									mkdir("Assets/fotos_usuarios/", 0777);
									uploadFoto($foto,$nombreImagen);
									if($_POST['foto_actual'] != 'avatar.png'){
										deleteFoto($_POST['foto_actual']);
									}
								}
							}
							$arrResponse = array('status' => true, 'fecha' => $fecha, 'msg' => 'Datos Actualizados correctamente.');
						}
					}else if($requestAlumno == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! El Alumno ya se encuentra registrado en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getAlumnos()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectAlumnos();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';
					$btnDesasignar = '';

					/*if($arrData[$i]['baja'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Baja</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}*/

					$arrData[$i]['tipo'] = '<span class="badge badge-success">Regular</span>';

					if($arrData[$i]['irregular'] == 1 AND $arrData[$i]['baja'] == 1)
					{
						$arrData[$i]['tipo'] = '<span class="badge badge-danger">Baja</span>';
					}else if($arrData[$i]['baja'] == 1){
						$arrData[$i]['tipo'] = '<span class="badge badge-danger">Baja</span>';
					}else if($arrData[$i]['irregular'] == 1){
						$arrData[$i]['tipo'] = '<span class="badge badge-warning">Irregular</span>';
					}

					if($arrData[$i]['beca'] == 1)
					{
						$arrData[$i]['status_beca'] = '<span class="badge badge-info">Becado</span>';
					}else{
						$arrData[$i]['status_beca'] = '';
					}

					if($arrData[$i]['tipo_registro'] == 'Alumno')
					{
						$arrData[$i]['tipo_alumno_format'] = '<span class="badge badge-success">Alumno</span>';
					}else{
						$arrData[$i]['tipo_alumno_format'] = '<span class="badge badge-info">Aspirante</span>';
					}

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					$arrData[$i]['grupo_format'] = $arrData[$i]['grado'].'-'.$arrData[$i]['grupo'];

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewAlumno" onClick="fntViewAlumno('.$arrData[$i]['idalumno'].')" title="Ver alumno"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary  btn-sm btnEditAlumno" onClick="fntEditAlumno(this,'.$arrData[$i]['idalumno'].')" title="Editar alumno"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelAlumno" onClick="fntDelAlumno('.$arrData[$i]['idalumno'].')" title="Eliminar alumno"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getAlumno($idalumno){
			if($_SESSION['permisosMod']['r']){
				$intIdAlumno = intval($idalumno);
				if(intval($intIdAlumno) > 0){
					$arrData = $this->model->selectAlumno($intIdAlumno);
					if(empty($arrData)){
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrData['url_foto'] = media().'/fotos_usuarios/'.$arrData['foto'];
						$arrData['grupo_format'] = $arrData['grado'].'-'.$arrData['grupo'];
						$arrDataGrupos = $this->model->selectGruposCarrera($arrData['carreraid']);
						if(!empty($arrDataGrupos)){
							$arrResponse = array('status' => true, 'statusGrupo' => true, 'data' => $arrData, "grupos" =>$arrDataGrupos);
						}else{
							$arrResponse = array('status' => true, 'statusGrupo' => false, 'data' => $arrData, "grupos" =>$arrDataGrupos);
						}
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delAlumno()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdAlumno = intval($_POST['idalumno']);
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$arrDataAlumno = $this->model->selectAlumno($intIdAlumno);
					$foto = $arrDataAlumno['foto'];
					$personaid = $arrDataAlumno['personaid'];
					$requestDelete = $this->model->deleteAlumno($intIdAlumno, $strModificador, $personaid);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el alumno');
						if(is_dir('Assets/fotos_usuarios') AND $foto != '' AND $foto != 'avatar.png')
						{
							deleteFoto($foto);
						}
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el alumno.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getGrupos($carreraid){
			if($_SESSION['permisosMod']['r']){
				$intCarreraId = intval($carreraid);
				if(intval($intCarreraId) > 0)
				{
					$arrData = $this->model->selectGruposCarrera($intCarreraId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron grupos asignados a esta carrera o programa educativo.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getLastId(){
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectLastId();
				if(empty($arrData)){
					$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
				}else{
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}
	}
 ?>