<?php 
	require 'Libraries/html2pdf/vendor/autoload.php';
	use Spipu\Html2Pdf\Html2Pdf;

	class Aparcial extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MACTAS);
		}

		public function Aparcial()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Acta Parcial";
			$data['page_title'] = "ACTA PARCIAL <small>UAF</small>";
			$data['page_name'] = "acta parcial";
			$data['page_functions_js'] = "functions_aparcial.js";
			$data['carreras'] = $this->model->selectCarreras();
			$this->views->getView($this,"aparcial",$data);
		}

		public function getAlumnos($carreraid){
			if($_SESSION['permisosMod']['r']){
				$intCarreraId = intval($carreraid);
				if(intval($intCarreraId) > 0)
				{
					$arrData = $this->model->selectAlumnos($intCarreraId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron alumnos asignados a la carrera y nivel seleccionados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan los alumnos correspondientes a la carrera y nivel seleccionados.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getBusquedaAlumno()
		{
			if($_POST)
			{
				if($_SESSION['permisosMod']['u'])
				{
					//$intCarreraId = intval($_POST['listCarreras']);
					$intAlumnoId = intval($_POST['listAlumnos']);
					$strOption = strClean($_POST['rbOption']);
					$intPrimero = intval($_POST['primero']);
					$intSegundo = intval($_POST['segundo']);
					$intTercero = intval($_POST['tercero']);
					$intCuarto = intval($_POST['cuarto']);
					$intQuinto = intval($_POST['quinto']);
					$intSexto = intval($_POST['sexto']);
					$intSeptimo = intval($_POST['septimo']);
					$intOctavo = intval($_POST['octavo']);
					$intNoveno = intval($_POST['noveno']);
					$semestres = array();

					if($intPrimero == 1){
						array_push($semestres, 1);
					}
					if($intSegundo == 1){
						array_push($semestres, 2);
					}
					if($intTercero == 1){
						array_push($semestres, 3);
					}
					if($intCuarto == 1){
						array_push($semestres, 4);
					}
					if($intQuinto == 1){
						array_push($semestres, 5);
					}
					if($intSexto == 1){
						array_push($semestres, 6);
					}
					if($intSeptimo == 1){
						array_push($semestres, 7);
					}
					if($intOctavo == 1){
						array_push($semestres, 8);
					}
					if($intNoveno == 1){
						array_push($semestres, 9);
					}
					
					if($strOption == "Personalizado"){
						$arrData = $this->model->selectCalificacionesSemestres($intAlumnoId, $semestres);	
					}else{
						$arrData = $this->model->selectCalificacionesTodos($intAlumnoId);
					}
					
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron registros de calificaciones con los datos de la búsqueda seleccionados');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'url' => base_url(), 'msg' => 'A continuación se listan los grupos correspondientes a la carrera seleccionada.');
					}
					
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
					die();
				}

			}
			
		}

		public function formatoActaParcialI($params)
{
    if ($_SESSION['permisosMod']['r']) {

        $array = explode(",", $params);
        $intAlumnoId = intval($array[0]);
        $strOption = $array[1] ?? "";
        $semestres = [];

        if ($intAlumnoId > 0) {

            // Armar arreglo de semestres seleccionados
            for ($i = 2; $i <= 10; $i++) {
                if (!empty($array[$i]) && intval($array[$i]) == 1) {
                    $semestres[] = $i - 1;
                }
            }

            $arrData = ($strOption == "Custom")
                ? $this->model->selectCalificacionesSemestres($intAlumnoId, $semestres)
                : $this->model->selectCalificacionesTodos($intAlumnoId);

            if (empty($arrData)) {
                echo "Error: Datos no encontrados.";
                return;
            }

            ob_end_clean();
						$html = getFile("Template/Modals/kardexIndividualPDF",$arrData);
						$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
						//$html2pdf->Image(media().'/images/logoVertical.png' , 10 ,100, 190 , 150,'PNG');
						$html2pdf->writeHTML($html);
						$html2pdf->output('Boleta_Individual: '.$arrData[0]['nombre_alumno'].'.pdf');
            exit;
        } else {
            echo "Dato no válido";
        }

    } else {
        header('Location: ' . base_url() . '/login');
        die();
    }
}

	}

 ?>