<?php 

	class Asistencias extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MASISTENCIAS);
		}

		public function Asistencias()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Asistencias";
			$data['page_title'] = "ASISTENCIAS <small>UAF</small>";
			$data['page_name'] = "asistencias";
			$data['page_functions_js'] = "functions_asistencias.js";
			$data['grupos'] = $this->model->selectGrupos($_SESSION['userData']['idpersona']);
			$data['ciclos'] = $this->model->selectCiclos();
			/*dep($data['ciclos']);
			exit;*/
			$this->views->getView($this,"asistencias",$data);
		}

		public function setAsistencia(){
			if($_POST){	
				
				if(empty($_POST['idGrupo']) || empty($_POST['idProfesor']) || empty($_POST['idMateria']) || empty($_POST['listaElementos']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					$fecha = strClean($_POST['txtFecha']);
					$idGrupo = intval($_POST['idGrupo']);
					$idProfesor = intval($_POST['idProfesor']);
					$idMateria = intval($_POST['idMateria']);
					$listaElementos = $_POST['listaElementos'];
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$requestAsistencia = "";

					if($idGrupo > 0)
					{
						$strTipoMovimiento = "Alta";
						if($_SESSION['permisosMod']['w']){
							$requestAsistencia = $this->model->insertAsistencia($fecha,
																		$idGrupo,
																		$idProfesor, 
																		$idMateria,
																		$listaElementos,
																		$strModificador,
																		$strTipoMovimiento);
						}
					}

					if(intval($requestAsistencia) > 0 )
					{
						$arrResponse = array('status' => true, 'msg' => 'Asistencia guardada correctamente.');
					}else if($requestAsistencia == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Usted ya registró asistencia de esta materia el día de hoy');		
					}else if($requestAsistencia == 'uciclo'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! No existe un ciclo escolar vigente para asignar el registro de asistencia');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function updateAsistencia(){
			if($_POST){	
				if(empty($_POST['idGrupoE']) || empty($_POST['idProfesorE']) || empty($_POST['idMateriaE']) || empty($_POST['listaElementosE']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					$fechaE = strClean($_POST['listFechas']);
					$idGrupoE = intval($_POST['idGrupoE']);
					$idProfesorE = intval($_POST['idProfesorE']);
					$idMateriaE = intval($_POST['idMateriaE']);
					$listaElementosE = $_POST['listaElementosE'];
					$strModificadorE = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$requestAsistenciaUpdate = "";


					if($idGrupoE > 0)
					{
						$strTipoMovimiento = "Actualización";
						if($_SESSION['permisosMod']['u']){
							$requestAsistenciaUpdate = $this->model->updateAsistencia($fechaE,
																		$idGrupoE,
																		$idProfesorE, 
																		$idMateriaE,
																		$listaElementosE,
																		$strModificadorE,
																		$strTipoMovimiento);
						}
					}

					if(intval($requestAsistenciaUpdate) > 0 )
					{
						$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
					}else if($requestAsistenciaUpdate == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Usted ya registró asistencia de esta materia el día de hoy');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getGrupos()
		{
			if($_SESSION['permisosMod']['r']){
				$profesorid = $_SESSION['userData']['idpersona'];
				$arrData = $this->model->selectGrupos($profesorid);
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					$arrData[$i]['grupo_format'] = $arrData[$i]['grado'].'-'.$arrData[$i]['grupo'];

					if($_SESSION['permisosMod']['r']){
						$btnExp = '<button class="btn btn-info btn-sm btnView" onClick="fntViewAsistencia('.$arrData[$i]['idgrupo'].','.$arrData[$i]['profesorid'].','.$arrData[$i]['idmateria'].')" title="Ver Asistencia"><i class="far fa-eye"></i></button>';
						$btnView = '<button class="btn btn-success btn-sm btnRegister" onClick="fntRegistrarAsistencia('.$arrData[$i]['idgrupo'].', '.$arrData[$i]['idmateria'].')" title="Registrar Asistencia"><i class="far fa-check-square"></i></button>';
						$btnViewF = '<button class="btn btn-info btn-sm btnViewFechas" onClick="fntViewAsistenciaFechas('.$arrData[$i]['idgrupo'].','.$arrData[$i]['profesorid'].','.$arrData[$i]['idmateria'].')"  title="Ver Asistencia Periódo"><i class="far fa-calendar"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-warning  btn-sm btnEditAsistencia" onClick="fntEditarAsistencia('.$arrData[$i]['idgrupo'].', '.$arrData[$i]['idmateria'].')" title="Editar asistencia"><i class="fas fa-pencil-alt"></i></button>';
					}
					/*if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelMateria" onClick="fntDelGrupo('.$arrData[$i]['idmateria'].')" title="Eliminar materia"><i class="far fa-trash-alt"></i></button>';
			
					}*/
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnExp.' '.$btnViewF.' </div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getAlumnos(){
			if($_SESSION['permisosMod']['r']){
				$idGrupo = intval($_POST['idgrupo']);
				$idMateria = intval($_POST['idmateria']);
				if(intval($idGrupo) > 0)
				{
					$arrData = $this->model->selectAlumnos($idGrupo, $idMateria);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getFechas(){
			if($_SESSION['permisosMod']['r']){
				$idGrupo = intval($_POST['idgrupo']);
				$idProfesor = intval($_POST['idprofesor']);
				$idMateria = intval($_POST['idmateria']);
				if(intval($idGrupo) > 0)
				{
					$arrData = $this->model->selectFechas($idGrupo, $idProfesor, $idMateria);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No hay registros de asistencia previos.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getAsistencia(){
			if($_SESSION['permisosMod']['r']){
				$idGrupo = intval($_POST['idgrupo']);
				$idProfesor = intval($_POST['idprofesor']);
				$idMateria = intval($_POST['idmateria']);
				$strFecha = strClean($_POST['fecha']);
				if(intval($idGrupo) > 0)
				{
					$arrData = $this->model->selectAsistencia($idGrupo, $idProfesor,$idMateria,$strFecha);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No hay registro de asistencia de la fecha seleccinada.');
					}else{
						for ($i=0; $i < count($arrData); $i++) { 
							
		                    if($arrData[$i]['asistencia'] === 'Asiste'){
		                        $arrData[$i]['btnEstado'] = '<input type="button" id="btnEstadoE" class="btn btn-success  btn-block btnChange" onClick="fntChange(this,'.$arrData[$i]['idalumno'].')" title="Cambiar estado" estado="Asiste" value="Asiste"/>';
		                    }elseif($arrData[$i]['asistencia'] === 'Retardo'){
		                        $arrData[$i]['btnEstado'] = '<input type="button" id="btnEstadoE" class="btn btn-warning  btn-block btnChange" onClick="fntChange(this,'.$arrData[$i]['idalumno'].')" title="Cambiar estado" estado="Retardo" value="Retardo"/>';
		                    }else{
		                        $arrData[$i]['btnEstado'] = '<input type="button" id="btnEstadoE" class="btn btn-danger  btn-block btnChange" onClick="fntChange(this,'.$arrData[$i]['idalumno'].')" title="Cambiar estado" estado="Falta" value="Falta"/>';
		                    }
						}
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getAsistenciasGrupo(){
			if($_SESSION['permisosMod']['r']){
				if($_POST)
				{
					$intGrupoId = intval($_POST['idgrupo']);
					$intProfesorId = intval($_POST['idprofesor']);
					$intMateriaId = intval($_POST['idmateria']);
					$strFechaInicial = strClean($_POST['fechai']);
					$strFechaFinal = strClean($_POST['fechaf']);

					if(strtotime($strFechaInicial) > strtotime($strFechaFinal)){
						$arrResponse = array("status" => false, "msg" => 'La fecha inicial no puede ser posterior a la fecha final.');
					}else{
						if(intval($intGrupoId) > 0)
						{
							$arrData = $this->model->selectAsistenciasGrupo($intGrupoId, $intProfesorId, $intMateriaId, $strFechaInicial, $strFechaFinal);
							if(empty($arrData))
							{
								$arrResponse = array('status' => false, 'msg' => 'No hay registros de asistencia disponibles.');
							}else{
								$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'Datos encontrados correctamente.');
							}
							
						}
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);	
				}
			}
			die();
		}

		public function delMateria()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdMateria = intval($_POST['idmateria']);
					$requestDelete = $this->model->deleteMateria($intIdMateria);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente la materia');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar la materia.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>