<?php 
	require 'Libraries/html2pdf/vendor/autoload.php';
	use Spipu\Html2Pdf\Html2Pdf;
	
	class Cargas extends Controllers
	{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MCARGAS);
		}

		public function Cargas()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Cargas Académicas";
			$data['page_title'] = "CARGAS ACADÉMICAS <small>UAF</small>";
			$data['page_name'] = "cargas académicas";
			$data['page_functions_js'] = "functions_cargas.js";
			$data['carreras'] = $this->model->selectCarreras();
			$data['materias'] = $this->model->selectMaterias();
			$data['usuarios'] = $this->model->selectUsuarios();
			$this->views->getView($this,"cargas",$data);
		}

		public function setCarga(){
			if($_POST){	
				
				if(empty($_POST['txtNombreDocente']) || empty($_POST['txtEmail']) || empty($_POST['listCarreras']) || empty($_POST['listGrupos']) || empty($_POST['listaElementos']))
				{
					$arrResponse = array("status" => false, "msg" => 'Faor de llenar los campos obligatorios.');
				}else{ 
					$idCarga = intval($_POST['idCarga']);
					$docenteId = intval($_POST['idDocente']);
					$strGrupo = strClean($_POST['listGrupos']);
					$intCarreraId = intval($_POST['listCarreras']);
					$strGrupo = strClean($_POST['listGrupos']);
					$listaElementos = $_POST['listaElementos'];
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);

					/*dep("ID Carga: ".$idCarga);
					dep("Nombre Docente: ".$strNombreDocente);
					dep("Dirección: ".$strDireccion);
					dep("Teléfono: ".$strTelefono);
					dep("Email: ".$strEmail);
					dep("ID Carrera: ".$intCarreraId);
					dep("Grupo: ".$strGrupo);
					dep("Elementos: ".$listaElementos);
					dep("Modifcador: ".$strModificador);
					exit;*/
					
					$requestCargas = "";

					if($idCarga == 0)
					{
						$option = 1;
						$strTipoMovimiento="Alta";
						if($_SESSION['permisosMod']['w']){
							$requestCargas = $this->model->insertCarga($docenteId,
																		$intCarreraId,
																		$strGrupo,
																		$strModificador, 
																		$strTipoMovimiento,
																		$listaElementos);
						}
					}else{
						$option = 2;
						$strTipoMovimiento="Actualización";
						if($_SESSION['permisosMod']['u']){
							$requestCargas = $this->model->updateCarga($idCarga,
																		$docenteId,
																		$intCarreraId,
																		$strGrupo,
																		$strModificador, 
																		$strTipoMovimiento,
																		$listaElementos);
						}

					}

					if(intval($requestCargas) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
					}else if($requestCargas == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Este email ya se encuentra registrado en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getDocentes()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectDocentes();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					$arrData[$i]['cantidad_materias'] = $this->model->selectCantidadMaterias($arrData[$i]['idpersona']);
					/*dep($arrData[$i]['cantidad_materias']);
					exit;*/

					$arrData[$i]['materias'] = 5;

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewHorario" onClick="fntViewCarga('.$arrData[$i]['idpersona'].')" title="Ver información"><i class="far fa-eye"></i></button>
							<a title="Generar formato" href="'.base_url().'/cargas/formatoCargas/'.$arrData[$i]['idpersona'].'" target="_blanck" class="btn btn-danger btn-sm"> <i class="fas fa-file-pdf"></i></a>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-warning  btn-sm btnEditCarga" onClick="fntEditCarga(this,'.$arrData[$i]['idpersona'].')" title="Editar Carga Académica"><i class="fas fa-pencil-alt"></i></button>';
						$btnAdd = '<button class="btn btn-primary btn-sm btnAddCarga" onClick="fntAgregarCarga(this,'.$arrData[$i]['idpersona'].')" title="Agregar Carga Académica"><i class="fas fa-plus"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnReporte = '<button class="btn btn-danger btn-sm btnDelCarga" onClick="fntDelCarga('.$arrData[$i]['idpersona'].')" title="Eliminar Carga"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getDocente($idpersona)
		{
			if($_SESSION['permisosMod']['r']){
				$intIdPersona = intval($idpersona);
				if(intval($intIdPersona) > 0)
				{
					$arrData = $this->model->selectDocente($intIdPersona);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function formatoCargas($idpersona)
		{
			if($_SESSION['permisosMod']['r']){
				//$intIdPersona = intval($idparsona)
				if(intval($idpersona)>0){
					$data = $this->model->selectFormatoDocente($idpersona);
					/*dep($data);
					exit;*/
					if(empty($data)){
						echo "Error: Datos no encontrados, intente más tarde.";
					}else{
						$idhorarioj = $data['idhorarioj'];
						ob_end_clean();
						$html = getFile("Template/Modals/cargasPDF",$data);
						$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
						$html2pdf->writeHTML($html);
						$html2pdf->output('Horario-'.$data[0]['nombre_profesor'].'.pdf');
					}
				}else{
					echo "Dato no válido";
				}
			}else{
				header('Location: '.base_url().'/login');
				die();
			}
		}

		public function getMateriasDocente($idpersona)
		{
			if($_SESSION['permisosMod']['r']){
				$intIdPersona = intval($idpersona);
				if(intval($intIdPersona) > 0)
				{
					$arrData = $this->model->selectMateriasDocente($intIdPersona);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getCargasDocente($idpersona)
		{
			if($_SESSION['permisosMod']['r']){
				$intIdPersona = intval($idpersona);
				if(intval($intIdPersona) > 0)
				{
					$arrData = $this->model->selectFormatoDocente($intIdPersona);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getEditCarga()
		{
			if($_POST)
			{
				if($_SESSION['permisosMod']['r'])
				{
					$intDocenteId = intval($_POST['docenteId']);
					$intCarreraId = intval($_POST['carreraId']);
					$strGrupo = strClean($_POST['grupo']);

					if(intval($intCarreraId) > 0 && intval($intDocenteId) > 0 && $strGrupo != "")
					{
						$arrData = $this->model->selectEditCarga($intDocenteId, $intCarreraId, $strGrupo);
						if(empty($arrData))
						{
							$arrResponse = array('status' => false, 'msg' => 'Carga Académica no encontrada.');
						}else{
							$arrMaterias = $this->model->selectMateriasCarrera($intCarreraId);
							$arrResponse = array('status' => true, 'data' => $arrData, 'materias' => $arrMaterias);
						}
						echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
					}
				}
			}
			
			die();
		}

		public function getMateriasCarrera($materiaid)
		{
			$intCarreraId = intval($materiaid);
			if(intval($intCarreraId))
			{
				$arrData = $this->model->selectMateriasCarrera($intCarreraId);
				if(empty($arrData))
				{
					$arrResponse = array('status' => false, 'msg' => 'No hay materias asignadas a esta carrera.');
				}else{
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
			}else{
				$arrResponse = array('status' => false, 'msg' => 'Error de proceso. Favor de intentar nuevamente.');
			}
			echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);

			die();
		}

		public function getHorarios()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectHorarios();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewHorario" onClick="fntViewHorario('.$arrData[$i]['idhorarioj'].')" title="Ver horario"><i class="far fa-eye"></i></button>
							<a title="Generar formato" href="'.base_url().'/horarios/formatoHorarios/'.$arrData[$i]['idhorarioj'].'" target="_blanck" class="btn btn-danger btn-sm"> <i class="fas fa-file-pdf"></i></a>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary  btn-sm btnEditHorario" onClick="fntEditHorario(this,'.$arrData[$i]['idhorarioj'].')" title="Editar horario"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelHorario" onClick="fntDelHorario('.$arrData[$i]['idhorarioj'].')" title="Eliminar horario"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getHorario($idhorarioj){
			if($_SESSION['permisosMod']['r']){
				$intIdHorarioJ = intval($idhorarioj);
				if(intval($intIdHorarioJ) > 0)
				{
					$arrData = $this->model->selectHorario($intIdHorarioJ);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delHorario()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdHorarioJ = intval($_POST['idhorario']);
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['nombres']);
					$requestDelete = $this->model->deleteHorario($intIdHorarioJ, $strModificador);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el horario');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el horario.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getGruposCarrera($carreraid)
		{
			$intCarreraId = intval($carreraid);
			if(intval($intCarreraId))
			{
				$arrData = $this->model->selectGruposCarrera($intCarreraId);
				if(empty($arrData))
				{
					$arrResponse = array('status' => false, 'msg' => 'No hay grupos asignados a esta carrera.');
				}else{
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
			}else{
				$arrResponse = array('status' => false, 'msg' => 'Error de proceso. Favor de intentar nuevamente.');
			}
			echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);

			die();
		}

		public function getMaterias()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectMaterias();
				if(empty($arrData))
				{
					$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
				}else{
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getMateriasNivel($nivelid)
		{
			$intNivelId = $nivelid;
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectMateriasNivel($intNivelId);
				if(empty($arrData))
				{
					$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
				}else{
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getProfesores(){
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectUsuarios();
				if(empty($arrData))
				{
					$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
				}else{
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getTableHorario($idhorarioj){
			if($_SESSION['permisosMod']['r']){
				$intIdHorarioJ = intval($idhorarioj);
				if(intval($intIdHorarioJ) > 0)
				{
					$arrData = $this->model->selectTableHorario($intIdHorarioJ);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

	}
 ?>