<?php 

	class Carreras extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MCARRERAS);
		}

		public function Carreras()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Carreras";
			$data['page_title'] = "CARRERAS <small>UAF</small>";
			$data['page_name'] = "carreras";
			$data['page_functions_js'] = "functions_carreras.js";
			$data['niveles'] = $this->model->selectNiveles();
			$this->views->getView($this,"carreras",$data);
		}

		public function setCarrera(){
			if($_POST){	
				
				if(empty($_POST['txtCarrera']) || empty($_POST['txtAbreviatura']) || empty($_POST['txtModelo']) || empty($_POST['txtRevision']) || empty($_POST['listNivel']) || empty($_POST['listModalidad']) || empty($_POST['listStatus']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					$idCarrera = intval($_POST['idCarrera']);
					$strCarrera = mb_strtoupper(strClean($_POST['txtCarrera']),'UTF-8');
					$strAbreviatura = mb_strtoupper(strClean($_POST['txtAbreviatura'], 'UTF-8'));
					$strModelo = mb_strtoupper(strClean($_POST['txtModelo'], 'UTF-8'));
					$strReforma = mb_strtoupper(strClean($_POST['listReforma'], 'UTF-8'));
					$strRevision = strClean($_POST['txtRevision']);
					$intNivelId = intval($_POST['listNivel']);
					$strModalidad = strClean($_POST['listModalidad']);
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$strTipoMovimiento="";
					$intStatus = intval($_POST['listStatus']);
					$requestCarrera = "";

					if($idCarrera == 0)
					{
						$option = 1;
						$strTipoMovimiento = "Alta";
						if($_SESSION['permisosMod']['w']){
							$requestCarrera = $this->model->insertCarrera($strCarrera,
																		$strAbreviatura, 
																		$strModelo,
																		$strReforma,								
																		$strRevision,
																		$intNivelId, 
																		$strModalidad,
																		$strModificador,
																		$strTipoMovimiento,
																		$intStatus);
						}
					}else{
						$option = 2;
						$strTipoMovimiento = "Actualizacion";
						if($_SESSION['permisosMod']['u']){
							$requestCarrera = $this->model->updateCarrera($idCarrera,
																		$strCarrera,
																		$strAbreviatura, 
																		$strModelo,
																		$strReforma,
																		$strRevision,
																		$intNivelId, 
																		$strModalidad,
																		$strModificador,
																		$strTipoMovimiento,
																		$intStatus);
						}

					}

					if(intval($requestCarrera) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
							date_default_timezone_set('America/Mexico_City');
							$strFecha = date('d-m-Y H:i:s');
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.', 'fecha' => $strFecha);
						}
					}else if($requestCarrera == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Esta carrera ya se encuentra registrada en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getCarreras()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectCarreras();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewCrrera" onClick="fntViewCarrera('.$arrData[$i]['idcarrera'].')" title="Ver carrera"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary  btn-sm btnEditCrrera" onClick="fntEditCarrera(this,'.$arrData[$i]['idcarrera'].')" title="Editar carrera"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelCrrera" onClick="fntDelCarrera('.$arrData[$i]['idcarrera'].')" title="Eliminar carrera"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getCarrera($idcarrera){
			if($_SESSION['permisosMod']['r']){
				$intIdCarrera = intval($idcarrera);
				if(intval($intIdCarrera) > 0)
				{
					$arrData = $this->model->selectCarrera($intIdCarrera);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delCarrera()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdCarrera = intval($_POST['idcarrera']);
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$requestDelete = $this->model->deleteCarrera($intIdCarrera, $strModificador);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente la carrera');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar la carrera.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>