	<?php 

class Ccomputo extends Controllers{

	public function __construct()
	{
		parent::__construct();
		session_start();
		//session_regenerate_id(true);
		if(empty($_SESSION['login']))
		{
			header('Location: '.base_url().'/login');
			die();
		}
		getPermisos(MCOMPUTO);
	}

	public function Ccomputo()
	{
		if(empty($_SESSION['permisosMod']['r'])){
			header("Location:".base_url().'/dashboard');
		}

		$data['page_tag'] = "Ccomputo";
		$data['page_title'] = "SOLICITUD C. COMPUTO <small>UAF </small>";
		$data['page_name'] = "centros cómputo";
		$data['page_functions_js'] = "functions_ccomputo.js";
		$this->views->getView($this,"ccomputo",$data);
	}

	public function setSolicitud(){
		if(empty($_POST['listCentroComputo']) || empty($_POST['txtDescripcion']) || empty($_POST['txtHoraInicial']) || empty($_POST['txtHoraFinal']) || empty($_POST['txtFechaInicial']) || empty($_POST['txtFechaFinal']))
		{
			$arrResponse = array("status" => false, "msg" => 'Llenar campos obligatorios.');
		}else{ 
			$idSolicitud = intval($_POST['idSolicitud']);
			$strCentroComputo = strClean($_POST['listCentroComputo']);
			$strDescripcion = strClean($_POST['txtDescripcion']);
			$strHoraInicial = strClean($_POST['txtHoraInicial']);
			$strHoraFinal = strClean($_POST['txtHoraFinal']);
			$strFechaInicial = strClean($_POST['txtFechaInicial']);
			$strFechaFinal = strClean($_POST['txtFechaFinal']);
			$strEstado = strClean($_POST['listEstado']);
			$strComentarios = strClean($_POST['txtComentarios']);
			$intPersonaId = intval($_SESSION['userData']['idpersona']);
			$listaElementos = strClean($_POST['listaElementos']);

			$request_solicitud = "";
			if($idSolicitud == 0)
			{
				$option = 1;
				if($_SESSION['permisosMod']['w']){
					$request_solicitud = $this->model->insertSolicitud($intPersonaId,
																	$strCentroComputo,
																	$strDescripcion,
																	$strHoraInicial,
																	$strHoraFinal,
																	$strFechaInicial,
																	$strFechaFinal,
																	$listaElementos);
				}
			}else{
				$option = 2;
				if($_SESSION['permisosMod']['u']){	
					$request_solicitud = $this->model->updateSolicitud($idSolicitud,
																	$intPersonaId,
																	$strCentroComputo,
																	$strDescripcion,
																	$strHoraInicial,
																	$strHoraFinal,
																	$strFechaInicial,
																	$strFechaFinal,
																	$strEstado,
																	$strComentarios,
																	$listaElementos);
				}
			}

			if(intval($request_solicitud) > 0 )
			{
				if($option == 1){
					$arrResponse = array('status' => true, 'msg' => 'Solicitud guardada correctamente.');
				}else{
					$arrResponse = array('status' => true, 'msg' => 'Solicitud actualizada correctamente.');
				}
			}else if($request_solicitud == 'exist'){
				$arrResponse = array('status' => false, 'msg' => '¡Atención! Esta ya se encuentra registrada en el sistema.');		
			}else{
				$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
			}
		}
		echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
	
		die();
	}

	public function getSolicitudesCalendar()
	{
		if($_SESSION['permisosMod']['r']){
			$arrData = $this->model->selectSolicitudes();
			for ($i=0; $i < count($arrData); $i++) {
				if($arrData[$i]['estado'] == 'Solicitado')
				{
					$arrData[$i]['bdgEstado'] = '<span class="badge badge-warning">Solicitado</span>';
				}elseif($arrData[$i]['estado'] == 'Denegado'){
					$arrData[$i]['bdgEstado'] = '<span class="badge badge-danger">Denegado</span>';
				}else{
					$arrData[$i]['bdgEstado'] = '<span class="badge badge-success">Autorizado</span>';
				}
			}
			$arrData['events'] = $arrData;	
			echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
		}
		die();
	}

	public function getSolicitudes()
	{
		if($_SESSION['permisosMod']['r']){
			date_default_timezone_set('America/Mexico_City');
			$fechaActual = date('Y-m-d');
			$arrData = $this->model->selectSolicitudes();
			for ($i=0; $i < count($arrData); $i++) {
				$btnView = '';
				$btnEdit = '';
				$btnDelete = '';
				$visibilidad = '';
				if($_SESSION['userData']['idrol'] != RADMINISTRADOR)
				{ 
					$visibilidad = "disabled"; 
				}

				if($arrData[$i]['estado'] == 'Solicitado')
				{
					$arrData[$i]['edo'] = '<btn class="btn btn-warning  btn-sm btnEditEstado" onClick="fntEditEstado(this,'.$arrData[$i]['idsolicitud'].')" title="Editar Estado" estado="'.$arrData[$i]['estado'].'" '.$visibilidad.'>Solicitado</btn>';
					//$arrData[$i]['edo'] = '<h5><span class="badge badge-warning">Solicitado</span></h5>';
				}elseif($arrData[$i]['estado'] == 'Denegado'){
					$arrData[$i]['edo'] = '<btn class="btn btn-danger  btn-sm btnEditEstado" onClick="fntEditEstado(this,'.$arrData[$i]['idsolicitud'].')" title="Editar Estado" estado="'.$arrData[$i]['estado'].'" '.$visibilidad.'>Denegado</btn>';
					//$arrData[$i]['edo'] = '<h5><span class="badge badge-danger">Denegado</span></h5>';
				}else{
					$arrData[$i]['edo'] = '<btn class="btn btn-success  btn-sm btnEditEstado" onClick="fntEditEstado(this,'.$arrData[$i]['idsolicitud'].')" title="Editar Estado" estado="'.$arrData[$i]['estado'].'" '.$visibilidad.'>Autorizado</btn>';
					//$arrData[$i]['edo'] = '<h5><span class="badge badge-success">Autorizado</span></h5>';
				}

				if($arrData[$i]['fecha_inicial'] >= $fechaActual)
				{
					$arrData[$i]['activo'] = true;
				}else{
					$arrData[$i]['activo'] = false;
				}

				$arrData[$i]['format_horario'] = '<h5><span class="badge badge-info">'.$arrData[$i]['hora_inicial'].' - '.$arrData[$i]['hora_final'].'</span></h5>';

				if($_SESSION['permisosMod']['u']){
					$btnEdit = '<button class="btn btn-primary  btn-sm" onClick="fntEditInfo(this,'.$arrData[$i]['idsolicitud'].'); return false;" title="Editar solicitud"><i class="fas fa-pencil-alt"></i></button>';
				}
				if($_SESSION['permisosMod']['d']){	
					$btnDelete = '<button class="btn btn-danger btn-sm" onClick="fntDelInfo('.$arrData[$i]['idsolicitud'].'); return false;" title="Eliminar solicitud"><i class="far fa-trash-alt"></i></button>';
				}
				$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
			}
			
			echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
		}
		die();
	}

	public function getSolicitud($idsolicitud){
		if($_SESSION['permisosMod']['r']){
			$intIdSolicitud = intval($idsolicitud);
			if($intIdSolicitud > 0)
			{
				$arrData = $this->model->selectSolicitud($intIdSolicitud);
				if(empty($arrData))
				{
					$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
				}else{
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
		}
		die();
	}

	public function actualizarEstado()
	{
		if($_POST)
		{
			if($_SESSION['permisosMod']['u'])
			{
				if($_SESSION['userData']['idrol'] != RADMINISTRADOR)
				{
					$arrResponse = array('status' => false, 'msg' => 'No cuentas con los permisos suficientes para realizar esta acción.');
					
				}else{
					$intIdSolicitud = intval($_POST['idsolicitud']);
					$strEstado = strClean($_POST['estado']);
					$nuevoEstado = "";
					$nuevoEstado = ($strEstado == "Solicitado") ? "Autorizado" : (($strEstado == "Autorizado") ? "Denegado" : "Solicitado");
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$strTipoMovimiento = "Actualización";
					$requestUpdate = $this->model->updateEstado($intIdSolicitud, $nuevoEstado, $strTipoMovimiento, $strModificador);
					$visibilidad = '';
					if(intval($requestUpdate)>0)
					{
						if($_SESSION['userData']['idrol'] != RADMINISTRADOR)
						{
							$visibilidad = "disabled";
						}
						if($nuevoEstado == "Solicitado")
						{
							$btnEstado = '<btn class="btn btn-warning  btn-sm btnEditEstado" onClick="fntEditEstado(this,'.$intIdSolicitud.')" title="Editar Estado" estado="'.$nuevoEstado.'" '.$visibilidad.'>Solicitado</btn>';
						}else if($nuevoEstado == "Denegado")
						{
							$btnEstado = '<btn class="btn btn-danger  btn-sm btnEditEstado" onClick="fntEditEstado(this,'.$intIdSolicitud.')" title="Editar Estado" estado="'.$nuevoEstado.'" '.$visibilidad.'>Denegado</btn>';
						}else{
							$btnEstado = '<btn class="btn btn-success  btn-sm btnEditEstado" onClick="fntEditEstado(this,'.$intIdSolicitud.')" title="Editar Estado" estado="'.$nuevoEstado.'" '.$visibilidad.'>Autorizado</btn>';
						}
						$arrResponse = array('status' => true, 'msg' => 'Se actualizo correctamente el estado de la solicitud','btnEstado' => $btnEstado);
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar actualizar el estado de la solicitud.');
					}
				}
			}else{
				$arrResponse = array('status' => false, 'msg' => 'No cuentas con los permisos suficientes para realizar esta acción.');
			}
			echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
		}
		die();
	}


	public function delSolicitud()
	{
		if($_POST){
			if($_SESSION['permisosMod']['d']){
				$intIdSolicitud = intval($_POST['idsolicitud']);
				$requestDelete = $this->model->deleteSolicitud($intIdSolicitud);
				if(intval($requestDelete)>0)
				{
					$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente la solicitud del sistema');
				}else{
					$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el registro.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
		}
		die();
	}

}

?>