<?php 
	use Spipu\Html2Pdf\Html2Pdf;
	use Mpdf\Mpdf;

	require 'Libraries/html2pdf/vendor/autoload.php';
	require 'Libraries/mpdf/vendor/autoload.php';
	

	class Cfinales extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MCALIFICACIONES);
		}

		public function Cfinales()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Calificaciones Finales";
			$data['page_title'] = "CALIFICACIONES FINALES<small>UAF</small>";
			$data['page_name'] = "calificaciones_finales";
			$data['page_functions_js'] = "functions_cfinales.js";
			$data['niveles'] = $this->model->selectNiveles();
			/*dep($data['niveles']);
			exit;*/
			$this->views->getView($this,"cfinales",$data);
		}

		public function setCalificacion(){
			if($_POST){	
				if(empty($_POST['json_calificaciones']) || empty($_POST['txtCarrera']) || empty($_POST['txtProfesor']) || empty($_POST['txtMateria']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					date_default_timezone_set('America/Mexico_City');
					$intSemestre = intval($_POST['txtSemestre']);
					$intNivelId = intval($_POST['nivelid']);
					$intCarreraId = intval($_POST['carreraid']);
					$strGrupo = intval($_POST['grupoid']);
					$intGrupoId = intval($_POST['grupoid']);
					$intProfesorId = intval($_POST['profesorid']);
					$intMateriaId = intval($_POST['materiaid']);
					$jsonData = strClean($_POST['json_calificaciones']);
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$strFechaCaptura = "";
					if($_SESSION['userData']['idrol'] == RADMINESCOLARES || $_SESSION['userData']['idrol'] == RAUXESCOLARES){
						$strFechaCaptura = strClean($_POST['txtFechaCaptura']);
					}else{
						$strFechaCaptura = date('Y-m-d');
					}
					$requestCalificacion = "";
					/*dep($jsonData);
					exit;*/
					$strTipoMovimiento = 'Alta';
					if($_SESSION['permisosMod']['w']){
						$requestCalificacion = $this->model->insertCalificacion($intSemestre,
																		$intNivelId,
																		$intCarreraId,
																		$intGrupoId,
																		$intProfesorId,
																		$intMateriaId,
																		$jsonData,
																		$strFechaCaptura,
																		$strModificador,
																		$strTipoMovimiento);
					}

					if(intval($requestCalificacion) > 0 )
					{
						$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
					}else if($requestCalificacion == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Ya se encuentran registradas las calificaciones del periódo seleccionado, para editarlas favor de ponerse en contacto con Sevicios Escolares o con el Administrador del sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}
	

		public function getCarreras($nivelid){
			if($_SESSION['permisosMod']['r']){
				$intNivelId = intval($nivelid);
				if(intval($intNivelId) > 0)
				{
					$arrData = $this->model->selectCarreras($intNivelId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron carreras asignadas al nivel seleccionado.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan las carreras correspondientes al nivel seleccionado.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getGrupos($carreraid){
			if($_SESSION['permisosMod']['r']){
				$intCarreraId = intval($carreraid);
				$intPersonaId = $_SESSION['userData']['idpersona'];
				if(intval($intCarreraId) > 0)
				{
					$arrData = $this->model->selectGrupos($intCarreraId, $intPersonaId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron grupos asignados a la carrera seleccionada');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan los grupos correspondientes a la carrera seleccionada.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getMaterias(){
			if($_POST)
			{
				if($_SESSION['permisosMod']['r'])
				{
					$intCarreraId = intval($_POST['carreraid']);
					$intGrupo = strClean($_POST['grupoid']);
					$intPersonaId = $_SESSION['userData']['idpersona'];
					if(intval($intCarreraId) > 0)
					{
						$arrData = $this->model->selectMaterias($intCarreraId, $intGrupo, $intPersonaId);
						if(empty($arrData))
						{
							$arrResponse = array('status' => false, 'msg' => 'No se encontraron materias asignadas al grupo seleccionado');
						}else{
							$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan las materias asignadas al grupo seleccionado.');
						}
						echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
					}
				}
				die();
			}
		}

		public function getBusquedaAlumnos()
		{
			if($_POST)
			{
				if($_SESSION['permisosMod']['u'])
				{
					date_default_timezone_set('America/Mexico_City');
					$strFechaActual = date('Y-m-d');
					$intNivelId = intval($_POST['listNiveles']);
					$intCarreraId = intval($_POST['listCarreras']);
					$strGrupoUnformat = strClean($_POST['listGrupos']);
					$intGrupoId = intval($_POST['listGrupos']);
					$intMateriaId = intval($_POST['listMaterias']);
					//$intDocenteId = intval($_SESSION['userData']['idpersona']);

					$strArrayGrupo = explode("-", $strGrupoUnformat);
					$strGrado = $strArrayGrupo[0];
					$strGrupo = $strArrayGrupo[0];

					/*dep("Fecha Actual: ".$strFechaActual);
					dep("ID Nivel: ".$intNivelId);
					dep("ID Carrera: ".$intCarreraId);
					dep("Grupo Unformat: ".$strGrupoUnformat);
					dep("ID Materia: ".$intMateriaId);
					dep("Array Grupo: ".$strArrayGrupo);
					dep("Grado: ".$strGrado);
					dep("Grupo: ".$strGrupo);

					dep("ID NIVEL: ".$intNivelId);
					dep("ID CARRERA: ".$intCarreraId);
					dep("GRUPO: ".$strGrupo);
					dep("ID MATERIA: ".$intMateriaId);
					exit;*/
					$arrDataCarga = $this->model->selectData($intNivelId, $intCarreraId, $intMateriaId, $intGrupoId);
					$intProfesorId = $arrDataCarga['profesorid'];
					$arrDataPermisivo = $this->model->selectPermisivoFecha($intProfesorId, $intMateriaId, $intCarreraId, $strGrupoUnformat);
					if(!empty($arrDataPermisivo['fecha_inicial']) && $arrDataPermisivo['fecha_final'] < $strFechaActual)
					{
						$arrResponse = array('status' => false, 'msg' => 'No se pueden cargar calificaciones fuera de la fecha limite permitida.');
					}else{
						$arrDataNivel = $this->model->selectBusquedaNivel($intNivelId);
						$arrDataCarrera = $this->model->selectBusquedaCarrera($intCarreraId);
						$arrDataAlumnos = $this->model->selectBusquedaAlumnos($intNivelId,$intCarreraId,$intGrupoId,$intProfesorId,$intMateriaId);
						$arrDataDocente = $this->model->selectBusquedaDocente($intProfesorId);
						$arrDataMateria = $this->model->selectBusquedaMateria($intMateriaId);
						$arrDataCalificaciones = $this->model->selectBusquedaCalificaciones($intNivelId, $intCarreraId, $intMateriaId, $intGrupoId);
						//dep($arrDataCalificaciones);
						//exit;
						
						if(empty($arrDataAlumnos))
						{
							$arrResponse = array('status' => false, 'msg' => 'No se encontraron alumnos con los datos de la búsqueda seleccionados');
						}elseif($arrDataAlumnos == 'exist'){
							$arrResponse = array('status' => false, 'msg' => '¡Atención! Ya se encuentran registradas las calificaciones del periódo seleccionado, para editarlas favor de ponerse en contacto con Sevicios Escolares o con el Administrador del sistema.');
						}else{
							$arrResponse = array('status' => true, 'nivel' => $arrDataNivel, 'carrera' => $arrDataCarrera, 'data' => $arrDataAlumnos, 'docente' => $arrDataDocente, 'materia' => $arrDataMateria, 'calificaciones' => $arrDataCalificaciones, 'msg' => 'A continuación se listan los grupos correspondientes a la carrera seleccionada.');
						}

					}
					
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
					die();
				}

			}
			
		}

		public function formatoGrupo($grupo)
		{
			if($_SESSION['permisosMod']['r']){
				$strGrupoUnformat = strClean($grupo);
				$strArrayGrupo = explode(",", $strGrupoUnformat);
				$intCarreraId = $strArrayGrupo[0];
				$strGrado = $strArrayGrupo[1];
				$strGrupo = $strArrayGrupo[2];
				
				if(intval($intCarreraId)>0){
					$data = $this->model->selectGrupo($intCarreraId, $strGrado, $strGrupo);
					if(empty($data)){
						echo "Error: Datos no encontrados, intente más tarde.";
					}else{
						ob_end_clean();
						$html = getFile("Template/Modals/gruposPDF",$data);
						$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
						$html2pdf->writeHTML($html);
						$html2pdf->output('Lista grupal: '.$data[0]['grado'].' '.$data[0]['grupo'].'.pdf');
					}
				}else{
					echo "Dato no válido";
				}
			}else{
				header('Location: '.base_url().'/login');
				die();
			}
		}

		public function generarActasMasivas($data){
		    if($_SESSION['permisosMod']['r']){
		        // 1. Cargar el autoload de Composer (Asegúrate de que la ruta sea correcta según tu estructura)
		        //require_once 'vendor/autoload.php'; 

		        $datos = strClean($data);
		        $array = explode(',', $datos);
		        $intNivelId = intval($array[0]);
		        $intCarreraId = intval($array[1]);
		        $intGrupoId = intval($array[2]);
		        $intProfesorId = intval($array[3]);
		        $intMateriaId = intval($array[4]);
                
		        if(intval($intCarreraId) > 0)
		        {
		            $data = $this->model->selectCalificacionesActa($intNivelId, $intCarreraId, $intMateriaId, $intGrupoId);
		            if(empty($data))
		            {
		                $arrResponse = array('status' => false, 'msg' => 'No se encontraron calificaciones registrados a este parcial');
		                // En un controlador de este tipo, podrías querer retornar un JSON o redireccionar
		                echo json_encode($arrResponse);
		                exit();
		            } else {
		            	if($_SESSION['userData']['idrol'] == RADMINESCOLARES || $_SESSION['userData']['idrol'] == RAUXESCOLARES)
		            	{
		            		try {
			                    // 2. Limpiar el búfer para evitar basura en el PDF
			                    if (ob_get_length()) ob_end_clean();

			                    // 3. Obtener el HTML de tu plantilla
			                    $html = getFile("Template/Modals/actaFinalBachilleratoEscolaresPDF", $data);

			                    // 4. Configuración de mPDF
			                    $mpdf = new \Mpdf\Mpdf([
			                        'mode' => 'utf-8',
			                        'format' => 'A4',
			                        'orientation' => 'P', // 'P' para Vertical, 'L' para Horizontal
			                        'margin_left' => 10,
			                        'margin_right' => 10,
			                        'margin_top' => 10,
			                        'margin_bottom' => 10,
			                    ]);

			                    // --- INICIO CONFIGURACIÓN MARCA DE AGUA / FONDO ---
			                    // Si deseas marca de agua (Imagen):
			                    $rutaLogo = media().'/images/logoVertical.png';
			                    //$rutaLogo = $_SERVER['DOCUMENT_ROOT'] . '/sieuaf/Assets/images/logoVertical.png';
			                    //dep($rutaLogo);exit;
			                    $mpdf->SetWatermarkImage($rutaLogo, 0.1, 105, 'F'); // Ruta, opacidad, tamaño
			                    $mpdf->showWatermarkImage = true;

			                    // Si deseas marca de agua (Texto):
			                    // $mpdf->SetWatermarkText('CONFIDENCIAL', 0.1);
			                    // $mpdf->showWatermarkText = true;
			                    // --- FIN CONFIGURACIÓN ---

			                    // 5. Escribir el contenido
			                    $mpdf->WriteHTML($html);

			                    // 6. Salida del PDF
			                    // 'I' abre en el navegador, 'D' descarga directamente
			                    $nombreArchivo = 'Acta_' . str_replace(' ', '_', $data[0]['materia']) . '.pdf';
			                    $mpdf->Output($nombreArchivo, 'I');
			                    
			                    exit();

			                } catch (\Mpdf\MpdfException $e) {
			                    // Capturar errores específicos de la librería
			                    echo "Error al generar el PDF: " . $e->getMessage();
			                    exit;
			                }
		            	}else{
		            		try {
		            			ob_end_clean();
								$html = getFile("Template/Modals/actaFinalBachilleratoPDF",$data);
								$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
								$html2pdf->writeHTML($html);
								$html2pdf->output('Acta: '.$data[0]['materia'].'.pdf');
								exit();
		            		} catch (\Mpdf\MpdfException $e) {
			                    // Capturar errores específicos de la librería
			                    echo "Error al generar el PDF: " . $e->getMessage();
			                    exit;
			                }
		            	}
		                
		            }
		        }
		    }
		    header('Location: '.base_url().'/login');
		    die();
		}

		public function generarActasFinales($data){
			if($_SESSION['permisosMod']['r']){
				$datos = strClean($data);
				$array = explode(',', $datos);
				$intNivelId = intval($array[0]);
				$intCarreraId = intval($array[1]);
				$intGrupoId = intval($array[2]);
				$intProfesorId = intval($array[3]);
				$intMateriaId = intval($array[4]);
				$intPersonaId = $_SESSION['userData']['idpersona'];

				if(intval($intCarreraId) > 0)
				{
					$data = $this->model->selectCalificacionesActa($intNivelId, $intCarreraId, $intMateriaId, $intGrupoId);
					if(empty($data))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se econtraron calificaciones registrados a este parcial');
					}else{
						ob_end_clean();
						$html = getFile("Template/Modals/actaFinalBachilleratoPDF",$data);
						$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
						$html2pdf->writeHTML($html);
						$html2pdf->output('Acta: '.$data[0]['materia'].'.pdf');
						exit();
					}
				}
			}
			header('Location: '.base_url().'/login');
			die();
		}

	}

 ?>