<?php 

	class Ciclos extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MCICLOESCOLAR);
		}

		public function Ciclos()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Ciclos";
			$data['page_title'] = "CICLOS <small>UAF</small>";
			$data['page_name'] = "ciclos";
			$data['page_functions_js'] = "functions_ciclos.js";
			$this->views->getView($this,"ciclos",$data);
		}

		public function setCiclo(){
			if($_POST){	
				
				if(empty($_POST['listCiclo']) || empty($_POST['listStatus']))
				{
					$arrResponse = array("status" => false, "msg" => 'Todos los campos son obligatorios.');
				}else{ 
					$idCiclo = intval($_POST['idCiclo']);
					$strCicloEscolar = strClean($_POST['listCiclo']);
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$intStatus = intval($_POST['listStatus']);
					$requestCiclo = "";

					if($idCiclo == 0)
					{
						$option = 1;
						$strTipoMovimiento = "Alta";
						if($_SESSION['permisosMod']['w']){
							$requestCiclo = $this->model->insertCiclo($strCicloEscolar,
																		$strModificador,
																		$intStatus);
						}
					}else{
						$option = 2;
						$strTipoMovimiento = "Actualizacion";
						if($_SESSION['permisosMod']['u']){
							$requestCiclo = $this->model->updateCiclo($strCicloEscolar,
																		$strModificador,
																		$intStatus);
						}

					}

					if(intval($requestCiclo) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.', 'modificador' => $strModificador, 'ultima_modificacion' => date('d-m-Y h:i:s'), 'tipo_movimiento' => $strTipoMovimiento);
						}
					}else if($requestCiclo == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Favor de revisar la información solo puede estar un ciclo escolar como ACTIVO o esta trantando de ingresar uno existente.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getCiclos()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectCiclos();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<button class="btn btn-success btn-block btnEstatus" onClick="fntChangeStatus(this,'.$arrData[$i]['idciclo'].')" estado="Activo" title="Cambiar estatus">Activo</button>';
					}else{
						$arrData[$i]['status'] = '<button class="btn btn-danger btn-block btnEstatus" onClick="fntChangeStatus(this,'.$arrData[$i]['idciclo'].')" estado="Inactivo" title="Cambiar estatus">Inactivo</button>';
					}
					$arrData[$i]['cont'] = $i+1;

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewCiclo" onClick="fntViewCiclo('.$arrData[$i]['idciclo'].')" title="Ver ciclo escolar"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary  btn-sm btnEditCiclo" onClick="fntEditCiclo(this,'.$arrData[$i]['idciclo'].')" title="Editar ciclo escolar"><i class="fas fa-pencil-alt"></i></button>';
					}
					/*if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelCiclo" onClick="fntDelCiclo('.$arrData[$i]['idciclo'].')" title="Eliminar ciclo escolar"><i class="far fa-trash-alt"></i></button>';
			
					}*/
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function updStatus(){
			if($_SESSION['permisosMod']['r']){
				$intIdCiclo = intval($_POST['idciclo']);
				$strStatus = strClean($_POST['status']);
				$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
				$strTipoMovimiento = "Actualización";
				if(intval($intIdCiclo) > 0)
				{	
					$arrData = $this->model->updateStatus($intIdCiclo,$strStatus,$strModificador,$strTipoMovimiento);
					if(intval($arrData) > 0)
					{
						if($strStatus == "Activo"){
							$btnStatus = '<button class="btn btn-success btn-block btnEstatus" onClick="fntChangeStatus(this,'.$intIdCiclo.')" estado="Activo" title="Cambiar estatus">Activo</button>';
						}else{
							$btnStatus = '<button class="btn btn-danger btn-block btnEstatus" onClick="fntChangeStatus(this,'.$intIdCiclo.')" estado="Inactivo" title="Cambiar estatus">Inactivo</button>';
						}
						$arrResponse = array('status' => true, 'msg' => 'Estado actualizado correctamente', 'btnStatus' => $btnStatus);
						
					}elseif($arrData == 'exist'){
						$arrResponse = array('status' => false, 'msg' => 'Ya se encuentra un ciclo escolar activo, favor de revisar la información');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'No se pudo actualizar es estado, favor de intentar más tarde.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getCiclo($idmateria){
			if($_SESSION['permisosMod']['r']){
				$intIdCiclo = intval($idmateria);
				if(intval($intIdCiclo) > 0)
				{
					$arrData = $this->model->selectCiclo($intIdCiclo);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delCiclo()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdCiclo = intval($_POST['idciclo']);
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$strTipoMovimiento = "Eliminación";
					$requestDelete = $this->model->deleteCiclo($intIdCiclo, $strModificador, $strTipoMovimiento);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el ciclo escolar');
					}elseif($requestDelete == "ciclo"){
						$arrResponse = array('status' => false, 'msg' => 'No se puede eliminar el ciclo escolar debido a que existe información ligada al mismo');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el ciclo escolar.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}

 ?>