<?php 
	require 'Libraries/html2pdf/vendor/autoload.php';
	use Spipu\Html2Pdf\Html2Pdf;

	class Comprobante extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MPAGOS);
		}

		public function generarComprobantePago($idpago)
		{
			if($_SESSION['permisosMod']['r']){
				if(is_numeric($idpago)){
					$data = $this->model->selectPago($idpago);
					if(empty($data)){
						echo "Error: Datos no encontrados, intente más tarde.";
					}else{
						$idpago = $data['idpago'];
						ob_end_clean();
						$html = getFile("Template/Modals/comprobantePagoPDF",$data);
						$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
						$html2pdf->writeHTML($html);
						$html2pdf->output('comprobante-'.$idpago.'.pdf');
					}
				}else{
					echo "Dato no válido";
				}
			}else{
				header('Location: '.base_url().'/login');
				die();
			}
		}

		public function generarComprobanteGasto($idgasto)
		{
			if($_SESSION['permisosMod']['r']){
				if(is_numeric($idgasto)){
					$data = $this->model->selectGasto($idgasto);
					if(empty($data)){
						echo "Error: Datos no encontrados, intente más tarde.";
					}else{
						$idgasto = $data['idgasto'];
						ob_end_clean();
						$html = getFile("Template/Modals/comprobanteGastoPDF",$data);
						$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
						$html2pdf->writeHTML($html);
						$html2pdf->output('factura-'.$idgasto.'.pdf');
					}
				}else{
					echo "Dato no válido";
				}
			}else{
				header('Location: '.base_url().'/login');
				die();
			}
		}

	}

 ?>
