<?php 
	
	class Dashboard extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			//session_regenerate_id(true);
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MDASHBOARD);
		}

		public function dashboard()
		{
			date_default_timezone_set('America/Mexico_City');
			$anio = date('Y');
			$mes = date('m');
			$data['page_id'] = 2;
			$data['page_tag'] = "Dashboard - Universidad Autónoma de Fresnillo";
			$data['page_title'] = "Dashboard - Universidad Autónoma de Fresnillo";
			$data['page_name'] = "dashboard";
			$data['page_functions_js'] = "functions_dashboard.js";
			$data['usuarios'] = $this->model->selectUsuarios();
			$data['alumnos'] = $this->model->selectAlumnos();
			$data['docentes'] = $this->model->selectDocentes();
			$data['niveles'] = $this->model->selectNiveles();
			$data['carreras'] = $this->model->selectCarreras();
			$data['extensiones'] = $this->model->selectExtensiones();
			$data['distribucionGenero'] = $this->model->distribucionGenero();
			$data['distribucionEscuelas'] = $this->model->distribucionEscuelas();
			$data['distribucionColonias'] = $this->model->distribucionColonias();
			$data['distribucionBecados'] = $this->model->distribucionBecados();
			$data['distribucionMedioPromocion'] = $this->model->distribucionMedioPromocion();
			$data['distribucionPaisNacimiento'] = $this->model->distribucionPaisNacimiento();
			$data['distribucionTipoBeca'] = $this->model->distribucionTipoBeca();
			$data['distribucionNiveles'] = $this->model->distribucionNiveles();	
			$data['lastEvents'] = $this->model->selectLastEvents();
			$data['lastBirthdays'] = $this->model->selectLastBirthdays();		
			/*dep($data['distribucionNiveles']);
			exit;*/
			/*$data['distribucionGrupos'] = $this->model->distribucionGrupos();
			$data['ingresosMDia'] = $this->model->selectIngresosMes($anio,$mes);
			$data['ingresosAnio'] = $this->model->selectIngresosAnio($anio);
			$data['gastosMDia'] = $this->model->selectGastosMes($anio,$mes);
			$data['gastosAnio'] = $this->model->selectGastosAnio($anio);
			$data['lastEvents'] = $this->model->selectLastEvents();
			$data['lastBirthdays'] = $this->model->selectLastBirthdays();*/
			/*if( $_SESSION['userData']['idrol'] == RTUTOR ){
				$this->views->getView($this,"dashboardTutor",$data);
			}else{*/
				$this->views->getView($this,"dashboard",$data);
			//}
		}

		public function getUsuarios()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectUsuarios();
				$arrResponse = array('status' => true, 'data' => $arrData);
			}
			echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			die();
		}

		public function getAlumnos()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectAlumnos();
				$arrResponse = array('status' => true, 'data' => $arrData);
			}
			echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			die();
		}

		public function getDocentes()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectDocentes();
				$arrResponse = array('status' => true, 'data' => $arrData);
			}
			echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			die();
		}

		public function getNiveles()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectNiveles();
				$arrResponse = array('status' => true, 'data' => $arrData);
			}
			echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			die();
		}

		public function getCarreras()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectCarreras();
				$arrResponse = array('status' => true, 'data' => $arrData);
			}
			echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			die();
		}

		public function getExtensiones()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectExtensiones();
				$arrResponse = array('status' => true, 'data' => $arrData);
			}
			echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			die();
		}

		public function ingresosMes(){
			if($_POST){
				$grafica = "ingresosMes";
				$nFecha = str_replace(" ","",$_POST['fecha']);
				$arrFecha = explode('-',$nFecha);
				$mes = $arrFecha[0];
				$anio = $arrFecha[1];
				$pagos = $this->model->selectIngresosMes($anio,$mes);
				$script = getFile("Template/Modals/graficas",$pagos);
				echo $script;
				die();
			}
		}

		public function ingresosAnio(){
			if($_POST){
				$grafica = "ingresosAnio";
				$anio = intval($_POST['anio']);
				$pagos = $this->model->selectIngresosAnio($anio);
				$script = getFile("Template/Modals/graficas",$pagos);
				echo $script;
				die();
			}
		}

		public function gastosMes(){
			if($_POST){
				$grafica = "gastosMes";
				$nFecha = str_replace(" ","",$_POST['fecha']);
				$arrFecha = explode('-',$nFecha);
				$mes = $arrFecha[0];
				$anio = $arrFecha[1];
				$pagos = $this->model->selectGastosMes($anio,$mes);
				$script = getFile("Template/Modals/graficas",$pagos);
				echo $script;
				die();
			}
		}

		public function gastosAnio(){
			if($_POST){
				$grafica = "gastosAnio";
				$anio = intval($_POST['anio']);
				$pagos = $this->model->selectGastosAnio($anio);
				$script = getFile("Template/Modals/graficas",$pagos);
				echo $script;
				die();
			}
		}

	}
 ?>