<?php 

	class Docentes extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MDOCENTES);
		}

		public function Docentes()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Docentes";
			$data['page_title'] = "DOCENTES <small> UAF</small>";
			$data['page_name'] = "docentes";
			$data['page_functions_js'] = "functions_docentes.js?v=<?= time();";
			$data['niveles'] =$this->model->selectNiveles();
			/*dep($_SESSION['idUser']);
			dep($_SESSION['userData']);
			exit;*/
			$this->views->getView($this,"docentes",$data);
		}

		public function setDocente(){
			if($_POST){	

				/*dep("No Empleado: ".$_POST['txtIdentificador']);	
				dep("Nombres: ".$_POST['txtNombre']);	
				dep("Apellidos: ".$_POST['txtApellido']);	
				dep("Email: ".$_POST['txtEmail']);	
				dep("ID Rol: ".$_POST['listRolid']);	
				dep("Estatus: ".$_POST['listStatus']);
				exit;*/
				if(empty($_POST['txtIdentificador']) || empty($_POST['txtNombres']) || empty($_POST['txtApellidos']) || empty($_POST['txtEmail']) || empty($_POST['listStatus']) || empty($_POST['listSexo']) || empty($_POST['listEstadoCivil']) || empty($_POST['listEstado']) || empty($_POST['listPais']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					$idDocente = intval($_POST['idDocente']);
					$intPersonaId = intval($_POST['idPersona']);
					$strIdentificador = strClean($_POST['txtIdentificador']);
					$strNombres = mb_strtoupper(strClean($_POST['txtNombres'], 'UTF-8'));
					$strApellidos = mb_strtoupper(strClean($_POST['txtApellidos'], 'UTF-8'));
					$strNombreCompleto = $strNombres.' '.$strApellidos;

					$strEmail = strtolower(strClean($_POST['txtEmail']));
					$intTipoId = intval(RDOCENTE);
					$strSexo = strClean($_POST['listSexo']);
					$strEstadoCivil = strClean($_POST['listEstadoCivil']);
					$strFechaNacimiento = strClean($_POST['txtFechaNacimiento']);
					$strRfc = strtoupper(strClean($_POST['txtRfc']));
					$strCurp = strtoupper(strClean($_POST['txtCurp']));
					$strDireccion = strClean($_POST['txtDireccion']);
					$strCodigoPostal = strClean($_POST['txtCodigoPostal']);
					$strCiudad = ucwords(strClean($_POST['txtCiudad']));
					$strEstado = strClean($_POST['listEstado']);
					$strPais = strClean($_POST['listPais']);
					$floatSalario = floatval($_POST['txtSalario']);
					$strTelefonoCelular = strClean($_POST['txtTelefonoCelular']);
					$strTelefonoFijo = strClean($_POST['txtTelefonoFijo']);
					$strEmpresa = strClean($_POST['txtEmpresa']);
					$strTelefonoEmpresa = strClean($_POST['txtTelefonoEmpresa']);
					$strNombreEmergencia = strClean($_POST['txtNombreEmergencias']);
					$strRelacionEmergencia = strClean($_POST['txtRelacionEmergencia']);
					$strTelefonoEmergencia = strClean($_POST['txtTelefonoEmergencia']);
					$strTipoSangre = strClean($_POST['txtTipoSangre']);
					$strPuesto = strClean($_POST['txtPuesto']);
					$strDepartamento = strClean($_POST['txtDepartamento']);
					$intNivelId = intval($_POST['listNiveles']);
					$strFechaContratacion = strClean($_POST['txtFechaContratacion']);
					$strTipoDocente = strClean($_POST['txtTipoDocente']);
					$strFormaPago = strClean($_POST['txtFormaPago']);
					$strNivelEstudios = strClean($_POST['txtNivelEstudios']);
					$strFechaEgreso = strClean($_POST['txtFechaEgreso']);
					$strInstitucion = strClean($_POST['txtInstitucion']);
					$strNumeroCedula = strClean($_POST['txtNumeroCedula']);
					$strCampoEstudios = strClean($_POST['txtCampoEstudios']);
					$strExperienciaDocente = strClean($_POST['txtExperienciaDocente']);
					$strExperienciaProfesional = strClean($_POST['txtExperienciaProfesional']);
					$strExperienciaLaboral = strClean($_POST['txtExperienciaLaboral']);
					$strPrioridad = strClean($_POST['txtPrioridad']);
					$strNecesidad = strClean($_POST['txtNecesidad']);
					$strFechaEntrevistaInicial = strClean($_POST['txtFechaEntrevistaInicial']);
					$strFechaMicroenseñanza = strClean($_POST['txtFechaMicroenseñanza']);
					$strFechaEntrevistaFinal = strClean($_POST['txtFechaEntrevistaFinal']);
					$strFechaInduccion = strClean($_POST['txtFechaInduccion']);
					$strCursoEbd = strClean($_POST['txtCursoEbd']);
					$strFechaCursoEbd = strClean($_POST['txtFechaCursoEbd']);
					$strOtrosCursos = strClean($_POST['txtOtrosCursos']);
					$strComentarios = strClean($_POST['txtComentarios']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$strTipoMovimiento = '';
					$intStatus = intval(strClean($_POST['listStatus']));
					$nombreSolicitudEmpleo = '';
					$nombreCv = '';
					$nombreAntecedentesPenales = '';
					$nombreCertificadoMedico = '';
					$nombreCartasRecomendacion = '';
					$nombreFotos = '';
					$nombreINE = '';
					$nombreCartillaMilitar = '';
					$nombreCurp = '';
					$nombreRfc = '';
					$nombreActaNacimiento = '';
					$nombreComprobanteDomicilio = '';
					$nombreCertificaciones = '';
					$nombreTitulo = '';
					$nombreCedula = '';

					$foto   	 	= $_FILES['foto'];
					$nombre_foto 	= $foto['name'];
					$type 		 	= $foto['type'];
					$url_temp    	= $foto['tmp_name'];
					$nombreImagen 	= 'avatar.png';
					$request_cateria = "";
					if($nombre_foto != ''){
						$nombreImagen = 'foto_'.$strNombres.' '.$strApellidos.'_'.rand(1,10000).'_'.$nombre_foto;
					}

					if(!empty($_FILES['txtSolicitudEmpleo']))
					{
						$solicitudEmpleo = $_FILES['txtSolicitudEmpleo'];
						$nombre_solicitud_empleo = $solicitudEmpleo['name'];
						$type_solicitud_empleo = $solicitudEmpleo['type'];
						$url_temp_solicitud_empleo = $solicitudEmpleo['tmp_name'];
						$requestSolicitudEmpleo = "";
						if($nombre_solicitud_empleo != '')
						{
							$nombreSolicitudEmpleo = 'Solicitud_Empleo_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_solicitud_empleo;
						}
					}

					if(!empty($_FILES['txtCv']))
					{
						$cv = $_FILES['txtCv'];
						$nombre_cv = $cv['name'];
						$type_cv = $cv['type'];
						$url_temp_cv = $cv['tmp_name'];
						$requestCv = "";
						if($nombre_cv != '')
						{
							$nombreCv = 'CV_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_cv;
						}
					}

					if(!empty($_FILES['txtAntecedentes']))
					{
						$antecedentes_penales = $_FILES['txtAntecedentes'];
						$nombre_antecedentes_penales = $antecedentes_penales['name'];
						$type_antecedentes_penales = $antecedentes_penales['type'];
						$url_temp_antecedentes_penales = $antecedentes_penales['tmp_name'];
						$requestAntecedentesPenales = "";
						if($nombre_antecedentes_penales != '')
						{
							$nombreAntecedentesPenales = 'Antecedentes_No_Penales_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_antecedentes_penales;
						}
					}

					if(!empty($_FILES['txtCertificadoMedico']))
					{
						$certificado_medico = $_FILES['txtCertificadoMedico'];
						$nombre_certificado_medico = $certificado_medico['name'];
						$type_certificado_medico = $certificado_medico['type'];
						$url_temp_certificado_medico = $certificado_medico['tmp_name'];
						$requestCertificadoMedico = "";
						if($nombre_certificado_medico != '')
						{
							$nombreCertificadoMedico = 'Certificado_Medico_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_certificado_medico;
						}
					}

					if(!empty($_FILES['txtCartasRecomendacion']))
					{
						$cartas_recomendacion = $_FILES['txtCartasRecomendacion'];
						$nombre_cartas_recomendacion = $cartas_recomendacion['name'];
						$type_cartas_recomendacion = $cartas_recomendacion['type'];
						$url_temp_cartas_recomendacion = $cartas_recomendacion['tmp_name'];
						$requestCartasRecomendacion = "";
						if($nombre_cartas_recomendacion != '')
						{
							$nombreCartasRecomendacion = 'Cartas_Recomendacion_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_cartas_recomendacion;
						}
					}

					if(!empty($_FILES['txtFotos']))
					{
						$fotos = $_FILES['txtFotos'];
						$nombre_fotos = $fotos['name'];
						$type_fotos = $fotos['type'];
						$url_temp_fotos = $fotos['tmp_name'];
						$requestFotos = "";
						if($nombre_fotos != '')
						{
							$nombreFotos = 'Fotos_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_fotos;
						}
					}

					if(!empty($_FILES['txtIne']))
					{
						$ine = $_FILES['txtIne'];
						$nombre_ine = $ine['name'];
						$type_ine = $ine['type'];
						$url_temp_ine = $ine['tmp_name'];
						$requestIne = "";
						if($nombre_ine != '')
						{
							$nombreINE = 'INE_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_ine;
						}
					}

					if(!empty($_FILES['txtCartillaMilitar']))
					{
						$cartilla_militar = $_FILES['txtCartillaMilitar'];
						$nombre_cartilla_militar = $cartilla_militar['name'];
						$type_cartilla_militar = $cartilla_militar['type'];
						$url_temp_cartilla_militar = $cartilla_militar['tmp_name'];
						$requestCartillaMilitar = "";
						if($nombre_cartilla_militar != '')
						{
							$nombreCartillaMilitar = 'Cartilla_Militar_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_cartilla_militar;
						}
					}

					if(!empty($_FILES['txtEcurp']))
					{
						$curp = $_FILES['txtEcurp'];
						$nombre_curp = $curp['name'];
						$type_curp = $curp['type'];
						$url_temp_curp = $curp['tmp_name'];
						$requestCurp = "";
						if($nombre_curp != '')
						{
							$nombreCurp = 'CURP_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_curp;
						}
					}

					if(!empty($_FILES['txtErfc']))
					{
						$rfc = $_FILES['txtErfc'];
						$nombre_rfc = $rfc['name'];
						$type_rfc = $rfc['type'];
						$url_temp_rfc = $rfc['tmp_name'];
						$requestRfc = "";
						if($nombre_rfc != '')
						{
							$nombreRfc = 'RFC_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_rfc;
						}
					}

					if(!empty($_FILES['txtActaNacimiento']))
					{
						$acta_nacimiento = $_FILES['txtActaNacimiento'];
						$nombre_acta_nacimiento = $acta_nacimiento['name'];
						$type_acta_nacimiento = $acta_nacimiento['type'];
						$url_temp_acta_nacimiento = $acta_nacimiento['tmp_name'];
						$requestActaNacimiento = "";
						if($nombre_acta_nacimiento != '')
						{
							$nombreActaNacimiento = 'Acta_Nacimiento_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_acta_nacimiento;
						}
					}
					
					if(!empty($_FILES['txtComprobanteDomicilio']))
					{
						$comprobante_domicilio = $_FILES['txtComprobanteDomicilio'];
						$nombre_comprobante_domicilio = $comprobante_domicilio['name'];
						$type_comprobante_domicilio = $comprobante_domicilio['type'];
						$url_temp_comprobante_domicilio = $comprobante_domicilio['tmp_name'];
						$requestComprobanteDomicilio = "";
						if($nombre_comprobante_domicilio != '')
						{
							$nombreComprobanteDomicilio = 'Comprobante_Domicilio_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_comprobante_domicilio;
						}
					}

					if(!empty($_FILES['txtCertificaciones']))
					{
						$certificaciones = $_FILES['txtCertificaciones'];
						$nombre_certificaciones = $certificaciones['name'];
						$type_certificaciones = $certificaciones['type'];
						$url_temp_certificaciones = $certificaciones['tmp_name'];
						$requestCertificaciones = "";
						if($nombre_certificaciones != '')
						{
							$nombreCertificaciones = 'Certificaciones_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_certificaciones;
						}
					}

					if(!empty($_FILES['txtTitulo']))
					{
						$titulo = $_FILES['txtTitulo'];
						$nombre_titulo = $titulo['name'];
						$type_titulo = $titulo['type'];
						$url_temp_titulo = $titulo['tmp_name'];
						$requestTitulo = "";
						if($nombre_titulo != '')
						{
							$nombreTitulo = 'Titulo_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_titulo;
						}
					}

					if(!empty($_FILES['txtCedulaProfesional']))
					{
						$cedula = $_FILES['txtCedulaProfesional'];
						$nombre_cedula = $cedula['name'];
						$type_cedula = $cedula['type'];
						$url_temp_cedula = $cedula['tmp_name'];
						$requestCedula = "";
						if($nombre_cedula != '')
						{
							$nombreCedula = 'Cedula_'.$strNombreCompleto.'_'.rand(1,100000000).'_'.$nombre_cedula;
						}
					}

					/*dep("IDENTIFICADOR: ".$strIdentificador);
					dep("NOMBRES: ".$strNombres); 
					dep("APELLIDOS: ".$strApellidos); 
					dep("EMAIL: ".$strEmail);
					dep("PASSWORD: ".$strPassword); 
					dep("ID ROL: ".$intTipoId);
					dep("SEXO: ".$strSexo); 
					dep("ESTADO CIVIL: ".$strEstadoCivil); 
					dep("FECHA NACIMIENTO: ".$strFechaNacimiento); 
					dep("RFC: ".$strRfc);
					dep("CURP: ".$strCurp);
					dep("DIRECCION: ".$strDireccion);
					dep("CP: ".$strCodigoPostal); 
					dep("CIUDAD: ".$strCiudad); 
					dep("ESTADO: ".$strEstado);
					dep("PAIS: ".$strPais); 
					dep("SALARIO: ".$floatSalario);
					dep("TELEFONO CELULAR: ".$strTelefonoCelular); 
					dep("TELEFONO FIJO: ".$strTelefonoFijo); 
					dep("EMPRESA: ".$strEmpresa); 
					dep("TEL EMPRESA: ".$strTelefonoEmpresa);
					dep("NOM. EMERGENCIA: ".$strNombreEmergencia);
					dep("REL. EMERGENCIA: ".$strRelacionEmergencia);
					dep("TEL. EMERGENCIA: ".$strTelefonoEmergencia); 
					dep("TIPO SANGRE: ".$strTipoSangre); 
					dep("PUESTO: ".$strPuesto);
					dep("DEPTO: ".$strDepartamento); 
					dep("ID NIVEL: ".$intNivelId);
					dep("FECHA CONTRATACION: ".$strFechaContratacion); 
					dep("TIPO DOCENTE: ".$strTipoDocente); 
					dep("FORMA PAGO: ".$strFormaPago); 
					dep("NIVEL ESTUDIOS: ".$strNivelEstudios);
					dep("FECHA EGRESO: ".$strFechaEgreso);
					dep("INSTITUCIÓN: ".$strInstitucion);
					dep("NUM. CEDULA PROF: ".$strNumeroCedula); 
					dep("CAMPO ESTUDIOS: ".$strCampoEstudios); 
					dep("EXPERIENCIA DOCENTE: ".$strExperienciaDocente);
					dep("EXPERIENCIA PROFESIONAL: ".$strExperienciaProfesional); 
					dep("EXPERICNECIA LABORAL: ".$strExperienciaLaboral);
					dep("PRIORIDAD: ".$strPrioridad); 
					dep("NECESIDAD RH: ".$strNecesidad);
					dep("F.ENTREVISTA INICIAL: ".$strFechaEntrevistaInicial); 
					dep("F. MICROENSEÑANZA: ".$strFechaMicroenseñanza);
					dep("F. ENTREVISTA FINAL: ".$strFechaEntrevistaFinal);
					dep("FECHA INDUCCION: ".$strFechaInduccion); 
					dep("SOLICITUD EMPLEO: ".$nombreSolicitudEmpleo); 
					dep("CURRICULUM: ".$nombreCv);
					dep("ANTECEDENTES PENALES: ".$nombreAntecedentesPenales); 
					dep("CERT MEDICO: ".$nombreCertificadoMedico);
					dep("CARTAS RECOMENDACION: ".$nombreCartasRecomendacion); 
					dep("FOTOS: ".$nombreFotos); 
					dep("INE: ".$nombreINE); 
					dep("CARTILLA MILITAR: ".$nombreCartillaMilitar);
					dep("CURP: ".$nombreCurp);
					dep("RFC: ".$nombreRfc);
					dep("ACTA NACIMIENTO: ".$nombreActaNacimiento);
					dep("COMPROBANTE DOMICILIO: ".$nombreComprobanteDomicilio); 
					dep("CERTIFICACIONES: ".$nombreCertificaciones);
					dep("TÍTULO: ".$nombreTitulo); 
					dep("CEDULA: ".$nombreCedula);
					dep("CURSO EBD: ".$strCursoEbd); 
					dep("F. CURSO EBD: ".$strFechaCursoEbd); 
					dep("OTROS CURSOS: ".$strOtrosCursos);
					dep("COMENTARIOS: ".$strComentarios);
					dep("MODIFICADOR: ".$strModificador);
					dep("TIPO MOVIMIENTO: ".$strTipoMovimiento);
					dep("ESTATUS: ".$intStatus);
					exit;*/

					$requestDocente = "";

					if($idDocente == 0)
					{
						$option = 1;
						$strTipoMovimiento = 'Alta';
						$strPassword = empty($_POST['txtPassword']) ? hash("SHA256",passGenerator()) : hash("SHA256",$_POST['txtPassword']);

						if($_SESSION['permisosMod']['w']){
							$requestDocente = $this->model->insertDocente($strIdentificador,
																			$nombreImagen,
																			$strNombres, 
																			$strApellidos, 
																			$strEmail,
																			$strPassword, 
																			$intTipoId,
																			$strSexo, 
																			$strEstadoCivil, 
																			$strFechaNacimiento, 
																			$strRfc,
																			$strCurp,
																			$strDireccion,
																			$strCodigoPostal, 
																			$strCiudad, 
																			$strEstado,
																			$strPais, 
																			$floatSalario,
																			$strTelefonoCelular, 
																			$strTelefonoFijo, 
																			$strEmpresa, 
																			$strTelefonoEmpresa,
																			$strNombreEmergencia,
																			$strRelacionEmergencia,
																			$strTelefonoEmergencia, 
																			$strTipoSangre, 
																			$strPuesto,
																			$strDepartamento, 
																			$intNivelId,
																			$strFechaContratacion, 
																			$strTipoDocente, 
																			$strFormaPago, 
																			$strNivelEstudios,
																			$strFechaEgreso,
																			$strInstitucion,
																			$strNumeroCedula, 
																			$strCampoEstudios, 
																			$strExperienciaDocente,
																			$strExperienciaProfesional, 
																			$strExperienciaLaboral,
																			$strPrioridad, 
																			$strNecesidad, 
																			$strFechaEntrevistaInicial, 
																			$strFechaMicroenseñanza,
																			$strFechaEntrevistaFinal,
																			$strFechaInduccion, 
																			$nombreSolicitudEmpleo, 
																			$nombreCv,
																			$nombreAntecedentesPenales, 
																			$nombreCertificadoMedico,
																			$nombreCartasRecomendacion, 
																			$nombreFotos, 
																			$nombreINE, 
																			$nombreCartillaMilitar,
																			$nombreCurp,
																			$nombreRfc,
																			$nombreActaNacimiento, 
																			$nombreComprobanteDomicilio, 
																			$nombreCertificaciones,
																			$nombreTitulo, 
																			$nombreCedula,
																			$strCursoEbd, 
																			$strFechaCursoEbd, 
																			$strOtrosCursos, 
																			$strComentarios,
																			$strModificador,
																			$strTipoMovimiento,
																			$intStatus);
						}
					}else{
						$option = 2;
						$arrDataDocente = $this->model->selectDocente($idDocente);
						$anteriorSolicitudEmpleo = $arrDataDocente['solicitud_empleo'];
						$anteriorCurriculum = $arrDataDocente['cv'];
						$anteriorAntecedentesPenales = $arrDataDocente['antecedentes_no_penales'];
						$anteriorCertficadoMedico = $arrDataDocente['certificado_medico'];
						$anteriorCartasRecomendacion = $arrDataDocente['cartas_recomendacion'];
						$anteriorFotos = $arrDataDocente['fotos'];
						$anteriorIne = $arrDataDocente['ine'];
						$anteriorCartillaMilitar = $arrDataDocente['cartilla_militar'];
						$anteriorCurp = $arrDataDocente['e_curp'];
						$anteriorRfc = $arrDataDocente['e_rfc'];
						$anteriorActaNacimiento = $arrDataDocente['acta_nacimiento'];
						$anteriorComprobanteDomicilio = $arrDataDocente['comprobante_domicilio'];
						$anteriorCertificaciones = $arrDataDocente['certificaciones'];
						$anteriorTitulo = $arrDataDocente['titulo'];
						$anteriorCedulaProfesional = $arrDataDocente['cedula_profesional'];
						if($nombreSolicitudEmpleo == ""){
							$nombreSolicitudEmpleo = $anteriorSolicitudEmpleo;
						}
						if($nombreCv == ""){
							$nombreCv = $anteriorCurriculum;
						}
						if($nombreAntecedentesPenales == ""){
							$nombreAntecedentesPenales = $anteriorAntecedentesPenales;
						}
						if($nombreCertificadoMedico == ""){
							$nombreCertificadoMedico = $anteriorCertficadoMedico;
						}
						if($nombreCartasRecomendacion == ""){
							$nombreCartasRecomendacion = $anteriorCartasRecomendacion;
						}
						if($nombreFotos == ""){
							$nombreFotos = $anteriorFotos;
						}
						if($nombreINE == ""){
							$nombreINE = $anteriorIne;
						}
						if($nombreCartillaMilitar == ""){
							$nombreCartillaMilitar = $anteriorCartillaMilitar;
						}
						if($nombreCurp == ""){
							$nombreCurp = $anteriorCurp;
						}
						if($nombreRfc == ""){
							$nombreRfc = $anteriorRfc;
						}
						if($nombreActaNacimiento == ""){
							$nombreActaNacimiento = $anteriorActaNacimiento;
						}
						if($nombreComprobanteDomicilio == ""){
							$nombreComprobanteDomicilio = $anteriorComprobanteDomicilio;
						}
						if($nombreCertificaciones == ""){
							$nombreCertificaciones = $anteriorCertificaciones;
						}
						if($nombreTitulo == ""){
							$nombreTitulo = $anteriorTitulo;
						}
						if($nombreCedula == ""){
							$nombreCedula = $anteriorCedulaProfesional;
						}

						if($nombre_foto == ''){
							if($_POST['foto_actual'] != 'avatar.png' AND $_POST['foto_remove'] == 0 ){
								$nombreImagen = $_POST['foto_actual'];
							}
							if($nombre_foto == '' AND $_POST['foto_remove'] == 1 AND $_POST['foto_actual'] != '')
							{
								$nombreImagen = $_POST['foto_actual'];
							}
						}
						
						$strTipoMovimiento = 'Actualización';
						$strPassword = empty($_POST['txtPassword']) ? "" : hash("SHA256",$_POST['txtPassword']);
						if($_SESSION['permisosMod']['u']){
							//dep($nombreSolicitudEmpleo);
							//exit;
							$requestDocente = $this->model->updateDocente($idDocente,
																			$strIdentificador,
																			$nombreImagen,
																			$strNombres, 
																			$strApellidos, 
																			$strEmail,
																			$strPassword, 
																			$intTipoId,
																			$strSexo, 
																			$strEstadoCivil, 
																			$strFechaNacimiento, 
																			$strRfc,
																			$strCurp,
																			$strDireccion,
																			$strCodigoPostal, 
																			$strCiudad, 
																			$strEstado,
																			$strPais, 
																			$floatSalario,
																			$strTelefonoCelular, 
																			$strTelefonoFijo, 
																			$strEmpresa, 
																			$strTelefonoEmpresa,
																			$strNombreEmergencia,
																			$strRelacionEmergencia,
																			$strTelefonoEmergencia, 
																			$strTipoSangre, 
																			$strPuesto,
																			$strDepartamento, 
																			$intNivelId,
																			$strFechaContratacion, 
																			$strTipoDocente, 
																			$strFormaPago, 
																			$strNivelEstudios,
																			$strFechaEgreso,
																			$strInstitucion,
																			$strNumeroCedula, 
																			$strCampoEstudios, 
																			$strExperienciaDocente,
																			$strExperienciaProfesional, 
																			$strExperienciaLaboral,
																			$strPrioridad, 
																			$strNecesidad, 
																			$strFechaEntrevistaInicial, 
																			$strFechaMicroenseñanza,
																			$strFechaEntrevistaFinal,
																			$strFechaInduccion, 
																			$nombreSolicitudEmpleo, 
																			$nombreCv,
																			$nombreAntecedentesPenales, 
																			$nombreCertificadoMedico,
																			$nombreCartasRecomendacion, 
																			$nombreFotos, 
																			$nombreINE, 
																			$nombreCartillaMilitar,
																			$nombreCurp,
																			$nombreRfc,
																			$nombreActaNacimiento, 
																			$nombreComprobanteDomicilio, 
																			$nombreCertificaciones,
																			$nombreTitulo, 
																			$nombreCedula,
																			$strCursoEbd, 
																			$strFechaCursoEbd, 
																			$strOtrosCursos, 
																			$strComentarios,
																			$strModificador,
																			$strTipoMovimiento,
																			$intPersonaId,
																			$intStatus);
						}

					}

					if(intval($requestDocente) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
							if($nombre_foto != "")
							{
								if(is_dir('Assets/fotos_usuarios'))
								{
									uploadFoto($foto,$nombreImagen);
								}else{
									mkdir("Assets/fotos_usuarios/", 0777);
									uploadFoto($foto,$nombreImagen);
								}
							}
							if($nombreSolicitudEmpleo != '')
							{ 
								if(is_dir('Assets/documentacion/solicitudes_empleo')){
									uploadDocumentacion($solicitudEmpleo,$nombreSolicitudEmpleo,"solicitudes_empleo"); 
								}
							}
							if($nombreCv != '')
							{ 
								if(is_dir('Assets/documentacion/curriculums')){
									uploadDocumentacion($cv,$nombreCv,"curriculums"); 
								}
							}
							if($nombreAntecedentesPenales != '')
							{ 
								if(is_dir('Assets/documentacion/antecedentes_no_penales')){
									uploadDocumentacion($antecedentes_penales,$nombreAntecedentesPenales,"antecedentes_no_penales"); 
								}
							}
							if($nombreCertificadoMedico != '')
							{ 
								if(is_dir('Assets/documentacion/certificados_medicos')){
									uploadDocumentacion($certificado_medico,"certificados_medicos"); 
								}
							}
							if($nombreCartasRecomendacion != '')
							{ 
								if(is_dir('Assets/documentacion/cartas_recomendacion')){
									uploadDocumentacion($cartas_recomendacion,$nombreCartasRecomendacion,"carteas_recomendacion"); 
								}
							}
							if($nombreFotos != '')
							{ 
								if(is_dir('Assets/documentacion/fotos')){
									uploadDocumentacion($fotos,$nombreFotos,"fotos"); 
								}
							}
							if($nombreINE != '')
							{ 
								if(is_dir('Assets/documentacion/ines')){
									uploadDocumentacion($ine,$nombreINE,"ines"); 
								}
							}
							if($nombreCartillaMilitar != '')
							{ 
								if(is_dir('Assets/documentacion/cartillas_militares')){
									uploadDocumentacion($cartilla_militar,$nombreCartillaMilitar,"cartillas_militares"); 
								}
							}
							if($nombreCurp != '')
							{ 
								if(is_dir('Assets/documentacion/curps')){
									uploadDocumentacion($curp,$nombreCurp,"curps"); 
								}
							}
							if($nombreRfc != '')
							{ 
								if(is_dir('Assets/documentacion/rfcs')){
									uploadDocumentacion($rfc,$nombreRfc,"rfcs"); 
								}
							}
							if($nombreActaNacimiento != '')
							{ 
								if(is_dir('Assets/documentacion/actas_nacimiento')){
									uploadDocumentacion($acta_nacimiento,$nombreActaNacimiento,"actas_nacimiento"); 
								}
							}
							if($nombreComprobanteDomicilio != '')
							{ 
								if(is_dir('Assets/documentacion/comprobantes_domicilio')){
									uploadDocumentacion($comprobante_domicilio,$nombreComprobanteDomicilio,"comprobantes_domicilio"); 
								}
							}
							if($nombreCertificaciones != '')
							{ 
								if(is_dir('Assets/documentacion/certificaciones')){
									uploadDocumentacion($certificaciones,$nombreCertificaciones,"certificaciones"); 
								}
							}
							if($nombreTitulo != '')
							{ 
								if(is_dir('Assets/documentacion/titulos')){
									uploadDocumentacion($titulo,$nombreTitulo,"titulos"); 
								}
							}
							if($nombreCedula != '')
							{ 
								if(is_dir('Assets/documentacion/cedulas')){
									uploadDocumentacion($cedula,$nombreCedula,"cedulas"); 
								}
							}
						}else{
							
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
							if($nombre_foto != "" && $nombreImagen!='avatar.png')
							{
								if(is_dir('Assets/fotos_usuarios'))
								{
									uploadFoto($foto,$nombreImagen);
									if($_POST['foto_actual'] != 'avatar.png'){
										deleteFoto($_POST['foto_actual']);
									}
								}else{
									mkdir("Assets/fotos_usuarios/", 0777);
									uploadFoto($foto,$nombreImagen);
									if($_POST['foto_actual'] != 'avatar.png'){
										deleteFoto($_POST['foto_actual']);
									}
								}
							}
							if($nombreSolicitudEmpleo != '' AND ($anteriorSolicitudEmpleo!=$nombreSolicitudEmpleo))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/solicitudes_empleo')){
									uploadDocumentacion($solicitudEmpleo,$nombreSolicitudEmpleo,"solicitudes_empleo"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorSolicitudEmpleo != ''){
									if(is_dir('Assets/documentacion/solicitudes_empleo')){
										deleteDocumentacion($anteriorSolicitudEmpleo,"solicitudes_empleo");
									}
								}
							}
							if($nombreCv != '' AND ($anteriorCurriculum!=$nombreCv))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/curriculums')){
									uploadDocumentacion($cv,$nombreCv,"curriculums"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorCurriculum != ''){
									if(is_dir('Assets/documentacion/curriculums')){
										deleteDocumentacion($anteriorCurriculum,"curriculums");
									}
								}
							}
							if($nombreAntecedentesPenales != '' AND ($anteriorAntecedentesPenales!=$nombreAntecedentesPenales))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/antecedentes_no_penales')){
									uploadDocumentacion($antecedentes_penales,$nombreAntecedentesPenales,"antecedentes_no_penales"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorAntecedentesPenales != ''){
									if(is_dir('Assets/documentacion/antecedentes_no_penales')){
										deleteDocumentacion($anteriorAntecedentesPenales,"antecedentes_no_penales");
									}
								}
							}
							if($nombreCertificadoMedico != '' AND ($anteriorCertficadoMedico!=$nombreCertificadoMedico))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/certificados_medicos')){
									uploadDocumentacion($certificado_medico,$nombreCertificadoMedico,"certificados_medicos"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorCertficadoMedico != ''){
									if(is_dir('Assets/documentacion/certificados_medicos')){
										deleteDocumentacion($anteriorCertficadoMedico,"certificados_medicos");
									}
								}
							}
							if($nombreCartasRecomendacion != '' AND ($anteriorCartasRecomendacion!=$nombreCartasRecomendacion))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/cartas_recomendacion')){
									uploadDocumentacion($cartas_recomendacion,$nombreCartasRecomendacion,"cartas_recomendacion"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorCartasRecomendacion != ''){
									if(is_dir('Assets/documentacion/cartas_recomendacion')){
										deleteDocumentacion($anteriorCartasRecomendacion,"cartas_recomendacion");
									}
								}
							}
							if($nombreFotos != '' AND ($anteriorFotos!=$nombreFotos))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/fotos')){
									uploadDocumentacion($fotos,$nombreFotos,"fotos"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorFotos != ''){
									if(is_dir('Assets/documentacion/fotos')){
										deleteDocumentacion($anteriorFotos,"fotos");
									}
								}
							}
							if($nombreINE != '' AND ($anteriorIne!=$nombreINE))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/ines')){
									uploadDocumentacion($ine,$nombreINE,"ines"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorIne != ''){
									if(is_dir('Assets/documentacion/ines')){
										deleteDocumentacion($anteriorIne,"ines");
									}
								}
							}
							if($nombreCartillaMilitar != '' AND ($anteriorCartillaMilitar!=$nombreCartillaMilitar))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/cartillas_militares')){
									uploadDocumentacion($cartilla_militar,$nombreCartillaMilitar,"cartillas_militares"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorCartillaMilitar != ''){
									if(is_dir('Assets/documentacion/cartillas_militares')){
										deleteDocumentacion($anteriorCartillaMilitar,"cartillas_militares");
									}
								}
							}
							if($nombreCurp != '' AND ($anteriorCurp!=$nombreCurp))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/curps')){
									uploadDocumentacion($curp,$nombreCurp,"curps"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorCurp != ''){
									if(is_dir('Assets/documentacion/curps')){
										deleteDocumentacion($anteriorCurp,"curps");
									}
								}
							}
							if($nombreRfc != '' AND ($anteriorRfc!=$nombreRfc))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/rfcs')){
									uploadDocumentacion($rfc,$nombreRfc,"rfcs"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorRfc != ''){
									if(is_dir('Assets/documentacion/rfcs')){
										deleteDocumentacion($anteriorRfc,"rfcs");
									}
								}
							}
							if($nombreActaNacimiento != '' AND ($anteriorActaNacimiento!=$nombreActaNacimiento))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/actas_nacimiento')){
									uploadDocumentacion($acta_nacimiento,$nombreActaNacimiento,"actas_nacimiento"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorActaNacimiento != ''){
									if(is_dir('Assets/documentacion/actas_nacimiento')){
										deleteDocumentacion($anteriorActaNacimiento,"actas_nacimiento");
									}
								}
							}
							if($nombreComprobanteDomicilio != '' AND ($anteriorComprobanteDomicilio!=$nombreComprobanteDomicilio))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/comprobantes_domicilio')){
									uploadDocumentacion($comprobante_domicilio,$nombreComprobanteDomicilio,"comprobantes_domicilio"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorComprobanteDomicilio != ''){
									if(is_dir('Assets/documentacion/comprobantes_domicilio')){
										deleteDocumentacion($anteriorComprobanteDomicilio,"comprobantes_domicilio");
									}
								}
							}
							if($nombreCertificaciones != '' AND ($anteriorCertificaciones!=$nombreCertificaciones))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/certificaciones')){
									uploadDocumentacion($certificaciones,$nombreCertificaciones,"certificaciones"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorCertificaciones != ''){
									if(is_dir('Assets/documentacion/certificaciones')){
										deleteDocumentacion($anteriorCertificaciones,"certificaciones");
									}
								}
							}
							if($nombreTitulo != '' AND ($anteriorTitulo!=$nombreTitulo))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/titulos')){
									uploadDocumentacion($titulo,$nombreTitulo,"titulos"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorTitulo != ''){
									if(is_dir('Assets/documentacion/titulos')){
										deleteDocumentacion($anteriorTitulo,"titulos");
									}
								}
							}
							if($nombreCedula != '' AND ($anteriorCedulaProfesional!=$nombreCedula))
							{
								//Subimos la nueva documentación al directorio
								if(is_dir('Assets/documentacion/cedulas')){
									uploadDocumentacion($cedula,$nombreCedula,"cedulas"); 
								}
								//Eliminamos la documentación anterior del directorio
								if($anteriorCedulaProfesional != ''){
									if(is_dir('Assets/documentacion/cedulas')){
										deleteDocumentacion($anteriorCedulaProfesional,"cedulas");
									}
								}
							}

						}
					}else if($requestDocente == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! el email o la identificación ya existe, ingrese otro.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getDocentes()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectDocentes();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewDocente" onClick="fntViewDocente('.$arrData[$i]['iddocente'].')" title="Ver docente"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						if($_SESSION['userData']['idrol'] == RADMINISTRADOR || $_SESSION['userData']['idrol'] == RADMINRECURSOSHUMANOS || $_SESSION['userData']['idrol'] == RADMINBACHILLERATO)
						{
							$btnEdit = '<button class="btn btn-primary  btn-sm btnEditDocente" onClick="fntEditDocente(this,'.$arrData[$i]['iddocente'].')" title="Editar usuario"><i class="fas fa-pencil-alt"></i></button>';
						}else{
							$btnEdit = '<button class="btn btn-secondary btn-sm" disabled><i class="fas fa-pencil-alt"></i></button>';
						}
					}
					if($_SESSION['permisosMod']['d']){
						if($_SESSION['userData']['idrol'] == RADMINISTRADOR || $_SESSION['userData']['idrol'] == RADMINRECURSOSHUMANOS || $_SESSION['userData']['idrol'] == RADMINBACHILLERATO)
						{
							$btnDelete = '<button class="btn btn-danger btn-sm btnDelDocente" onClick="fntDelDocente('.$arrData[$i]['iddocente'].')" title="Eliminar docente"><i class="far fa-trash-alt"></i></button>';
						}else{
							$btnDelete = '<button class="btn btn-secondary btn-sm" disabled><i class="far fa-trash-alt"></i></button>';
						}
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getDocente($iddocente){
			if($_SESSION['permisosMod']['r']){
				$intIdDocente = intval($iddocente);
				if($intIdDocente > 0)
				{
					$arrData = $this->model->selectDocente($intIdDocente);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrData['url_foto'] = media().'/fotos_usuarios/'.$arrData['foto'];
						if($arrData['solicitud_empleo']=="")
						{
							$arrData['ruta_solicitud_empleo']="";
						}else{
							$arrData['ruta_solicitud_empleo']='<a href="'.base_url().'/Assets/documentacion/solicitudes_empleo'.'/'.$arrData['solicitud_empleo'].'" target="blank">Ver solicitud empleo</a>';
						}
						if($arrData['cv']=="")
						{
							$arrData['ruta_cv']="";
						}else{
							$arrData['ruta_cv']='<a href="'.base_url().'/Assets/documentacion/curriculums'.'/'.$arrData['cv'].'" target="blank">Ver Curriculum Vitae</a>';
						}
						if($arrData['antecedentes_no_penales']=="")
						{
							$arrData['ruta_antecedentes']="";
						}else{
							$arrData['ruta_antecedentes']='<a href="'.base_url().'/Assets/documentacion/antecedentes_no_penales'.'/'.$arrData['antecedentes_no_penales'].'" target="blank">Ver Antecedentes No Penales</a>';
						}
						if($arrData['certificado_medico']=="")
						{
							$arrData['ruta_certificado_medico']="";
						}else{
							$arrData['ruta_certificado_medico']='<a href="'.base_url().'/Assets/documentacion/certificados_medicos'.'/'.$arrData['certificado_medico'].'" target="blank">Ver Certificado Médico</a>';
						}
						if($arrData['cartas_recomendacion']=="")
						{
							$arrData['ruta_cartas_recomendacion']="";
						}else{
							$arrData['ruta_cartas_recomendacion']='<a href="'.base_url().'/Assets/documentacion/cartas_recomendacion'.'/'.$arrData['cartas_recomendacion'].'" target="blank">Ver cartas recomendación</a>';
						}
						if($arrData['fotos']=="")
						{
							$arrData['ruta_fotos']="";
						}else{
							$arrData['ruta_fotos']='<a href="'.base_url().'/Assets/documentacion/fotos'.'/'.$arrData['fotos'].'" target="blank">Ver fotos</a>';
						}
						if($arrData['ine']=="")
						{
							$arrData['ruta_ine']="";
						}else{
							$arrData['ruta_ine']='<a href="'.base_url().'/Assets/documentacion/ines'.'/'.$arrData['ine'].'" target="blank">Ver INE</a>';
						}
						if($arrData['cartilla_militar']=="")
						{
							$arrData['ruta_cartilla_militar']="";
						}else{
							$arrData['ruta_cartilla_militar']='<a href="'.base_url().'/Assets/documentacion/cartillas_militares'.'/'.$arrData['cartilla_militar'].'" target="blank">Ver cartilla militar</a>';
						}
						if($arrData['e_curp']=="")
						{
							$arrData['ruta_ecurp']="";
						}else{
							$arrData['ruta_ecurp']='<a href="'.base_url().'/Assets/documentacion/curps'.'/'.$arrData['e_curp'].'" target="blank">Ver CURP</a>';
						}
						if($arrData['e_rfc']=="")
						{
							$arrData['ruta_erfc']="";
						}else{
							$arrData['ruta_erfc']='<a href="'.base_url().'/Assets/documentacion/rfcs'.'/'.$arrData['e_rfc'].'" target="blank">Ver RFC</a>';
						}
						if($arrData['acta_nacimiento']=="")
						{
							$arrData['ruta_acta_nacimiento']="";
						}else{
							$arrData['ruta_acta_nacimiento']='<a href="'.base_url().'/Assets/documentacion/actas_nacimiento'.'/'.$arrData['acta_nacimiento'].'" target="blank">Ver acta nacimiento</a>';
						}
						if($arrData['comprobante_domicilio']=="")
						{
							$arrData['ruta_comprobante_domicilio']="";
						}else{
							$arrData['ruta_comprobante_domicilio']='<a href="'.base_url().'/Assets/documentacion/comprobantes_domicilio'.'/'.$arrData['comprobante_domicilio'].'" target="blank">Ver comprobante de domicilio</a>';
						}
						if($arrData['certificaciones']=="")
						{
							$arrData['ruta_certificaciones']="";
						}else{
							$arrData['ruta_certificaciones']='<a href="'.base_url().'/Assets/documentacion/certificaciones'.'/'.$arrData['certificaciones'].'" target="blank">Ver certificaciones</a>';
						}
						if($arrData['titulo']=="")
						{
							$arrData['ruta_titulo']="";
						}else{
							$arrData['ruta_titulo']='<a href="'.base_url().'/Assets/documentacion/titulos'.'/'.$arrData['titulo'].'" target="blank">Ver título</a>';
						}
						if($arrData['cedula_profesional']=="")
						{
							$arrData['ruta_cedula_profesional']="";
						}else{
							$arrData['ruta_cedula_profesional']='<a href="'.base_url().'/Assets/documentacion/cedulas'.'/'.$arrData['cedula_profesional'].'" target="blank">Ver cedula profesional</a>';
						}

						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delDocente()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$idDocente = intval($_POST['idpersona']);
					$requestId = $this->model->selectId($idDocente);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					
					$arrDataDocente = $this->model->selectDocente($idDocente);
					$foto=$arrDataDocente['foto'];
					$anteriorSolicitudEmpleo = $arrDataDocente['solicitud_empleo'];
					$anteriorCurriculum = $arrDataDocente['cv'];
					$anteriorAntecedentesPenales = $arrDataDocente['antecedentes_no_penales'];
					$anteriorCertficadoMedico = $arrDataDocente['certificado_medico'];
					$anteriorCartasRecomendacion = $arrDataDocente['cartas_recomendacion'];
					$anteriorFotos = $arrDataDocente['fotos'];
					$anteriorIne = $arrDataDocente['ine'];
					$anteriorCartillaMilitar = $arrDataDocente['cartilla_militar'];
					$anteriorCurp = $arrDataDocente['e_curp'];
					$anteriorRfc = $arrDataDocente['e_rfc'];
					$anteriorActaNacimiento = $arrDataDocente['acta_nacimiento'];
					$anteriorComprobanteDomicilio = $arrDataDocente['comprobante_domicilio'];
					$anteriorCertificaciones = $arrDataDocente['certificaciones'];
					$anteriorTitulo = $arrDataDocente['titulo'];
					$anteriorCedulaProfesional = $arrDataDocente['cedula_profesional'];					

					$requestDelete = $this->model->deleteDocente($idDocente, $strModificador, $requestId['personaid']);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado el docente');
						if(is_dir('Assets/fotos_usuarios') AND $foto != '' AND $foto != 'avatar.png')
						{
							deleteFoto($foto);
						}
						if($anteriorSolicitudEmpleo != ''){
							if(is_dir('Assets/documentacion/solicitudes_empleo')){
								deleteDocumentacion($anteriorSolicitudEmpleo,"solicitudes_empleo");
							}
						}
						if($anteriorCurriculum != ''){
							if(is_dir('Assets/documentacion/curriculums')){
								deleteDocumentacion($anteriorCurriculum,"curriculums");
							}
						}			
						if($anteriorAntecedentesPenales != ''){
							if(is_dir('Assets/documentacion/antecedentes_no_penales')){
								deleteDocumentacion($anteriorAntecedentesPenales,"antecedentes_no_penales");
							}
						}
									
						if($anteriorCertficadoMedico != ''){
							if(is_dir('Assets/documentacion/certificados_medicos')){
								deleteDocumentacion($anteriorCertficadoMedico,"certificados_medicos");
							}
						}				
						if($anteriorCartasRecomendacion != ''){
							if(is_dir('Assets/documentacion/cartas_recomendacion')){
								deleteDocumentacion($anteriorCartasRecomendacion,"cartas_recomendacion");
							}
						}				
						if($anteriorFotos != ''){
							if(is_dir('Assets/documentacion/fotos')){
								deleteDocumentacion($anteriorFotos,"fotos");
							}
						}				
						if($anteriorIne != ''){
							if(is_dir('Assets/documentacion/ines')){
								deleteDocumentacion($anteriorIne,"ines");
							}
						}				
						if($anteriorCartillaMilitar != ''){
							if(is_dir('Assets/documentacion/cartillas_militares')){
								deleteDocumentacion($anteriorCartillaMilitar,"cartillas_militares");
							}
						}				
						if($anteriorCurp != ''){
							if(is_dir('Assets/documentacion/curps')){
								deleteDocumentacion($anteriorCurp,"curps");
							}
						}				
						if($anteriorRfc != ''){
							if(is_dir('Assets/documentacion/rfcs')){
								deleteDocumentacion($anteriorRfc,"rfcs");
							}
						}				
						if($anteriorActaNacimiento != ''){
							if(is_dir('Assets/documentacion/actas_nacimiento')){
								deleteDocumentacion($anteriorActaNacimiento,"actas_nacimiento");
							}
						}				
						if($anteriorComprobanteDomicilio != ''){
							if(is_dir('Assets/documentacion/comprobantes_domicilio')){
								deleteDocumentacion($anteriorComprobanteDomicilio,"comprobantes_domicilio");
							}
						}				
						if($anteriorCertificaciones != ''){
							if(is_dir('Assets/documentacion/certificaciones')){
								deleteDocumentacion($anteriorCertificaciones,"certificaciones");
							}
						}				
						if($anteriorTitulo != ''){
							if(is_dir('Assets/documentacion/titulos')){
								deleteDocumentacion($anteriorTitulo,"titulos");
							}
						}				
						if($anteriorCedulaProfesional != ''){
							if(is_dir('Assets/documentacion/cedulas')){
								deleteDocumentacion($anteriorCedulaProfesional,"cedulas");
							}
						}		
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el registro del Docente.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function perfil(){
			$data['page_tag'] = "Perfil";
			$data['page_title'] = "Perfil de usuario";
			$data['page_name'] = "perfil";
			$data['page_functions_js'] = "functions_usuarios.js";
			$this->views->getView($this,"perfil",$data);
		}

		public function putPerfil(){
			if($_POST){
				if(empty($_POST['txtNombre']) || empty($_POST['txtApellido']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{
					$idUsuario = $_SESSION['idUser'];
					$strNombresMin = strtolower(strClean($_POST['txtNombre']));
					$strNombre = ucwords($strNombresMin);
					$strApellidosMin = strtolower(strClean($_POST['txtApellido']));
					$strApellido = ucwords($strApellidosMin);
					$strPassword = "";
					$strDireccion = strClean($_POST['txtDireccion']);
					$strTelefono = strClean($_POST['txtTelefono']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$strTipoMovimiento = 'Actualización';
					
					if(!empty($_POST['txtPassword'])){
						$strPassword = hash("SHA256",$_POST['txtPassword']);
					}
					$request_user = $this->model->updatePerfil($idUsuario,
																$strNombre,
																$strApellido, 
																$strPassword,
																$strDireccion,
																$strTelefono,
																$strModificador,
																$strTipoMovimiento);
					if($request_user)
					{
						sessionUser($_SESSION['idUser']);
						$arrResponse = array('status' => true, 'msg' => 'Datos actualizados correctamente.');
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible actualizar los datos');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

	}

 ?>