<?php 
	require 'Libraries/html2pdf/vendor/autoload.php';
	use Spipu\Html2Pdf\Html2Pdf;

	class Editar_calificaciones extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MEDITARCALIFICACIONES);
		}

		public function Editar_calificaciones()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Editar Calificaciones";
			$data['page_title'] = "EDITAR CALIFICACIONES <small>UAF</small>";
			$data['page_name'] = "editar_calificaciones";
			$data['page_functions_js'] = "functions_editar_calificaciones.js";
			$data['niveles'] = $this->model->selectNiveles();
			$this->views->getView($this,"editar_calificaciones",$data);
		}

		public function updateCalificacion(){
			if($_POST){	
				if(empty($_POST['txtEditarNivel']) || empty($_POST['txtEditarCarrera']) || empty($_POST['txtEditarDocente']) || empty($_POST['txtEditarMateria']) || empty($_POST['listaElementos']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}elseif($_POST['txtSeleccion'] == 0){
					$arrResponse = array("status" => false, "msg" => 'Debe seleccionar a un alumno para editar el registro de calificación.');
				}else{ 
					$strDataArray = json_decode($_POST['listaElementos'], true);
					for ($i=0; $i < count($strDataArray); $i++) { 
						if($strDataArray[$i]['checked'] == true && $strDataArray[$i]['calificacion_a'] == "")
						{
							$arrResponse = array("status" => false, "msg" => 'El campo de la calificación es obligatorio.');
							echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
							exit();
						}
					}
					date_default_timezone_set('America/Mexico_City');
					$idKardex = intval($_POST['idkardex']);
					$strMatricula = strClean($_POST['txtMatricula']);
					$intNivelId = intval($_POST['nivelid']);
					$intCarreraId = intval($_POST['carreraid']);
					$strGrupo = strClean($_POST['grupo']);
					$intGrupoId = intval($_POST['grupoid']);
					$intProfesorId = intval($_POST['docenteid']);
					$intMateriaId = intval($_POST['materiaid']);
					$strData = $_POST['listaElementos'];
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$strFechaCaptura = "";
					if($_SESSION['userData']['idrol'] == RADMINESCOLARES || $_SESSION['userData']['idrol'] == RAUXESCOLARES){
						$strFechaCaptura = strClean($_POST['txtFechaCaptura']);
					}else{
						$strFechaCaptura = date('Y-m-d');
					}
					$strArrayGrupo = explode("-", $strGrupo);
					$intSemestre = intval($strArrayGrupo[0]);

					$requestCalificacion = "";

					if($idKardex > 0)
					{
						$strTipoMovimiento = 'Actualización';
						if($_SESSION['permisosMod']['u']){

							$requestCalificacion = $this->model->updateCalificaciones($idKardex,
																			$strMatricula,
																			$intNivelId,
																			$intCarreraId,
																			$intSemestre,
																			$intGrupoId,
																			$intProfesorId,
																			$intMateriaId,
																			$strData,
																			$strFechaCaptura,
																			$strModificador,
																			$strTipoMovimiento);
						}
					}
					if(intval($requestCalificacion) > 0 )
					{
						$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
					}else if($requestCalificacion == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Ya se encuentran registradas las calificaciones del periódo seleccionado.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function updateCalificacionIndividual(){
			if($_POST){	
				if(empty($_POST['idKardexIndividual']) || empty($_POST['idKardexJson']) || empty($_POST['listaElementosIndividual']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					if($_POST['txtCalificacionIndivA'] == "" && $_POST['txtCalificacionIndivB'] == "" && $_POST['txtCalificacionIndivC'] == "" && $_POST['txtCalificacionIndivD'] == "")
					{
						$arrResponse = array("status" => false, "msg" => 'El campo de la calificación es obligatorio.');
						echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
						exit();
					}
					date_default_timezone_set('America/Mexico_City');
					$idKardexIndividual = intval($_POST['idKardexIndividual']);
					$idKardexJson = intVal($_POST['idKardexJson']);
					$strCalificacionA = strClean($_POST['txtCalificacionIndivA']);
					$strCalificacionB = strClean($_POST['txtCalificacionIndivB']);
					$strCalificacionC = strClean($_POST['txtCalificacionIndivC']);
					$strCalificacionD = strClean($_POST['txtCalificacionIndivD']);
					$strData = $_POST['listaElementosIndividual'];
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$strFechaCaptura = date('Y-m-d');
					$strTipoMovimiento = 'Actualización';
					$requestCalificacionIndividual = "";

					if($idKardexIndividual > 0)
					{
						$strTipoMovimiento = 'Actualización';
						if($_SESSION['permisosMod']['u']){

							$requestCalificacionIndividual = $this->model->updateCalificacionIndividual($idKardexIndividual,
																			$idKardexJson,
																			$strCalificacionA,
																			$strCalificacionB,
																			$strCalificacionC,
																			$strCalificacionD,
																			$strData,
																			$strFechaCaptura,
																			$strModificador,
																			$strTipoMovimiento);
						}
					}

					if(intval($requestCalificacionIndividual) > 0 )
					{
						$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
					}else if($requestCalificacionIndividual == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Ya se encuentran registradas las calificaciones del periódo seleccionado.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getCarreras($nivelid){
			if($_SESSION['permisosMod']['r']){
				$intNivelId = intval($nivelid);
				if(intval($intNivelId) > 0)
				{
					$arrData = $this->model->selectCarreras($intNivelId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron carreras asignadas al nivel seleccionado.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan las carreras correspondientes al nivel seleccionado.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getGrupos($carreraid){
			if($_SESSION['permisosMod']['r']){
				$intCarreraId = intval($carreraid);
				$intPersonaId = $_SESSION['userData']['idpersona'];
				if(intval($intCarreraId) > 0)
				{
					$arrData = $this->model->selectGrupos($intCarreraId, $intPersonaId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron grupos asignados a la carrera seleccionada');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan los grupos correspondientes a la carrera seleccionada.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getAlumnosIndividual($carreraid){
			if($_SESSION['permisosMod']['r']){
				$intCarreraId = intval($carreraid);
				if(intval($intCarreraId) > 0)
				{
					$arrData = $this->model->selectAlumnosIndividual($intCarreraId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron alumnos asignados a la carrera seleccionada');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan los alumnos correspondientes a la carrera seleccionada.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getMaterias(){
			if($_POST)
			{
				if($_SESSION['permisosMod']['r'])
				{
					$intCarreraId = intval($_POST['carreraid']);
					$intGrupoId = strClean($_POST['grupoid']);
					$intPersonaId = $_SESSION['userData']['idpersona'];
					if(intval($intCarreraId) > 0)
					{
						$arrData = $this->model->selectMaterias($intCarreraId, $intGrupoId, $intPersonaId);
						if(empty($arrData))
						{
							$arrResponse = array('status' => false, 'msg' => 'No se encontraron calificaciones de materias asignadas al alumno seleccionado');
						}else{
							$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan las materias asignadas al alumno seleccionado.');
						}
						echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
					}
				}
				die();
			}
		}

		public function getMateriasIndividual(){
			if($_POST)
			{
				if($_SESSION['permisosMod']['r'])
				{
					$intCarreraId = intval($_POST['carreraid']);
					$intAlumnoId = intval($_POST['alumnoid']);
					if(intval($intCarreraId) > 0)
					{
						$arrData = $this->model->selectMateriasIndividual($intCarreraId, $intAlumnoId);
						if(empty($arrData))
						{
							$arrResponse = array('status' => false, 'msg' => 'No se encontraron materias asignadas al alumno seleccionado');
						}else{
							$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan las materias asignadas al alumno seleccionado.');
						}
						echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
					}
				}
				die();
			}
		}

		public function getBusquedaEditarAlumnos()
		{
			if($_POST)
			{
				if($_SESSION['permisosMod']['u'])
				{
					date_default_timezone_set('America/Mexico_City');
					$strFechaActual = date('Y-m-d');
					$intNivelId = intval($_POST['listNiveles']);
					$intCarreraId = intval($_POST['listCarreras']);
					$intGrupoId = intval($_POST['listGrupos']);
					$strGrupoUnformat = strClean($_POST['listGrupos']);
					$intMateriaId = intval($_POST['listMaterias']);
					$strArrayGrupo = explode("-", $strGrupoUnformat);
					$strGrado = $strArrayGrupo[0];
					//$strGrupo = $strArrayGrupo[1];

					$arrDataCarga = $this->model->selectData($intNivelId, $intCarreraId, $intMateriaId, $intGrupoId);
					$intDocenteId = $arrDataCarga['profesorid'];
					$arrDataPermisivo = $this->model->selectPermisivoFecha($intDocenteId, $intMateriaId, $intCarreraId, $intGrupoId);

					if(!empty($arrDataPermisivo['fecha_inicial']) && $arrDataPermisivo['fecha_final'] < $strFechaActual)
					{
						$arrResponse = array('status' => false, 'msg' => 'No se pueden cargar calificaciones fuera de la fecha limite permitida.');
					}else{
						$arrDataNivel = $this->model->selectBusquedaNivel($intNivelId);
						$arrDataCarrera = $this->model->selectBusquedaCarrera($intCarreraId);
						$arrDataAlumnos = $this->model->selectBusquedaEditarAlumnos($intNivelId,$intCarreraId,$intGrupoId,$intMateriaId);
						$arrDataDocente = $this->model->selectBusquedaDocente($intDocenteId);
						$arrDataMateria = $this->model->selectBusquedaMateria($intMateriaId);	
						if(empty($arrDataAlumnos))
						{
							$arrResponse = array('status' => false, 'msg' => 'No se encontraron registros de calificaciones con los datos de la búsqueda seleccionados');
						}else{
							$arrResponse = array('status' => true, 'nivel' => $arrDataNivel, 'carrera' => $arrDataCarrera, 'data' => $arrDataAlumnos, 'docente' => $arrDataDocente, 'materia' => $arrDataMateria, 'grupo' => $strGrupoUnformat, 'url' => base_url(),'msg' => 'A continuación se listan los registros de calificaciones correspondientes a la carrera seleccionada.');
						}

					}	
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
					die();
				}
			}
		}

		public function getBusquedaAlumnoIndividual()
		{
			if($_POST)
			{
				if($_SESSION['permisosMod']['u'])
				{
					date_default_timezone_set('America/Mexico_City');
					$strFechaActual = date('Y-m-d');
					$intNivelId = intval($_POST['listNivelesIndividual']);
					$intCarreraId = intval($_POST['listCarrerasIndividual']);
					$intAlumnoId = intVal($_POST['listAlumnosIndividual']);
					$intMateriaId = intval($_POST['listMateriasIndividual']);
					
					$arrDataNivel = $this->model->selectBusquedaNivel($intNivelId);
					$arrDataCarrera = $this->model->selectBusquedaCarrera($intCarreraId);
					$arrDataAlumnos = $this->model->selectBusquedaAlumnoIndividual($intNivelId,$intCarreraId,$intAlumnoId,$intMateriaId);
					//dep($arrDataAlumnos);
					$intGrupoId = $arrDataAlumnos['grupoid'];
					$strGrado = $arrDataAlumnos['grado'];
					$strGrupo = $arrDataAlumnos['grupo'];
					$strGrupoUnformat = $strGrado.'-'.$strGrupo;
					$arrDataDocenteIndividual = $this->model->selectBusquedaDocenteIndividual($intMateriaId, $intNivelId, $intCarreraId, $intGrupoId);
					$arrDataMateria = $this->model->selectBusquedaMateria($intMateriaId);

					if(empty($arrDataAlumnos))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron registros de calificaciones con los datos de la búsqueda seleccionados');
					}else{
						$arrResponse = array('status' => true, 'nivel' => $arrDataNivel, 'carrera' => $arrDataCarrera, 'data' => $arrDataAlumnos, 'docente' => $arrDataDocenteIndividual, 'materia' => $arrDataMateria, 'grupo' => $strGrupoUnformat, 'url' => base_url(),'msg' => 'A continuación se listan los grupos correspondientes a la carrera seleccionada.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
					die();
				}

			}
			
		}

		public function formatoCalificaciones($idkardexj)
		{
			if($_SESSION['permisosMod']['r']){
				$intKardexjId = $idkardexj;
				if(intval($intKardexjId)>0){
					$data = $this->model->selectFormatoCalificaciones($intKardexjId);
					if(empty($data)){
						echo "Error: Datos no encontrados, intente más tarde.";
					}else{
						ob_end_clean();
						$html = getFile("Template/Modals/kardexECalificacionesPDF",$data);
						$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
						$html2pdf->writeHTML($html);
						$html2pdf->output('Kardex-'.$data[0]['carrera'].'/'.$data[0]['grupo'].'.pdf');
					}
				}else{
					echo "Dato no válido";
				}
			}else{
				header('Location: '.base_url().'/login');
				die();
			}
		}
	}
	
 ?>