<?php 

	class Equipos extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MEQUIPOS);
		}

		public function Equipos()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Equipos";
			$data['page_title'] = "EQUIPOS <small>UAF</small>";
			$data['page_name'] = "equipos";
			$data['page_functions_js'] = "functions_equipos.js";
			$this->views->getView($this,"equipos",$data);
		}

		public function setEquipo(){
			if($_POST){	
				
				if(empty($_POST['txtUsuario']) || empty($_POST['listStatus']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					$idEquipo = intval($_POST['idEquipo']);
					$strUsuario = strtoupper(strClean($_POST['txtUsuario']));
					$strIp = strClean($_POST['txtIp']);
					$strTipoIp = strClean($_POST['listTipoIp']);
					$strMac = strClean($_POST['txtMac']);
					$strAnyDesk = strClean($_POST['txtAnyDesk']);
					$strDepartamento = strClean($_POST['txtDepartamento']);
					$strSynology = strClean($_POST['listSynology']);
					$strExtension = strClean($_POST['txtExtension']);
					$strIpTelefono = strClean($_POST['txtIpTelefono']);
					$strTipoIpTelefono = strClean($_POST['listTipoIpTelefono']);
					$strDns = strClean($_POST['txtDns']);
					$strComentarios = strClean($_POST['txtComentarios']);
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$intStatus = intval($_POST['listStatus']);
					$strTipoMovimiento = "";
					$requestEquipo = "";

					/*dep("ID Equipo: ".$idEquipo);
					dep("Usuario: ".$strUsuario);
					dep("IP: ".$strIp);
					dep("Tipo IP: ".$strTipoIp);
					dep("MAC: ".$strMac);
					dep("AnyDesk: ".$strAnyDesk);
					dep("Departamento: ".$strDepartamento);
					dep("Synology: ".$strSynology);
					dep("Extension: ".$strExtension);
					dep("IP Telefono: ".$strIpTelefono);
					dep("Tipo IP Telefono: ".$strTipoIpTelefono);
					dep("DNS: ".$strDns);
					dep("Comentarios: ".$strComentarios);
					dep("ID Persona: ".$intPersonaId);
					dep("Estatus: ".$intStatus);
					exit;*/


					if($idEquipo == 0)
					{
						$option = 1;
						$strTipoMovimiento = "Alta";
						if($_SESSION['permisosMod']['w']){
							$requestEquipo = $this->model->insertEquipo($strUsuario,
																		$strIp,
																		$strTipoIp,
																		$strMac,
																		$strAnyDesk,
																		$strDepartamento,
																		$strSynology,
																		$strExtension,
																		$strIpTelefono,
																		$strTipoIpTelefono,
																		$strDns,
																		$strModificador,
																		$strTipoMovimiento,
																		$strComentarios,
																		$intStatus);
						}
					}else{
						$option = 2;
						$strTipoMovimiento = "Actualización";
						if($_SESSION['permisosMod']['u']){
							$requestEquipo = $this->model->updateEquipo($idEquipo,
																		$strUsuario,
																		$strIp,
																		$strTipoIp,
																		$strMac,
																		$strAnyDesk,
																		$strDepartamento,
																		$strSynology,
																		$strExtension,
																		$strIpTelefono,
																		$strTipoIpTelefono,
																		$strDns,
																		$strModificador,
																		$strTipoMovimiento,
																		$strComentarios,
																		$intStatus);
						}

					}

					if(intval($requestEquipo) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
					}else if($requestNivel == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Este equipo ya se encuentra registrado en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getEquipos()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectEquipos();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';
					$visibilidad = '';
					if(!$_SESSION['permisosMod']['u'])
					{
						$visibilidad = "disabled";
					}

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					if($arrData[$i]['tipo_ip'] == "Estatica")
					{
						$arrData[$i]['btnTipoIp'] = '<button class="btn btn-success  btn-sm btnEditTipoIp" onClick="fntEditTipoIp(this,'.$arrData[$i]['idequipo'].')" title="Editar Tipo IP" estado="'.$arrData[$i]['tipo_ip'].'" '.$visibilidad.'>Estatica</button>';
					}else if($arrData[$i]['tipo_ip'] == "Dinamica")
					{
						$arrData[$i]['btnTipoIp'] = '<button class="btn btn-success  btn-sm btnEditTipoIp" onClick="fntEditTipoIp(this,'.$arrData[$i]['idequipo'].')" title="Editar Tipo IP" estado="'.$arrData[$i]['tipo_ip'].'" '.$visibilidad.'>Dinamica</button>';
					}else{
						$arrData[$i]['btnTipoIp'] = $arrData[$i]['btnSynology'] = '<button class="btn btn-warning  btn-sm btnEditTipoIp" onClick="fntEditTipoIp(this,'.$arrData[$i]['idequipo'].')" title="Editar Tipo IP" estado="'.$arrData[$i]['tipo_ip'].'" '.$visibilidad.'>No verificado</button>';
					}

					if($arrData[$i]['synology'] == "Corriendo")
					{
						$arrData[$i]['btnSynology'] = '<button class="btn btn-success  btn-sm btnEditSynology" onClick="fntEditSynology(this,'.$arrData[$i]['idequipo'].')" title="Editar Estatus Synology" estado="'.$arrData[$i]['synology'].'" '.$visibilidad.'>'.$arrData[$i]['synology'].'</button>';
					}else if($arrData[$i]['synology'] == "Detenido")
					{
						$arrData[$i]['btnSynology'] = '<button class="btn btn-danger  btn-sm btnEditSynology" onClick="fntEditSynology(this,'.$arrData[$i]['idequipo'].')" title="Editar Estatus Synology" estado="'.$arrData[$i]['synology'].'" '.$visibilidad.'>'.$arrData[$i]['synology'].'</button>';
					}else{
						$arrData[$i]['btnSynology'] = $arrData[$i]['btnSynology'] = '<button class="btn btn-warning  btn-sm btnEditSynology" onClick="fntEditSynology(this,'.$arrData[$i]['idequipo'].')" title="Editar Estatus Synology" estado="'.$arrData[$i]['synology'].'" '.$visibilidad.'>'.$arrData[$i]['synology'].'</button>';
					}

					if($arrData[$i]['tipo_ip_telefono'] == "Estatica")
					{
						$arrData[$i]['btnTipoIpTelefono'] = '<button class="btn btn-success  btn-sm btnEditTipoIpTelefono" onClick="fntEditTipoIpTelefono(this,'.$arrData[$i]['idequipo'].')" title="Editar Tipo IP Teléfono" estado="'.$arrData[$i]['tipo_ip_telefono'].'" '.$visibilidad.'>'.$arrData[$i]['tipo_ip_telefono'].'</button>';
					}else if($arrData[$i]['tipo_ip_telefono'] == "Dinamica")
					{
						$arrData[$i]['btnTipoIpTelefono'] = '<button class="btn btn-success  btn-sm btnEditTipoIpTelefono" onClick="fntEditTipoIpTelefono(this,'.$arrData[$i]['idequipo'].')" title="Editar Tipo IP Teléfono" estado="'.$arrData[$i]['tipo_ip_telefono'].'" '.$visibilidad.'>'.$arrData[$i]['tipo_ip_telefono'].'</button>';
					}else{
						$arrData[$i]['btnTipoIpTelefono'] = $arrData[$i]['btnSynology'] = '<button class="btn btn-warning  btn-sm btnEditTipoIpTelefono" onClick="fntEditTipoIpTelefono(this,'.$arrData[$i]['idequipo'].')" title="Editar Tipo IP Teléfono" estado="'.$arrData[$i]['tipo_ip_telefono'].'" '.$visibilidad.'>'.$arrData[$i]['tipo_ip_telefono'].'</button>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewEquipo" onClick="fntViewEquipo('.$arrData[$i]['idequipo'].')" title="Ver equipo"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary  btn-sm btnEditEquipo" onClick="fntEditEquipo(this,'.$arrData[$i]['idequipo'].')" title="Editar equipo"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelEquipo" onClick="fntDelEquipo('.$arrData[$i]['idequipo'].')" title="Eliminar equipo"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getEquipo($idequipo){
			if($_SESSION['permisosMod']['r']){
				$intIdEquipo = intval($idequipo);
				if(intval($intIdEquipo) > 0)
				{
					$arrData = $this->model->selectEquipo($intIdEquipo);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delEquipo()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdEquipo = intval($_POST['idequipo']);
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$requestDelete = $this->model->deleteEquipo($intIdEquipo, $strModificador);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el registro');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el registro.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function actualizarSynology()
		{
			if($_POST){
				if($_SESSION['permisosMod']['u'])
				{
					$intIdEquipo = intval($_POST['idequipo']);
					$strEstado = strClean($_POST['estado']);
					$nuevoEstado = "";
					$nuevoEstado = ($strEstado == "No verificado") ? "Corriendo" : (($strEstado == "Corriendo") ? "Detenido" : "No verificado");
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$strTipoMovimiento = "Actualización";
					$requestUpdate = $this->model->updateSynology($intIdEquipo, $nuevoEstado, $strTipoMovimiento, $strModificador);
					$visibilidad = '';
					if(intval($requestUpdate)>0)
					{
						if(!$_SESSION['permisosMod']['r'])
						{
							$visibilidad = "disabled";
						}
						if($nuevoEstado == "Corriendo")
						{
							$btnSynology = '<button class="btn btn-success  btn-sm btnEditSynology" onClick="fntEditSynology(this,'.$intIdEquipo.')" title="Editar Estatus Synology" estado="'.$nuevoEstado.'" '.$visibilidad.'>'.$nuevoEstado.'</button>';
						}else if($nuevoEstado == "Detenido")
						{
							$btnSynology = '<button class="btn btn-danger  btn-sm btnEditSynology" onClick="fntEditSynology(this,'.$intIdEquipo.')" title="Editar Estatus Synology" estado="'.$nuevoEstado.'" '.$visibilidad.'>'.$nuevoEstado.'</button>';
						}else{
							$btnSynology = '<button class="btn btn-warning  btn-sm btnEditSynology" onClick="fntEditSynology(this,'.$intIdEquipo.')" title="Editar Estatus Synology" estado="'.$nuevoEstado.'" '.$visibilidad.'>'.$nuevoEstado.'</button>';
						}
						$strFecha = date('m-d-Y H:i:s');
						$arrResponse = array('status' => true, 'msg' => 'Se actualizo correctamente el estado del Synology','btnSynology' => $btnSynology, 'fecha' => $strFecha);
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar actualizar el estado del Synology.');
					}
				}else{
					$arrResponse = array('status' => false, 'msg' => 'No cuentas con los permisos suficientes para realizar esta acción.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function actualizarTipoIp()
		{
			if($_POST){
				if($_SESSION['permisosMod']['u'])
				{
					$intIdEquipo = intval($_POST['idequipo']);
					$strEstado = strClean($_POST['estado']);
					$nuevoEstado = "";
					$nuevoEstado = ($strEstado == "No verificado") ? "Estatica" : (($strEstado == "Estatica") ? "Dinamica" : "No verificado");
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$strTipoMovimiento = "Actualización";
					$requestUpdate = $this->model->updateTipoIp($intIdEquipo, $nuevoEstado, $strTipoMovimiento, $strModificador);
					$visibilidad = '';
					if(intval($requestUpdate)>0)
					{
						if(!$_SESSION['permisosMod']['r'])
						{
							$visibilidad = "disabled";
						}

						if($nuevoEstado == "Estatica" || $nuevoEstado == "Dinamica")
						{
							$btnTipoIp = '<button class="btn btn-success  btn-sm btnEditTipoIp" onClick="fntEditTipoIp(this,'.$intIdEquipo.')" title="Editar Tipo IP" estado="'.$nuevoEstado.'" '.$visibilidad.'>'.$nuevoEstado.'</button>';
						}else{
							$btnTipoIp = '<button class="btn btn-warning  btn-sm btnEditTipoIp" onClick="fntEditTipoIp(this,'.$intIdEquipo.')" title="Editar Tipo IP" estado="'.$nuevoEstado.'" '.$visibilidad.'>'.$nuevoEstado.'</button>';
						}
						$strFecha = date('m-d-Y H:i:s');
						$arrResponse = array('status' => true, 'msg' => 'Se actualizo correctamente el Tipo de IP del equipo de cómputo','btnTipoIp' => $btnTipoIp, 'fecha' => $strFecha);
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar actualizar el Tipo de IP del equipo de cómputo.');
					}
				}else{
					$arrResponse = array('status' => false, 'msg' => 'No cuentas con los permisos suficientes para realizar esta acción.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function actualizarTipoIpTelefono()
		{
			if($_POST){
				if($_SESSION['permisosMod']['u'])
				{
					$intIdEquipo = intval($_POST['idequipo']);
					$strEstado = strClean($_POST['estado']);
					$nuevoEstado = "";
					$nuevoEstado = ($strEstado == "No verificado") ? "Estatica" : (($strEstado == "Estatica") ? "Dinamica" : "No verificado");
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$strTipoMovimiento = "Actualización";
					$requestUpdate = $this->model->updateTipoIpTelefono($intIdEquipo, $nuevoEstado, $strTipoMovimiento, $strModificador);
					$visibilidad = '';
					if(intval($requestUpdate)>0)
					{
						if(!$_SESSION['permisosMod']['r'])
						{
							$visibilidad = "disabled";
						}

						if($nuevoEstado == "Estatica" || $nuevoEstado == "Dinamica")
						{
							$btnTipoIpTelefono = '<button class="btn btn-success  btn-sm btnEditTipoIpTelefono" onClick="fntEditTipoIpTelefono(this,'.$intIdEquipo.')" title="Editar Tipo IP Teléfono" estado="'.$nuevoEstado.'" '.$visibilidad.'>'.$nuevoEstado.'</button>';
						}else{
							$btnTipoIpTelefono = '<button class="btn btn-warning  btn-sm btnEditTipoIpTelefono" onClick="fntEditTipoIpTelefono(this,'.$intIdEquipo.')" title="Editar Tipo IP Teléfono" estado="'.$nuevoEstado.'" '.$visibilidad.'>'.$nuevoEstado.'</button>';
						}
						$strFecha = date('m-d-Y H:i:s');
						$arrResponse = array('status' => true, 'msg' => 'Se actualizo correctamente el Tipo de IP del teléfono','btnTipoIpTelefono' => $btnTipoIpTelefono, 'fecha' => $strFecha);
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar actualizar el Tipo de IP del teléfono.');
					}
				}else{
					$arrResponse = array('status' => false, 'msg' => 'No cuentas con los permisos suficientes para realizar esta acción.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

	}
 ?>