<?php 

	class Escuelas extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MESCUELASPROCEDENCIA);
		}

		public function Escuelas()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Escuelas";
			$data['page_title'] = "ESCUELAS <small>UAF</small>";
			$data['page_name'] = "escuelas";
			$data['page_functions_js'] = "functions_escuelas.js";
			$this->views->getView($this,"escuelas",$data);
		}

		public function setEscuela(){
			if($_POST){	
				
				if(empty($_POST['txtNombre']) || empty($_POST['txtLocalidad']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					$idEscuela = intval($_POST['idEscuela']);
					$strNombre = mb_strtoupper(strClean($_POST['txtNombre']), 'UTF-8');
					$strLocalidad = mb_strtoupper(strClean($_POST['txtLocalidad']));
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$intStatus = intval($_POST['listStatus']);
					$strTipoMovimiento = '';
					$requestEscuela = "";

					if($idEscuela == 0)
					{
						$option = 1;
						$strTipoMovimiento = 'Alta';
						if($_SESSION['permisosMod']['w']){
							$requestEscuela = $this->model->insertEscuela($strNombre,
																		$strLocalidad,
																		$strModificador, 
																		$strTipoMovimiento,
																		$intStatus);
						}
					}else{
						$option = 2;
						$strTipoMovimiento = 'Actualización';
						if($_SESSION['permisosMod']['u']){
							$requestEscuela = $this->model->updateEscuela($idEscuela,
																		$strNombre,
																		$strLocalidad,
																		$strModificador,
																		$strTipoMovimiento, 
																		$intStatus);
						}

					}

					if(intval($requestEscuela) > 0 )
					{
						$strFecha = date('d-m-Y h:i:s');
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.', 'fecha' => $strFecha);
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos actualizados correctamente.', 'fecha' => $strFecha);
						}
					}else if($requestEscuela == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Esta escuela ya se encuentra registrada en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getEscuelas()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectEscuelas();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewEscuela" onClick="fntViewEscuela('.$arrData[$i]['idescuela'].')" title="Ver escuela"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary  btn-sm btnEditEscuela" onClick="fntEditEscuela(this,'.$arrData[$i]['idescuela'].')" title="Editar escuela"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelEscuela" onClick="fntDelEscuela('.$arrData[$i]['idescuela'].')" title="Eliminar escuela"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getEscuela($idescuela){
			if($_SESSION['permisosMod']['r']){
				$intIdEscuela = intval($idescuela);
				if(intval($intIdEscuela) > 0)
				{
					$arrData = $this->model->selectEscuela($intIdEscuela);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delEscuela()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdEscuela = intval($_POST['idnivel']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$requestDelete = $this->model->deleteEscuela($intIdEscuela, $strModificador);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el registro de la escuela');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el registro de la escuela.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>