<?php 

	class Estadisticas extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MESTADISTICAS);
		}

		public function Estadisticas()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Estadisticas";
			$data['page_title'] = "ESTADISTICAS <small>UAF</small>";
			$data['page_name'] = "estadisticas";
			$data['page_functions_js'] = "functions_estadisticas.js";
			$data['alumnos'] = $this->model->selectAlumnos();
			$this->views->getView($this,"estadisticas",$data);
		}

		public function setMateria(){
			if($_POST){	
				
				if(empty($_POST['txtMateria']) || empty($_POST['listNivel']) || empty($_POST['txtClave']) || empty($_POST['listStatus']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					$idMateria = intval($_POST['idMateria']);
					$strClave = strClean($_POST['txtClave']);
					$strMateria = strClean($_POST['txtMateria']);
					$intNivelId = intval($_POST['listNivel']);
					$strComentarios = strClean($_POST['txtComentarios']);
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$intStatus = intval($_POST['listStatus']);
					$requestMateria = "";

					if($idMateria == 0)
					{
						$option = 1;
						$strTipoMovimiento = "Alta";
						if($_SESSION['permisosMod']['w']){
							$requestMateria = $this->model->insertMateria($strClave,
																		$strMateria,
																		$intNivelId, 
																		$strComentarios,
																		$strModificador,
																		$strTipoMovimiento,
																		$intStatus);
						}
					}else{
						$option = 2;
						$strTipoMovimiento = "Actualizacion";
						if($_SESSION['permisosMod']['u']){
							$requestMateria = $this->model->updateMateria($idMateria,
																		$strClave,
																		$strMateria,
																		$intNivelId,
																		$strComentarios,
																		$strModificador,
																		$strTipoMovimiento,
																		$intStatus);
						}

					}

					if(intval($requestMateria) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.', 'modificador' => $strModificador, 'ultima_modificacion' => date('d-m-Y h:i:s'), 'tipo_movimiento' => $strTipoMovimiento);
						}
					}else if($requestMateria == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Esta materia ya se encuentra registrada en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getAlumno()
		{
			if($_POST){
				if($_SESSION['permisosMod']['r']){
					$intAlumnoId = $_POST['listAlumnos'];
					$arrData = $this->model->selectAlumno($intAlumnoId);
					if(intval($intAlumnoId) AND !empty($arrData))
					{
						$arrDataCalificaciones = $this->model->selectCalificacionesAlumno($intAlumnoId);
						$arrDataAsistencias = $this->model->selectAsistenciasAlumno($intAlumnoId);
						$arrDataIncidencias = $this->model->selectIncidenciasAlumno($intAlumnoId);
						$arrResponse = array('status'=>true, 'alumno'=>$arrData, 'calificaciones'=>$arrDataCalificaciones, 'asistencias'=>$arrDataAsistencias, 'incidencias'=>$arrDataIncidencias, 'msg'=>'Datos encontrados correctamente', JSON_UNESCAPED_UNICODE);
					}else{
						$arrResponse = array('status'=>false, 'alumno'=>$arrData, 'calificaciones'=>$arrDataCalificaciones, 'asistencias'=>$arrDataAsistencias, 'msg'=>'No se encontraron datos para mostrar', JSON_UNESCAPED_UNICODE);
				
					}
				}		
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getMaterias()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectMaterias();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}
					$arrData[$i]['cont'] = $i+1;

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewMateria" onClick="fntViewMateria('.$arrData[$i]['idmateria'].')" title="Ver materia"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary  btn-sm btnEditMateria" onClick="fntEditMateria(this,'.$arrData[$i]['idmateria'].')" title="Editar materia"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelMateria" onClick="fntDelMateria('.$arrData[$i]['idmateria'].')" title="Eliminar materia"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getMateria($idmateria){
			if($_SESSION['permisosMod']['r']){
				$intIdMateria = intval($idmateria);
				if(intval($intIdMateria) > 0)
				{
					$arrData = $this->model->selectMateria($intIdMateria);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delMateria()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdMateria = intval($_POST['idmateria']);
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$strTipoMovimiento = "Eliminación";
					$requestDelete = $this->model->deleteMateria($intIdMateria, $strModificador, $strTipoMovimiento);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente la materia.');
					}elseif($requestDelete == "campo"){
						$arrResponse = array('status' => false, 'msg' => 'No se puede eliminar la materia debido a que se encuentra asignada a un campo formativo.');
					}elseif($requestDelete == "asignada"){
						$arrResponse = array('status' => false, 'msg' => 'No se puede eliminar la materia debido a que se encuentra asignada a un horario.');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar la materia.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>