	<?php 

class Eventos extends Controllers{

	public function __construct()
	{
		parent::__construct();
		session_start();
		//session_regenerate_id(true);
		if(empty($_SESSION['login']))
		{
			header('Location: '.base_url().'/login');
			die();
		}
		getPermisos(MEVENTOS);
	}

	public function eventos()
	{
		if(empty($_SESSION['permisosMod']['r'])){
			header("Location:".base_url().'/dashboard');
		}

		$data['page_tag'] = "Eventos";
		$data['page_title'] = "EVENTOS <small>UAF </small>";
		$data['page_name'] = "eventos";
		$data['page_functions_js'] = "functions_eventos.js";
		$data['niveles'] = $this->model->selectNiveles();
		$this->views->getView($this,"eventos",$data);
	}

	public function setEvento(){
		//error_reporting(0);
		if(empty($_POST['txtEvento']) || empty($_POST['txtUbicacion']) || empty($_POST['txtHoraInicial']) || empty($_POST['txtHoraFinal']) || empty($_POST['txtFechaInicial']) || empty($_POST['txtFechaFinal']) || empty($_POST['txtDescripcion']) || empty($_POST['listNivel']) || empty($_POST['listStatus']))
		{
			$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
		}else{ 
			$idEvento = intval($_POST['idEvento']);
			$strEvento = strClean($_POST['txtEvento']);
			$strUbicacion = strClean($_POST['txtUbicacion']);
			$strHoraInicial = strClean($_POST['txtHoraInicial']);
			$strHoraFinal = strClean($_POST['txtHoraFinal']);
			$strFechaInicial = strClean($_POST['txtFechaInicial']);
			$strFechaFinal = strClean($_POST['txtFechaFinal']);
			$intPersonaId = intval($_SESSION['userData']['idpersona']);
			$strNivel = strClean($_POST['listNivel']);
			$strDescripcion = strClean($_POST['txtDescripcion']);
			$intStatus = intval($_POST['listStatus']);

			$request_evento = "";
			if($idEvento == 0)
			{
				$option = 1;
				if($_SESSION['permisosMod']['w']){
					$request_evento = $this->model->insertEvento($strEvento,
																	$strUbicacion,
																	$strHoraInicial,
																	$strHoraFinal,
																	$intPersonaId,
																	$strNivel,
																	$strFechaInicial,
																	$strFechaFinal,
																	$strDescripcion,
																	$intStatus);
				}
			}else{
				$option = 2;
				if($_SESSION['permisosMod']['u']){
					$request_evento = $this->model->updateEvento($idEvento,
																	$strEvento,
																	$strUbicacion,
																	$strHoraInicial,
																	$strHoraFinal,
																	$intPersonaId,
																	$strNivel,
																	$strFechaInicial,
																	$strFechaFinal,
																	$strDescripcion,
																	$intStatus);
				}
			}

			if(intval($request_evento) > 0 )
			{
				if($option == 1){
					$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
				}else{
					$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
				}
			}else if($request_evento == 'exist'){
				$arrResponse = array('status' => false, 'msg' => '¡Atención! Este evento ya se encuentra registrado en el sistema.');		
			}else{
				$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
			}
		}
		echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
	
		die();
	}

	public function getEventosCalendar()
	{
		if($_SESSION['permisosMod']['r']){
			date_default_timezone_set('America/Mexico_City');
			$fechaActual = date('Y-m-d');
			$arrData = $this->model->selectEventos();
			$arrData['events'] = $arrData;	
			echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
		}
		die();
	}

	public function getEventos()
	{
		if($_SESSION['permisosMod']['r']){
			date_default_timezone_set('America/Mexico_City');
			$fechaActual = date('Y-m-d');
			$arrData = $this->model->selectEventos();
			for ($i=0; $i < count($arrData); $i++) {
				$btnView = '';
				$btnEdit = '';
				$btnDelete = '';
				if($arrData[$i]['status'] == 1)
				{
					$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
				}else{
					$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
				}

				if($arrData[$i]['fecha_inicial'] >= $fechaActual)
				{
					$arrData[$i]['activo'] = true;
				}else{
					$arrData[$i]['activo'] = false;
				}

				$arrData[$i]['format_horario'] = '<h5><span class="badge badge-info">'.$arrData[$i]['hora_inicial'].' - '.$arrData[$i]['hora_final'].'</span></h5>';
				//$arrData[$i]['format_horario'] = $arrData[$i]['hora_inicial'].' - '.$arrData[$i]['hora_final'];

				if($_SESSION['permisosMod']['u']){
					$btnEdit = '<button class="btn btn-primary  btn-sm" onClick="fntEditInfo(this,'.$arrData[$i]['idevento'].'); return false;" title="Editar evento"><i class="fas fa-pencil-alt"></i></button>';
				}
				if($_SESSION['permisosMod']['d']){	
					$btnDelete = '<button class="btn btn-danger btn-sm" onClick="fntDelInfo('.$arrData[$i]['idevento'].'); return false;" title="Eliminar evento"><i class="far fa-trash-alt"></i></button>';
				}
				$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
			}
			
			echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
		}
		die();
	}

	public function getEvento($idevento){
		if($_SESSION['permisosMod']['r']){
			$intIdEvento = intval($idevento);
			if($intIdEvento > 0)
			{
				$arrData = $this->model->selectEvento($intIdEvento);
				if(empty($arrData))
				{
					$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
				}else{
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
		}
		die();
	}


	public function delEvento()
	{
		if($_POST){
			if($_SESSION['permisosMod']['d']){
				$intIdEvento = intval($_POST['idevento']);
				$requestDelete = $this->model->deleteEvento($intIdEvento);
				if(intval($requestDelete)>0)
				{
					$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el evento del sistema');
				}else{
					$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el evento.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
		}
		die();
	}

}

?>