<?php 

class Grupos extends Controllers{
	public function __construct()
	{
		parent::__construct();
		session_start();
		if(empty($_SESSION['login']))
		{
			header('Location: '.base_url().'/login');
			die();
		}
		getPermisos(MGRUPOS);
	}

	public function Grupos()
	{
		if(empty($_SESSION['permisosMod']['r'])){
			header("Location:".base_url().'/dashboard');
		}
		$data['page_tag'] = "Grupos";
		$data['page_title'] = "GRUPOS <small>UAF</small>";
		$data['page_name'] = "grupos";
		$data['niveles'] = $this->model->selectNiveles();
		$data['ciclos'] = $this->model->selectCiclos();
		$data['page_functions_js'] = "functions_grupos.js";
		$this->views->getView($this,"grupos",$data);
	}

	public function setGrupo(){
			if($_POST){	
				if(empty($_POST['listNivel']) || empty($_POST['listCarreras']) || empty($_POST['listGrado']) || empty($_POST['txtGrupo']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					$idGrupo = intval($_POST['idGrupo']);
					$intNivelId = intval($_POST['listNivel']);
					$intCarreraId = intval($_POST['listCarreras']);
					$intGrado = intval($_POST['listGrado']);
					$strGrupo = ucwords(strClean($_POST['txtGrupo']));
					$intPersonaId = intval($_POST['txtPersonaId']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$requestGrupo = "";

					if($idGrupo == 0)
					{
						$option = 1;
						$strTipoMovimiento = "Alta";
						if($_SESSION['permisosMod']['w']){
							$requestGrupo = $this->model->insertGrupo($intNivelId,
																		$intCarreraId,
																		$intGrado,
																		$strGrupo,
																		$intPersonaId,
																		$strModificador,
																		$strTipoMovimiento);
																		
						}
					}else{
						$option = 2;
						$strTipoMovimiento = "Actualización";
						if($_SESSION['permisosMod']['u']){

							$requestGrupo = $this->model->updateGrupo($idGrupo,
																		$intNivelId,
																		$intCarreraId,
																		$intGrado,
																		$strGrupo,
																		$intPersonaId,
																		$strModificador,
																		$strTipoMovimiento);
						}

					}

					if(intval($requestGrupo) > 0 )
					{
						date_default_timezone_set('America/Mexico_City');
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
					
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.', 'modificador' => $strModificador, 'ultima_modificacion' => date('d-m-Y h:i:s'), 'tipo_movimiento' => $strTipoMovimiento);
						}
					}else if($requestGrupo == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Ya se encuentra registrado un grado y grupo en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

	public function getNivel($idnivel)
	{
		if($_SESSION['permisosMod']['r']){
			$intNivelId = intVal($idnivel);
			$request = $this->model->selectNivel($intNivelId);
			$return = array("status" => true, "data" => $request);
			echo json_encode($return, JSON_UNESCAPED_UNICODE);
		}
		die();
	}

	public function getGrupos()
	{
		if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectGrupos();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewGrupo" onClick="fntViewInfo('.$arrData[$i]['idgrupo'].')" title="Ver grupo"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary  btn-sm btnEditGrupo" onClick="fntEditGrupo(this,'.$arrData[$i]['idgrupo'].')" title="Editar grupo"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelGrupo" onClick="fntDelGrupo('.$arrData[$i]['idgrupo'].')" title="Eliminar grupo"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['carrera_format'] = $arrData[$i]['abreviatura'].'/'.$arrData[$i]['carrera'].'/'.$arrData[$i]['reforma'];
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
	}

	public function getGrupo($idgrupo)
	{
		if($_SESSION['permisosMod']['r']){
			$intIdGrupo = intVal($idgrupo);
			$request = $this->model->selectGrupo($intIdGrupo);
			if(intval($request) > 0){
				$requestCarreras = $this->model->selectCarreras($request['nivelid']);
			}
			$return = array("status" => true, "data" => $request, "carreras" => $requestCarreras);
			echo json_encode($return, JSON_UNESCAPED_UNICODE);
		}
		die();
	}

	public function getCarreras()
	{
		if($_POST){
			$intNivelId = intVal($_POST['idnivel']);
			$request = $this->model->selectCarreras($intNivelId);
			if(intval($request)>0){
				$return = array("status" => true, "data" => $request, "msg" => "Carreras obtenidas correctamente.");
			}else{
				$return = array("status" => false, "data" => $request, "msg" => "No hay carreras asignadas a este nivel educativo.");
			}
			
			echo json_encode($return, JSON_UNESCAPED_UNICODE);
		}
		die();
	}

	public function getGrupoAlumnos($idgrupo)
	{
		if($_SESSION['permisosMod']['r']){
			$intIdGrupo = intVal($idgrupo);
			$request = $this->model->selectGrupoAlumnos($intIdGrupo);
			$return = array("status" => true, "data" => $request);
			echo json_encode($return, JSON_UNESCAPED_UNICODE);
		}
		die();
	}

	public function getAlumnos($nivelid)
	{
		$intNivelId = $nivelid;
		if($_SESSION['permisosMod']['r']){
			$arrData = $this->model->selectAlumnos($intNivelId);
			for ($i=0; $i < count($arrData); $i++) {
				$btnView = '';
				$btnEdit = '';
				$btnDelete = '';

				if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

				if($_SESSION['permisosMod']['r']){
					$btnView = '<button class="btn btn-info btn-sm" onClick="fntViewAlumno('.$arrData[$i]['idalumno'].')" title="Ver Alumno"><i class="far fa-eye"></i></button>';
				}
				if($_SESSION['permisosMod']['u']){

					if($arrData[$i]['asignado'] == 0)
					{
						$btnAgregar = '<button class="btn btn-primary  btn-sm" onClick="fntAgregar(this,'.$arrData[$i]['idalumno'].')" title="Agregar Alumno"><i class="fas fa-plus"></i></button>';
					}else{
						/*$btnAgregar = '<button class="btn btn-default  btn-sm" onClick="fntDesasignar(this,'.$arrData[$i]['idalumno'].')" title="Desasignar Alumno"><i class="fas fa-reply"></i></button>';*/
						$btnAgregar = '';
					}
	
				}
				$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnAgregar.'</div>';
			}
			echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
		}
		die();
	}

	public function getAlumno($idalumno)
	{
		if($_SESSION['permisosMod']['r']){
			$intIdAlumno = intVal($idalumno);
			$request = $this->model->selectAlumno($intIdAlumno);
			$return = array("status" => true, "data" => $request);
			echo json_encode($return, JSON_UNESCAPED_UNICODE);
		}
		die();
	}

	public function setAsignar($idalumno)
	{
		if($_POST['idalumno']);
		{
			if($_SESSION['permisosMod']['r']){
				$intIdAlumno = intVal($_POST['idalumno']);
				$requestAsignar = $this->model->updateAsignar($intIdAlumno);
				if($requestAsignar)
				{	
					$arrResponse = array('status' => true, 'msg' => 'Asignación exitosa del alumno.');
				}else{
					$arrResponse = array('status' => false, 'msg' => 'Error al intentar remover el alumno.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}	
		
	}

	public function setRemover($idalumno)
	{
		if($_POST['idalumno']);
		{
			if($_SESSION['permisosMod']['r']){
				$intIdAlumno = intVal($_POST['idalumno']);
				$requestAsignar = $this->model->updateRemover($intIdAlumno);
				if($requestAsignar)
				{	
					$arrResponse = array('status' => true, 'msg' => 'Se ha removido correctamente el alumno del grupo.');
				}else{
					$arrResponse = array('status' => false, 'msg' => 'Error al intentar remover el alumno.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}	
		
	}

	public function delGrupo()
	{
		if($_POST['idgrupo']);
		{
			if($_SESSION['permisosMod']['r']){
				$intIdGrupo = intVal($_POST['idgrupo']);
				$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
				$strTipoMovimiento = "Eliminación";
				$requestDelete = $this->model->deleteGrupo($intIdGrupo,$strModificador,$strTipoMovimiento);
				if(intval($requestDelete)>0)
				{	
					$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado el grupo correctamente');
				}elseif($requestDelete == 'alumnos'){
					$arrResponse = array('status' => false, 'msg' => 'Error, no se puede eliminar el grupo debido a que hay alumnos asignados.');
				}else{
					$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el grupo.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}	
		
	}

}

?>