<?php 
	require 'Libraries/html2pdf/vendor/autoload.php';
	use Spipu\Html2Pdf\Html2Pdf;
	
	class Horarios extends Controllers
	{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MCARGAS);
		}

		public function Horarios()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Horarios";
			$data['page_title'] = "HORARIOS <small>UAF</small>";
			$data['page_name'] = "horarios";
			$data['page_functions_js'] = "functions_horarios.js";
			$data['carreras'] = $this->model->selectCarreras();
			$data['grupos'] = $this->model->selectGrupos();
			$data['ciclos'] = $this->model->selectCiclos();
			$data['materias'] = $this->model->selectMaterias();
			$data['usuarios'] = $this->model->selectUsuarios();
			$this->views->getView($this,"horarios",$data);
		}

		public function setHorario(){
			if($_POST){	
				if(empty($_POST['listGrupo']) || empty($_POST['listStatus'])){
					$arrResponse = array("status" => false, "msg" => 'Es obligatorio seleccionar un grupo para guardar el horario.');
				}elseif(empty($_POST['listCiclo'])){
					$arrResponse = array("status" => false, "msg" => 'Es obligatorio asignar un ciclo escolar.');
				}elseif(empty($_POST['listaElementosLunes']) AND empty($_POST['listaElementosMartes']) AND empty($_POST['listaElementosMiercoles']) AND empty($_POST['listaElementosJueves']) AND empty($_POST['listaElementosViernes']) AND empty($_POST['listaElementosSabado'])){
					$arrResponse = array("status" => false, "msg" => 'El horario no se puede almacenar vacio. Favor de completar la información.');
				}elseif(empty($_POST['txtFechaInicial']) || empty($_POST['txtFechaFinal'])){
					$arrResponse = array("status" => false, "msg" => 'Debe seleccionar el periódo de impartición de la materia para la captura de calificaciones.');
				}else{ 
					$idHorario = intval($_POST['idHorario']);
					$intGrupoId = intval($_POST['listGrupo']);
					$intCarreraId = intval($_POST['listCarreras']);
					$intCicloEscolar = strClean($_POST['listCiclo']);
					$strFechaInicial = strClean($_POST['txtFechaInicial']);
					$strFechaFinal = strClean($_POST['txtFechaFinal']);
					$strDataLunes = $_POST['listaElementosLunes'];
					$strDataMartes = $_POST['listaElementosMartes'];
					$strDataMiercoles = $_POST['listaElementosMiercoles'];
					$strDataJueves = $_POST['listaElementosJueves'];
					$strDataViernes = $_POST['listaElementosViernes'];
					$strDataSabado = $_POST['listaElementosSabado'];
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$intStatus = intval($_POST['listStatus']);
					/*dep("ID Horario: ".$idHorario);
					dep("ID Carrera: ".$intCarreraId);
					dep("ID Grupo: ".$intGrupoId);
					dep("Lunes: ".$strDataLunes);
					dep("Martes: ".$strDataMartes);
					dep("Miercoles: ".$strDataMiercoles);
					dep("Jueves: ".$strDataJueves);
					dep("Viernes: ".$strDataViernes);
					dep("Sabado: ".$strDataSabado);
					dep("Estatus: ".$intStatus);
					exit;*/
					
					$requestHorarios = "";
					$ruta="";

					if($idHorario == 0)
					{
						$option = 1;
						$strTipoMovimiento = 'Alta';
						if($_SESSION['permisosMod']['w']){
							$requestHorarios = $this->model->insertHorario($intGrupoId,
																		$intCarreraId,
																		$strFechaInicial,
																		$strFechaFinal,
																		$strDataLunes,
																		$strDataMartes,
																		$strDataMiercoles,
																		$strDataJueves,
																		$strDataViernes, 
																		$strDataSabado,
																		$strModificador,
																		$strTipoMovimiento,
																		$intCicloEscolar,
																		$intStatus);
						}
					}else{
						$option = 2;
						$strTipoMovimiento = 'Actualización';
						if($_SESSION['permisosMod']['u']){
							$requestHorarios = $this->model->updateHorario($idHorario,
																		$intGrupoId,
																		$intCarreraId,
																		$strFechaInicial,
																		$strFechaFinal,
																		$strDataLunes,
																		$strDataMartes,
																		$strDataMiercoles,
																		$strDataJueves,
																		$strDataViernes,
																		$strDataSabado, 
																		$strModificador,
																		$strTipoMovimiento,
																		$intCicloEscolar,
																		$intStatus);
						}

					}

					if(intval($requestHorarios) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
					}else if($requestHorarios == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Este horario ya se encuentra registrado en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getHorarios()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectHorarios();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					$arrData[$i]['carrera_format'] = $arrData[$i]['carrera'].'/'.$arrData[$i]['reforma'];

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewHorario" onClick="fntViewHorario('.$arrData[$i]['idhorarioj'].')" title="Ver horario"><i class="far fa-eye"></i></button>
							<a title="Generar formato" href="'.base_url().'/horarios/formatoHorarios/'.$arrData[$i]['idhorarioj'].'" target="_blanck" class="btn btn-danger btn-sm"> <i class="fas fa-file-pdf"></i></a>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-primary  btn-sm btnEditHorario" onClick="fntEditHorario(this,'.$arrData[$i]['idhorarioj'].')" title="Editar horario"><i class="fas fa-pencil-alt"></i></button>';
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelHorario" onClick="fntDelHorario('.$arrData[$i]['idhorarioj'].')" title="Eliminar horario"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getHorario($idhorarioj){
			if($_SESSION['permisosMod']['r']){
				$intIdHorarioJ = intval($idhorarioj);
				if(intval($intIdHorarioJ) > 0)
				{
					$arrData = $this->model->selectHorario($intIdHorarioJ);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delHorario()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdHorarioJ = intval($_POST['idhorario']);
					$strModificador = $_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos'];
					$strTipoMovimiento = "Eliminación";
					$requestDelete = $this->model->deleteHorario($intIdHorarioJ, $strModificador, $strTipoMovimiento);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente el horario');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el horario.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getMaterias()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectMaterias();
				if(empty($arrData))
				{
					$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
				}else{
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getMateriasCarrera($carreraid)
		{
			$intCarreraId = $carreraid;
			if(intval($intCarreraId) > 0)
			{
				if($_SESSION['permisosMod']['r']){
					$arrData = $this->model->selectMateriasCarrera($intCarreraId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
				}
			}else{
				$arrResponse = array('status' => false, 'msg' => 'No hay materías asignadas a este Nivel Educativo.');
			}
			echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);

			die();
		}

		public function getMateriasNivel($carreraid)
		{
			$intCarreraId = $carreraid;
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectMateriasCarrera($intCarreraId);
				if(empty($arrData))
				{
					$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
				}else{
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getProfesores(){
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectUsuarios();
				if(empty($arrData))
				{
					$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
				}else{
					$arrResponse = array('status' => true, 'data' => $arrData);
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getTableHorario($idhorarioj){
			if($_SESSION['permisosMod']['r']){
				$intIdHorarioJ = intval($idhorarioj);
				if(intval($intIdHorarioJ) > 0)
				{
					$arrData = $this->model->selectHorarioJ($intIdHorarioJ);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function formatoHorarios($idhorarioj)
		{
			if($_SESSION['permisosMod']['r']){
				if(is_numeric($idhorarioj)){
					$data = $this->model->selectHorarioJ($idhorarioj);
					/*dep($data);
					exit;*/
					if(empty($data)){
						echo "Error: Datos no encontrados, intente más tarde.";
					}else{
						$idhorarioj = $data['idhorarioj'];
						ob_end_clean();
						$html = getFile("Template/Modals/horariosPDF",$data);
						$html2pdf = new Html2Pdf('L','A4','es','true','UTF-8');
						$html2pdf->writeHTML($html);
						$html2pdf->output('horario-'.$data[0]['nivel'].' '.$data[0]['grado'].'-'.$data[0]['grupo'].'.pdf');
					}
				}else{
					echo "Dato no válido";
				}
			}else{
				header('Location: '.base_url().'/login');
				die();
			}
		}

	}
 ?>