<?php 

	class Incidencias extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MINCIDENCIAS);
		}

		public function Incidencias()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Incidencias";
			$data['page_title'] = "INCIDENCIAS <small>UAF</small>";
			$data['page_name'] = "incidencias";
			$data['page_functions_js'] = "functions_incidencias.js";
			$data['alumnos'] = $this->model->selectAlumnos();
			$this->views->getView($this,"incidencias",$data);
		}

		public function setIncidencia(){
			if($_POST){	
				if(empty($_POST['txtIncidencia']) || empty($_POST['listAlumno']) || empty($_POST['txtFecha']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{
					$idIncidencia = intval($_POST['idIncidencia']);
					$intAlumnoId = intval($_POST['listAlumno']);
					$data = $this->model->selectNivel($intAlumnoId);
					$intNivelId = $data['nivelid'];
					$strNivel = $data['nivel'];
					$strIncidencia = strClean($_POST['txtIncidencia']);					
					$intPersonaId = $_SESSION['userData']['idpersona'];
					$strFecha = strClean($_POST['txtFecha']);
					
					$requestIncidencia = "";

					if($idIncidencia == 0)
					{
						$option = 1;
						if($_SESSION['permisosMod']['w']){
							$requestIncidencia = $this->model->insertIncidencia($intAlumnoId,
																		$intNivelId,
																		$strIncidencia, 
																		$intPersonaId,
																		$strFecha);
						}
					}else{
						$option = 2;
						if($_SESSION['permisosMod']['u']){
							$requestIncidencia = $this->model->updateIncidencia($idIncidencia,
																		$intAlumnoId,
																		$intNivelId,
																		$strIncidencia, 
																		$intPersonaId,
																		$strFecha);
						}

					}

					if(intval($requestIncidencia) > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.', 'nivel' => $strNivel);
						}
					}else if($requestIncidencia == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! Esta Incidencia ya se encuentra registrada en el sistema.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function updateSeguimiento(){
			if($_POST){	
				if(empty($_POST['listEstado']) || empty($_POST['idIncidenciaS']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{
					$idIncidencia = intval($_POST['idIncidenciaS']);
					$strSeguimiento = strClean($_POST['txtSeguimiento']);
					$strEstado = strClean($_POST['listEstado']);
					$requestSeguimiento = "";

					if($idIncidencia > 0)
					{
						$option = 1;
						if($_SESSION['permisosMod']['u']){
							$requestSeguimiento = $this->model->updateSeguimiento($idIncidencia,
																		$strSeguimiento,
																		$strEstado);
						}
					}

					if(intval($requestSeguimiento) > 0 )
					{
						$visibilidad = '';
						$btnEstado = '';
						if($_SESSION['userData']['idrol'] != RADMINISTRADOR && $_SESSION['userData']['idrol'] != RRECTORIA && $_SESSION['userData']['idrol'] != RORIENTACION && $_SESSION['userData']['idrol'] != RADMINBACHILLERATO && $_SESSION['userData']['idrol'] != RADMINLICENCIATURA && $_SESSION['userData']['idrol'] != RADMININGENIERIA && $_SESSION['userData']['idrol'] != RADMINPOSGRADO){
							$visibilidad = "disabled";
						}
						if($strEstado == "Pendiente"){
							$btnEstado= '<button class="btn btn-warning  btn-sm btnEditEstado" onClick="fntEditEstado(this,'.$idIncidencia.')" title="Editar Estado" estado="'.$strEstado.'" '.$visibilidad.'>Pendiente</button>';
						}else{
							$btnEstado = '<button class="btn btn-success  btn-sm btnEditEstado" onClick="fntEditEstado(this,'.$idIncidencia.')" title="Editar Estado" estado="'.$strEstado.'" '.$visibilidad.'>Terminado</button>';
						}

						$arrResponse = array('status' => true, 'msg' => 'Datos actualizados correctamente.', 'data' => $btnEstado);
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getIncidencias()
		{
			if($_SESSION['permisosMod']['r']){
				
				$arrData = $this->model->selectIncidencias();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnSeguimiento = '';
					$btnDelete = '';
					$visibilidad = '';
					if($_SESSION['userData']['idrol'] != RADMINISTRADOR && $_SESSION['userData']['idrol'] != RRECTORIA && $_SESSION['userData']['idrol'] != RORIENTACION && $_SESSION['userData']['idrol'] != RADMINBACHILLERATO && $_SESSION['userData']['idrol'] != RADMINLICENCIATURA && $_SESSION['userData']['idrol'] != RADMININGENIERIA && $_SESSION['userData']['idrol'] != RADMINPOSGRADO)
					{
						$visibilidad = "disabled";
					}

					if($arrData[$i]['status'] == 1)
					{
						$arrData[$i]['status'] = '<span class="badge badge-success">Activo</span>';
					}else{
						$arrData[$i]['status'] = '<span class="badge badge-danger">Inactivo</span>';
					}

					if($arrData[$i]['estado'] == "Pendiente")
					{
						$arrData[$i]['btnEstado'] = '<button class="btn btn-warning  btn-sm btnEditEstado" onClick="fntEditEstado(this,'.$arrData[$i]['idincidencia'].')" title="Editar Estado" estado="'.$arrData[$i]['estado'].'" '.$visibilidad.'>Pendiente</button>';
					}else
					{
						$arrData[$i]['btnEstado'] = '<button class="btn btn-success  btn-sm btnEditEstado" onClick="fntEditEstado(this,'.$arrData[$i]['idincidencia'].')" title="Editar Estado" estado="'.$arrData[$i]['estado'].'" '.$visibilidad.'>Finalizado</button>';
					}

					if($_SESSION['permisosMod']['r']){
						$btnView = '<button class="btn btn-info btn-sm btnViewIncidencia" onClick="fntViewIncidencia('.$arrData[$i]['idincidencia'].')" title="Ver incidencia"><i class="far fa-eye"></i></button>';
					}
					if($_SESSION['permisosMod']['u']){
						$btnEdit = '<button class="btn btn-warning  btn-sm btnEditIncidencia" onClick="fntEditIncidencia(this,'.$arrData[$i]['idincidencia'].')" title="Editar incidencia"><i class="fas fa-pencil-alt"></i></button>';
						if($_SESSION['userData']['idrol'] == RADMINISTRADOR || $_SESSION['userData']['idrol'] == RRECTORIA || $_SESSION['userData']['idrol'] == RORIENTACION || $_SESSION['userData']['idrol'] == RADMINBACHILLERATO || $_SESSION['userData']['idrol'] == RADMINLICENCIATURA || $_SESSION['userData']['idrol'] == RADMININGENIERIA|| $_SESSION['userData']['idrol'] == RADMINPOSGRADO){
							$btnSeguimiento = '<button class="btn btn-primary  btn-sm btnSeguimiento" onClick="fntSeguimiento(this,'.$arrData[$i]['idincidencia'].')" title="Dar seguimiento"><i class="fas fa-book"></i></button>';
						}
						
					}
					if($_SESSION['permisosMod']['d']){
						
						$btnDelete = '<button class="btn btn-danger btn-sm btnDelIncidencia" onClick="fntDelIncidencia('.$arrData[$i]['idincidencia'].')" title="Eliminar incidencia"><i class="far fa-trash-alt"></i></button>';
			
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnSeguimiento.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getIncidencia($idincidencia){
			if($_SESSION['permisosMod']['r']){
				$intIdIncidencia = intval($idincidencia);
				if(intval($intIdIncidencia) > 0)
				{
					$arrData = $this->model->selectIncidencia($intIdIncidencia);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delIncidencia()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdIncidencia = intval($_POST['idincidencia']);
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$requestDelete = $this->model->deleteIncidencia($intIdIncidencia, $strModificador);
					if(intval($requestDelete)>0)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado correctamente la incidencia');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar eliminar el registro.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function actualizarEstado()
		{
			if($_POST){
				if($_SESSION['permisosMod']['u'])
				{
					$intIdIncidencia = intval($_POST['idincidencia']);
					$strEstado = strClean($_POST['estado']);
					$nuevoEstado = "";
					$btnEstado = '';
					$nuevoEstado = ($strEstado == "Pendiente") ? "Finalizado" : "Pendiente";
					$strModificador = strClean($_SESSION['userData']['nombres'].' '.$_SESSION['userData']['apellidos']);
					$strTipoMovimiento = "Actualización";
					$requestUpdate = $this->model->updateEstado($intIdIncidencia, $nuevoEstado, $strTipoMovimiento, $strModificador);
					$visibilidad = '';
					if(intval($requestUpdate)>0)
					{
						if($_SESSION['userData']['idrol'] != RADMINISTRADOR && $_SESSION['userData']['idrol'] != RRECTORIA && $_SESSION['userData']['idrol'] != RORIENTACION && $_SESSION['userData']['idrol'] != RADMINBACHILLERATO && $_SESSION['userData']['idrol'] != RADMINLICENCIATURA && $_SESSION['userData']['idrol'] != RADMININGENIERIA && $_SESSION['userData']['idrol'] != RADMINPOSGRADO)
						{
							$visibilidad = "disabled";
						}
						if($nuevoEstado == "Pendiente")
						{
							$btnEstado = '<button class="btn btn-warning  btn-sm btnEditEstado" onClick="fntEditEstado(this,'.$intIdIncidencia.')" title="Editar Estado" estado="'.$nuevoEstado.'" '.$visibilidad.'>Pendiente</button>';
						}else
						{
							$btnEstado = '<button class="btn btn-success  btn-sm btnEditEstado" onClick="fntEditEstado(this,'.$intIdIncidencia.')" title="Editar Estado" estado="'.$nuevoEstado.'" '.$visibilidad.'>Finalizado</button>';
						}
						
						$arrResponse = array('status' => true, 'msg' => 'Se actualizo correctamente el estado del seguimiento','btnEstado' => $btnEstado);
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al intentar actualizar el estado del Synology.');
					}
				}else{
					$arrResponse = array('status' => false, 'msg' => 'No cuentas con los permisos suficientes para realizar esta acción.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}
	}
 ?>