<?php 
	require 'Libraries/html2pdf/vendor/autoload.php';
	use Spipu\Html2Pdf\Html2Pdf;

	class Kgrupal extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MKARDEX);
		}

		public function Kgrupal()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Kardex Grupal";
			$data['page_title'] = "KARDEX GRUPAL <small>UAF</small>";
			$data['page_name'] = "kardex grupal";
			$data['page_functions_js'] = "functions_kgrupal.js";
			$data['carreras'] = $this->model->selectCarreras();
			$this->views->getView($this,"kgrupal",$data);
		}

		public function getGrupos($carreraid){
			if($_SESSION['permisosMod']['r']){
				$intCarreraId = intval($carreraid);
				if(intval($intCarreraId) > 0)
				{
					$arrData = $this->model->selectGrupos($intCarreraId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron grupos asignados a la carrera y nivel seleccionados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan los grupos correspondientes a la carrera y nivel seleccionados.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getMaterias(){
			if($_SESSION['permisosMod']['r']){
				$intCarreraId = intval($_POST['carreraid']);
				$intGrupoId = strClean($_POST['grupo']);
				if(intval($intCarreraId) > 0)
				{
					$arrData = $this->model->selectMaterias($intCarreraId, $intGrupoId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron materias asignadas a los datos seleccionados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan las materias correspondientes a los datos seleccionados.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getBusquedaAlumno()
		{
			if($_POST)
			{
				if($_SESSION['permisosMod']['u'])
				{
					//$intCarreraId = intval($_POST['listCarreras']);
					$intCarreraId = intval($_POST['listCarreras']);
					$intGrupoId = strClean($_POST['listGrupos']);
					$intMateriaId = intval($_POST['listMaterias']);
					$strOption = strClean($_POST['rbOption']);
					$intPrimero = intval($_POST['primero']);
					$intSegundo = intval($_POST['segundo']);
					$intTercero = intval($_POST['tercero']);
					$intCuarto = intval($_POST['cuarto']);
					$intQuinto = intval($_POST['quinto']);
					$intSexto = intval($_POST['sexto']);
					$intSeptimo = intval($_POST['septimo']);
					$intOctavo = intval($_POST['octavo']);
					$intNoveno = intval($_POST['noveno']);
					$semestres = array();

					if($intPrimero == 1){
						array_push($semestres, 1);
					}
					if($intSegundo == 1){
						array_push($semestres, 2);
					}
					if($intTercero == 1){
						array_push($semestres, 3);
					}
					if($intCuarto == 1){
						array_push($semestres, 4);
					}
					if($intQuinto == 1){
						array_push($semestres, 5);
					}
					if($intSexto == 1){
						array_push($semestres, 6);
					}
					if($intSeptimo == 1){
						array_push($semestres, 7);
					}
					if($intOctavo == 1){
						array_push($semestres, 8);
					}
					if($intNoveno == 1){
						array_push($semestres, 9);
					}
					
					if($strOption == "Personalizado"){
						$arrData = $this->model->selectKardexSemestres($intCarreraId, $intGrupoId, $intMateriaId, $semestres);	
					}else{
						$arrData = $this->model->selectKardexTodos($intCarreraId, $intGrupoId, $intMateriaId);
					}
					
					/*if(intval($arrData)>0){
						
						//$idkardex = $data['idkardex'];
						ob_end_clean();
						$html = getFile("Template/Modals/kardexECalificacionesPDF",$arrData);
						$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
						$html2pdf->writeHTML($html);
						$html2pdf->output('Kardex-'.$arrData[0]['nombre_alumno'].'.pdf');
					}else{
						echo "Dato no válido";
					}*/
					
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron regsitros de calificaciones con los datos de la búsqueda seleccionados');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'url' => base_url(), 'msg' => 'A continuación se listan los grupos correspondientes a la carrera seleccionada.');
					}
					
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
					die();
				}

			}
			
		}

		public function formatoKardexGrupal($params)
		{
			if($_SESSION['permisosMod']['r']){
				$array = explode(",", $params);
				$intCarreraId = $array[0];
				$intGrupoId = $array[1];
				$intMateriaId = $array[2];
				$strOption = $array[3];
				$intPrimero = $array[4];
				$intSegundo = $array[5];
				$intTercero = $array[6];
				$intCuarto = $array[7];
				$intQuinto = $array[8];
				$intSexto = $array[9];
				$intSeptimo = $array[10];
				$intOctavo = $array[11];
				$intNoveno = $array[12];
				$semestres = array();
				
				if(intval($intCarreraId)>0){
					if($strOption == "Custom"){
						if($intPrimero == 1){
							array_push($semestres, 1);
						}
						if($intSegundo == 1){
							array_push($semestres, 2);
						}
						if($intTercero == 1){
							array_push($semestres, 3);
						}
						if($intCuarto == 1){
							array_push($semestres, 4);
						}
						if($intQuinto == 1){
							array_push($semestres, 5);
						}
						if($intSexto == 1){
							array_push($semestres, 6);
						}
						if($intSeptimo == 1){
							array_push($semestres, 7);
						}
						if($intOctavo == 1){
							array_push($semestres, 8);
						}
						if($intNoveno == 1){
							array_push($semestres, 9);
						}
						$arrData = $this->model->selectKardexSemestres($intCarreraId, $intGrupoId, $intMateriaId, $semestres);	
					}else{
						$arrData = $this->model->selectKardexTodos($intCarreraId, $intGrupoId, $intMateriaId);
					}

					if(empty($arrData)){
						echo "Error: Datos no encontrados, intente más tarde.";
					}else{
						ob_end_clean();
						$html = getFile("Template/Modals/kardexGrupalPDF",$arrData);
						$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
						//$html2pdf->Image(media().'/images/logoVertical.png' , 10 ,100, 190 , 150,'PNG');
						$html2pdf->writeHTML($html);
						$html2pdf->output('KardeX_Individual: '.$data[0]['nombre_alumno'].'.pdf');
					}
				}else{
					echo "Dato no válido";
				}
			}else{
				header('Location: '.base_url().'/login');
				die();
			}
		}

	}

 ?>