<?php 
	use Mpdf\Mpdf;
	require 'Libraries/mpdf/vendor/autoload.php';

	class Kindividual extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url().'/login');
				die();
			}
			getPermisos(MKARDEX);
		}

		public function Kindividual()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url().'/dashboard');
			}
			$data['page_tag'] = "Kardex Individual";
			$data['page_title'] = "KARDEX INDIVIDUAL <small>UAF</small>";
			$data['page_name'] = "kardex individual";
			$data['page_functions_js'] = "functions_kindividual.js?v=<?= time();";
			$data['carreras'] = $this->model->selectCarreras();
			$this->views->getView($this,"kindividual",$data);
		}

		public function getAlumnos($carreraid){
			if($_SESSION['permisosMod']['r']){
				$intCarreraId = intval($carreraid);
				if(intval($intCarreraId) > 0)
				{
					$arrData = $this->model->selectAlumnos($intCarreraId);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron alumnos asignados a la carrera y nivel seleccionados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'msg' => 'A continuación se listan los alumnos correspondientes a la carrera y nivel seleccionados.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function getBusquedaAlumno()
		{
			if($_POST)
			{
				if($_SESSION['permisosMod']['u'])
				{
					//$intCarreraId = intval($_POST['listCarreras']);
					$intAlumnoId = intval($_POST['listAlumnos']);
					$strOption = strClean($_POST['rbOption']);
					$intPrimero = intval($_POST['primero']);
					$intSegundo = intval($_POST['segundo']);
					$intTercero = intval($_POST['tercero']);
					$intCuarto = intval($_POST['cuarto']);
					$intQuinto = intval($_POST['quinto']);
					$intSexto = intval($_POST['sexto']);
					$intSeptimo = intval($_POST['septimo']);
					$intOctavo = intval($_POST['octavo']);
					$intNoveno = intval($_POST['noveno']);
					$semestres = array();

					if($intPrimero == 1){
						array_push($semestres, 1);
					}
					if($intSegundo == 1){
						array_push($semestres, 2);
					}
					if($intTercero == 1){
						array_push($semestres, 3);
					}
					if($intCuarto == 1){
						array_push($semestres, 4);
					}
					if($intQuinto == 1){
						array_push($semestres, 5);
					}
					if($intSexto == 1){
						array_push($semestres, 6);
					}
					if($intSeptimo == 1){
						array_push($semestres, 7);
					}
					if($intOctavo == 1){
						array_push($semestres, 8);
					}
					if($intNoveno == 1){
						array_push($semestres, 9);
					}
					
					if($strOption == "Personalizado"){
						$arrData = $this->model->selectKardexSemestres($intAlumnoId, $semestres);	
					}else{
						$arrData = $this->model->selectKardexTodos($intAlumnoId);
					}
					
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'No se encontraron registros de calificaciones con los datos de la búsqueda seleccionados');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData, 'url' => base_url(), 'msg' => 'A continuación se listan los grupos correspondientes a la carrera seleccionada.');
					}
					
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
					die();
				}

			}
			
		}

		public function formatoKardexIndividual($params)
		{
	   	 	if ($_SESSION['permisosMod']['r']) {
		        $array = explode(",", $params);
		        $intAlumnoId = intval($array[0]);
		        $strOption = $array[1] ?? "";
		        $semestres = [];

		        if ($intAlumnoId > 0) {

		            // Armar arreglo de semestres seleccionados
		            for ($i = 2; $i <= 10; $i++) {
		                if (!empty($array[$i]) && intval($array[$i]) == 1) {
		                    $semestres[] = $i - 1;
		                }
		            }

		            $arrData = ($strOption == "Custom")
		                ? $this->model->selectKardexSemestres($intAlumnoId, $semestres)
		                : $this->model->selectKardexTodos($intAlumnoId);

		            if (empty($arrData)) {
		                echo "Error: Datos no encontrados.";
		                return;
		            }else{
		            	try {
		                    if (ob_get_length()) ob_end_clean();
		                    if($_SESSION['userData']['idrol'] == RADMINESCOLARES || $_SESSION['userData']['idrol'] == RAUXESCOLARES){
		                    	$dataEscolares = $this->model->selectJefeEscolares();
			            		$arrData[0]['jefe_escolares'] = $dataEscolares['jefe_escolares'];
		                    	$html = getFile("Template/Modals/kardexIndividualEscolaresPDF", $arrData);
			            	}else{
			            		$html = getFile("Template/Modals/kardexIndividualPDF", $arrData);
			            	}
		                    

		                    $mpdf = new \Mpdf\Mpdf([
		                        'mode' => 'utf-8',
		                        'format' => 'A4',
		                        'orientation' => 'P', // 'P' para Vertical, 'L' para Horizontal
		                        'margin_left' => 10,
		                        'margin_right' => 10,
		                        'margin_top' => 10,
		                        'margin_bottom' => 10,
		                    ]);
		                    $rutaLogo = media().'/images/logoVertical.png';
		                    //$rutaLogo = $_SERVER['DOCUMENT_ROOT'] . '/sieuaf/Assets/images/logoVertical.png';
		                    //dep($rutaLogo);exit;
		                    $mpdf->SetWatermarkImage($rutaLogo, 0.1, 105, 'F'); // Ruta, opacidad, tamaño
		                    $mpdf->showWatermarkImage = true;

		                    // Marca de agua (Texto):
		                    // $mpdf->SetWatermarkText('CONFIDENCIAL', 0.1);
		                    // $mpdf->showWatermarkText = true;
		               
		                    $mpdf->WriteHTML($html);

		                    // 'I' abre en el navegador, 'D' descarga directamente
		                    
		                    if($_SESSION['userData']['idrol'] == RADMINESCOLARES || $_SESSION['userData']['idrol'] == RAUXESCOLARES){
		                    	$nombreArchivo = 'Kardex_Individual_' . str_replace(' ', '_', $arrData[0]['nombre_alumno']) . '.pdf';
			            	}else{
			            		$nombreArchivo = 'Reporte_Parcial_' . str_replace(' ', '_', $arrData[0]['nombre_alumno']) . '.pdf';
			            	}
		                    $mpdf->Output($nombreArchivo, 'I');
		                    exit();

		                } catch (\Mpdf\MpdfException $e) {
		                    echo "Error al generar el PDF: " . $e->getMessage();
		                    exit;
			           	}

		            	//Libreria html2pdf
		            	/*ob_end_clean();
						$html = getFile("Template/Modals/kardexIndividualPDF",$arrData);
						$html2pdf = new Html2Pdf('p','A4','es','true','UTF-8');
						$html2pdf->writeHTML($html);
						$html2pdf->output('Kardex_Individual: '.$arrData[0]['nombre_alumno'].'.pdf');
		            	exit;*/
		            }

		            
		        } else {
		            echo "Dato no válido";
		        }

		    } else {
		        header('Location: ' . base_url() . '/login');
		        die();
		    }
		}

	}

 ?>